/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;

class UFFDistanceCalc
extends Calculation {
    double r0;
    double kb;

    UFFDistanceCalc() {
    }

    @Override
    void setData(List<Object[]> list, int n, int n2, double d) {
        this.calcs.parA = (FFParam)this.calcs.getParameter(this.calcs.minAtoms[n].sType);
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.calcs.minAtoms[n2].sType);
        this.r0 = CalculationsUFF.calculateR0(this.calcs.parA.dVal[0], this.calcs.parB.dVal[0], this.calcs.parA.dVal[8], this.calcs.parB.dVal[8], d);
        this.kb = 1390.2842991599998 * this.calcs.parA.dVal[5] * this.calcs.parB.dVal[5] / (this.r0 * this.r0 * this.r0);
        list.addLast((Object)new Object[]{new int[]{n, n2}, new double[]{this.r0, this.kb, d}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        this.r0 = this.dData[0];
        this.kb = this.dData[1];
        this.calcs.setPairVariables(this);
        this.delta = this.rab - this.r0;
        this.energy = this.kb * this.delta * this.delta;
        if (this.calcs.gradients) {
            this.dE = 2.0 * this.kb * this.delta;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(0, this));
        }
        return this.energy;
    }
}

