/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.Calculation;

class MMFFDistanceCalc
extends Calculation {
    static final double FSTRETCH = 71.96625;
    static final double CS = -2.0;
    static final double CS2 = 2.3333333333333335;
    double r0;
    double kb;
    double delta2;

    MMFFDistanceCalc() {
    }

    void setData(List<Object[]> list, MinBond minBond) {
        this.ia = minBond.data[0];
        this.ib = minBond.data[1];
        Object object = this.calcs.getParameterObj(minBond);
        if (object == null) {
            return;
        }
        list.addLast((Object)new Object[]{new int[]{this.ia, this.ib}, object});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        this.kb = this.dData[0];
        this.r0 = this.dData[1];
        this.calcs.setPairVariables(this);
        this.delta = this.rab - this.r0;
        this.delta2 = this.delta * this.delta;
        this.energy = 71.96625 * this.kb * this.delta2 * (1.0 + -2.0 * this.delta + 2.3333333333333335 * this.delta2);
        if (this.calcs.gradients) {
            this.dE = 71.96625 * this.kb * this.delta * (2.0 + -6.0 * this.delta + 9.333333333333334 * this.delta2);
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(0, this));
        }
        return this.energy;
    }
}

