/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Map;
import javajs.util.PT;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jmol.api.JmolAppAPI;
import org.jmol.api.JmolDialogInterface;
import org.jmol.dialog.FileChooser;
import org.jmol.dialog.FilePreview;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class Dialog
extends JPanel
implements JmolDialogInterface {
    String[] extensions = new String[10];
    String choice;
    String extension;
    private static int defaultChoice;
    static int qualityJPG;
    static int qualityPNG;
    private JSlider qSliderJPEG;
    private JSlider qSliderPNG;
    private JComboBox<String> cb;
    JPanel qPanelJPEG;
    JPanel qPanelPNG;
    static JFileChooser imageChooser;
    static JFileChooser saveChooser;
    private static FileChooser openChooser;
    private FilePreview openPreview;
    File initialFile;
    static boolean haveTranslations;
    private static boolean isMac;
    protected String[] imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM"};
    protected String[] imageExtensions = new String[]{"jpg", "png", "gif", "ppm"};
    protected String outputFileName;
    protected String dialogType;
    protected String inputFileName;
    protected Viewer vwr;
    protected int qualityJ = -1;
    protected int qualityP = -1;
    protected String imageType;

    public String getOpenFileNameFromDialog(Map<String, Object> map, Viewer viewer, String object, JmolAppAPI jmolAppAPI, String string, boolean bl) {
        Object object2;
        Object object3;
        if (openChooser == null) {
            openChooser = new FileChooser();
            object3 = UIManager.get("FileChooser.fileNameLabelText");
            UIManager.put("FileChooser.fileNameLabelText", GT._((String)"File or URL:"));
            Dialog.getXPlatformLook(openChooser);
            UIManager.put("FileChooser.fileNameLabelText", object3);
        }
        if (this.openPreview == null && (viewer.isApplet() || Boolean.valueOf(System.getProperty("openFilePreview", "true")).booleanValue())) {
            this.openPreview = new FilePreview(viewer, openChooser, bl, map);
        }
        if (jmolAppAPI != null) {
            object3 = jmolAppAPI.getHistoryWindowSize(string);
            if (object3 != null) {
                openChooser.setDialogSize((Dimension)object3);
            }
            if ((object2 = jmolAppAPI.getHistoryWindowPosition(string)) != null) {
                openChooser.setDialogLocation((Point)object2);
            }
        }
        openChooser.resetChoosableFileFilters();
        this.openPreview.setPreviewOptions(bl);
        if (object != null) {
            int n = ((String)object).lastIndexOf(".");
            object2 = ((String)object).substring(n + 1);
            if (n >= 0 && ((String)object2).length() > 0) {
                openChooser.addChoosableFileFilter(new TypeFilter((String)object2));
            }
            if (((String)object).indexOf(".") == 0) {
                object = "Jmol" + (String)object;
            }
            if (((String)object).length() > 0) {
                openChooser.setSelectedFile(new File((String)object));
            }
        }
        if (object == null || ((String)object).indexOf(":") < 0 && ((String)object).indexOf("/") != 0) {
            File file = (File)FileManager.getLocalDirectory((Viewer)viewer, (boolean)true);
            openChooser.setCurrentDirectory(file);
        }
        File file = null;
        if (openChooser.showOpenDialog(this) == 0) {
            file = openChooser.getSelectedFile();
        }
        if (file == null) {
            return this.closePreview();
        }
        if (jmolAppAPI != null) {
            jmolAppAPI.addHistoryWindowInfo(string, (Component)openChooser.getDialog(), null);
        }
        if ((object2 = viewer.getLocalUrl(file.getAbsolutePath())) != null) {
            object = object2;
        } else {
            FileManager.setLocalPath((Viewer)viewer, (String)file.getParent(), (boolean)true);
            object = file.getAbsolutePath();
        }
        boolean bl2 = bl && this.openPreview != null && this.openPreview.isAppendSelected();
        boolean bl3 = bl && this.openPreview != null && this.openPreview.isCartoonsSelected();
        this.closePreview();
        if (((String)object).startsWith("/")) {
            object = "file://" + (String)object;
        }
        return (!bl || bl3 ? "" : "#NOC#;") + (String)(bl2 ? "load append " + PT.esc((String)object) : object);
    }

    String closePreview() {
        if (this.openPreview != null) {
            this.openPreview.updatePreview(this.vwr, null);
        }
        return null;
    }

    public String getSaveFileNameFromDialog(Viewer viewer, String string, String string2) {
        if (saveChooser == null) {
            saveChooser = new JFileChooser();
            Dialog.getXPlatformLook(saveChooser);
        }
        saveChooser.setCurrentDirectory((File)FileManager.getLocalDirectory((Viewer)viewer, (boolean)true));
        File file = null;
        saveChooser.resetChoosableFileFilters();
        if (string != null) {
            int n = string.lastIndexOf(".");
            String string3 = string.substring(n + 1);
            if (n >= 0 && string3.length() > 0) {
                saveChooser.addChoosableFileFilter(new TypeFilter(string3));
            }
            if (string.equals("*")) {
                string = viewer.getModelSetFileName();
            }
            if (string.indexOf(".") == 0) {
                string = "Jmol" + string;
            }
            file = new File(string);
        }
        if (string2 != null) {
            saveChooser.addChoosableFileFilter(new TypeFilter(string2));
        }
        saveChooser.setSelectedFile(file);
        file = this.showSaveDialog(this, saveChooser, file);
        if (file == null) {
            return null;
        }
        FileManager.setLocalPath((Viewer)viewer, (String)file.getParent(), (boolean)true);
        return file.getAbsolutePath();
    }

    public String getImageFileNameFromDialog(Viewer viewer, String string, String string2, String[] stringArray, String[] stringArray2, int n, int n2) {
        File file;
        block12: {
            block11: {
                if (n < 0 || n > 100) {
                    n = qualityJPG;
                }
                if (n2 < 0) {
                    n2 = qualityPNG;
                }
                if (n2 > 9) {
                    n2 = 2;
                }
                qualityJPG = n;
                qualityPNG = n2;
                if (this.extension == null) {
                    this.extension = "jpg";
                }
                if (imageChooser == null) {
                    imageChooser = new JFileChooser();
                    Dialog.getXPlatformLook(imageChooser);
                }
                imageChooser.setCurrentDirectory((File)FileManager.getLocalDirectory((Viewer)viewer, (boolean)true));
                imageChooser.resetChoosableFileFilters();
                file = null;
                if (string != null) break block11;
                string = viewer.getModelSetFileName();
                if (string.indexOf("?") >= 0) {
                    string = string.substring(0, string.indexOf("?"));
                }
                String string3 = imageChooser.getCurrentDirectory().getPath();
                if (string == null || string3 == null) break block12;
                int n3 = string.lastIndexOf(46);
                if (n3 != -1) {
                    string = string.substring(0, n3) + "." + this.extension;
                }
                file = new File(string3, string);
                break block12;
            }
            if (string.indexOf(".") == 0) {
                string = "Jmol" + string;
            }
            file = new File(string);
            string2 = string.substring(string.lastIndexOf(".") + 1);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string2.equals(stringArray[i]) && !string2.toLowerCase().equals(stringArray2[i])) continue;
                string2 = stringArray[i];
                break;
            }
        }
        this.createExportPanel(stringArray, stringArray2, string2);
        this.initialFile = file;
        imageChooser.setSelectedFile(this.initialFile);
        file = this.showSaveDialog(this, imageChooser, file);
        if (file == null) {
            return null;
        }
        qualityJPG = this.qSliderJPEG.getValue();
        qualityPNG = this.qSliderPNG.getValue();
        if (this.cb.getSelectedIndex() >= 0) {
            defaultChoice = this.cb.getSelectedIndex();
        }
        FileManager.setLocalPath((Viewer)viewer, (String)file.getParent(), (boolean)true);
        return file.getAbsolutePath();
    }

    private void createExportPanel(String[] stringArray, String[] stringArray2, String string) {
        imageChooser.setAccessory(this);
        this.setLayout(new BorderLayout());
        if (string == null || string.equals("JPG")) {
            string = "JPEG";
        }
        defaultChoice = stringArray.length;
        while (--defaultChoice >= 1 && !stringArray[defaultChoice].equals(string)) {
        }
        this.extension = stringArray2[defaultChoice];
        this.choice = stringArray[defaultChoice];
        this.extensions = stringArray2;
        imageChooser.resetChoosableFileFilters();
        imageChooser.addChoosableFileFilter(new TypeFilter(this.extension));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(new TitledBorder(GT._((String)"Image Type")));
        this.cb = new JComboBox();
        for (int i = 0; i < stringArray.length; ++i) {
            this.cb.addItem(stringArray[i]);
        }
        jPanel.add(this.cb);
        this.cb.setSelectedIndex(defaultChoice);
        this.cb.addItemListener(new ExportChoiceListener());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.qPanelJPEG = new JPanel();
        this.qPanelJPEG.setLayout(new BorderLayout());
        this.qPanelJPEG.setBorder(new TitledBorder(GT.i((String)GT._((String)"JPEG Quality ({0})"), (int)qualityJPG)));
        this.qSliderJPEG = new JSlider(0, 50, 100, qualityJPG);
        this.qSliderJPEG.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.qSliderJPEG.setPaintTicks(true);
        this.qSliderJPEG.setMajorTickSpacing(10);
        this.qSliderJPEG.setPaintLabels(true);
        this.qSliderJPEG.addChangeListener(new QualityListener(true, this.qSliderJPEG));
        this.qPanelJPEG.add((Component)this.qSliderJPEG, "South");
        jPanel2.add((Component)this.qPanelJPEG, "North");
        this.qPanelPNG = new JPanel();
        this.qPanelPNG.setLayout(new BorderLayout());
        this.qPanelPNG.setBorder(new TitledBorder(GT.i((String)GT._((String)"PNG Compression  ({0})"), (int)qualityPNG)));
        this.qSliderPNG = new JSlider(0, 0, 9, qualityPNG);
        this.qSliderPNG.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.qSliderPNG.setPaintTicks(true);
        this.qSliderPNG.setMajorTickSpacing(2);
        this.qSliderPNG.setPaintLabels(true);
        this.qSliderPNG.addChangeListener(new QualityListener(false, this.qSliderPNG));
        this.qPanelPNG.add((Component)this.qSliderPNG, "South");
        jPanel2.add((Component)this.qPanelPNG, "South");
        this.add((Component)jPanel2, "South");
    }

    public String getType() {
        return this.choice;
    }

    public int getQuality(String string) {
        return string.equals("JPEG") || string.equals("JPG") ? qualityJPG : (string.equals("PNG") ? qualityPNG : -1);
    }

    private static boolean doOverWrite(JFileChooser jFileChooser, File file) {
        Object[] objectArray = new Object[]{GT._((String)"Yes"), GT._((String)"No")};
        int n = JOptionPane.showOptionDialog(jFileChooser, GT.o((String)GT._((String)"Do you want to overwrite file {0}?"), (Object)file.getAbsolutePath()), GT._((String)"Warning"), -1, 2, null, objectArray, objectArray[0]);
        return n == 0;
    }

    private File showSaveDialog(Component component, JFileChooser jFileChooser, File file) {
        do {
            if (jFileChooser.showSaveDialog(component) != 0) {
                return null;
            }
            if (this.cb == null || this.cb.getSelectedIndex() < 0) continue;
            defaultChoice = this.cb.getSelectedIndex();
        } while ((file = jFileChooser.getSelectedFile()) != null && file.exists() && !Dialog.doOverWrite(jFileChooser, file));
        return file;
    }

    public void setupUI(boolean bl) {
        if (bl || !haveTranslations) {
            Dialog.setupUIManager();
        }
        haveTranslations = true;
    }

    public static void setupUIManager() {
        UIManager.put("FileChooser.acceptAllFileFilterText", GT._((String)"All Files"));
        UIManager.put("FileChooser.cancelButtonText", GT._((String)"Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", GT._((String)"Abort file chooser dialog"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", GT._((String)"Details"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", GT._((String)"Details"));
        UIManager.put("FileChooser.directoryDescriptionText", GT._((String)"Directory"));
        UIManager.put("FileChooser.directoryOpenButtonText", GT._((String)"Open"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", GT._((String)"Open selected directory"));
        UIManager.put("FileChooser.fileAttrHeaderText", GT._((String)"Attributes"));
        UIManager.put("FileChooser.fileDateHeaderText", GT._((String)"Modified"));
        UIManager.put("FileChooser.fileDescriptionText", GT._((String)"Generic File"));
        UIManager.put("FileChooser.fileNameHeaderText", GT._((String)"Name"));
        UIManager.put("FileChooser.fileNameLabelText", GT._((String)"File Name:"));
        UIManager.put("FileChooser.fileSizeHeaderText", GT._((String)"Size"));
        UIManager.put("FileChooser.filesOfTypeLabelText", GT._((String)"Files of Type:"));
        UIManager.put("FileChooser.fileTypeHeaderText", GT._((String)"Type"));
        UIManager.put("FileChooser.helpButtonText", GT._((String)"Help"));
        UIManager.put("FileChooser.helpButtonToolTipText", GT._((String)"FileChooser help"));
        UIManager.put("FileChooser.homeFolderAccessibleName", GT._((String)"Home"));
        UIManager.put("FileChooser.homeFolderToolTipText", GT._((String)"Home"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", GT._((String)"List"));
        UIManager.put("FileChooser.listViewButtonToolTipText", GT._((String)"List"));
        UIManager.put("FileChooser.lookInLabelText", GT._((String)"Look In:"));
        UIManager.put("FileChooser.newFolderErrorText", GT._((String)"Error creating new folder"));
        UIManager.put("FileChooser.newFolderAccessibleName", GT._((String)"New Folder"));
        UIManager.put("FileChooser.newFolderToolTipText", GT._((String)"Create New Folder"));
        UIManager.put("FileChooser.openButtonText", GT._((String)"Open"));
        UIManager.put("FileChooser.openButtonToolTipText", GT._((String)"Open selected file"));
        UIManager.put("FileChooser.openDialogTitleText", GT._((String)"Open"));
        UIManager.put("FileChooser.saveButtonText", GT._((String)"Save"));
        UIManager.put("FileChooser.saveButtonToolTipText", GT._((String)"Save selected file"));
        UIManager.put("FileChooser.saveDialogTitleText", GT._((String)"Save"));
        UIManager.put("FileChooser.saveInLabelText", GT._((String)"Save In:"));
        UIManager.put("FileChooser.updateButtonText", GT._((String)"Update"));
        UIManager.put("FileChooser.updateButtonToolTipText", GT._((String)"Update directory listing"));
        UIManager.put("FileChooser.upFolderAccessibleName", GT._((String)"Up"));
        UIManager.put("FileChooser.upFolderToolTipText", GT._((String)"Up One Level"));
        UIManager.put("OptionPane.cancelButtonText", GT._((String)"Cancel"));
        UIManager.put("OptionPane.noButtonText", GT._((String)"No"));
        UIManager.put("OptionPane.okButtonText", GT._((String)"OK"));
        UIManager.put("OptionPane.yesButtonText", GT._((String)"Yes"));
    }

    private static void getXPlatformLook(JFileChooser jFileChooser) {
        if (isMac) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel.isNativeLookAndFeel()) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
                jFileChooser.updateUI();
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    System.out.println(unsupportedLookAndFeelException.getMessage());
                }
            }
        } else {
            jFileChooser.updateUI();
        }
    }

    public void setImageInfo(int n, int n2, String string) {
        this.qualityJ = n;
        this.qualityP = n2;
        this.imageType = string;
    }

    public String getFileNameFromDialog(Viewer viewer, String string, String string2) {
        this.vwr = viewer;
        this.dialogType = string;
        this.inputFileName = string2;
        this.outputFileName = null;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Dialog.this.dialogType.equals("Load")) {
                        Dialog.this.outputFileName = Dialog.this.getOpenFileNameFromDialog(Dialog.this.vwr.getViewerOptions(), Dialog.this.vwr, Dialog.this.inputFileName, null, null, false);
                        return;
                    }
                    if (Dialog.this.dialogType.equals("Save")) {
                        Dialog.this.outputFileName = Dialog.this.getSaveFileNameFromDialog(Dialog.this.vwr, Dialog.this.inputFileName, null);
                        return;
                    }
                    if (Dialog.this.dialogType.startsWith("Save Image")) {
                        Dialog.this.outputFileName = Dialog.this.getImageFileNameFromDialog(Dialog.this.vwr, Dialog.this.inputFileName, Dialog.this.imageType, Dialog.this.imageChoices, Dialog.this.imageExtensions, Dialog.this.qualityJ, Dialog.this.qualityP);
                        return;
                    }
                    Dialog.this.outputFileName = null;
                }
            });
        }
        catch (Exception exception) {
            Logger.error((String)exception.getMessage());
        }
        return this.outputFileName;
    }

    static {
        qualityJPG = 75;
        qualityPNG = 2;
        haveTranslations = false;
        isMac = System.getProperty("os.name", "").startsWith("Mac");
    }

    public static class TypeFilter
    extends FileFilter {
        String thisType;

        TypeFilter(String string) {
            this.thisType = string.toLowerCase();
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() || this.thisType == null) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(".");
            return n >= 0 && string.substring(n + 1).toLowerCase().equals(this.thisType);
        }

        @Override
        public String getDescription() {
            return this.thisType.toUpperCase() + " (*." + this.thisType + ")";
        }
    }

    public class ExportChoiceListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            File file = imageChooser.getSelectedFile();
            if (file == null) {
                file = Dialog.this.initialFile;
            }
            File file2 = null;
            String string = Dialog.this.extensions[jComboBox.getSelectedIndex()];
            String string2 = file.getName();
            if (string2 != null && string2.endsWith("." + Dialog.this.extension)) {
                string2 = string2.substring(0, string2.length() - Dialog.this.extension.length());
                string2 = string2 + string;
                Dialog.this.initialFile = file2 = new File(file.getParent(), string2);
            }
            Dialog.this.extension = string;
            imageChooser.resetChoosableFileFilters();
            imageChooser.addChoosableFileFilter(new TypeFilter(Dialog.this.extension));
            if (file2 != null) {
                imageChooser.setSelectedFile(file2);
            }
            Dialog.this.choice = (String)jComboBox.getSelectedItem();
        }
    }

    public class QualityListener
    implements ChangeListener {
        private boolean isJPEG;
        private JSlider slider;

        public QualityListener(boolean bl, JSlider jSlider) {
            this.isJPEG = bl;
            this.slider = jSlider;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = this.slider.getValue();
            if (this.isJPEG) {
                qualityJPG = n;
                Dialog.this.qPanelJPEG.setBorder(new TitledBorder(GT.i((String)GT._((String)"JPEG Quality ({0})"), (int)n)));
            } else {
                qualityPNG = n;
                Dialog.this.qPanelPNG.setBorder(new TitledBorder(GT.i((String)GT._((String)"PNG Quality ({0})"), (int)n)));
            }
        }
    }
}

