/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Dimension;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDialogInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.c.CBK;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class StatusManager {
    protected Viewer vwr;
    private JmolStatusListener jmolStatusListener;
    private JmolCallbackListener jmolCallbackListener;
    private String statusList = "";
    private boolean allowStatusReporting;
    private Map<String, List<List<Object>>> messageQueue = new Hashtable<String, List<List<Object>>>();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    Map<CBK, String> jmolScriptCallbacks = new Hashtable<CBK, String>();
    private int minSyncRepeatMs = 100;
    public boolean syncingScripts = false;
    boolean syncingMouse = false;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    boolean stereoSync = false;
    public static final int SYNC_OFF = 0;
    public static final int SYNC_DRIVER = 1;
    public static final int SYNC_SLAVE = 2;
    public static final int SYNC_DISABLE = 3;
    public static final int SYNC_ENABLE = 4;
    public static final int SYNC_STEREO = 5;
    private int qualityJPG = -1;
    private int qualityPNG = -1;
    private String imageType;

    StatusManager(Viewer viewer) {
        this.vwr = viewer;
    }

    void setAllowStatusReporting(boolean bl) {
        this.allowStatusReporting = bl;
    }

    public String getStatusList() {
        return this.statusList;
    }

    Map<String, List<List<Object>>> getMessageQueue() {
        return this.messageQueue;
    }

    private boolean recordStatus(String string) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(string) >= 0);
    }

    private synchronized void setStatusChanged(String string, int n, Object object, boolean bl) {
        List<List<Object>> list;
        if (!this.recordStatus(string)) {
            return;
        }
        List<Object> list2 = new List<Object>();
        list2.addLast(Integer.valueOf(++this.statusPtr));
        list2.addLast(string);
        list2.addLast(Integer.valueOf(n));
        list2.addLast(object);
        List<List<Object>> list3 = list = bl ? null : this.messageQueue.get(string);
        if (list == null) {
            list = new List();
            this.messageQueue.put(string, list);
        } else if (list.size() == MAXIMUM_QUEUE_LENGTH) {
            list.remove(0);
        }
        list.addLast(list2);
    }

    synchronized List<List<List<Object>>> getStatusChanged(String string) {
        boolean bl = string.length() > 0 && string.charAt(0) == '-';
        boolean bl2 = string.length() > 0 && string.charAt(0) == '+';
        boolean bl3 = false;
        if (bl) {
            this.statusList = PT.rep(this.statusList, string.substring(1, string.length()), "");
        } else if (this.statusList.equals(string = PT.rep(string, "+", "")) || bl2 && this.statusList.indexOf(string) >= 0) {
            bl3 = true;
        } else {
            if (!bl2) {
                this.statusList = "";
            }
            this.statusList = this.statusList + string;
            if (Logger.debugging) {
                Logger.debug("StatusManager messageQueue = " + this.statusList);
            }
        }
        List<List<List<Object>>> list = new List<List<List<Object>>>();
        if (bl3) {
            for (Map.Entry<String, List<List<Object>>> entry : this.messageQueue.entrySet()) {
                list.addLast(entry.getValue());
            }
        }
        this.messageQueue.clear();
        this.statusPtr = 0;
        return list;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener, JmolCallbackListener jmolCallbackListener) {
        this.jmolStatusListener = jmolStatusListener;
        this.jmolCallbackListener = jmolCallbackListener == null ? jmolStatusListener : jmolCallbackListener;
    }

    synchronized void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.jmolCallbackListener = jmolCallbackListener;
    }

    private String jmolScriptCallback(CBK cBK) {
        String string = this.jmolScriptCallbacks.get((Object)cBK);
        if (string != null) {
            this.vwr.evalStringQuietSync(string, true, false);
        }
        return string;
    }

    synchronized void setCallbackFunction(String string, String string2) {
        CBK cBK = CBK.getCallback(string);
        if (cBK != null) {
            int n;
            int n2 = string2 == null ? 0 : (string2.length() > 7 && string2.toLowerCase().indexOf("script:") == 0 ? 7 : (n = string2.length() > 11 && string2.toLowerCase().indexOf("jmolscript:") == 0 ? 11 : 0));
            if (n == 0) {
                this.jmolScriptCallbacks.remove((Object)cBK);
            } else {
                this.jmolScriptCallbacks.put(cBK, string2.substring(n).trim());
            }
        }
        if (this.jmolCallbackListener != null) {
            this.jmolCallbackListener.setCallbackFunction(string, string2);
        }
    }

    private boolean notifyEnabled(CBK cBK) {
        return this.jmolCallbackListener != null && this.jmolCallbackListener.notifyEnabled(cBK);
    }

    synchronized void setStatusAppletReady(String string, boolean bl) {
        String string2;
        String string3 = string2 = bl ? this.jmolScriptCallback(CBK.APPLETREADY) : null;
        if (this.notifyEnabled(CBK.APPLETREADY)) {
            this.jmolCallbackListener.notifyCallback(CBK.APPLETREADY, new Object[]{string2, string, bl, null});
        }
    }

    synchronized void setStatusAtomMoved(BS bS) {
        String string = this.jmolScriptCallback(CBK.ATOMMOVED);
        this.setStatusChanged("atomMoved", -1, bS, false);
        if (this.notifyEnabled(CBK.ATOMMOVED)) {
            this.jmolCallbackListener.notifyCallback(CBK.ATOMMOVED, new Object[]{string, bS});
        }
    }

    synchronized void setStatusAtomPicked(int n, String string, Map<String, Object> map) {
        String string2 = this.jmolScriptCallback(CBK.PICK);
        Logger.info("setStatusAtomPicked(" + n + "," + string + ")");
        this.setStatusChanged("atomPicked", n, string, false);
        if (this.notifyEnabled(CBK.PICK)) {
            this.jmolCallbackListener.notifyCallback(CBK.PICK, new Object[]{string2, string, n, map});
        }
    }

    synchronized int setStatusClicked(int n, int n2, int n3, int n4, int n5) {
        String string = this.jmolScriptCallback(CBK.CLICK);
        if (!this.notifyEnabled(CBK.CLICK)) {
            return n3;
        }
        int[] nArray = new int[]{n3, n5};
        this.jmolCallbackListener.notifyCallback(CBK.CLICK, new Object[]{string, n, n2, n3, n4, nArray});
        return nArray[0];
    }

    synchronized void setStatusResized(int n, int n2) {
        String string = this.jmolScriptCallback(CBK.RESIZE);
        if (this.notifyEnabled(CBK.RESIZE)) {
            this.jmolCallbackListener.notifyCallback(CBK.RESIZE, new Object[]{string, n, n2});
        }
    }

    synchronized void setStatusAtomHovered(int n, String string) {
        String string2 = this.jmolScriptCallback(CBK.HOVER);
        if (this.notifyEnabled(CBK.HOVER)) {
            this.jmolCallbackListener.notifyCallback(CBK.HOVER, new Object[]{string2, string, n});
        }
    }

    synchronized void setStatusObjectHovered(String string, String string2, P3 p3) {
        String string3 = this.jmolScriptCallback(CBK.HOVER);
        if (this.notifyEnabled(CBK.HOVER)) {
            this.jmolCallbackListener.notifyCallback(CBK.HOVER, new Object[]{string3, string2, -1, string, Float.valueOf(p3.x), Float.valueOf(p3.y), Float.valueOf(p3.z)});
        }
    }

    synchronized void setFileLoadStatus(String string, String string2, String string3, String string4, int n, boolean bl, Boolean bl2) {
        Object object;
        if (string == null && "resetUndo".equals(string2)) {
            object = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (object != null) {
                object.zap();
            }
            string2 = this.vwr.getZapName();
        }
        this.setStatusChanged("fileLoaded", n, string, false);
        if (string4 != null) {
            this.setStatusChanged("fileLoadError", n, string4, false);
        }
        object = this.jmolScriptCallback(CBK.LOADSTRUCT);
        if (bl && this.notifyEnabled(CBK.LOADSTRUCT)) {
            String string5 = (String)this.vwr.getParameter("_smilesString");
            if (string5.length() != 0) {
                string2 = string5;
            }
            this.jmolCallbackListener.notifyCallback(CBK.LOADSTRUCT, new Object[]{object, string, string2, string3, string4, n, this.vwr.getParameter("_modelNumber"), this.vwr.getModelNumberDotted(this.vwr.getModelCount() - 1), bl2});
        }
    }

    synchronized void setStatusFrameChanged(int n, int n2, int n3, int n4, int n5, float f, String string) {
        if (this.vwr.getModelSet() == null) {
            return;
        }
        boolean bl = this.vwr.isAnimationOn();
        int n6 = bl ? -2 - n5 : n5;
        this.setStatusChanged("frameChanged", n6, n5 >= 0 ? this.vwr.getModelNumberDotted(n5) : "", false);
        String string2 = this.jmolScriptCallback(CBK.ANIMFRAME);
        if (this.notifyEnabled(CBK.ANIMFRAME)) {
            this.jmolCallbackListener.notifyCallback(CBK.ANIMFRAME, new Object[]{string2, new int[]{n6, n, n2, n3, n4, n5}, string, Float.valueOf(f)});
        }
        if (this.vwr.jmolpopup != null && !bl) {
            this.vwr.jmolpopup.jpiUpdateComputedMenus();
        }
    }

    synchronized void setScriptEcho(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, string, false);
        String string2 = this.jmolScriptCallback(CBK.ECHO);
        if (this.notifyEnabled(CBK.ECHO)) {
            this.jmolCallbackListener.notifyCallback(CBK.ECHO, new Object[]{string2, string, bl ? 1 : 0});
        }
    }

    synchronized void setStatusMeasuring(String string, int n, String string2, float f) {
        this.setStatusChanged(string, n, string2, false);
        String string3 = null;
        if (string.equals("measureCompleted")) {
            Logger.info("measurement[" + n + "] = " + string2);
            string3 = this.jmolScriptCallback(CBK.MEASURE);
        } else if (string.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", n, string2, false);
            Logger.info("measurePicked " + n + " " + string2);
        }
        if (this.notifyEnabled(CBK.MEASURE)) {
            this.jmolCallbackListener.notifyCallback(CBK.MEASURE, new Object[]{string3, string2, n, string, Float.valueOf(f)});
        }
    }

    synchronized void notifyError(String string, String string2, String string3) {
        String string4 = this.jmolScriptCallback(CBK.ERROR);
        if (this.notifyEnabled(CBK.ERROR)) {
            this.jmolCallbackListener.notifyCallback(CBK.ERROR, new Object[]{string4, string, string2, this.vwr.getShapeErrorState(), string3});
        }
    }

    synchronized void notifyMinimizationStatus(String string, Integer n, Float f, Float f2, String string2) {
        String string3 = this.jmolScriptCallback(CBK.MINIMIZATION);
        if (this.notifyEnabled(CBK.MINIMIZATION)) {
            this.jmolCallbackListener.notifyCallback(CBK.MINIMIZATION, new Object[]{string3, string, n, f, f2, string2});
        }
    }

    synchronized void setScriptStatus(String string, String string2, int n, String string3) {
        boolean bl;
        if (n < -1) {
            int n2 = -2 - n;
            this.setStatusChanged("scriptStarted", n2, string2, false);
            string = "script " + n2 + " started";
        } else if (string == null) {
            return;
        }
        String string4 = n == 0 ? this.jmolScriptCallback(CBK.SCRIPT) : null;
        boolean bl2 = bl = string == "Script completed";
        if (this.recordStatus("script")) {
            boolean bl3 = string3 != null;
            this.setStatusChanged(bl3 ? "scriptError" : "scriptStatus", 0, string, false);
            if (bl3 || bl) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (bl3 ? " unsuccessfully: " + string : " successfully"), false);
            }
        }
        if (bl && this.vwr.getBoolean(603979880) && this.vwr.getBoolean(603979825)) {
            Object[] objectArray = new Object[]{null, "script <exiting>", string2, -1, string3};
            if (this.notifyEnabled(CBK.SCRIPT)) {
                this.jmolCallbackListener.notifyCallback(CBK.SCRIPT, objectArray);
            }
            this.processScript(objectArray);
            string = "Jmol script completed.";
        }
        Object[] objectArray = new Object[]{string4, string, string2, bl ? -1 : n, string3};
        if (this.notifyEnabled(CBK.SCRIPT)) {
            this.jmolCallbackListener.notifyCallback(CBK.SCRIPT, objectArray);
        }
        this.processScript(objectArray);
    }

    private void processScript(Object[] objectArray) {
        int n = (Integer)objectArray[3];
        if (this.vwr.scriptEditor != null) {
            if (n > 0) {
                this.vwr.scriptEditor.notifyScriptTermination();
            } else if (n < 0) {
                if (n == -2) {
                    this.vwr.scriptEditor.notifyScriptStart();
                }
            } else if (this.vwr.scriptEditor.isVisible() && ((String)objectArray[2]).length() > 0) {
                this.vwr.scriptEditor.notifyContext(this.vwr.getScriptContext("SE notify"), objectArray);
            }
        }
        if (this.vwr.appConsole != null && n == 0) {
            String string = objectArray[1] == null ? null : objectArray[1].toString();
            this.vwr.appConsole.sendConsoleMessage(string);
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String string) {
        if (this.syncingMouse) {
            if (string != null) {
                this.syncSend(string, "*", 0);
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.vwr.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), "*", 0);
        }
    }

    void setSyncDriver(int n) {
        if (this.stereoSync && n != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*", 0);
            this.stereoSync = false;
        }
        switch (n) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.vwr.appletName + " sync mode=" + n + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    public void syncSend(String string, String string2, int n) {
        if (n != 0 || this.notifyEnabled(CBK.SYNC)) {
            this.jmolCallbackListener.notifyCallback(CBK.SYNC, new Object[]{null, string, string2, n});
        }
    }

    public void modifySend(int n, int n2, int n3, String string) {
        if (this.notifyEnabled(CBK.STRUCTUREMODIFIED)) {
            this.jmolCallbackListener.notifyCallback(CBK.STRUCTUREMODIFIED, new Object[]{null, n3, n, n2, string});
        }
    }

    public int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String string) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(string);
        }
    }

    synchronized void clearConsole() {
        if (this.vwr.appConsole != null) {
            this.vwr.appConsole.sendConsoleMessage(null);
        }
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(CBK.MESSAGE, null);
        }
    }

    float[][] functionXY(String string, int n, int n2) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)] : this.jmolStatusListener.functionXY(string, n, n2);
    }

    float[][][] functionXYZ(String string, int n, int n2, int n3) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)][Math.abs(n2)] : this.jmolStatusListener.functionXYZ(string, n, n2, n3);
    }

    String jsEval(String string) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval(string);
    }

    String createImage(String string, String string2, String string3, byte[] byArray, int n) {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.createImage(string, string2, string3 == null ? byArray : (byte[])string3, n);
    }

    Map<String, Object> getRegistryInfo() {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getRegistryInfo();
    }

    String dialogAsk(String string, String string2) {
        boolean bl = string.equals("Save Image");
        JmolDialogInterface jmolDialogInterface = (JmolDialogInterface)Interface.getOption("dialog.Dialog");
        if (jmolDialogInterface == null) {
            return null;
        }
        jmolDialogInterface.setupUI(false);
        if (bl) {
            jmolDialogInterface.setImageInfo(this.qualityJPG, this.qualityPNG, this.imageType);
        }
        String string3 = jmolDialogInterface.getFileNameFromDialog(this.vwr, string, string2);
        if (bl && string3 != null) {
            this.qualityJPG = jmolDialogInterface.getQuality("JPG");
            this.qualityPNG = jmolDialogInterface.getQuality("PNG");
            String string4 = jmolDialogInterface.getType();
            if (string4 != null) {
                this.imageType = string4;
            }
        }
        return string3;
    }

    Map<String, Object> getJspecViewProperties(String string) {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getJSpecViewProperty(string == null || string.length() == 0 ? "" : ":" + string);
    }

    public Dimension resizeInnerPanel(int n, int n2) {
        return this.jmolStatusListener == null ? new Dimension(n, n2) : this.jmolStatusListener.resizeInnerPanel("preferredWidthHeight " + n + " " + n2 + ";");
    }
}

