/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    public float vOcc = Float.NaN;
    public Map<String, Float> htUij;
    public float vOcc0;
    String id;
    private List<Modulation> mods;
    private int modDim;
    private int iop;
    private P3 r0;
    private SymmetryInterface symmetry;
    private M3 gammaE;
    private Matrix gammaIinv;
    private Matrix sigma;
    private Matrix sI;
    private Matrix tau;
    private boolean enabled;
    private float scale = 1.0f;
    private P3 qtOffset = new P3();
    private boolean isQ;
    private Matrix t;
    private ModulationSet modTemp;
    private String strop;
    private boolean isSubsystem;
    private Matrix tFactor;
    P3 ptTemp = new P3();

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ModulationSet set(String string, P3 p3, int n, List<Modulation> list, M3 m3, Matrix[] matrixArray, int n2, SymmetryInterface symmetryInterface) {
        this.id = string + "_" + symmetryInterface.getSpaceGroupName();
        this.strop = symmetryInterface.getSpaceGroupXyz(n2, false);
        this.modDim = n;
        this.mods = list;
        this.iop = n2;
        this.symmetry = symmetryInterface;
        this.sigma = matrixArray[0];
        this.tFactor = matrixArray[1];
        boolean bl = this.isSubsystem = this.tFactor != null;
        if (this.isSubsystem) {
            this.tFactor = this.tFactor.inverse();
        }
        this.gammaE = m3;
        Matrix matrix = symmetryInterface.getOperationRsVs(n2);
        this.gammaIinv = matrix.getSubmatrix(3, 3, n, n).inverse();
        this.sI = matrix.getSubmatrix(3, 3 + n, n, 1);
        this.r0 = P3.newP(p3);
        this.tau = this.gammaIinv.mul(this.sigma.mul(Matrix.newT(p3, true)).sub(this.sI));
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create r=" + Escape.eP(p3) + " si=" + Escape.e(this.sI.getArray()) + " ginv=" + this.gammaIinv.toString().replace('\n', ' '));
        }
        this.t = new Matrix(null, n, 1);
        return this;
    }

    @Override
    public SymmetryInterface getUnitCell() {
        return this.symmetry;
    }

    public synchronized ModulationSet calculate(T3 t3, boolean bl) {
        int n;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        double[][] dArray = this.t.getArray();
        for (n = 0; n < this.modDim; ++n) {
            dArray[n][0] = 0.0;
        }
        if (bl && this.qtOffset != null) {
            Matrix matrix = new Matrix(null, 3, 1);
            matrix.getArray()[0] = new double[]{this.qtOffset.x, this.qtOffset.y, this.qtOffset.z};
            this.t = this.sigma.mul(matrix);
            dArray = this.t.getArray();
        }
        if (t3 != null) {
            switch (this.modDim) {
                default: {
                    double[] dArray2 = dArray[2];
                    dArray2[0] = dArray2[0] + (double)t3.z;
                }
                case 2: {
                    double[] dArray3 = dArray[1];
                    dArray3[0] = dArray3[0] + (double)t3.y;
                }
                case 1: 
            }
            double[] dArray4 = dArray[0];
            dArray4[0] = dArray4[0] + (double)t3.x;
            if (this.isSubsystem) {
                this.t = this.tFactor.mul(this.t);
            }
        }
        this.t = this.gammaIinv.mul(this.t).add(this.tau);
        n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, this.t.getArray());
        }
        this.gammaE.rotate(this);
        return this;
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    @Override
    public synchronized void setModTQ(T3 t3, boolean bl, T3 t32, boolean bl2, float f) {
        if (this.enabled) {
            this.addTo(t3, -1.0f);
        }
        this.enabled = false;
        this.scale = f;
        if (t32 != null) {
            this.qtOffset.setT(t32);
            this.isQ = bl2;
            if (bl2) {
                t32 = null;
            }
            this.calculate(t32, bl2);
        }
        if (bl) {
            this.addTo(t3, 1.0f);
            this.enabled = true;
        }
    }

    @Override
    public void addTo(T3 t3, float f) {
        this.ptTemp.setT(this);
        this.ptTemp.scale(this.scale * f);
        this.symmetry.toCartesian(this.ptTemp, true);
        t3.add(this.ptTemp);
    }

    @Override
    public String getState() {
        String string = "";
        if (this.qtOffset != null && this.qtOffset.length() > 0.0f) {
            string = string + "; modulation " + Escape.eP(this.qtOffset) + " " + this.isQ + ";\n";
        }
        string = string + "modulation {selected} " + (this.enabled ? "ON" : "OFF");
        return string;
    }

    @Override
    public Object getModulation(String string, T3 t3) {
        this.getModTemp();
        if (string.equals("D")) {
            return P3.newP(t3 == null ? this.r0 : this.modTemp.calculate(t3, false));
        }
        return null;
    }

    @Override
    public void setTempPoint(T3 t3, T3 t32, float f, float f2) {
        if (!this.enabled) {
            return;
        }
        this.getModTemp();
        this.addTo(t3, -1.0f);
        this.modTemp.calculate(t32, false).addTo(t3, f2);
    }

    private void getModTemp() {
        if (this.modTemp != null) {
            return;
        }
        this.modTemp = new ModulationSet();
        this.modTemp.id = this.id;
        this.modTemp.tau = this.tau;
        this.modTemp.mods = this.mods;
        this.modTemp.gammaE = this.gammaE;
        this.modTemp.modDim = this.modDim;
        this.modTemp.gammaIinv = this.gammaIinv;
        this.modTemp.sigma = this.sigma;
        this.modTemp.r0 = this.r0;
        this.modTemp.symmetry = this.symmetry;
        this.modTemp.t = this.t;
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.id);
        hashtable.put("r0", this.r0);
        hashtable.put("tau", this.tau.getArray());
        hashtable.put("modDim", this.modDim);
        hashtable.put("gammaE", this.gammaE);
        hashtable.put("gammaIinv", this.gammaIinv.getArray());
        hashtable.put("sI", this.sI.getArray());
        hashtable.put("sigma", this.sigma.getArray());
        hashtable.put("symop", this.iop + 1);
        hashtable.put("strop", this.strop);
        hashtable.put("unitcell", this.symmetry.getUnitCellInfo());
        List<Hashtable<String, Object>> list = new List<Hashtable<String, Object>>();
        for (int i = 0; i < this.mods.size(); ++i) {
            list.addLast(((Modulation)this.mods.get(i)).getInfo());
        }
        hashtable.put("mods", list);
        map.put("modulation", hashtable);
    }
}

