/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public final class ModelLoader {
    private Viewer vwr;
    public ModelSet ms;
    private ModelSet mergeModelSet;
    private boolean merging;
    private boolean appendNew;
    private String jmolData;
    private String[] group3Lists;
    private int[][] group3Counts;
    private final int[] specialAtomIndexes = new int[JC.ATOMID_MAX];
    private boolean someModelsHaveUnitcells;
    private boolean someModelsAreModulated;
    private boolean is2D;
    private boolean isPDB;
    public boolean isTrajectory;
    private boolean isPyMOLsession;
    private boolean doMinimize;
    private boolean doAddHydrogens;
    private boolean doRemoveAddedHydrogens;
    private String fileHeader;
    private JmolBioResolver jbr;
    private Group[] groups;
    private int groupCount;
    private final Map<Object, Atom> htAtomMap = new Hashtable<Object, Atom>();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private int currentChainID;
    private boolean isNewChain;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode = '\u0000';
    private String currentGroup3;
    private Group nullGroup;
    public int baseModelIndex = 0;
    private int baseModelCount = 0;
    public int baseAtomIndex = 0;
    private int baseGroupIndex = 0;
    private int baseTrajectoryCount = 0;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private boolean noAutoBond;
    private boolean modulationOn;
    private Group[] mergeGroups;
    private int iChain;
    private List<Bond> vStereo;
    public BS structuresDefinedInFile = new BS();

    public ModelLoader(Viewer viewer, String string, SB sB, Object object, ModelSet modelSet, BS bS) {
        this.vwr = viewer;
        this.ms = new ModelSet(viewer, string);
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        this.mergeModelSet = modelSet;
        boolean bl = this.merging = this.mergeModelSet != null && this.mergeModelSet.ac > 0;
        if (this.merging) {
            this.ms.canSkipLoad = false;
        } else {
            viewer.resetShapes(false);
        }
        this.ms.preserveState = viewer.getPreserveState();
        this.ms.showRebondTimes = viewer.getBoolean(603979934);
        if (bS == null) {
            this.initializeInfo(string, null);
            this.createModelSet(null, null, null);
            viewer.setStringProperty("_fileType", "");
            return;
        }
        if (!this.ms.preserveState) {
            this.ms.canSkipLoad = false;
        }
        Map<String, Object> map = jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object);
        map.put("loadScript", sB);
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), map);
        this.createModelSet(jmolAdapter, object, bS);
    }

    private void initializeInfo(String string, Map<String, Object> map) {
        this.ms.g3d = this.vwr.getGraphicsData();
        this.ms.modelSetTypeName = string;
        this.ms.isXYZ = string == "xyz";
        this.ms.modelSetAuxiliaryInfo = map;
        this.ms.modelSetProperties = (Properties)this.ms.getModelSetAuxiliaryInfoValue("properties");
        this.isPDB = this.ms.isPDB = this.ms.getModelSetAuxiliaryInfoBoolean("isPDB");
        if (this.isPDB) {
            this.jbr = (JmolBioResolver)Interface.getInterface("org.jmol.modelsetbio.Resolver");
            this.jbr.initialize(this);
        }
        this.jmolData = (String)this.ms.getModelSetAuxiliaryInfoValue("jmolData");
        this.fileHeader = (String)this.ms.getModelSetAuxiliaryInfoValue("fileHeader");
        this.ms.trajectorySteps = (List)this.ms.getModelSetAuxiliaryInfoValue("trajectorySteps");
        this.isTrajectory = this.ms.trajectorySteps != null;
        this.isPyMOLsession = this.ms.getModelSetAuxiliaryInfoBoolean("isPyMOL");
        boolean bl = this.doAddHydrogens = this.jbr != null && !this.isTrajectory && !this.isPyMOLsession && !this.ms.getModelSetAuxiliaryInfoBoolean("pdbNoHydrogens") && (this.ms.getModelSetAuxiliaryInfoBoolean("pdbAddHydrogens") || this.vwr.getBooleanProperty("pdbAddHydrogens"));
        if (map != null) {
            map.remove("pdbNoHydrogens");
            map.remove("pdbAddHydrogens");
            map.remove("trajectorySteps");
            if (this.isTrajectory) {
                this.ms.vibrationSteps = (List)map.remove("vibrationSteps");
            }
        }
        this.modulationOn = this.ms.getModelSetAuxiliaryInfoBoolean("modulationOn");
        this.noAutoBond = this.ms.getModelSetAuxiliaryInfoBoolean("noAutoBond");
        this.is2D = this.ms.getModelSetAuxiliaryInfoBoolean("is2D");
        this.doMinimize = this.is2D && this.ms.getModelSetAuxiliaryInfoBoolean("doMinimize");
        this.adapterTrajectoryCount = this.ms.trajectorySteps == null ? 0 : this.ms.trajectorySteps.size();
        this.ms.someModelsHaveSymmetry = this.ms.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.ms.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsAreModulated = this.ms.getModelSetAuxiliaryInfoBoolean("someModelsAreModulated");
        this.ms.someModelsHaveFractionalCoordinates = this.ms.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.ms.isPDB |= this.mergeModelSet.isPDB;
            this.ms.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.ms.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.ms.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
            this.ms.modelSetAuxiliaryInfo.put("someModelsHaveSymmetry", this.ms.someModelsHaveSymmetry);
            this.ms.modelSetAuxiliaryInfo.put("someModelsHaveUnitcells", this.someModelsHaveUnitcells);
            this.ms.modelSetAuxiliaryInfo.put("someModelsHaveFractionalCoordinates", this.ms.someModelsHaveFractionalCoordinates);
            this.ms.modelSetAuxiliaryInfo.put("someModelsHaveAromaticBonds", this.ms.someModelsHaveAromaticBonds);
        }
    }

    public String getGroup3(int n) {
        return n >= this.group3Of.length ? null : this.group3Of[n];
    }

    public int getFirstAtomIndex(int n) {
        return this.firstAtomIndexes[n];
    }

    public int getAtomCount() {
        return this.ms.ac;
    }

    private void createModelSet(JmolAdapter jmolAdapter, Object object, BS bS) {
        int n;
        int n2 = n = jmolAdapter == null ? 0 : jmolAdapter.getAtomCount(object);
        if (n > 0) {
            Logger.info("reading " + n + " atoms");
        }
        this.adapterModelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        this.appendNew = !this.merging || jmolAdapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.vwr.getBoolean(603979792);
        this.htAtomMap.clear();
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = Integer.MAX_VALUE;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
        if (this.merging) {
            this.baseModelCount = this.mergeModelSet.mc;
            this.baseTrajectoryCount = this.mergeModelSet.mergeTrajectories(this.isTrajectory);
            if (this.baseTrajectoryCount > 0) {
                if (this.isTrajectory) {
                    int n3;
                    if (this.mergeModelSet.vibrationSteps == null) {
                        this.mergeModelSet.vibrationSteps = new List();
                        n3 = this.mergeModelSet.trajectorySteps.size();
                        while (--n3 >= 0) {
                            this.mergeModelSet.vibrationSteps.addLast(null);
                        }
                    }
                    for (n3 = 0; n3 < this.ms.trajectorySteps.size(); ++n3) {
                        this.mergeModelSet.trajectorySteps.addLast(this.ms.trajectorySteps.get(n3));
                        this.mergeModelSet.vibrationSteps.addLast(this.ms.vibrationSteps == null ? null : (V3[])this.ms.vibrationSteps.get(n3));
                    }
                }
                this.ms.trajectorySteps = this.mergeModelSet.trajectorySteps;
                this.ms.vibrationSteps = this.mergeModelSet.vibrationSteps;
            }
        }
        this.initializeAtomBondModelCounts(n);
        if (bS != null && (this.doMinimize || this.is2D)) {
            bS.setBits(this.baseAtomIndex, this.baseAtomIndex + n);
        }
        if (jmolAdapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, null);
        } else {
            Quat quat;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.ms.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.ms.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.ms.mc == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((quat = (Quat)this.ms.getModelSetAuxiliaryInfoValue("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + quat);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(jmolAdapter, object);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            if (this.merging && !this.appendNew) {
                Map<String, Object> map = jmolAdapter.getAtomSetAuxiliaryInfo(object, 0);
                this.ms.setModelAuxiliaryInfo(this.baseModelIndex, "initialAtomCount", map.get("initialAtomCount"));
                this.ms.setModelAuxiliaryInfo(this.baseModelIndex, "initialBondCount", map.get("initialBondCount"));
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        if (this.is2D && this.doMinimize) {
            this.applyStereochemistry();
        }
        if (this.doAddHydrogens) {
            this.jbr.finalizeHydrogens();
        }
        if (jmolAdapter != null) {
            this.ms.calculatePolymers(this.groups, this.groupCount, this.baseGroupIndex, null);
            if (this.jbr != null) {
                this.jbr.iterateOverAllNewStructures(jmolAdapter, object);
            }
        }
        this.setDefaultRendering(this.vwr.getInt(553648170));
        RadiusData radiusData = this.vwr.getDefaultRadiusData();
        int n4 = this.ms.ac;
        Atom[] atomArray = this.ms.at;
        for (int i = this.baseAtomIndex; i < n4; ++i) {
            atomArray[i].setMadAtom(this.vwr, radiusData);
        }
        Model[] modelArray = this.ms.am;
        for (int i = modelArray[this.baseModelIndex].firstAtomIndex; i < n4; ++i) {
            modelArray[atomArray[i].mi].bsAtoms.set(i);
        }
        this.freeze();
        this.finalizeShapes();
        this.vwr.setModelSet(this.ms);
        this.setAtomProperties();
        if (jmolAdapter != null) {
            jmolAdapter.finish(object);
        }
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    private void setDefaultRendering(int n) {
        if (this.isPyMOLsession) {
            return;
        }
        SB sB = new SB();
        int n2 = this.ms.mc;
        Model[] modelArray = this.ms.am;
        for (int i = this.baseModelIndex; i < n2; ++i) {
            if (!modelArray[i].isBioModel) continue;
            modelArray[i].getDefaultLargePDBRendering(sB, n);
        }
        if (sB.length() == 0) {
            return;
        }
        sB.append("select *;");
        String string = (String)this.ms.getModelSetAuxiliaryInfoValue("jmolscript");
        if (string == null) {
            string = "";
        }
        sB.append(string);
        this.ms.modelSetAuxiliaryInfo.put("jmolscript", sB.toString());
    }

    private void setAtomProperties() {
        int n = this.ms.mc;
        for (int i = this.baseModelIndex; i < n; ++i) {
            Map map = (Map)this.ms.getModelAuxiliaryInfoValue(i, "atomProperties");
            if (map == null) continue;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                BS bS = this.ms.getModelAtomBitSetIncludingDeleted(i, true);
                if (this.doAddHydrogens) {
                    string2 = this.jbr.fixPropertyValue(bS, string2);
                }
                string = "property_" + string.toLowerCase();
                Logger.info("creating " + string + " for model " + this.ms.getModelName(i));
                this.vwr.setData(string, new Object[]{string, string2, bS, 0, Boolean.FALSE}, this.ms.ac, 0, 0, Integer.MAX_VALUE, 0);
            }
        }
    }

    private void initializeAtomBondModelCounts(int n) {
        int n2 = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.ms.mc = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.vwr.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.ms.mc = this.baseModelCount;
            }
            this.ms.ac = this.baseAtomIndex = this.mergeModelSet.ac;
            this.ms.bondCount = this.mergeModelSet.bondCount;
            this.mergeGroups = this.mergeModelSet.getGroups();
            this.groupCount = this.baseGroupIndex = this.mergeGroups.length;
            this.ms.mergeModelArrays(this.mergeModelSet);
            this.ms.growAtomArrays(this.ms.ac + n);
        } else {
            this.ms.mc = this.adapterModelCount;
            this.ms.ac = 0;
            this.ms.bondCount = 0;
            this.ms.at = new Atom[n];
            this.ms.bo = new Bond[250 + n];
        }
        if (this.doAddHydrogens) {
            this.jbr.initializeHydrogenAddition();
        }
        if (n2 > 1) {
            this.ms.mc += n2 - 1;
        }
        this.ms.am = (Model[])AU.arrayCopyObject(this.ms.am, this.ms.mc);
        this.ms.modelFileNumbers = AU.arrayCopyI(this.ms.modelFileNumbers, this.ms.mc);
        this.ms.modelNumbers = AU.arrayCopyI(this.ms.modelNumbers, this.ms.mc);
        this.ms.modelNumbersForAtomLabel = AU.arrayCopyS(this.ms.modelNumbersForAtomLabel, this.ms.mc);
        this.ms.modelNames = AU.arrayCopyS(this.ms.modelNames, this.ms.mc);
        this.ms.frameTitles = AU.arrayCopyS(this.ms.frameTitles, this.ms.mc);
        if (this.merging) {
            for (int i = 0; i < this.mergeModelSet.mc; ++i) {
                this.ms.am[i] = this.mergeModelSet.am[i];
                this.mergeModelSet.am[i].ms = this.ms;
            }
        }
    }

    private void mergeGroups() {
        Map<String, Object> map = this.mergeModelSet.getAuxiliaryInfo(null);
        String[] stringArray = (String[])map.get("group3Lists");
        int[][] nArray = (int[][])map.get("group3Counts");
        if (stringArray != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = stringArray[i + 1];
                this.group3Counts[i + 1] = nArray[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = stringArray[0];
            this.group3Counts[0] = nArray[0];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object) {
        int n;
        Object object2;
        String[] stringArray;
        Object object3;
        this.group3Lists = new String[this.ms.mc + 1];
        this.group3Counts = AU.newInt2(this.ms.mc + 1);
        this.structuresDefinedInFile = new BS();
        if (this.merging) {
            this.mergeGroups();
        }
        int n2 = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int n3 = this.baseModelIndex;
        int n4 = 0;
        while (n4 < this.adapterModelCount) {
            int n5 = jmolAdapter.getAtomSetNumber(object, n4);
            object3 = jmolAdapter.getAtomSetName(object, n4);
            stringArray = jmolAdapter.getAtomSetAuxiliaryInfo(object, n4);
            if (stringArray.containsKey("modelID")) {
                stringArray.put((String)"modelID0", (Object)stringArray.get("modelID"));
            }
            object2 = (Properties)stringArray.get("modelProperties");
            this.vwr.setStringProperty("_fileType", (String)stringArray.get("fileType"));
            if (object3 == null) {
                Object object4 = this.jmolData != null && this.jmolData.indexOf(";") > 2 ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (object3 = this.appendNew ? "" + n5 % 1000000 : "");
            }
            if ((n = this.setModelNameNumberProperties(n3, n2, (String)object3, n5, (Properties)object2, (Map<String, Object>)stringArray, this.jmolData)) != 0) {
                this.group3Lists[n3 + 1] = JC.getGroup3List();
                this.group3Counts[n3 + 1] = new int[JC.getGroup3Count() + 10];
                if (this.group3Lists[0] == null) {
                    this.group3Lists[0] = JC.getGroup3List();
                    this.group3Counts[0] = new int[JC.getGroup3Count() + 10];
                }
            }
            if (this.ms.getModelAuxiliaryInfoValue(n3, "periodicOriginXyz") != null) {
                this.ms.someModelsHaveSymmetry = true;
            }
            ++n4;
            ++n3;
        }
        Model model = this.ms.am[this.baseModelIndex];
        this.vwr.setSmilesString((String)this.ms.modelSetAuxiliaryInfo.get("smilesString"));
        String string = (String)this.ms.modelSetAuxiliaryInfo.remove("loadState");
        object3 = (SB)this.ms.modelSetAuxiliaryInfo.remove("loadScript");
        if (((SB)object3).indexOf("Viewer.AddHydrogens") < 0 || !model.isModelKit) {
            stringArray = PT.split(string, "\n");
            object2 = new SB();
            for (n = 0; n < stringArray.length; ++n) {
                int n6 = model.loadState.indexOf(stringArray[n]);
                if (n6 >= 0 && n6 == model.loadState.lastIndexOf(stringArray[n])) continue;
                ((SB)object2).append(stringArray[n]).appendC('\n');
            }
            model.loadState = model.loadState + model.loadScript.toString() + ((SB)object2).toString();
            model.loadScript = new SB();
            model.loadScript.append("  ").appendSB((SB)object3).append(";\n");
        }
        if (this.isTrajectory) {
            int n7 = this.ms.mc - n3 + 1;
            Logger.info(n7 + " trajectory steps read");
            this.ms.setModelAuxiliaryInfo(this.baseModelCount, "trajectoryStepCount", n7);
            int n8 = this.adapterModelCount;
            n = n3;
            while (n < this.ms.mc) {
                this.ms.am[n] = this.ms.am[this.baseModelCount];
                this.ms.modelNumbers[n] = jmolAdapter.getAtomSetNumber(object, n8);
                this.ms.modelNames[n] = jmolAdapter.getAtomSetName(object, n8);
                this.structuresDefinedInFile.set(n);
                ++n;
                ++n8;
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private boolean setModelNameNumberProperties(int n, int n2, String string, int n3, Properties properties, Map<String, Object> map, String string2) {
        boolean bl;
        Model[] modelArray;
        boolean bl2;
        boolean bl3 = bl2 = map != null && Boolean.TRUE == map.get("isPDB");
        if (this.appendNew) {
            this.ms.am[n] = bl2 ? this.jbr.getBioModel(n, n2, string2, properties, map) : new Model(this.ms, n, n2, string2, properties, map);
            this.ms.modelNumbers[n] = n3;
            this.ms.modelNames[n] = string;
        } else {
            modelArray = map.get("PDB_CONECT_firstAtom_count_max");
            if (modelArray != null) {
                this.ms.setModelAuxiliaryInfo(n, "PDB_CONECT_firstAtom_count_max", modelArray);
            }
        }
        modelArray = this.ms.am;
        Atom[] atomArray = this.ms.at;
        modelArray[n].bsAtoms.set(atomArray.length + 1);
        modelArray[n].bsAtoms.clear(atomArray.length + 1);
        String string3 = (String)this.ms.getModelAuxiliaryInfoValue(n, "altLocs");
        modelArray[n].setNAltLocs(string3 == null ? 0 : string3.length());
        if (string3 != null) {
            char[] cArray = string3.toCharArray();
            Arrays.sort(cArray);
            string3 = String.valueOf(cArray);
            this.ms.setModelAuxiliaryInfo(n, "altLocs", string3);
        }
        string3 = (String)this.ms.getModelAuxiliaryInfoValue(n, "insertionCodes");
        modelArray[n].setNInsertions(string3 == null ? 0 : string3.length());
        modelArray[n].isModelKit = bl = this.ms.modelSetName != null && this.ms.modelSetName.startsWith("Jmol Model Kit") || string.startsWith("Jmol Model Kit") || "Jme".equals(this.ms.getModelAuxiliaryInfoValue(n, "fileType"));
        return bl2;
    }

    private void finalizeModels(int n) {
        int n2;
        int n3;
        int n4 = this.ms.mc;
        if (n4 == n) {
            return;
        }
        int n5 = 0;
        int n6 = -1;
        int[] nArray = this.ms.modelNumbers;
        String[] stringArray = this.ms.modelNames;
        if (this.isTrajectory) {
            n3 = n;
            while (++n3 < this.ms.mc) {
                nArray[n3] = nArray[n3 - 1] + 1;
            }
        }
        if (n > 0) {
            if (nArray[0] < 1000000) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (stringArray[n3].length() == 0) {
                        stringArray[n3] = "" + nArray[n3];
                    }
                    int n7 = n3;
                    nArray[n7] = nArray[n7] + 1000000;
                    this.ms.modelNumbersForAtomLabel[n3] = "1." + (n3 + 1);
                }
            }
            n3 = nArray[n - 1];
            n3 -= n3 % 1000000;
            if (nArray[n] < 1000000) {
                n3 += 1000000;
            }
            n2 = n;
            while (n2 < n4) {
                int n8 = n2++;
                nArray[n8] = nArray[n8] + n3;
            }
        }
        Model[] modelArray = this.ms.am;
        for (n2 = n; n2 < n4; ++n2) {
            String string;
            int n9;
            this.ms.setModelAuxiliaryInfo(n2, "fileType", this.ms.modelSetTypeName);
            if (this.fileHeader != null) {
                this.ms.setModelAuxiliaryInfo(n2, "fileHeader", this.fileHeader);
            }
            if ((n9 = nArray[n2] / 1000000) != n6) {
                n5 = 0;
                n6 = n9;
            }
            ++n5;
            if (n9 == 0) {
                string = "" + this.ms.getModelNumber(n2);
                n9 = 1;
            } else {
                string = n9 + "." + n5;
            }
            this.ms.modelNumbersForAtomLabel[n2] = string;
            modelArray[n2].fileIndex = n9 - 1;
            this.ms.modelFileNumbers[n2] = n9 * 1000000 + n5;
            if (stringArray[n2] != null && stringArray[n2].length() != 0) continue;
            stringArray[n2] = string;
        }
        if (this.merging) {
            for (n2 = 0; n2 < n; ++n2) {
                modelArray[n2].ms = this.ms;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.ms.setModelAuxiliaryInfo(n2, "modelName", stringArray[n2]);
            this.ms.setModelAuxiliaryInfo(n2, "modelNumber", nArray[n2] % 1000000);
            this.ms.setModelAuxiliaryInfo(n2, "modelFileNumber", this.ms.modelFileNumbers[n2]);
            this.ms.setModelAuxiliaryInfo(n2, "modelNumberDotted", this.ms.getModelNumberDotted(n2));
            String string = (String)this.ms.getModelAuxiliaryInfoValue(n2, "altLocs");
            if (string == null) continue;
            Logger.info("model " + this.ms.getModelNumberDotted(n2) + " alternative locations: " + string);
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        int n;
        Object object2;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JmolAdapterAtomIterator jmolAdapterAtomIterator = jmolAdapter.getAtomIterator(object);
        int n3 = 0;
        Model[] modelArray = this.ms.am;
        if (this.ms.mc > 0) {
            this.nullGroup = new Group().setGroup(new Chain(this.ms.am[this.baseModelIndex], 32, -1), "", 0, -1, -1);
        }
        while (jmolAdapterAtomIterator.hasNext()) {
            ++n3;
            int n4 = jmolAdapterAtomIterator.getAtomSetIndex() + this.baseModelIndex;
            if (n4 != n2) {
                this.iChain = 0;
                this.currentModelIndex = n4;
                this.currentModel = modelArray[n4];
                this.currentChainID = Integer.MAX_VALUE;
                this.isNewChain = true;
                modelArray[n4].bsAtoms.clearAll();
                bl = modelArray[n4].isBioModel;
                n2 = n4;
                boolean bl4 = bl2 = bl && this.doAddHydrogens;
                if (this.jbr != null) {
                    this.jbr.setHaveHsAlready(false);
                }
            }
            object2 = jmolAdapterAtomIterator.getGroup3();
            n = jmolAdapterAtomIterator.getChainID();
            this.checkNewGroup(jmolAdapter, n, (String)object2, jmolAdapterAtomIterator.getSequenceNumber(), jmolAdapterAtomIterator.getInsertionCode(), bl2, bl3);
            int n5 = jmolAdapterAtomIterator.getElementNumber();
            if (bl2 && Elements.getElementNumber(n5) == 1) {
                this.jbr.setHaveHsAlready(true);
            }
            String string = jmolAdapterAtomIterator.getAtomName();
            int n6 = bl2 ? this.getPdbCharge((String)object2, string) : jmolAdapterAtomIterator.getFormalCharge();
            this.addAtom(bl, jmolAdapterAtomIterator.getAtomSymmetry(), jmolAdapterAtomIterator.getAtomSite(), jmolAdapterAtomIterator.getUniqueID(), n5, string, n6, jmolAdapterAtomIterator.getPartialCharge(), jmolAdapterAtomIterator.getTensors(), jmolAdapterAtomIterator.getOccupancy(), jmolAdapterAtomIterator.getBfactor(), jmolAdapterAtomIterator.getXYZ(), jmolAdapterAtomIterator.getIsHetero(), jmolAdapterAtomIterator.getAtomSerial(), (String)object2, jmolAdapterAtomIterator.getVib(), jmolAdapterAtomIterator.getAlternateLocationID(), jmolAdapterAtomIterator.getRadius());
        }
        if (this.groupCount > 0 && bl2) {
            this.jbr.addImplicitHydrogenAtoms(jmolAdapter, this.groupCount - 1, this.isNewChain && !bl3 ? 1 : 0);
        }
        n2 = -1;
        VDW vDW = null;
        object2 = this.ms.at;
        for (n = 0; n < this.ms.ac; ++n) {
            if (object2[n].mi == n2) continue;
            n2 = object2[n].mi;
            modelArray[n2].firstAtomIndex = n;
            VDW vDW2 = this.ms.getDefaultVdwType(n2);
            if (vDW2 == vDW) continue;
            Logger.info("Default Van der Waals type for model set to " + vDW2.getVdwLabel());
            vDW = vDW2;
        }
        Logger.info(n3 + " atoms created");
    }

    private int getPdbCharge(String string, String string2) {
        return string.equals("ARG") && string2.equals("NH1") || string.equals("LYS") && string2.equals("NZ") || string.equals("HIS") && string2.equals("ND1") ? 1 : 0;
    }

    private void addAtom(boolean bl, BS bS, int n, Object object, int n2, String string, int n3, float f, List<Object> list, int n4, float f2, P3 p3, boolean bl2, int n5, String string2, V3 v3, char c, float f3) {
        byte by = 0;
        if (string != null) {
            if (bl && string.indexOf(42) >= 0) {
                string = string.replace('*', '\'');
            }
            by = JC.lookupSpecialAtomID(string);
            if (bl && by == 2 && "CA".equalsIgnoreCase(string2)) {
                by = 0;
            }
        }
        Atom atom = this.ms.addAtom(this.currentModelIndex, this.nullGroup, n2, string, n5, n, p3, f3, v3, n3, f, n4, f2, list, bl2, by, bS);
        atom.setAltLoc(c);
        this.htAtomMap.put(object, atom);
    }

    private void checkNewGroup(JmolAdapter jmolAdapter, int n, String string, int n2, char c, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (n != this.currentChainID) {
            this.currentChainID = n;
            this.currentChain = this.getOrAllocateChain(this.currentModel, n);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
            this.isNewChain = true;
        }
        if (n2 != this.currentGroupSequenceNumber || c != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            if (this.groupCount > 0 && bl) {
                this.jbr.addImplicitHydrogenAtoms(jmolAdapter, this.groupCount - 1, this.isNewChain && !bl2 ? 1 : 0);
                this.jbr.setHaveHsAlready(false);
            }
            this.currentGroupSequenceNumber = n2;
            this.currentGroupInsertionCode = c;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])AU.doubleLength(this.chainOf);
                this.group3Of = AU.doubleLengthS(this.group3Of);
                this.seqcodes = AU.doubleLengthI(this.seqcodes);
                this.firstAtomIndexes = AU.doubleLengthI(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = this.ms.ac;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcodeFor(n2, c);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, int n) {
        int n2;
        Chain chain = model.getChain(n);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])AU.doubleLength(model.chains);
        }
        Chain[] chainArray = model.chains;
        if (n == 0 || n == 32) {
            n2 = -1;
        } else {
            int n3 = this.iChain;
            n2 = n3;
            this.iChain = n3 + 1;
        }
        Chain chain2 = new Chain(model, n, n2);
        chainArray[model.chainCount++] = chain2;
        return chain2;
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapterBondIterator jmolAdapterBondIterator = jmolAdapter.getBondIterator(object);
        if (jmolAdapterBondIterator == null) {
            return;
        }
        short s = this.vwr.getMadBond();
        this.ms.defaultCovalentMad = this.jmolData == null ? s : (short)0;
        boolean bl = false;
        while (jmolAdapterBondIterator.hasNext()) {
            short s2;
            float f;
            int n = jmolAdapterBondIterator.getEncodedOrder();
            short s3 = (short)n;
            Bond bond = this.bondAtoms(jmolAdapterBondIterator.getAtomUniqueID1(), jmolAdapterBondIterator.getAtomUniqueID2(), s3);
            if (bond == null) continue;
            if (s3 > 1 && s3 != 1025 && s3 != 1041) {
                bl = true;
            }
            if ((f = jmolAdapterBondIterator.getRadius()) > 0.0f) {
                bond.setMad((short)(f * 2000.0f));
            }
            if ((s2 = jmolAdapterBondIterator.getColix()) >= 0) {
                bond.setColix(s2);
            }
            bond.order |= n & 0x18000;
        }
        if (bl && this.ms.someModelsHaveSymmetry && !this.vwr.getBoolean(603979794)) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.ms.defaultCovalentMad = s;
    }

    private Bond bondAtoms(Object object, Object object2, short s) {
        Bond bond;
        boolean bl;
        Atom atom = this.htAtomMap.get(object);
        if (atom == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + object);
            return null;
        }
        Atom atom2 = this.htAtomMap.get(object2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + object2);
            return null;
        }
        if (atom.isBonded(atom2)) {
            return null;
        }
        boolean bl2 = s == 1025;
        boolean bl3 = bl = s == 1041;
        if (bl2 || bl) {
            bond = this.ms.bondMutually(atom, atom2, this.is2D ? s : (short)1, this.ms.getDefaultMadFromOrder(1), 0.0f);
            if (this.vStereo == null) {
                this.vStereo = new List();
            }
            this.vStereo.addLast(bond);
        } else {
            bond = this.ms.bondMutually(atom, atom2, s, this.ms.getDefaultMadFromOrder(s), 0.0f);
            if (bond.isAromatic()) {
                this.ms.someModelsHaveAromaticBonds = true;
            }
        }
        if (this.ms.bondCount == this.ms.bo.length) {
            this.ms.bo = (Bond[])AU.arrayCopyObject(this.ms.bo, this.ms.bondCount + 250);
        }
        this.ms.setBond(this.ms.bondCount++, bond);
        return bond;
    }

    private void initializeUnitCellAndSymmetry() {
        int n;
        int n2;
        if (this.someModelsAreModulated && this.ms.bsModulated == null) {
            this.ms.bsModulated = new BS();
        }
        if (this.someModelsHaveUnitcells) {
            this.ms.unitCells = new SymmetryInterface[this.ms.mc];
            this.ms.haveUnitCells = true;
            boolean bl = this.mergeModelSet != null && this.mergeModelSet.unitCells != null;
            for (n2 = 0; n2 < this.ms.mc; ++n2) {
                if (bl && n2 < this.baseModelCount) {
                    this.ms.unitCells[n2] = this.mergeModelSet.unitCells[n2];
                    continue;
                }
                this.ms.unitCells[n2] = Interface.getSymmetry();
                this.ms.unitCells[n2].setSymmetryInfo(n2, this.ms.getModelAuxiliaryInfo(n2));
            }
        }
        if (this.appendNew && this.ms.someModelsHaveSymmetry) {
            this.ms.getAtomBits(1089470478, null);
            Atom[] atomArray = this.ms.at;
            short s = -1;
            n = 0;
            for (n2 = this.baseAtomIndex; n2 < this.ms.ac; ++n2) {
                if (atomArray[n2].mi != s) {
                    s = atomArray[n2].mi;
                    n = this.baseAtomIndex + this.ms.getModelAuxiliaryInfoInt(s, "presymmetryAtomIndex") + this.ms.getModelAuxiliaryInfoInt(s, "presymmetryAtomCount");
                }
                if (n2 < n) continue;
                this.ms.bsSymmetry.set(n2);
            }
        }
        if (this.appendNew && this.ms.someModelsHaveFractionalCoordinates) {
            Atom[] atomArray = this.ms.at;
            n2 = -1;
            SymmetryInterface symmetryInterface = null;
            for (n = this.baseAtomIndex; n < this.ms.ac; ++n) {
                if (atomArray[n].mi != n2) {
                    n2 = atomArray[n].mi;
                    symmetryInterface = this.ms.getUnitCell(n2);
                }
                if (symmetryInterface == null || !symmetryInterface.getCoordinatesAreFractional()) continue;
                symmetryInterface = atomArray[n].getUnitCell();
                symmetryInterface.toCartesian(symmetryInterface.toSupercell(atomArray[n]), false);
            }
            for (n = this.baseModelIndex; n < this.ms.mc; ++n) {
                if (!this.ms.isTrajectory(n) || (symmetryInterface = this.ms.getUnitCell(n)) == null || !symmetryInterface.getCoordinatesAreFractional() || !symmetryInterface.isSupercell()) continue;
                P3[] p3Array = (P3[])this.ms.trajectorySteps.get(n);
                int n3 = p3Array.length;
                while (--n3 >= 0) {
                    if (p3Array[n3] == null) continue;
                    symmetryInterface.toSupercell(p3Array[n3]);
                }
            }
        }
    }

    private void initializeBonding() {
        BS bS;
        BS bS2 = bS = this.ms.getModelSetAuxiliaryInfoValue("someModelsHaveCONECT") == null ? null : new BS();
        if (bS != null) {
            this.ms.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bS);
        }
        int n = 0;
        boolean bl = this.vwr.getBoolean(603979794);
        boolean bl2 = this.vwr.getBoolean(603979798);
        boolean bl3 = this.vwr.getBoolean(603979846);
        BS bS3 = null;
        boolean bl4 = false;
        int n2 = this.ms.mc;
        Model[] modelArray = this.ms.am;
        if (!this.noAutoBond) {
            for (int i = this.baseModelIndex; i < n2; ++i) {
                boolean bl5;
                n = modelArray[i].bsAtoms.cardinality();
                int n3 = this.ms.getModelAuxiliaryInfoInt(i, "initialBondCount");
                boolean bl6 = modelArray[i].isBioModel;
                if (n3 < 0) {
                    n3 = this.ms.bondCount;
                }
                boolean bl7 = this.ms.getModelAuxiliaryInfoBoolean(i, "hasSymmetry");
                boolean bl8 = bl5 = bl3 || bl2 && (n3 == 0 || bl6 && this.jmolData == null && (this.ms.getModelSetAuxiliaryInfoBoolean("havePDBHeaderName") || n3 < n / 2) || bl7 && !bl && !this.ms.getModelAuxiliaryInfoBoolean(i, "hasBonds"));
                if (!bl5) continue;
                bl4 = true;
                if (!this.merging && n2 <= 1) continue;
                if (bS3 == null) {
                    bS3 = BS.newN(this.ms.ac);
                }
                if (i != this.baseModelIndex && this.isTrajectory) continue;
                bS3.or(modelArray[i].bsAtoms);
            }
        }
        if (bl4) {
            if (this.modulationOn) {
                this.ms.setModulation(null, true, null, false);
            }
            this.ms.autoBondBs4(bS3, bS3, bS, null, this.ms.defaultCovalentMad, this.vwr.getBoolean(603979874));
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            this.ms.initializeBspf();
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.mergeGroups.length; ++n) {
                this.groups[n] = this.mergeGroups[n];
                this.groups[n].setModelSet(this.ms);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chainOf[n], this.group3Of[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.ms.ac : this.firstAtomIndexes[n + 1]);
        }
        if (this.group3Lists != null && this.ms.modelSetAuxiliaryInfo != null) {
            this.ms.modelSetAuxiliaryInfo.put("group3Lists", this.group3Lists);
            this.ms.modelSetAuxiliaryInfo.put("group3Counts", this.group3Counts);
            for (n = 0; n < this.group3Counts.length; ++n) {
                if (this.group3Counts[n] != null) continue;
                this.group3Counts[n] = new int[0];
            }
        }
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        String string2;
        Group group;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.ms.at[n3].mi;
        Group group2 = group = string == null || this.jbr == null ? null : this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, s, this.specialAtomIndexes, this.ms.at);
        if (group == null) {
            group = new Group().setGroup(chain, string, n2, n3, n5);
            string2 = "o>";
        } else {
            String string3 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (string2 = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, string2, string);
        }
        this.addGroup(chain, group);
        this.groups[n] = group;
        group.setGroupIndex(n);
        int n6 = n4;
        while (--n6 >= n3) {
            this.ms.at[n6].setGroup(group);
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])AU.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int n, String string, String string2) {
        int n2 = n + 1;
        if (this.group3Lists == null || this.group3Lists[n2] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n3 = this.group3Lists[n2].indexOf(string3);
        if (n3 < 0) {
            int n4 = n2;
            this.group3Lists[n4] = this.group3Lists[n4] + ",[" + string3 + "]";
            n3 = this.group3Lists[n2].indexOf(string3);
            this.group3Counts[n2] = AU.arrayCopyI(this.group3Counts[n2], this.group3Counts[n2].length + 10);
        }
        int[] nArray = this.group3Counts[n2];
        int n5 = n3 / 6;
        nArray[n5] = nArray[n5] + 1;
        n3 = this.group3Lists[n2].indexOf(",[" + string3);
        if (n3 >= 0) {
            this.group3Lists[n2] = this.group3Lists[n2].substring(0, n3) + string + this.group3Lists[n2].substring(n3 + 2);
        }
        if (n >= 0) {
            this.countGroup(-1, string, string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void freeze() {
        Object object;
        void var1_2;
        this.htAtomMap.clear();
        if (this.ms.ac < this.ms.at.length) {
            this.ms.growAtomArrays(this.ms.ac);
        }
        if (this.ms.bondCount < this.ms.bo.length) {
            this.ms.bo = (Bond[])AU.arrayCopyObject(this.ms.bo, this.ms.bondCount);
        }
        int bl = 5;
        while (--var1_2 > 0) {
            this.ms.numCached[var1_2] = 0;
            object = this.ms.freeBonds[var1_2];
            int n = ((Bond[][])object).length;
            while (--n >= 0) {
                object[n] = null;
            }
        }
        this.ms.setAtomNamesAndNumbers(0, this.baseAtomIndex, this.mergeModelSet);
        this.findElementsPresent();
        this.ms.resetMolecules();
        this.currentModel = null;
        this.currentChain = null;
        if (!this.isPDB || this.isPyMOLsession) {
            this.ms.freezeModels();
            return;
        }
        boolean bl2 = this.vwr.getBoolean(603979826);
        object = this.ms.calculateStructuresAllExcept(this.structuresDefinedInFile, bl2, false, true, true, bl2);
        if (((String)object).length() > 0) {
            Logger.info((String)object);
        }
    }

    private void findElementsPresent() {
        int n;
        this.ms.elementsPresent = new BS[this.ms.mc];
        for (n = 0; n < this.ms.mc; ++n) {
            this.ms.elementsPresent[n] = BS.newN(64);
        }
        n = this.ms.ac;
        while (--n >= 0) {
            int n2 = this.ms.at[n].getAtomicAndIsotopeNumber();
            if (n2 >= Elements.elementNumberMax) {
                n2 = Elements.elementNumberMax + Elements.altElementIndexFromNumber(n2);
            }
            this.ms.elementsPresent[this.ms.at[n].mi].set(n2);
        }
    }

    private void applyStereochemistry() {
        this.set2dZ(this.baseAtomIndex, this.ms.ac);
        if (this.vStereo != null) {
            BS bS = new BS();
            bS.setBits(this.baseAtomIndex, this.ms.ac);
            int n = this.vStereo.size();
            while (--n >= 0) {
                Bond bond = (Bond)this.vStereo.get(n);
                float f = bond.order == 1025 ? 3 : -3;
                bond.order = 1;
                if (bond.atom2.z != bond.atom1.z && f < 0.0f == bond.atom2.z < bond.atom1.z) {
                    f /= 3.0f;
                }
                BS bS2 = JmolMolecule.getBranchBitSet(this.ms.at, bond.atom2.i, bS, null, bond.atom1.i, false, true);
                bS2.set(bond.atom2.i);
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    this.ms.at[n2].z += f;
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                bond.atom2.x = (bond.atom1.x + bond.atom2.x) / 2.0f;
                bond.atom2.y = (bond.atom1.y + bond.atom2.y) / 2.0f;
            }
            this.vStereo = null;
        }
        this.is2D = false;
    }

    private void set2dZ(int n, int n2) {
        BS bS = BS.newN(n2);
        BS bS2 = new BS();
        V3 v3 = new V3();
        V3 v32 = V3.new3(0.0f, 1.0f, 0.0f);
        V3 v33 = new V3();
        BS bS3 = new BS();
        bS3.setBits(n, n2);
        for (int i = n; i < n2; ++i) {
            if (bS.get(i) || bS2.get(i)) continue;
            bS2 = this.getBranch2dZ(i, -1, bS3, bS2, v3, v32, v33);
            bS.or(bS2);
        }
    }

    private BS getBranch2dZ(int n, int n2, BS bS, BS bS2, V3 v3, V3 v32, V3 v33) {
        BS bS3 = BS.newN(this.ms.ac);
        if (n < 0) {
            return bS3;
        }
        BS bS4 = new BS();
        bS4.or(bS);
        if (n2 >= 0) {
            bS4.clear(n2);
        }
        ModelLoader.setBranch2dZ(this.ms.at[n], bS3, bS4, v3, v32, v33);
        return bS3;
    }

    private static void setBranch2dZ(Atom atom, BS bS, BS bS2, V3 v3, V3 v32, V3 v33) {
        int n = atom.i;
        if (!bS2.get(n)) {
            return;
        }
        bS2.clear(n);
        bS.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if (bond.isHydrogen()) continue;
            Atom atom2 = bond.getOtherAtom(atom);
            ModelLoader.setAtom2dZ(atom, atom2, v3, v32, v33);
            ModelLoader.setBranch2dZ(atom2, bS, bS2, v3, v32, v33);
        }
    }

    private static void setAtom2dZ(Atom atom, Atom atom2, V3 v3, V3 v32, V3 v33) {
        v3.sub2(atom2, atom);
        v3.z = 0.0f;
        v3.normalize();
        v33.cross(v32, v3);
        double d = Math.acos(v3.dot(v32));
        atom2.z = atom.z + (float)((double)0.8f * Math.sin(4.0 * d));
    }

    private void finalizeShapes() {
        this.ms.sm = this.vwr.getShapeManager();
        this.ms.sm.setModelSet(this.ms);
        this.ms.setBsHidden(this.vwr.getHiddenSet());
        if (!this.merging) {
            this.ms.sm.resetShapes();
        }
        this.ms.sm.loadDefaultShapes(this.ms);
        if (this.ms.someModelsHaveAromaticBonds && this.vwr.getBoolean(603979944)) {
            this.ms.assignAromaticBondsBs(false, null);
        }
        if (this.merging && this.baseModelCount == 1) {
            this.ms.sm.setShapePropertyBs(6, "clearModelIndex", null, null);
        }
    }

    public void undeleteAtom(int n) {
        this.ms.at[n].valence = 0;
    }

    public void deleteAtoms(BS bS) {
        this.doRemoveAddedHydrogens = true;
        if (this.doRemoveAddedHydrogens) {
            int n;
            int[] nArray = new int[this.ms.ac];
            int[] nArray2 = new int[this.ms.ac - bS.cardinality()];
            int n2 = this.baseAtomIndex;
            Model[] modelArray = this.ms.am;
            Atom[] atomArray = this.ms.at;
            for (n = this.baseAtomIndex; n < this.ms.ac; ++n) {
                modelArray[atomArray[n].mi].bsAtoms.clear(n);
                modelArray[atomArray[n].mi].bsAtomsDeleted.clear(n);
                if (bS.get(n)) {
                    nArray[n] = n2 - 1;
                    --modelArray[atomArray[n].mi].ac;
                    continue;
                }
                nArray2[n2] = n;
                nArray[n] = n2++;
            }
            this.ms.modelSetAuxiliaryInfo.put("bsDeletedAtoms", bS);
            for (n = this.baseGroupIndex; n < this.groups.length; ++n) {
                Group group = this.groups[n];
                if (group.firstAtomIndex < this.baseAtomIndex) continue;
                group.firstAtomIndex = nArray[group.firstAtomIndex];
                group.lastAtomIndex = nArray[group.lastAtomIndex];
                if (group.leadAtomIndex < 0) continue;
                group.leadAtomIndex = nArray[group.leadAtomIndex];
            }
            this.ms.adjustAtomArrays(nArray2, this.baseAtomIndex, n2);
        } else {
            this.ms.vwr.deleteAtoms(bS, false);
        }
        this.ms.calcBoundBoxDimensions(null, 1.0f);
        this.ms.resetMolecules();
        this.ms.validateBspf(false);
    }

    public static String createAtomDataSet(Viewer viewer, ModelSet modelSet, int n, Object object, BS bS) {
        int n2;
        if (object == null) {
            return null;
        }
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        P3 p3 = new P3();
        Atom[] atomArray = modelSet.at;
        float f = viewer.getFloat(570425363);
        if (modelSet.unitCells != null) {
            n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (atomArray[n2].getAtomSymmetry() != null) {
                    f = -f;
                    break;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        n2 = -1;
        int n3 = 0;
        boolean bl = BSUtil.cardinalityOf(bS) == viewer.getAtomCount();
        Object object2 = jmolAdapter.getAtomIterator(object);
        while (object2.hasNext()) {
            P3 p32 = object2.getXYZ();
            if (Float.isNaN(p32.x + p32.y + p32.z)) continue;
            if (n == 1146095626) {
                if ((n2 = bS.nextSetBit(n2 + 1)) < 0) break;
                ++n3;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + n2 + ": " + atomArray[n2] + " --> (" + p32.x + "," + p32.y + "," + p32.z);
                }
                modelSet.setAtomCoord(n2, p32.x, p32.y, p32.z);
                continue;
            }
            p3.setT(p32);
            BS bS2 = BS.newN(modelSet.ac);
            modelSet.getAtomsWithin(f, p3, bS2, -1);
            bS2.and(bS);
            if (bl) {
                n3 = BSUtil.cardinalityOf(bS2);
                if (n3 == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + p3);
                    continue;
                }
                if (n3 > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n3 + " atoms found at position " + p3);
                }
            }
            switch (n) {
                case 1146095631: {
                    V3 v3 = object2.getVib();
                    if (v3 == null) break;
                    if (Logger.debugging) {
                        Logger.debug("xyz: " + p3 + " vib: " + v3);
                    }
                    modelSet.setAtomCoords(bS2, 1146095631, v3);
                    break;
                }
                case 1129318401: {
                    modelSet.setAtomProperty(bS2, n, object2.getOccupancy(), 0.0f, null, null, null);
                    break;
                }
                case 1112541196: {
                    modelSet.setAtomProperty(bS2, n, 0, object2.getPartialCharge(), null, null, null);
                    break;
                }
                case 1112541199: {
                    modelSet.setAtomProperty(bS2, n, 0, object2.getBfactor(), null, null, null);
                }
            }
        }
        switch (n) {
            case 1146095631: {
                object2 = jmolAdapter.getAtomSetName(object, 0);
                Logger.info("_vibrationName = " + (String)object2);
                viewer.setStringProperty("_vibrationName", (String)object2);
                break;
            }
            case 1146095626: {
                Logger.info(n3 + " atom positions read");
                modelSet.recalculateLeadMidpointsAndWingVectors(-1);
                if (n3 != modelSet.ac) break;
                return "boundbox {*};reset";
            }
        }
        return null;
    }
}

