/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javajs.J2SIgnoreImport;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={ResourceBundle.class, Locale.class})
class Resource {
    private ResourceBundle resource;
    private Map<String, String> resourceMap;

    private Resource(Object object, String string) {
        if (string == null) {
            this.resourceMap = (Map)object;
        } else {
            this.resource = (ResourceBundle)object;
        }
    }

    static Resource getResource(String string, String string2) {
        String string3 = null;
        if (GT.vwr.isApplet()) {
            String string4 = Viewer.appletIdiomaBase + "/" + string2 + ".po";
            Logger.info("Loading language resource " + string4);
            string3 = GT.vwr.getFileAsString(string4, false);
            return Resource.getResourceFromPO(string3);
        }
        Object object = Interface.getInterface(string = string + string2 + ".Messages_" + string2);
        return object == null ? null : new Resource(object, string);
    }

    String getString(String string) {
        try {
            return this.resource == null ? this.resourceMap.get(string) : this.resource.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getLanguage() {
        String string = null;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            string = locale.getLanguage();
            if (locale.getCountry() != null) {
                string = string + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    string = string + "_" + locale.getVariant();
                }
            }
        }
        return string;
    }

    static Resource getResourceFromPO(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String[] stringArray = PT.split(string, "\n");
            int n = 0;
            String string2 = "";
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.length() <= 2) {
                    if (n == 2 && string2.length() != 0 && string3.length() != 0) {
                        hashtable.put(string3, string2);
                    }
                    n = 0;
                    continue;
                }
                if (string4.indexOf("msgid") == 0) {
                    n = 1;
                    string3 = Resource.fix(string4);
                    continue;
                }
                if (string4.indexOf("msgstr") == 0) {
                    n = 2;
                    string2 = Resource.fix(string4);
                    continue;
                }
                if (n == 1) {
                    string3 = string3 + Resource.fix(string4);
                    continue;
                }
                if (n != 2) continue;
                string2 = string2 + Resource.fix(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info(hashtable.size() + " translations loaded");
        return hashtable.size() == 0 ? null : new Resource(hashtable, null);
    }

    static String fix(String string) {
        if (string.indexOf("\\\"") >= 0) {
            string = PT.rep(string, "\\\"", "\"");
        }
        return PT.rep(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")), "\\n", "\n");
    }
}

