/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javajs.api.GenericFileInterface;
import javajs.util.PT;

class AwtFile
extends File
implements GenericFileInterface {
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};

    AwtFile(String string) {
        super(string);
    }

    @Override
    public GenericFileInterface getParentAsFile() {
        AwtFile awtFile = null;
        try {
            File file = this.getParentFile();
            awtFile = new AwtFile(file.getAbsolutePath());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return awtFile;
    }

    static Object getBufferedFileInputStream(String string) {
        File file = new File(string);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    static Object getBufferedURLInputStream(URL uRL, byte[] byArray, String string) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            String string2 = null;
            if (byArray != null) {
                string2 = "application/octet-stream;";
            } else if (string != null) {
                string2 = "application/x-www-form-urlencoded";
            }
            if (string2 != null) {
                uRLConnection.setRequestProperty("Content-Type", string2);
                uRLConnection.setDoOutput(true);
                if (byArray == null) {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                    outputStreamWriter.write(string);
                    outputStreamWriter.flush();
                } else {
                    uRLConnection.getOutputStream().write(byArray);
                    uRLConnection.getOutputStream().flush();
                }
            }
            return new BufferedInputStream(uRLConnection.getInputStream());
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    @Override
    public String getFullPath() {
        try {
            return this.getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getLocalUrl(GenericFileInterface genericFileInterface) {
        int n;
        if (genericFileInterface.getName().startsWith("=")) {
            return genericFileInterface.getName();
        }
        String string = genericFileInterface.getFullPath();
        if (string == null) {
            return null;
        }
        string = string.replace('\\', '/');
        for (n = 0; n < urlPrefixPairs.length; ++n) {
            if (string.indexOf(urlPrefixPairs[n]) != 0) continue;
            return null;
        }
        for (n = 0; n < urlPrefixPairs.length; n += 2) {
            if (string.indexOf(urlPrefixPairs[n]) <= 0) continue;
            return urlPrefixPairs[n + 1] + PT.trim(string.substring(string.indexOf(urlPrefixPairs[n]) + urlPrefixPairs[n].length()), "/");
        }
        return null;
    }
}

