/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.P3i;
import javajs.util.SB;
import org.jmol.symmetry.HallRotationTerm;
import org.jmol.symmetry.HallTranslation;
import org.jmol.util.Logger;

class HallInfo {
    String hallSymbol;
    String primitiveHallSymbol;
    char latticeCode = '\u0000';
    String latticeExtension;
    boolean isCentrosymmetric;
    int nRotations;
    HallRotationTerm[] rotationTerms = new HallRotationTerm[16];
    P3i vector12ths;
    String vectorCode;

    HallInfo(String string) {
        try {
            String string2 = this.hallSymbol = string.trim();
            string2 = this.extractLatticeInfo(string2);
            if (HallTranslation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = HallTranslation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            string2 = this.extractVectorInfo(string2) + this.latticeExtension;
            if (Logger.debugging) {
                Logger.debug("Hallinfo: " + string + " " + string2);
            }
            int n = 0;
            char c = '\u0000';
            this.primitiveHallSymbol = "P";
            while (string2.length() > 0 && this.nRotations < 16) {
                string2 = this.extractRotationInfo(string2, n, c);
                HallRotationTerm hallRotationTerm = this.rotationTerms[this.nRotations - 1];
                n = hallRotationTerm.order;
                c = hallRotationTerm.axisType;
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + hallRotationTerm.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception exception) {
            Logger.error("Invalid Hall symbol " + exception);
            this.nRotations = 0;
        }
    }

    String dumpInfo() {
        SB sB = new SB();
        sB.append("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            sB.append("\n\nrotation term ").appendI(i + 1).append(this.rotationTerms[i].dumpInfo(this.vectorCode));
        }
        return sB.toString();
    }

    private String getLatticeDesignation() {
        return HallTranslation.getLatticeDesignation2(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return "";
        }
        String string2 = string.substring(0, n).toUpperCase();
        this.latticeCode = string2.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = string2.charAt(1);
        }
        return string.substring(n + 1).trim();
    }

    private String extractVectorInfo(String string) {
        this.vector12ths = new P3i();
        this.vectorCode = "";
        int n = string.indexOf("(");
        int n2 = string.indexOf(")", n);
        if (n > 0 && n2 > n) {
            String string2 = string.substring(n + 1, n2);
            this.vectorCode = " (" + string2 + ")";
            string = string.substring(0, n).trim();
            n = string2.indexOf(" ");
            if (n >= 0) {
                this.vector12ths.x = Integer.parseInt(string2.substring(0, n));
                if ((n = (string2 = string2.substring(n + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(string2.substring(0, n));
                    string2 = string2.substring(n + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(string2);
        }
        return string;
    }

    private String extractRotationInfo(String string, int n, char c) {
        String string2;
        int n2 = string.indexOf(" ");
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1).trim();
        } else {
            string2 = string;
            string = "";
        }
        this.rotationTerms[this.nRotations] = new HallRotationTerm(this, string2, n, c);
        ++this.nRotations;
        return string;
    }
}

