/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.C;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;
    private P3i[] screens;

    @Override
    protected boolean render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        this.g3d.addRenderer(1073742182);
        short[] sArray = polyhedra.colixes;
        boolean bl = false;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            int n2 = polyhedronArray[n].centralAtom.i;
            short s = sArray == null || n2 >= sArray.length ? (short)0 : polyhedra.colixes[n2];
            if (!this.render1(polyhedronArray[n], s)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean render1(Polyhedron polyhedron, short s) {
        int n;
        if (polyhedron.visibilityFlags == 0) {
            return false;
        }
        s = C.getColixInherited(s, polyhedron.centralAtom.getColix());
        boolean bl = false;
        if (C.isColixTranslucent(s)) {
            bl = true;
        } else if (!this.g3d.setColix(s)) {
            return false;
        }
        P3[] p3Array = polyhedron.vertices;
        if (this.screens == null || this.screens.length < p3Array.length) {
            this.screens = new P3i[p3Array.length];
            n = p3Array.length;
            while (--n >= 0) {
                this.screens[n] = new P3i();
            }
        }
        byte[] byArray = polyhedron.planes;
        n = p3Array.length;
        while (--n >= 0) {
            Atom atom;
            Atom atom2 = atom = p3Array[n] instanceof Atom ? (Atom)p3Array[n] : null;
            if (atom == null) {
                this.vwr.transformPtScr(p3Array[n], this.screens[n]);
                continue;
            }
            this.screens[n].set(atom.sX, atom.sY, atom.sZ);
        }
        this.isAll = this.drawEdges == 1;
        boolean bl2 = this.frontOnly = this.drawEdges == 2;
        if (!bl || this.g3d.setColix(s)) {
            n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                this.fillFace(polyhedron.normixes[n++], this.screens[byArray[n2++]], this.screens[byArray[n2++]], this.screens[byArray[n2++]]);
            }
        }
        if (this.g3d.setColix(C.getColixTranslucent3(s, false, 0.0f))) {
            n = 0;
            int n3 = 0;
            while (n3 < byArray.length) {
                this.drawFace(polyhedron.normixes[n++], this.screens[byArray[n3++]], this.screens[byArray[n3++]], this.screens[byArray[n3++]]);
            }
        }
        return bl;
    }

    private void drawFace(short s, P3i p3i, P3i p3i2, P3i p3i3) {
        if (this.isAll || this.frontOnly && this.g3d.isDirectedTowardsCamera(s)) {
            this.drawCylinderTriangle(p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    private void drawCylinderTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.g3d.isAntialiased() ? 6 : 3;
        this.g3d.fillCylinderScreen((byte)3, n10, n, n2, n3, n4, n5, n6);
        this.g3d.fillCylinderScreen((byte)3, n10, n4, n5, n6, n7, n8, n9);
        this.g3d.fillCylinderScreen((byte)3, n10, n, n2, n3, n7, n8, n9);
    }

    private void fillFace(short s, P3i p3i, P3i p3i2, P3i p3i3) {
        this.g3d.fillTriangleTwoSided(s, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
    }
}

