/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;
import org.jmol.viewer.Viewer;

public abstract class BioPolymer {
    public Monomer[] monomers;
    public Model model;
    protected P3[] leadMidpoints;
    protected P3[] leadPoints;
    protected P3[] controlPoints;
    protected V3[] wingVectors;
    protected int[] leadAtomIndices;
    protected int type = 0;
    public int bioPolymerIndexInModel;
    public int monomerCount;
    protected static final int TYPE_NOBONDING = 0;
    protected static final int TYPE_AMINO = 1;
    protected static final int TYPE_NUCLEIC = 2;
    protected static final int TYPE_CARBOHYDRATE = 3;
    private boolean invalidLead;
    protected boolean invalidControl = false;
    protected float sheetSmoothing;
    protected boolean hasWingPoints;
    public BS reversed;
    public boolean twistedSheets;
    private final V3 unitVectorX = V3.new3(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BS bsSelectedMonomers;
    public boolean haveParameters;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};

    public Group[] getGroups() {
        return this.monomers;
    }

    BioPolymer(Monomer[] monomerArray) {
        this.monomers = monomerArray;
        int n = this.monomerCount = monomerArray.length;
        while (--n >= 0) {
            monomerArray[n].setBioPolymer(this, n);
        }
        this.model = monomerArray[0].getModel();
    }

    public void getRange(BS bS) {
        if (this.monomerCount == 0) {
            return;
        }
        bS.setBits(this.monomers[0].firstAtomIndex, this.monomers[this.monomerCount - 1].lastAtomIndex + 1);
    }

    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    protected void removeProteinStructure(int n, int n2) {
        Monomer monomer = this.monomers[n];
        STR sTR = monomer.getProteinStructureType();
        int n3 = -1;
        int n4 = 0;
        for (int i = n; n4 < n2 && i < this.monomerCount; ++n4, ++i) {
            this.monomers[i].setStructure(null);
            n3 = this.monomers[i].setProteinStructureType(sTR, n3);
        }
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            this.invalidLead = true;
        }
        if (this.invalidLead) {
            int n = this.monomerCount;
            while (--n >= 0) {
                this.leadAtomIndices[n] = this.monomers[n].leadAtomIndex;
            }
            this.invalidLead = false;
        }
        return this.leadAtomIndices;
    }

    protected int getIndex(int n, int n2, int n3, int n4) {
        int n5 = this.monomerCount;
        while (--n5 >= 0) {
            Monomer monomer = this.monomers[n5];
            if (monomer.chain.chainID != n || monomer.seqcode != n2 || n3 >= 0 && n3 != monomer.firstAtomIndex && n4 != monomer.lastAtomIndex) continue;
            break;
        }
        return n5;
    }

    final P3 getLeadPoint(int n) {
        return this.monomers[n].getLeadAtom();
    }

    private final P3 getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    private final P3 getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int n, P3 p3) {
        if (n == this.monomerCount) {
            --n;
        } else if (n > 0) {
            p3.ave(this.getLeadPoint(n), this.getLeadPoint(n - 1));
            return;
        }
        p3.setT(this.getLeadPoint(n));
    }

    final P3 getWingPoint(int n) {
        return this.monomers[n].getWingAtom();
    }

    public void getConformation(BS bS, int n) {
        Atom[] atomArray = this.model.getModelSet().at;
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            this.monomers[n2].getConformation(atomArray, bS, n);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void setConformation(BS bS) {
        Atom[] atomArray = this.model.getModelSet().at;
        int n = this.monomerCount;
        while (--n >= 0) {
            this.monomers[n].updateOffsetsForAlternativeLocations(atomArray, bS);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.invalidControl = true;
        this.invalidLead = true;
        this.getLeadAtomIndices();
        this.resetHydrogenPoints();
        this.calcLeadMidpointsAndWingVectors();
    }

    protected void resetHydrogenPoints() {
    }

    public P3[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadMidpoints;
    }

    P3[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadPoints;
    }

    public P3[] getControlPoints(boolean bl, float f, boolean bl2) {
        if (bl2) {
            this.invalidControl = true;
        }
        return !bl ? this.leadMidpoints : (f == 0.0f ? this.leadPoints : this.getControlPoints2(f));
    }

    private P3[] getControlPoints2(float f) {
        if (!this.invalidControl && f == this.sheetSmoothing) {
            return this.controlPoints;
        }
        this.getLeadPoints();
        V3 v3 = new V3();
        if (this.controlPoints == null) {
            this.controlPoints = new P3[this.monomerCount + 1];
        }
        if (!Float.isNaN(f)) {
            this.sheetSmoothing = f;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.controlPoints[i] = this.getControlPoint(i, v3);
        }
        this.controlPoints[this.monomerCount] = this.getTerminatorPoint();
        this.invalidControl = false;
        return this.controlPoints;
    }

    protected P3 getControlPoint(int n, V3 v3) {
        return this.leadPoints[n];
    }

    public final V3[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors() {
        P3 p3;
        if (this.leadMidpoints == null) {
            this.leadMidpoints = new P3[this.monomerCount + 1];
            this.leadPoints = new P3[this.monomerCount + 1];
            this.wingVectors = new V3[this.monomerCount + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        if (this.reversed == null) {
            this.reversed = BS.newN(this.monomerCount);
        } else {
            this.reversed.clearAll();
        }
        this.twistedSheets = this.model.ms.vwr.getBoolean(603979968);
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        V3 v34 = new V3();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = p3 = this.getLeadPoint(0);
        V3 v35 = null;
        for (int i = 1; i < this.monomerCount; ++i) {
            P3 p32 = p3;
            this.leadPoints[i] = p3 = this.getLeadPoint(i);
            P3 p33 = new P3();
            p33.ave(p3, p32);
            this.leadMidpoints[i] = p33;
            if (!this.hasWingPoints) continue;
            v3.sub2(p3, p32);
            v32.sub2(p32, this.getWingPoint(i - 1));
            v33.cross(v3, v32);
            v34.cross(v3, v33);
            v34.normalize();
            if (!this.twistedSheets && v35 != null && (double)v35.angle(v34) > 1.5707963267948966) {
                this.reversed.set(i);
                v34.scale(-1.0f);
            }
            v35 = this.wingVectors[i] = V3.newV(v34);
        }
        this.leadPoints[this.monomerCount] = this.leadMidpoints[this.monomerCount] = this.getTerminatorPoint();
        if (!this.hasWingPoints) {
            if (this.monomerCount < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                V3 v36 = null;
                for (int i = 1; i < this.monomerCount; ++i) {
                    v3.sub2(this.leadMidpoints[i], this.leadPoints[i]);
                    v32.sub2(this.leadPoints[i], this.leadMidpoints[i + 1]);
                    v33.cross(v3, v32);
                    v33.normalize();
                    if (v36 != null && (double)v36.angle(v33) > 1.5707963267948966) {
                        v33.scale(-1.0f);
                    }
                    v36 = this.wingVectors[i] = V3.newV(v33);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[this.monomerCount] = this.wingVectors[this.monomerCount - 1];
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short[] sArray, int n3, BS bS) {
        int n4 = this.monomerCount;
        while (--n4 >= 0) {
            Atom atom;
            if ((this.monomers[n4].shapeVisibilityFlags & n3) == 0 || !(atom = this.monomers[n4].getLeadAtom()).checkVisible() || bS != null && bS.get(atom.i) || sArray[n4] <= 0 && sArray[n4 + 1] <= 0) continue;
            this.monomers[n4].findNearestAtomIndex(n, n2, atomArray, sArray[n4], sArray[n4 + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BS bS) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BS();
        }
        this.bsSelectedMonomers.clearAll();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bS)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int n) {
        return n >= 0 && this.bsSelectedMonomers.get(n);
    }

    public int getPolymerPointsAndVectors(int n, BS bS, List<P3[]> list, boolean bl, float f) {
        P3[] p3Array = this.getControlPoints(bl, f, false);
        V3[] v3Array = this.getWingVectors();
        int n2 = this.monomerCount;
        for (int i = 0; i < n2; ++i) {
            if (bS.get(this.monomers[i].leadAtomIndex)) {
                list.addLast(new P3[]{p3Array[i], P3.newP(v3Array[i])});
                n = i;
                continue;
            }
            if (n == 0x7FFFFFFE) continue;
            list.addLast(new P3[]{p3Array[i], P3.newP(v3Array[i])});
            n = 0x7FFFFFFE;
        }
        if (n + 1 < n2) {
            list.addLast(new P3[]{p3Array[n + 1], P3.newP(v3Array[n + 1])});
        }
        return n;
    }

    public String getSequence() {
        char[] cArray = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            cArray[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(cArray);
    }

    public Map<String, Object> getPolymerInfo(BS bS) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        List<Hashtable<String, Object>> list2 = null;
        ProteinStructure proteinStructure = null;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!bS.get(this.monomers[i].leadAtomIndex)) continue;
            Map<String, Object> map = this.monomers[i].getMyInfo();
            map.put("monomerIndex", i);
            list.addLast(map);
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 == null || proteinStructure2 == proteinStructure) continue;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            proteinStructure = proteinStructure2;
            proteinStructure.getInfo(hashtable2);
            if (list2 == null) {
                list2 = new List<Hashtable<String, Object>>();
            }
            hashtable2.put("index", n++);
            list2.addLast(hashtable2);
        }
        if (list.size() > 0) {
            hashtable.put("sequence", this.getSequence());
            hashtable.put("monomers", list);
            if (list2 != null) {
                hashtable.put("structures", list2);
            }
        }
        return hashtable;
    }

    public void getPolymerSequenceAtoms(int n, int n2, BS bS, BS bS2) {
        int n3 = Math.min(this.monomerCount, n + n2);
        while (--n3 >= n) {
            this.monomers[n3].getMonomerSequenceAtoms(bS, bS2);
        }
    }

    public ProteinStructure getProteinStructure(int n) {
        return this.monomers[n].getProteinStructure();
    }

    public boolean calcParameters() {
        this.haveParameters = true;
        return this.calcEtaThetaAngles() || this.calcPhiPsiAngles();
    }

    protected boolean calcEtaThetaAngles() {
        return false;
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    public static final void getPdbData(Viewer viewer, BioPolymer bioPolymer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3) {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7 = c2 == 'C' || c2 == 'P';
        boolean bl8 = bl6 = c == 'R' || c == 'S' && bl7;
        if (bl6 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        boolean bl9 = bioPolymer instanceof AminoPolymer;
        boolean bl10 = c == 'r';
        boolean bl11 = bl5 = !bl6 && c == 'S';
        if (n2 == 2 && bl10) {
            c = (char)119;
        }
        if (bl5) {
            n2 = 2;
        }
        boolean bl12 = c == 'S';
        boolean bl13 = bl4 = "rcpCP".indexOf(c2) >= 0;
        if (Logger.debugging && (bl5 || bl7)) {
            Logger.debug("For straightness calculation: useQuaternionStraightness = " + bl12 + " and quaternionFrame = " + c2);
        }
        if (bl3 && !bl2) {
            oC.append("REMARK   6    AT GRP CH RESNO  ");
            switch (c) {
                default: {
                    oC.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    oC.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    oC.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    oC.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (bl4) {
                        oC.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    oC.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            oC.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            oC.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (c != 'R') {
                oC.append("  centerX___ centerY___ centerZ___");
            }
            if (c2 == 'n') {
                oC.append("  NHX_______ NHY_______ NHZ_______");
            }
            oC.append("\n\n");
        }
        float f = c == 'R' ? 1.0f : 10.0f;
        bl = false;
        int n3 = 0;
        while (n3 < (bl ? 2 : 1)) {
            for (int i = 0; i < (n < 1 ? 1 : n); ++i) {
                BioPolymer.getData(viewer, i, n, bioPolymer, c, c2, n2, bS, bS2, bl2, bl6, bl7, bl12, bl4, bl5, f, bl9, bl10, labelTokenArray, oC, sB, bS3);
            }
            ++n3;
            f *= -1.0f;
        }
    }

    private static void getData(Viewer viewer, int n, int n2, BioPolymer bioPolymer, char c, char c2, int n3, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f, boolean bl7, boolean bl8, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3) {
        String string = n3 > 0 ? "dq" + (n3 == 2 ? "2" : "") : "q";
        Atom atom = null;
        Quat quat = null;
        Quat quat2 = null;
        Quat quat3 = null;
        Quat quat4 = null;
        Atom atom2 = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string2 = "";
        float f6 = Float.NaN;
        float f7 = Float.NaN;
        P3 p3 = bl ? new P3() : null;
        int n4 = n2 <= 1 ? 1 : n2;
        for (int i = n; i < bioPolymer.monomerCount; i += n4) {
            Quat quat5;
            Object object;
            Monomer monomer = bioPolymer.monomers[i];
            if (bS != null && !bS.get(monomer.leadAtomIndex)) continue;
            Atom atom3 = monomer.getLeadAtom();
            String string3 = monomer.getUniqueID();
            if (bl2) {
                float f8;
                if (c == 'S') {
                    monomer.setGroupParameter(1112539150, Float.NaN);
                }
                f2 = monomer.getGroupParameter(1112539145);
                f3 = monomer.getGroupParameter(1112539146);
                f4 = monomer.getGroupParameter(1112539144);
                if (f4 < -90.0f) {
                    f4 += 360.0f;
                }
                if (Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4 -= 180.0f)) {
                    if (bS == null) continue;
                    bS.clear(atom3.i);
                    continue;
                }
                float f9 = bl5 ? bioPolymer.calculateRamachandranHelixAngle(i, c2) : 0.0f;
                float f10 = f8 = bl3 || bl5 ? BioPolymer.getStraightness((float)Math.cos((double)(f9 / 2.0f / 180.0f) * Math.PI)) : 0.0f;
                if (c == 'S') {
                    monomer.setGroupParameter(1112539150, f8);
                    continue;
                }
                if (bl) {
                    if (bS2 != null && !bS2.get(atom3.getIndex())) continue;
                    object = (AminoMonomer)monomer;
                    p3.set(-f2, f2, 0.5f);
                    oC.append("draw ID \"phi").append(string3).append("\" ARROW ARC ").append(Escape.eP(((AminoMonomer)object).getNitrogenAtom())).append(Escape.eP(atom3)).append(Escape.eP(((AminoMonomer)object).getCarbonylCarbonAtom())).append(Escape.eP(p3)).append(" \"phi = ").append(String.valueOf(Math.round(f2))).append("\" color ").append(qColor[2]).append("\n");
                    p3.set(0.0f, f3, 0.5f);
                    oC.append("draw ID \"psi").append(string3).append("\" ARROW ARC ").append(Escape.eP(atom3)).append(Escape.eP(((AminoMonomer)object).getCarbonylCarbonAtom())).append(Escape.eP(((AminoMonomer)object).getNitrogenAtom())).append(Escape.eP(p3)).append(" \"psi = ").append(String.valueOf(Math.round(f3))).append("\" color ").append(qColor[1]).append("\n");
                    oC.append("draw ID \"planeNCC").append(string3).append("\" ").append(Escape.eP(((AminoMonomer)object).getNitrogenAtom())).append(Escape.eP(atom3)).append(Escape.eP(((AminoMonomer)object).getCarbonylCarbonAtom())).append(" color ").append(qColor[0]).append("\n");
                    oC.append("draw ID \"planeCNC").append(string3).append("\" ").append(Escape.eP(((AminoMonomer)bioPolymer.monomers[i - 1]).getCarbonylCarbonAtom())).append(Escape.eP(((AminoMonomer)object).getNitrogenAtom())).append(Escape.eP(atom3)).append(" color ").append(qColor[1]).append("\n");
                    oC.append("draw ID \"planeCCN").append(string3).append("\" ").append(Escape.eP(atom3)).append(Escape.eP(((AminoMonomer)object).getCarbonylCarbonAtom())).append(Escape.eP(((AminoMonomer)bioPolymer.monomers[i + 1]).getNitrogenAtom())).append(" color ").append(qColor[2]).append("\n");
                    continue;
                }
                if (Float.isNaN(f9)) {
                    string2 = "";
                    if (bl5) {
                        continue;
                    }
                } else {
                    quat5 = Quat.newVA(P3.new3(1.0f, 0.0f, 0.0f), f9);
                    string2 = BioPolymer.getQInfo(quat5);
                    if (bl5) {
                        f4 = f9;
                        f5 = f8;
                    } else {
                        f5 = atom3.getPartialCharge();
                    }
                }
            } else {
                quat5 = monomer.getQuaternion(c2);
                if (quat5 != null) {
                    quat5.setRef(quat4);
                    quat4 = Quat.newQ(quat5);
                }
                if (n3 == 2) {
                    monomer.setGroupParameter(1112539150, Float.NaN);
                }
                if (quat5 == null) {
                    quat = null;
                    quat4 = null;
                } else if (n3 > 0) {
                    Atom atom4 = atom3;
                    Quat quat6 = quat5;
                    if (quat == null) {
                        quat5 = null;
                        quat3 = null;
                    } else {
                        quat2 = bl8 ? quat.leftDifference(quat5) : quat5.rightDifference(quat);
                        if (n3 == 1) {
                            quat5 = quat2;
                        } else if (quat3 == null) {
                            quat5 = null;
                        } else {
                            quat5 = quat2.rightDifference(quat3);
                            f6 = BioPolymer.getQuaternionStraightness(string3, quat3, quat2);
                            f7 = BioPolymer.get3DStraightness(string3, quat3, quat2);
                            ((Monomer)atom.getGroup()).setGroupParameter(1112539150, bl4 ? f6 : f7);
                        }
                        quat3 = quat2;
                    }
                    atom = atom4;
                    quat = quat6;
                }
                if (quat5 == null) {
                    atom2 = null;
                    continue;
                }
                switch (c) {
                    default: {
                        f2 = quat5.q1;
                        f3 = quat5.q2;
                        f4 = quat5.q3;
                        f5 = quat5.q0;
                        break;
                    }
                    case 'x': {
                        f2 = quat5.q0;
                        f3 = quat5.q1;
                        f4 = quat5.q2;
                        f5 = quat5.q3;
                        break;
                    }
                    case 'y': {
                        f2 = quat5.q3;
                        f3 = quat5.q0;
                        f4 = quat5.q1;
                        f5 = quat5.q2;
                        break;
                    }
                    case 'z': {
                        f2 = quat5.q2;
                        f3 = quat5.q3;
                        f4 = quat5.q0;
                        f5 = quat5.q1;
                    }
                }
                P3 p32 = monomer.getQuaternionFrameCenter(c2);
                if (p32 == null) {
                    p32 = new P3();
                }
                if (bl) {
                    if (bS2 != null && !bS2.get(atom3.getIndex())) continue;
                    int n5 = (int)Math.floor(Math.acos(f5) * 360.0 / Math.PI);
                    if (n3 == 0) {
                        oC.append(Escape.drawQuat(quat5, string, string3, p32, 1.0f));
                        if (c2 == 'n' && bl7 && (object = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            oC.append("draw ID \"").append(string).append("nh").append(string3).append("\" width 0.1 ").append(Escape.eP((T3)object)).append("\n");
                        }
                    }
                    if (n3 == 1) {
                        oC.append((String)monomer.getHelixData(135176, c2, n2)).append("\n");
                        continue;
                    }
                    p3.set(f2 * 2.0f, f3 * 2.0f, f4 * 2.0f);
                    oC.append("draw ID \"").append(string).append("a").append(string3).append("\" VECTOR ").append(Escape.eP(p32)).append(Escape.eP(p3)).append(" \">").append(String.valueOf(n5)).append("\" color ").append(qColor[n3]).append("\n");
                    continue;
                }
                string2 = BioPolymer.getQInfo(quat5) + Txt.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{p32});
                if (c2 == 'n' && bl7) {
                    string2 = string2 + Txt.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (n3 == 2 && !Float.isNaN(f6)) {
                    string2 = string2 + Txt.sprintf(" %10.5f %10.5f", "F", new Object[]{new float[]{f6, f7}});
                }
            }
            if (oC == null) continue;
            bS3.set(((Monomer)atom3.getGroup()).leadAtomIndex);
            viewer.ms.getLabeler();
            oC.append(LabelToken.formatLabelAtomArray(viewer, atom3, labelTokenArray, '\u0000', null));
            oC.append(Txt.sprintf("%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", "ssF", new Object[]{atom3.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2 * f, f3 * f, f4 * f, f5 * f}}));
            if (atom2 != null && atom2.getPolymerIndexInModel() == atom3.getPolymerIndexInModel()) {
                sB.append("CONECT").append(Txt.formatStringI("%5i", "i", atom2.getAtomNumber())).append(Txt.formatStringI("%5i", "i", atom3.getAtomNumber())).appendC('\n');
            }
            atom2 = atom3;
        }
    }

    public String drawQuat(Quat quat, String string, String string2, P3 p3, float f) {
        String string3 = " VECTOR " + Escape.eP(p3) + " ";
        if (f == 0.0f) {
            f = 1.0f;
        }
        return "draw " + string + "x" + string2 + string3 + Escape.eP(quat.getVectorScaled(0, f)) + " color red\n" + "draw " + string + "y" + string2 + string3 + Escape.eP(quat.getVectorScaled(1, f)) + " color green\n" + "draw " + string + "z" + string2 + string3 + Escape.eP(quat.getVectorScaled(2, f)) + " color blue\n";
    }

    private static String getQInfo(Quat quat) {
        A4 a4 = quat.toAxisAngle4f();
        return Txt.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", "F", new Object[]{new float[]{quat.q0, quat.q1, quat.q2, quat.q3, (float)((double)(a4.angle * 180.0f) / Math.PI), a4.x, a4.y, a4.z}});
    }

    protected float calculateRamachandranHelixAngle(int n, char c) {
        return Float.NaN;
    }

    private static float get3DStraightness(String string, Quat quat, Quat quat2) {
        return quat.getNormal().dot(quat2.getNormal());
    }

    private static float getQuaternionStraightness(String string, Quat quat, Quat quat2) {
        return BioPolymer.getStraightness(quat.dot(quat2));
    }

    private static float getStraightness(float f) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(f)) / Math.PI);
    }

    public boolean isDna() {
        return this.monomerCount > 0 && this.monomers[0].isDna();
    }

    public boolean isRna() {
        return this.monomerCount > 0 && this.monomers[0].isRna();
    }

    public void getRangeGroups(int n, BS bS, BS bS2) {
        int n2;
        BS bS3 = new BS();
        for (n2 = 0; n2 < this.monomerCount; ++n2) {
            if (!this.monomers[n2].isSelected(bS)) continue;
            bS3.setBits(Math.max(0, n2 - n), n2 + n + 1);
            n2 += n - 1;
        }
        n2 = bS3.nextSetBit(0);
        while (n2 >= 0 && n2 < this.monomerCount) {
            this.monomers[n2].selectAtoms(bS2);
            n2 = bS3.nextSetBit(n2 + 1);
        }
    }

    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, List<Bond> list, int n, int[][][] nArray, boolean bl, boolean bl2) {
    }

    public void setStructureList(Map<STR, float[]> map) {
    }

    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OC oC, SB sB, BS bS3) {
    }

    public int getType() {
        return this.type;
    }

    public List<Atom[]> calculateStruts(ModelSet modelSet, BS bS, BS bS2, List<Atom> list, float f, int n, boolean bl) {
        return null;
    }
}

