/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.StateScript;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Measure;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected final Atom[] closest = new Atom[1];
    private SymmetryInterface pointGroup;
    private final M3 matTemp = new M3();
    private final M3 matInv = new M3();
    private final M4 mat4 = new M4();
    private final M4 mat4t = new M4();
    private final V3 vTemp = new V3();

    public ModelSet(Viewer viewer, String string) {
        this.vwr = viewer;
        this.modelSetName = string;
    }

    @Override
    protected void releaseModelSet() {
        this.am = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        this.selectionHaloEnabled = bl;
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.mc; ++i) {
                if (this.modelNumbers[i] != n && (n >= 1000000 || this.modelNumbers[i] != 1000000 + n)) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public BS getBitSetTrajectories() {
        if (this.trajectorySteps == null) {
            return null;
        }
        BS bS = new BS();
        int n = this.mc;
        while (--n >= 0) {
            int n2 = this.am[n].getSelectedTrajectory();
            if (n2 < 0) continue;
            bS.set(n2);
            n = this.am[n].trajectoryBaseIndex;
        }
        return bS;
    }

    public void setTrajectoryBs(BS bS) {
        for (int i = 0; i < this.mc; ++i) {
            if (!bS.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        if (n < 0 || !this.isTrajectory(n)) {
            return;
        }
        if (this.at[this.am[n].firstAtomIndex].mi == n) {
            return;
        }
        int n2 = this.am[n].trajectoryBaseIndex;
        this.am[n2].setSelectedTrajectory(n);
        this.setAtomPositions(n2, n, (P3[])this.trajectorySteps.get(n), null, 0.0f, this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(n), true);
        int n3 = this.vwr.getCurrentModelIndex();
        if (n3 >= 0 && n3 != n && this.am[n3].fileIndex == this.am[n].fileIndex) {
            this.vwr.setCurrentModelIndexClear(n, false);
        }
    }

    public void morphTrajectories(int n, int n2, float f) {
        if (n < 0 || n2 < 0 || !this.isTrajectory(n) || !this.isTrajectory(n2)) {
            return;
        }
        if (f == 0.0f) {
            this.setTrajectory(n);
            return;
        }
        if (f == 1.0f) {
            this.setTrajectory(n2);
            return;
        }
        int n3 = this.am[n].trajectoryBaseIndex;
        this.am[n3].setSelectedTrajectory(n);
        this.setAtomPositions(n3, n, (P3[])this.trajectorySteps.get(n), (P3[])this.trajectorySteps.get(n2), f, this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(n), true);
        int n4 = this.vwr.getCurrentModelIndex();
        if (n4 >= 0 && n4 != n && this.am[n4].fileIndex == this.am[n].fileIndex) {
            this.vwr.setCurrentModelIndexClear(n, false);
        }
    }

    private void setAtomPositions(int n, int n2, P3[] p3Array, P3[] p3Array2, float f, V3[] v3Array, boolean bl) {
        BS bS = new BS();
        V3 v3 = new V3();
        int n3 = this.am[n].firstAtomIndex;
        int n4 = n3 + this.getAtomCountInModel(n);
        if (f == 0.0f) {
            int n5 = 0;
            for (int i = n3; i < n4 && n5 < p3Array.length; ++i, ++n5) {
                this.at[i].mi = (short)n2;
                if (p3Array[n5] == null) continue;
                if (bl) {
                    this.at[i].setFractionalCoordTo(p3Array[n5], true);
                } else {
                    this.at[i].setT(p3Array[n5]);
                }
                if (this.vibrationSteps != null) {
                    if (v3Array != null && v3Array[n5] != null) {
                        v3 = v3Array[n5];
                    }
                    this.setVibrationVector(i, v3);
                }
                bS.set(i);
            }
        } else {
            P3 p3 = new P3();
            int n6 = Math.min(p3Array.length, p3Array2.length);
            int n7 = 0;
            for (int i = n3; i < n4 && n7 < n6; ++i, ++n7) {
                this.at[i].mi = (short)n2;
                if (p3Array[n7] == null || p3Array2[n7] == null) continue;
                p3.sub2(p3Array2[n7], p3Array[n7]);
                p3.scaleAdd2(f, p3, p3Array[n7]);
                if (bl) {
                    this.at[i].setFractionalCoordTo(p3, true);
                } else {
                    this.at[i].setT(p3);
                }
                bS.set(i);
            }
        }
        this.initializeBspf();
        this.validateBspfForModel(n, false);
        this.recalculateLeadMidpointsAndWingVectors(n);
        this.sm.refreshShapeTrajectories(n, bS, null);
        if (this.am[n].hasRasmolHBonds) {
            this.am[n].clearRasmolHydrogenBonds(null);
            this.am[n].getRasmolHydrogenBonds(bS, bS, null, false, Integer.MAX_VALUE, false, null);
        }
    }

    public P3[] getFrameOffsets(BS bS) {
        int n;
        if (bS == null) {
            return null;
        }
        P3[] p3Array = new P3[this.mc];
        for (n = 0; n < this.mc; ++n) {
            p3Array[n] = new P3();
        }
        n = 0;
        int n2 = 0;
        P3 p3 = p3Array[0];
        boolean bl = this.trajectorySteps != null && this.trajectorySteps.size() == this.mc;
        int n3 = bl ? this.mc : 1;
        block1: for (int i = 0; i < n3; ++i) {
            if (bl) {
                this.setTrajectory(i);
            }
            for (int j = 0; j <= this.ac; ++j) {
                if (j == this.ac || this.at[j].mi != n) {
                    if (n2 > 0) {
                        p3.scale(-1.0f / (float)n2);
                        if (n != 0) {
                            p3.sub(p3Array[0]);
                        }
                        n2 = 0;
                    }
                    if (j == this.ac) continue block1;
                    n = this.at[j].mi;
                    p3 = p3Array[n];
                }
                if (!bS.get(j)) continue;
                p3.add(this.at[j]);
                ++n2;
            }
        }
        p3Array[0].set(0.0f, 0.0f, 0.0f);
        return p3Array;
    }

    public BS getAtomBits(int n, Object object) {
        switch (n) {
            default: {
                return BSUtil.andNot(this.getAtomBitsMaybeDeleted(n, object), this.vwr.getDeletedAtoms());
            }
            case 0x100022: 
        }
        int n2 = (Integer)object;
        int n3 = this.getModelNumberIndex(n2, true, true);
        return n3 < 0 && n2 > 0 ? new BS() : this.vwr.getModelUndeletedAtomsBitSet(n3);
    }

    public String getAtomLabel(int n) {
        return (String)this.vwr.getShapePropertyIndex(5, "label", n);
    }

    public int findNearestAtomIndex(int n, int n2, BS bS, int n3) {
        if (this.ac == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearest2(n, n2, this.closest, bS, n3);
        this.sm.findNearestShapeAtomIndex(n, n2, this.closest, bS);
        int n4 = this.closest[0] == null ? -1 : this.closest[0].i;
        this.closest[0] = null;
        return n4;
    }

    public String calculateStructures(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        BS bS2 = new BS();
        BS bS3 = BSUtil.copyInvert(this.modelsOf(bS, bS2), this.mc);
        if (!bl4) {
            return this.calculateStructuresAllExcept(bS3, bl, bl2, bl3, false, false);
        }
        for (int i = 0; i < this.mc; ++i) {
            if (bS3.get(i)) continue;
            this.am[i].clearBioPolymers();
        }
        this.calculatePolymers(null, 0, 0, bS3);
        String string = this.calculateStructuresAllExcept(bS3, bl, bl2, bl3, true, false);
        this.vwr.resetBioshapes(bS2);
        this.setStructureIndexes();
        return string;
    }

    public String calculatePointGroup(BS bS) {
        return (String)this.calculatePointGroupForFirstModel(bS, false, false, false, null, 0, 0.0f);
    }

    public Map<String, Object> getPointGroupInfo(BS bS) {
        return (Map)this.calculatePointGroupForFirstModel(bS, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BS bS, boolean bl, String string, int n, float f) {
        return (String)this.calculatePointGroupForFirstModel(bS, true, bl, false, string, n, f);
    }

    private Object calculatePointGroupForFirstModel(BS bS, boolean bl, boolean bl2, boolean bl3, String string, int n, float f) {
        Object object;
        int n2;
        int n3 = this.vwr.getCurrentModelIndex();
        int n4 = n2 = bS == null ? -1 : bS.nextSetBit(0);
        if (n3 < 0 && n2 >= 0) {
            n3 = this.at[n2].getModelIndex();
        }
        if (n3 < 0) {
            n3 = this.vwr.getVisibleFramesBitSet().nextSetBit(0);
            bS = null;
        }
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
        if (bS != null) {
            bS2.and(bS);
        }
        if ((n2 = bS2.nextSetBit(0)) < 0) {
            bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
            n2 = bS2.nextSetBit(0);
        }
        boolean bl4 = (object = this.vwr.getShapePropertyIndex(18, "mad", n2)) != null && (Integer)object != 0 || this.vwr.isVibrationOn();
        SymmetryInterface symmetryInterface = Interface.getSymmetry();
        this.pointGroup = symmetryInterface.setPointGroup(this.pointGroup, this.at, bS2, bl4, this.vwr.getFloat(0x22000026), this.vwr.getFloat(0x22000028));
        if (!bl && !bl3) {
            return this.pointGroup.getPointGroupName();
        }
        Object object2 = this.pointGroup.getPointGroupInfo(n3, bl2, bl3, string, n, f);
        if (bl3) {
            return object2;
        }
        return (this.mc > 1 ? "frame " + this.getModelNumberDotted(n3) + "; " : "") + object2;
    }

    private BS modelsOf(BS bS, BS bS2) {
        int n;
        BS bS3 = BS.newN(this.mc);
        boolean bl = bS == null;
        int n2 = n = bl ? this.ac - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.am[this.at[n2].mi].trajectoryBaseIndex;
            if (!this.isJmolDataFrameForModel(n3)) {
                bS3.set(n3);
                bS2.set(n2);
            }
            n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        return bS3;
    }

    public String getDefaultStructure(BS bS, BS bS2) {
        BS bS3 = this.modelsOf(bS, bS2);
        SB sB = new SB();
        int n = bS3.nextSetBit(0);
        while (n >= 0) {
            if (this.am[n].isBioModel && this.am[n].defaultStructure != null) {
                sB.append(this.am[n].defaultStructure);
            }
            n = bS3.nextSetBit(n + 1);
        }
        return sB.toString();
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        if (n2 == 1073741852 && n != 2048) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bS : null, bl ? null : bS, bl ? null : bS2, " auto", false, true);
        }
        this.moleculeCount = 0;
        return this.makeConnections2(f, f2, n, n2, bS, bS2, bS3, bl, bl2, f3);
    }

    public void setPdbConectBonding(int n, int n2, BS bS) {
        short s = this.vwr.getMadBond();
        for (int i = n2; i < this.mc; ++i) {
            int n3;
            List list = (List)this.getModelAuxiliaryInfoValue(i, "PDB_CONECT_bonds");
            if (list == null) continue;
            int n4 = list.size();
            this.setModelAuxiliaryInfo(i, "initialBondCount", n4);
            int[] nArray = (int[])this.getModelAuxiliaryInfoValue(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])list.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bS != null) {
                    if (this.at[n11].isHetero()) {
                        bS.set(n11);
                    }
                    if (this.at[n12].isHetero()) {
                        bS.set(n12);
                    }
                }
                this.checkValencesAndBond(this.at[n11], this.at[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    public void deleteAllBonds() {
        this.moleculeCount = 0;
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.remove(n);
        }
        this.deleteAllBonds2();
    }

    private void includeAllRelatedFrames(BS bS) {
        for (int i = 0; i < this.mc; ++i) {
            if (bS.get(i)) {
                int n;
                if (!this.isTrajectory(i) || bS.get(n = this.am[i].trajectoryBaseIndex)) continue;
                bS.set(n);
                this.includeAllRelatedFrames(bS);
                return;
            }
            if ((!this.isTrajectory(i) || !bS.get(this.am[i].trajectoryBaseIndex)) && (!this.isJmolDataFrameForModel(i) || !bS.get(this.am[i].dataSourceFrame))) continue;
            bS.set(i);
        }
    }

    public BS deleteModels(BS bS) {
        int n;
        this.moleculeCount = 0;
        BS bS2 = this.getModelBitSet(bS, false);
        this.includeAllRelatedFrames(bS2);
        int n2 = BSUtil.cardinalityOf(bS2);
        if (n2 == 0) {
            return null;
        }
        int n3 = bS2.nextSetBit(0);
        while (n3 >= 0) {
            this.clearDataFrameReference(n3);
            n3 = bS2.nextSetBit(n3 + 1);
        }
        if (n2 == this.mc) {
            BS bS3 = this.getModelAtomBitSetIncludingDeleted(-1, true);
            this.vwr.zap(true, false, false);
            return bS3;
        }
        this.validateBspf(false);
        Model[] modelArray = new Model[this.mc - n2];
        Model[] modelArray2 = this.am;
        BS bS4 = new BS();
        int n4 = 0;
        for (n = 0; n < this.mc; ++n) {
            if (bS2.get(n)) {
                this.getAtomCountInModel(n);
                bS4.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                continue;
            }
            this.am[n].modelIndex = n4;
            modelArray[n4++] = this.am[n];
        }
        this.am = modelArray;
        n = this.mc;
        BS bS5 = this.getBondsForSelectedAtoms(bS4, true);
        this.deleteBonds(bS5, true);
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bS2.get(i)) {
                ++n5;
                continue;
            }
            int n6 = modelArray2[i].ac;
            if (n6 == 0) continue;
            BS bS6 = modelArray2[i].bsAtoms;
            int n7 = modelArray2[i].firstAtomIndex;
            BSUtil.deleteBits(this.bsSymmetry, bS6);
            this.deleteModel(n5, n7, n6, bS6, bS5);
            int n8 = n;
            while (--n8 > i) {
                modelArray2[n8].fixIndices(n5, n6, bS6);
            }
            this.vwr.deleteShapeAtoms(new Object[]{modelArray, this.at, new int[]{n5, n7, n6}}, bS6);
            --this.mc;
        }
        this.deleteModel(-1, 0, 0, null, null);
        return bS4;
    }

    public void setAtomProperty(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                int n3;
                Object object;
                if (f > 4.0f) {
                    f = 4.0f;
                }
                if (fArray != null) {
                    object = new float[this.ac];
                    n3 = bS.nextSetBit(0);
                    int n4 = 0;
                    while (n3 >= 0) {
                        object[n3] = fArray[n4++];
                        n3 = bS.nextSetBit(n3 + 1);
                    }
                    fArray = object;
                }
            }
            case 1113200646: 
            case 1113200652: {
                Object object = null;
                int n3 = 0;
                if (fArray == null) {
                    if (f > 16.0f) {
                        f = 16.1f;
                    }
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    n3 = (int)Math.floor(f * 2000.0f);
                } else {
                    object = new RadiusData(fArray, 0.0f, null, null);
                }
                this.sm.setShapeSizeBs(JC.shapeTokenIndex(n), n3, (RadiusData)object, bS);
                return;
            }
        }
        this.setAPm(bS, n, n2, f, string, fArray, stringArray);
    }

    public Object getFileData(int n) {
        if (n < 0) {
            return "";
        }
        Map<String, Object> map = (Map<String, Object>)this.getModelAuxiliaryInfoValue(n, "fileData");
        if (map != null) {
            return map;
        }
        if (!this.getModelAuxiliaryInfoBoolean(n, "isCIF")) {
            return this.getPDBHeader(n);
        }
        map = this.vwr.getCifData(n);
        this.setModelAuxiliaryInfo(n, "fileData", map);
        return map;
    }

    @Override
    public int calculateStruts(BS bS, BS bS2) {
        this.vwr.setModelVisibility();
        return this.calculateStrutsMC(bS, bS2);
    }

    public BS addHydrogens(List<Atom> list, P3[] p3Array) {
        int n = this.mc - 1;
        BS bS = new BS();
        if (this.isTrajectory(n) || this.am[n].getGroupCount() > 1) {
            return bS;
        }
        this.growAtomArrays(this.ac + p3Array.length);
        RadiusData radiusData = this.vwr.getDefaultRadiusData();
        short s = this.getDefaultMadFromOrder(1);
        int n2 = 0;
        int n3 = this.am[n].ac + 1;
        while (n2 < list.size()) {
            Atom atom = (Atom)list.get(n2);
            Atom atom2 = this.addAtom(n, atom.group, 1, "H" + n3, n3, n3, p3Array[n2], Float.NaN, null, 0, 0.0f, 100, Float.NaN, null, false, (byte)0, null);
            atom2.setMadAtom(this.vwr, radiusData);
            bS.set(atom2.i);
            this.bondAtoms(atom, atom2, 1, s, null, 0.0f, false, false);
            ++n2;
            ++n3;
        }
        this.sm.loadDefaultShapes(this);
        return bS;
    }

    public void setAtomCoordsRelative(T3 t3, BS bS) {
        this.setAtomsCoordRelative(bS, t3.x, t3.y, t3.z);
        this.mat4.setIdentity();
        this.vTemp.setT(t3);
        this.mat4.setTranslation(this.vTemp);
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void setAtomCoords(BS bS, int n, Object object) {
        this.setAtomCoord2(bS, n, object);
        switch (n) {
            case 1112541202: 
            case 1112541203: 
            case 1112541204: 
            case 1146095631: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities(bS, null);
            }
        }
    }

    public void invertSelected(P3 p3, P4 p4, int n, BS bS, BS bS2) {
        if (p3 != null) {
            int n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                float f = (p3.x - this.at[n2].x) * 2.0f;
                float f2 = (p3.y - this.at[n2].y) * 2.0f;
                float f3 = (p3.z - this.at[n2].z) * 2.0f;
                this.setAtomCoordRelative(n2, f, f2, f3);
                n2 = bS2.nextSetBit(n2 + 1);
            }
            return;
        }
        if (p4 != null) {
            V3 v3 = V3.new3(p4.x, p4.y, p4.z);
            v3.normalize();
            float f = (float)Math.sqrt(p4.x * p4.x + p4.y * p4.y + p4.z * p4.z);
            int n3 = bS2.nextSetBit(0);
            while (n3 >= 0) {
                float f4 = -Measure.distanceToPlaneD(p4, f, this.at[n3]) * 2.0f;
                float f5 = v3.x * f4;
                float f6 = v3.y * f4;
                float f7 = v3.z * f4;
                this.setAtomCoordRelative(n3, f5, f6, f7);
                n3 = bS2.nextSetBit(n3 + 1);
            }
            return;
        }
        if (n >= 0) {
            Object object;
            Atom atom = this.at[n];
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return;
            }
            BS bS3 = new BS();
            List<P3> list = new List<P3>();
            BS bS4 = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            for (int i = 0; i < bondArray.length; ++i) {
                object = bondArray[i].getOtherAtom(atom);
                if (bS.get(((Atom)object).i)) {
                    bS3.or(JmolMolecule.getBranchBitSet(this.at, ((Atom)object).i, bS4, null, n, true, true));
                    continue;
                }
                list.addLast((P3)object);
            }
            if (list.size() == 0) {
                return;
            }
            p3 = Measure.getCenterAndPoints(list)[0];
            V3 v3 = V3.newVsub(atom, p3);
            object = Quat.newVA(v3, 180.0f);
            this.moveAtoms(null, ((Quat)object).getMatrix(), null, bS3, atom, true, false);
        }
    }

    public void setDihedrals(float[] fArray, BS[] bSArray, float f) {
        int n = fArray.length / 6;
        if (f > 1.0f) {
            f = 1.0f;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            BS bS = bSArray[n2];
            if (bS != null && !bS.isEmpty()) {
                Atom atom = this.at[(int)fArray[n3 + 1]];
                V3 v3 = V3.newVsub(this.at[(int)fArray[n3 + 2]], atom);
                float f2 = (fArray[n3 + 5] - fArray[n3 + 4]) * f;
                A4 a4 = A4.newVA(v3, (float)((double)(-f2) / 57.29577951308232));
                this.matTemp.setAA(a4);
                this.ptTemp.setT(atom);
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0) {
                    this.at[n4].sub(this.ptTemp);
                    this.matTemp.rotate(this.at[n4]);
                    this.at[n4].add(this.ptTemp);
                    this.taintAtom(n4, (byte)2);
                    n4 = bS.nextSetBit(n4 + 1);
                }
            }
            ++n2;
            n3 += 6;
        }
    }

    public void moveAtoms(M3 m3, M3 m32, V3 v3, BS bS, P3 p3, boolean bl, boolean bl2) {
        int n;
        if (!bl2) {
            if (m3 == null) {
                this.matTemp.setM3(m32);
            } else {
                this.matInv.setM3(m32);
                this.matInv.invert();
                this.ptTemp.set(0.0f, 0.0f, 0.0f);
                this.matTemp.mul2(m3, m32);
                this.matTemp.mul2(this.matInv, this.matTemp);
            }
            if (bl) {
                this.vTemp.setT(p3);
                this.mat4.setIdentity();
                this.mat4.setTranslation(this.vTemp);
                this.mat4t.setToM3(this.matTemp);
                this.mat4.mul(this.mat4t);
                this.mat4t.setIdentity();
                this.vTemp.scale(-1.0f);
                this.mat4t.setTranslation(this.vTemp);
                this.mat4.mul(this.mat4t);
            } else {
                this.mat4.setToM3(this.matTemp);
            }
            n = bS.nextSetBit(0);
            while (n >= 0) {
                if (bl) {
                    this.mat4.rotTrans(this.at[n]);
                } else {
                    this.ptTemp.add(this.at[n]);
                    this.mat4.rotTrans(this.at[n]);
                    this.ptTemp.sub(this.at[n]);
                }
                this.taintAtom(n, (byte)2);
                n = bS.nextSetBit(n + 1);
            }
            if (!bl) {
                this.ptTemp.scale(1.0f / (float)bS.cardinality());
                if (v3 == null) {
                    v3 = new V3();
                }
                v3.add(this.ptTemp);
            }
        }
        if (v3 != null) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                this.at[n].add(v3);
                n = bS.nextSetBit(n + 1);
            }
            if (!bl2) {
                this.mat4t.setIdentity();
                this.mat4t.setTranslation(v3);
                this.mat4.mul2(this.mat4t, this.mat4);
            }
        }
        this.recalculatePositionDependentQuantities(bS, this.mat4);
    }

    public void recalculatePositionDependentQuantities(BS bS, M4 m4) {
        if (this.getHaveStraightness()) {
            this.calculateStraightness();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
        BS bS2 = this.getModelBitSet(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            this.sm.refreshShapeTrajectories(n, bS, m4);
            n = bS2.nextSetBit(n + 1);
        }
        this.averageAtomPoint = null;
    }

    public BS[] getBsBranches(float[] fArray) {
        int n = fArray.length / 6;
        BS[] bSArray = new BS[n];
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            float f = fArray[n3 + 5] - fArray[n3 + 4];
            if (!(Math.abs(f) < 1.0f)) {
                int n4 = (int)fArray[n3 + 1];
                int n5 = (int)fArray[n3 + 2];
                String string = "" + n4 + "_" + n5;
                if (!hashtable.containsKey(string)) {
                    hashtable.put(string, Boolean.TRUE);
                    BS bS = this.vwr.getBranchBitSet(n5, n4, true);
                    Bond[] bondArray = this.at[n4].bonds;
                    Atom atom = this.at[n4];
                    for (int i = 0; i < bondArray.length; ++i) {
                        int n6;
                        Bond bond = bondArray[i];
                        if (!bond.isCovalent() || (n6 = bond.getOtherAtom((Atom)atom).i) == n5 || !bS.get(n6)) continue;
                        bS = null;
                        break;
                    }
                    bSArray[n2] = bS;
                }
            }
            ++n2;
            n3 += 6;
        }
        return bSArray;
    }

    public M4[] getSymMatrices(int n) {
        int n2 = this.getModelSymmetryCount(n);
        if (n2 == 0) {
            return null;
        }
        M4[] m4Array = new M4[n2];
        SymmetryInterface symmetryInterface = this.am[n].biosymmetry;
        if (symmetryInterface == null) {
            symmetryInterface = this.vwr.getModelUnitCell(n);
        }
        int n3 = n2;
        while (--n3 >= 0) {
            m4Array[n3] = symmetryInterface.getSpaceGroupOperation(n3);
        }
        return m4Array;
    }
}

