/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;

class UFFTorsionCalc
extends Calculation {
    UFFTorsionCalc() {
    }

    void setData(List<Object[]> list, int[] nArray) {
        double d = -1.0;
        int n = 0;
        double d2 = 0.0;
        this.ia = nArray[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ib = nArray[1];
        this.b = this.calcs.minAtoms[this.ib];
        this.ic = nArray[2];
        this.c = this.calcs.minAtoms[this.ic];
        this.id = nArray[3];
        this.d = this.calcs.minAtoms[this.id];
        MinBond minBond = this.c.getBondTo(this.ib);
        double d3 = minBond.order;
        if (minBond.isAromatic) {
            d3 = 1.5;
        }
        if (minBond.isAmide) {
            d3 = 1.41;
        }
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.b.sType);
        this.calcs.parC = (FFParam)this.calcs.getParameter(this.c.sType);
        switch (this.calcs.parB.iVal[0] * this.calcs.parC.iVal[0]) {
            case 9: {
                n = 3;
                double d4 = this.calcs.parB.dVal[6];
                double d5 = this.calcs.parC.dVal[6];
                double d6 = 0.0;
                switch (this.b.atom.getElementNumber()) {
                    case 8: {
                        d6 = 2.0;
                        break;
                    }
                    case 16: 
                    case 34: 
                    case 52: 
                    case 84: {
                        d6 = 6.8;
                    }
                }
                if (d6 != 0.0) {
                    switch (this.c.atom.getElementNumber()) {
                        case 8: {
                            d4 = d6;
                            d5 = 2.0;
                            n = 2;
                            break;
                        }
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            d4 = d6;
                            d5 = 6.8;
                            n = 2;
                        }
                    }
                }
                d2 = 2.0934 * Math.sqrt(d4 * d5);
                break;
            }
            case 4: {
                d = 1.0;
                n = 2;
                d2 = 10.466999999999999 * Math.sqrt(this.calcs.parB.dVal[7] * this.calcs.parC.dVal[7]) * (1.0 + 4.18 * Math.log(d3));
                break;
            }
            case 6: {
                d = 1.0;
                n = 6;
                boolean bl = this.calcs.parC.iVal[0] == 3;
                block13 : switch ((bl ? this.c : this.b).atom.getElementNumber()) {
                    case 8: 
                    case 16: 
                    case 34: 
                    case 52: 
                    case 84: {
                        switch ((bl ? this.b : this.c).atom.getElementNumber()) {
                            case 8: 
                            case 16: 
                            case 34: 
                            case 52: 
                            case 84: {
                                break block13;
                            }
                        }
                        n = 2;
                        d = -1.0;
                    }
                }
                d2 = 2.0934;
            }
        }
        if (Util.isNearZero(d2)) {
            return;
        }
        list.addLast(new Object[]{new int[]{this.ia, this.ib, this.ic, this.id, n}, new double[]{d2, d}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        int n = this.iData[4];
        double d = this.dData[0];
        double d2 = this.dData[1];
        this.calcs.setTorsionVariables(this);
        this.energy = d * (1.0 - d2 * Math.cos(this.theta * (double)n));
        if (this.calcs.gradients) {
            this.dE = d * (double)n * d2 * Math.sin((double)n * this.theta);
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(3, this));
        }
        return this.energy;
    }
}

