/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;

class UFFAngleCalc
extends Calculation {
    UFFAngleCalc() {
    }

    void setData(List<Object[]> list, int[] nArray) {
        double d;
        double d2;
        double d3;
        this.ia = nArray[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ib = nArray[1];
        this.b = this.calcs.minAtoms[this.ib];
        this.ic = nArray[2];
        this.c = this.calcs.minAtoms[this.ic];
        double d4 = this.a.sType == "H_" && this.c.sType == "H_" ? 10 : 1;
        this.calcs.parA = (FFParam)this.calcs.getParameter(this.a.sType);
        this.calcs.parB = (FFParam)this.calcs.getParameter(this.b.sType);
        this.calcs.parC = (FFParam)this.calcs.getParameter(this.c.sType);
        int n = this.calcs.parB.iVal[0];
        double d5 = this.calcs.parA.dVal[5];
        double d6 = this.calcs.parC.dVal[5];
        double d7 = this.calcs.parB.dVal[1];
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                break;
            }
            default: {
                d3 = 1.0 / (4.0 * d9 * d9);
                d2 = -4.0 * d3 * d8;
                d = d3 * (2.0 * d8 * d8 + 1.0);
            }
        }
        MinBond minBond = this.a.getBondTo(this.ib);
        double d10 = minBond.order;
        if (minBond.isAromatic) {
            d10 = 1.5;
        }
        if (minBond.isAmide) {
            d10 = 1.41;
        }
        this.rab = CalculationsUFF.calculateR0(this.calcs.parA.dVal[0], this.calcs.parB.dVal[0], this.calcs.parA.dVal[8], this.calcs.parB.dVal[8], d10);
        minBond = this.c.getBondTo(this.ib);
        d10 = minBond.order;
        if (minBond.isAromatic) {
            d10 = 1.5;
        }
        if (minBond.isAmide) {
            d10 = 1.41;
        }
        double d11 = CalculationsUFF.calculateR0(this.calcs.parB.dVal[0], this.calcs.parC.dVal[0], this.calcs.parB.dVal[8], this.calcs.parC.dVal[8], d10);
        double d12 = Math.sqrt(this.rab * this.rab + d11 * d11 - 2.0 * this.rab * d11 * d8);
        double d13 = 2696.8016159999997 * (d5 * d6 / Math.pow(d12, 5.0)) * (3.0 * this.rab * d11 * (1.0 - d8 * d8) - d12 * d12 * d8);
        list.addLast(new Object[]{new int[]{this.ia, this.ib, this.ic, n}, new double[]{d13, d7 * 57.29577951308232, d - d3, d2, 2.0 * d3, d4 * d13}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        int n = this.iData[3];
        double d = this.calcs.isPreliminary ? this.dData[5] : this.dData[0];
        double d2 = this.dData[2];
        double d3 = this.dData[3];
        double d4 = this.dData[4];
        this.calcs.setAngleVariables(this);
        if ((n == 4 || n == 6) && (this.theta > 2.35619 || this.theta < 0.785398)) {
            n = 1;
        }
        double d5 = Math.cos(this.theta);
        double d6 = Math.sin(this.theta);
        switch (n) {
            case 0: 
            case 1: {
                this.energy = d * (1.0 + d5) * (1.0 + d5) / 4.0;
                break;
            }
            case 2: {
                this.energy = d * (1.0 + 4.0 * d5 * (1.0 + d5)) / 9.0;
                break;
            }
            case 4: 
            case 6: {
                this.energy = d * d5 * d5;
                break;
            }
            default: {
                this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
            }
        }
        if (this.calcs.gradients) {
            switch (n) {
                case 0: 
                case 1: {
                    this.dE = -0.5 * d * d6 * (1.0 + d5);
                    break;
                }
                case 2: {
                    this.dE = -4.0 * d6 * d * (1.0 - 2.0 * d5) / 9.0;
                    break;
                }
                case 4: 
                case 6: {
                    this.dE = -d * d6 * d5;
                    break;
                }
                default: {
                    this.dE = -d * (d3 * d6 - 2.0 * d4 * d5 * d6);
                }
            }
            this.calcs.addForces(this, 3);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(1, this));
        }
        return this.energy;
    }
}

