/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.forcefield.Calculation;

class MMFFVDWCalc
extends Calculation {
    MMFFVDWCalc() {
    }

    @Override
    void setData(List<Object[]> list, int n, int n2, double d) {
        this.a = this.calcs.minAtoms[n];
        this.b = this.calcs.minAtoms[n2];
        double[] dArray = (double[])this.calcs.getParameter(this.a.vdwKey);
        double[] dArray2 = (double[])this.calcs.getParameter(this.b.vdwKey);
        if (dArray == null || dArray2 == null) {
            return;
        }
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        int n3 = (int)dArray[4];
        double d6 = dArray2[0];
        double d7 = dArray2[1];
        double d8 = dArray2[2];
        double d9 = dArray2[3];
        int n4 = (int)dArray2[4];
        double d10 = d4 * Math.pow(d2, 0.25);
        double d11 = d8 * Math.pow(d6, 0.25);
        double d12 = (d10 - d11) / (d10 + d11);
        double d13 = 0.5 * (d10 + d11);
        if (n3 != 68 && n4 != 68) {
            d13 *= 1.0 + 0.2 * (1.0 - Math.exp(-12.0 * d12 * d12));
        }
        double d14 = 181.16 * d5 * d9 * d2 * d6 / (Math.sqrt(d2 / d3) + Math.sqrt(d6 / d7)) * Math.pow(d13, -6.0);
        if (n3 + n4 == 133) {
            d13 *= 0.8;
            d14 *= 0.5;
        }
        list.addLast(new Object[]{new int[]{n, n2}, new double[]{d13, d14}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        this.calcs.setPairVariables(this);
        double d = this.dData[0];
        double d2 = this.dData[1];
        double d3 = this.rab / d;
        double d4 = 1.07 / (d3 + 0.07);
        double d5 = 1.12 / (Math.pow(d3, 7.0) + 0.12);
        this.energy = d2 * Math.pow(d4, 7.0) * (d5 - 2.0);
        if (this.calcs.gradients) {
            this.dE = -7.0 * d2 * Math.pow(d4, 7.0) / d * (d4 / 1.07 * (d5 - 2.0) + d5 * d5 * Math.pow(d3, 6.0));
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging && Math.abs(this.energy) > 0.1) {
            this.calcs.appendLogData(this.calcs.getDebugLine(5, this));
        }
        return this.energy;
    }
}

