/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class JaguarReader
extends VolumeFileReader {
    private float[] extents = new float[3];

    JaguarReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        String string;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("Jaguar data\n");
        this.jvxlFileHeaderBuffer.append("\n");
        while ((string = this.readLine()) != null && string.indexOf("origin=") < 0) {
        }
        String[] stringArray = PT.getTokensAt(string, 0);
        if (stringArray.length == 4 && stringArray[0].equals("origin=")) {
            this.volumetricOrigin.set(this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]));
            VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, "0", "0 " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3], this.jvxlFileHeaderBuffer);
            if (!this.isAngstroms) {
                this.volumetricOrigin.scale(0.5291772f);
            }
        }
        this.readExtents(0);
        this.readExtents(1);
        this.readExtents(2);
        stringArray = PT.getTokens(this.readLine());
        this.voxelCounts[0] = this.parseIntStr(stringArray[1]);
        this.voxelCounts[1] = this.parseIntStr(stringArray[2]);
        this.voxelCounts[2] = this.parseIntStr(stringArray[3]);
        float f = this.isAngstroms ? 1.0f : 0.5291772f;
        float f2 = this.extents[0] / (float)(this.voxelCounts[0] - 1);
        this.volumetricVectors[0].set(f2 * f, 0.0f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[0] + " " + f2 + " 0.0 0.0\n");
        f2 = this.extents[1] / (float)(this.voxelCounts[1] - 1);
        this.volumetricVectors[1].set(0.0f, f2 * f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[1] + " 0.0 " + f2 + " 0.0\n");
        f2 = this.extents[2] / (float)(this.voxelCounts[2] - 1);
        this.volumetricVectors[2].set(0.0f, 0.0f, f2 * f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[2] + " 0.0 0.0 " + f2 + "\n");
        this.readLine();
    }

    private void readExtents(int n) throws Exception {
        String[] stringArray = PT.getTokens(this.readLine());
        this.extents[n] = this.parseFloatStr(stringArray[n + 1]);
    }
}

