/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.util.C;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class _IdtfExporter
extends __CartesianExporter {
    private boolean haveSphere;
    private boolean haveCylinder;
    private boolean haveCylinderIn;
    private boolean haveCone;
    private boolean haveCircle;
    private P3 ptMin = P3.new3(1.0E10f, 1.0E10f, 1.0E10f);
    private P3 ptMax = P3.new3(-1.0E10f, -1.0E10f, -1.0E10f);
    private int iObj;
    private Map<String, Boolean> htDefs = new Hashtable<String, Boolean>();
    private final M4 m = new M4();
    private final SB models = new SB();
    private final SB resources = new SB();
    private final SB modifiers = new SB();
    private Map<String, List<String>> htNodes = new Hashtable<String, List<String>>();
    private M4 cylinderMatrix = new M4();
    private SB sbTemp;
    private int[][] triangleFace = AU.newInt2(1);

    public _IdtfExporter() {
        this.triangleFace[0] = new int[]{0, 1, 2};
        this.commentChar = "% ";
    }

    @Override
    protected void output(T3 t3) {
        this.output(t3, this.sbTemp, true);
    }

    private void output(T3 t3, SB sB, boolean bl) {
        if (bl) {
            this.checkPoint(t3);
        }
        sB.append(_IdtfExporter.round(t3.x)).append(" ").append(_IdtfExporter.round(t3.y)).append(" ").append(_IdtfExporter.round(t3.z)).append(" ");
    }

    private void checkPoint(T3 t3) {
        if (t3.x < this.ptMin.x) {
            this.ptMin.x = t3.x;
        }
        if (t3.y < this.ptMin.y) {
            this.ptMin.y = t3.y;
        }
        if (t3.z < this.ptMin.z) {
            this.ptMin.z = t3.z;
        }
        if (t3.x > this.ptMax.x) {
            this.ptMax.x = t3.x;
        }
        if (t3.y > this.ptMax.y) {
            this.ptMax.y = t3.y;
        }
        if (t3.z > this.ptMax.z) {
            this.ptMax.z = t3.z;
        }
    }

    @Override
    protected void outputHeader() {
        this.output("FILE_FORMAT \"IDTF\"\nFORMAT_VERSION 100\n");
        this.m.setIdentity();
        Quat quat = this.vwr.getRotationQuaternion();
        this.m.setToM3(quat.getMatrix());
        quat.transformP2(this.referenceCenter, this.tempP1);
        this.m.m03 = -this.tempP1.x;
        this.m.m13 = -this.tempP1.y;
        this.m.m23 = -this.tempP1.z;
        this.m.m33 = 1.0f;
        this.output("NODE \"GROUP\" {\n");
        this.output("NODE_NAME \"Jmol\"\n");
        this.output("PARENT_LIST {\nPARENT_COUNT 1\n");
        this.output("PARENT 0 {\n");
        this.output(this.getParentItem("", this.m));
        this.output("}}}\n");
    }

    @Override
    String finalizeOutput() {
        this.finalizeOutput2();
        return this.getAuxiliaryFileData();
    }

    private String getAuxiliaryFileData() {
        String string = this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
        string = string.substring(string.lastIndexOf("\\") + 1);
        String string2 = string + ".";
        string2 = string2.substring(0, string2.indexOf("."));
        return "% Created by: Jmol " + Viewer.getJmolVersion() + "\n% Creation date: " + this.getExportDate() + "\n% File created: " + this.fileName + " (" + this.out.getByteCount() + " bytes)\n\n" + "\n\\documentclass[12pt,letter]{article}" + "\n\\usepackage{hyperref}" + "\n\\usepackage{media9}" + "\n\\usepackage{verbatim}" + "\n\\pagestyle{empty}" + "\n\\begin{document}" + "\n    \\begin{center}" + "\n        \\addmediapath{./} % here you can set the path where is been saved the u3d file" + "\n        \\includemedia[" + "\n            label=" + string2 + "," + "\n            width=0.9\\textwidth," + "\n            height=0.9\\textheight," + "\n            activate=pageopen," + "\n            deactivate=pageclose," + "\n            3Dtoolbar=false," + "\n            3Dnavpane=false," + "\n            3Dmenu," + "\n            3Droo=" + this.cameraDistance + "," + "\n            3Dcoo= 0.0 0.0 -" + this.cameraDistance + "," + "\n            3Dc2c=0.0 0.0 1.0," + "\n            3Daac=" + this.aperatureAngle + "," + "\n            3Droll=0.0," + "\n            3Dbg=" + this.rgbFractionalFromColix(this.backgroundColix) + ", % to set the background color for 3D vwr; white = 1 1 1; so, you need to do the proportion: '255:1=[RGB]:x'" + "\n            transparent=false," + "\n            3Dlights=Headlamp," + "\n            3Drender=Solid," + "\n            3Dpartsattrs=restore," + "\n        ]{}{" + string2 + ".u3d}" + "\n%  \\\\" + "\n%\\movieref[3Dcalculate]{" + string2 + "}{Click here!}" + "\n\\end{center}" + "\n\\end{document}" + "\n\\begin{comment}" + this.vwr.getWrappedStateScript() + "\n\\end{comment}";
    }

    private String getParentItem(String string, M4 m4) {
        SB sB = new SB();
        sB.append("PARENT_NAME \"" + string + "\"\n");
        sB.append("PARENT_TM {\n");
        sB.append(m4.m00 + " " + m4.m10 + " " + m4.m20 + " 0.0\n");
        sB.append(m4.m01 + " " + m4.m11 + " " + m4.m21 + " 0.0\n");
        sB.append(m4.m02 + " " + m4.m12 + " " + m4.m22 + " 0.0\n");
        sB.append(m4.m03 + " " + m4.m13 + " " + m4.m23 + " " + m4.m33 + "\n");
        sB.append("}\n");
        return sB.toString();
    }

    private void addColix(short s, boolean bl) {
        String string = "_" + s;
        if (this.htDefs.containsKey(string)) {
            return;
        }
        String string2 = bl ? "1.0 1.0 1.0" : this.rgbFractionalFromColix(s);
        this.htDefs.put(string, Boolean.TRUE);
        this.resources.append("RESOURCE_LIST \"SHADER\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Shader" + string + "\"\n");
        this.resources.append("ATTRIBUTE_USE_VERTEX_COLOR \"FALSE\"\n");
        this.resources.append("SHADER_MATERIAL_NAME \"Mat" + string + "\"\n");
        this.resources.append("SHADER_ACTIVE_TEXTURE_COUNT 0\n");
        this.resources.append("}}\n");
        this.resources.append("RESOURCE_LIST \"MATERIAL\" {\n");
        this.resources.append("RESOURCE_COUNT 1\n");
        this.resources.append("RESOURCE 0 {\n");
        this.resources.append("RESOURCE_NAME \"Mat" + string + "\"\n");
        this.resources.append("MATERIAL_AMBIENT " + string2 + "\n");
        this.resources.append("MATERIAL_DIFFUSE " + string2 + "\n");
        this.resources.append("MATERIAL_SPECULAR 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_EMISSIVE 0.0 0.0 0.0\n");
        this.resources.append("MATERIAL_REFLECTIVITY 0.00000\n");
        this.resources.append("MATERIAL_OPACITY " + _IdtfExporter.opacityFractionalFromColix(s) + "\n");
        this.resources.append("}}\n");
    }

    private void addShader(String string, short s) {
        this.modifiers.append("MODIFIER \"SHADING\" {\n");
        this.modifiers.append("MODIFIER_NAME \"" + string + "\"\n");
        this.modifiers.append("PARAMETERS {\n");
        this.modifiers.append("SHADER_LIST_COUNT 1\n");
        this.modifiers.append("SHADING_GROUP {\n");
        this.modifiers.append("SHADER_LIST 0 {\n");
        this.modifiers.append("SHADER_COUNT 1\n");
        this.modifiers.append("SHADER_NAME_LIST {\n");
        this.modifiers.append("SHADER 0 NAME: \"Shader_" + s + "\"\n");
        this.modifiers.append("}}}}}\n");
    }

    @Override
    protected void outputFooter() {
        this.htDefs = null;
        this.outputNodes();
        this.output(this.models.toString());
        this.output(this.resources.toString());
        this.output("RESOURCE_LIST \"VIEW\" {\n");
        this.output("\tRESOURCE_COUNT 1\n");
        this.output("\tRESOURCE 0 {\n");
        this.output("\t\tRESOURCE_NAME \"View0\"\n");
        this.output("\t\tVIEW_PASS_COUNT 1\n");
        this.output("\t\tVIEW_ROOT_NODE_LIST {\n");
        this.output("\t\t\tROOT_NODE 0 {\n");
        this.output("\t\t\t\tROOT_NODE_NAME \"\"\n");
        this.output("\t\t\t}\n");
        this.output("\t\t}\n");
        this.output("\t}\n");
        this.output("}\n\n");
        this.output(this.modifiers.toString());
    }

    private void outputNodes() {
        for (Map.Entry<String, List<String>> entry : this.htNodes.entrySet()) {
            int n;
            String string = entry.getKey();
            List<String> list = entry.getValue();
            this.output("NODE \"MODEL\" {\n");
            this.output("NODE_NAME \"" + string + "\"\n");
            System.out.println("output idtf " + string);
            int n2 = list.size();
            this.output("PARENT_LIST {\nPARENT_COUNT " + n2 + "\n");
            for (n = 0; n < n2; ++n) {
                this.output("PARENT " + n + " {\n");
                this.output((String)list.get(n));
                this.output("}\n");
            }
            this.output("}\n");
            n = string.indexOf("_");
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (string.equals("Ellipse")) {
                string = "Circle";
            }
            this.output("RESOURCE_NAME \"" + string + "_Mesh\"\n}\n");
        }
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        A4 a4 = Quat.getQuaternionFrame(p3, p3Array[1], p3Array[3]).toAxisAngle4f();
        float f = p3Array[1].distance(p3);
        float f2 = p3Array[3].distance(p3);
        float f3 = p3Array[5].distance(p3);
        this.setSphereMatrix(p3, f, f2, f3, a4, this.sphereMatrix);
        this.outputEllipsoid(p3, this.sphereMatrix, s);
    }

    private void outputEllipsoid(P3 p3, M4 m4, short s) {
        if (!this.haveSphere) {
            this.models.append(this.getSphereResource());
            this.haveSphere = true;
        }
        this.checkPoint(p3);
        this.addColix(s, false);
        String string = "Sphere_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new List();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        list.addLast(this.getParentItem("Jmol", m4));
    }

    private String getSphereResource() {
        SB sB = new SB();
        sB.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"Sphere_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n");
        int n = Geodesic.getVertexCount(2);
        short[] sArray = Geodesic.getFaceVertexes(2);
        int n2 = sArray.length / 3;
        int[][] nArray = AU.newInt2(n2);
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{sArray[++n3], sArray[++n3], sArray[++n3]};
        }
        T3[] t3Array = new V3[n];
        for (int i = 0; i < n; ++i) {
            t3Array[i] = Geodesic.getVertexVector(i);
        }
        return this.getMeshData("Sphere", nArray, t3Array, t3Array);
    }

    private String getMeshData(String string, int[][] nArray, T3[] t3Array, T3[] t3Array2) {
        int n;
        int n2 = nArray.length;
        int n3 = t3Array.length;
        int n4 = t3Array2.length;
        SB sB = new SB();
        this.getMeshHeader(string, n2, n3, n4, 0, sB);
        SB sB2 = new SB();
        for (n = 0; n < nArray.length; ++n) {
            sB2.appendI(nArray[n][0]).append(" ");
            sB2.appendI(nArray[n][1]).append(" ");
            sB2.appendI(nArray[n][2]).append(" ");
        }
        sB.append("MESH_FACE_POSITION_LIST { ");
        sB.appendSB(sB2);
        sB.append("}\n");
        sB.append("MESH_FACE_NORMAL_LIST { ");
        sB.appendSB(sB2);
        sB.append("}\n");
        sB.append("MESH_FACE_SHADING_LIST { ");
        for (n = 0; n < n2; ++n) {
            sB.append("0 ");
        }
        sB.append("}\n");
        sB.append("MODEL_POSITION_LIST { ");
        for (n = 0; n < n3; ++n) {
            this.output(t3Array[n], sB, false);
        }
        sB.append("}\n");
        sB.append("MODEL_NORMAL_LIST { ");
        for (n = 0; n < n4; ++n) {
            this.output(t3Array2[n], sB, false);
        }
        sB.append("}\n}}}\n");
        return sB.toString();
    }

    private void getMeshHeader(String string, int n, int n2, int n3, int n4, SB sB) {
        sB.append("RESOURCE_LIST \"MODEL\" {\n").append("RESOURCE_COUNT 1\n").append("RESOURCE 0 {\n").append("RESOURCE_NAME \"").append(string).append("_Mesh\"\n").append("MODEL_TYPE \"MESH\"\n").append("MESH {\n").append("FACE_COUNT ").appendI(n).append("\n").append("MODEL_POSITION_COUNT ").appendI(n2).append("\n").append("MODEL_NORMAL_COUNT ").appendI(n3).append("\n").append("MODEL_DIFFUSE_COLOR_COUNT ").appendI(n4).append("\n").append("MODEL_SPECULAR_COLOR_COUNT 0\n").append("MODEL_TEXTURE_COORD_COUNT 0\n").append("MODEL_BONE_COUNT 0\n").append("MODEL_SHADING_COUNT 1\n").append("MODEL_SHADING_DESCRIPTION_LIST {\n").append("SHADING_DESCRIPTION 0 {\n").append("TEXTURE_LAYER_COUNT 0\n").append("SHADER_ID 0\n}}\n");
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        if (p34 != null) {
            if (by == 2) {
                this.outputEllipse(p3, p32, p34, p35, s);
                this.tempP3.add2(p3, p3);
                this.tempP3.sub(p34);
                this.outputEllipse(p3, p33, this.tempP3, p35, s);
            }
        } else if (by == 3) {
            this.outputSphere(p32, f * 1.01f, s, true);
            this.outputSphere(p33, f * 1.01f, s, true);
        } else if (by == 2) {
            this.outputCircle(p32, p33, s, f);
            this.outputCircle(p33, p32, s, f);
        }
        if (!this.haveCylinder) {
            this.models.append(this.getCylinderResource(false));
            this.haveCylinder = true;
        }
        if (p34 != null && by == 0 && !this.haveCylinderIn) {
            this.models.append(this.getCylinderResource(true));
            this.haveCylinderIn = true;
        }
        this.checkPoint(p32);
        this.checkPoint(p33);
        this.addColix(s, false);
        int n = p34 != null && by == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            String string = "Cylinder" + (i == 0 ? "_" : "In_") + s;
            List<String> list = this.htNodes.get(string);
            if (list == null) {
                list = new List();
                this.htNodes.put(string, list);
                this.addShader(string, s);
            }
            if (p34 == null) {
                this.cylinderMatrix.setToM3(this.getRotationMatrix(p32, p33, f));
            } else {
                this.cylinderMatrix.setToM3(this.getRotationMatrix(p3, p33, f, p34, p35));
            }
            this.cylinderMatrix.m03 = p32.x;
            this.cylinderMatrix.m13 = p32.y;
            this.cylinderMatrix.m23 = p32.z;
            this.cylinderMatrix.m33 = 1.0f;
            list.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
            f *= 0.95f;
        }
        return true;
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            this.outputCircle(p3, p32, s, f);
            return;
        }
    }

    private boolean outputEllipse(P3 p3, P3 p32, P3 p33, P3 p34, short s) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new M4();
        }
        this.addColix(s, false);
        String string = "Ellipse_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new List();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.checkPoint(p3);
        this.cylinderMatrix.setToM3(this.getRotationMatrix(p3, p32, 1.0f, p33, p34));
        this.cylinderMatrix.m03 = p32.x;
        this.cylinderMatrix.m13 = p32.y;
        this.cylinderMatrix.m23 = p32.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
        return true;
    }

    private void outputCircle(P3 p3, P3 p32, short s, float f) {
        if (!this.haveCircle) {
            this.models.append(this.getCircleResource());
            this.haveCircle = true;
            this.cylinderMatrix = new M4();
        }
        this.addColix(s, false);
        String string = "Circle_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new List();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.checkPoint(p3);
        this.cylinderMatrix.setToM3(this.getRotationMatrix(p3, p32, f));
        this.cylinderMatrix.m03 = p3.x;
        this.cylinderMatrix.m13 = p3.y;
        this.cylinderMatrix.m23 = p3.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getCylinderResource(boolean bl) {
        float f;
        float f2;
        int n;
        int n2 = 10;
        int n3 = 360 / n2 * 2;
        int n4 = n3 / 2;
        int[][] nArray = AU.newInt2(n3);
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4, i};
                nArray[++n5] = new int[]{i + n4, (i + 1) % n4 + n4, (i + 1) % n4};
                continue;
            }
            nArray[++n5] = new int[]{i, (i + 1) % n4, i + n4};
            nArray[++n5] = new int[]{(i + 1) % n4, (i + 1) % n4 + n4, i + n4};
        }
        T3[] t3Array = new P3[n3];
        T3[] t3Array2 = new P3[n3];
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos((double)(n * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n * n2) / 180.0 * Math.PI);
            t3Array[n] = P3.new3(f2, f, 0.0f);
            t3Array2[n] = P3.new3(f2, f, 0.0f);
        }
        for (n = 0; n < n4; ++n) {
            f2 = (float)Math.cos(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n + 0.5) * (double)n2 / 180.0 * Math.PI);
            t3Array[n + n4] = P3.new3(f2, f, 1.0f);
            t3Array2[n + n4] = t3Array2[n];
        }
        if (bl) {
            for (n = 0; n < n4; ++n) {
                t3Array2[n].scale(-1.0f);
            }
        }
        return this.getMeshData(bl ? "CylinderIn" : "Cylinder", nArray, t3Array, t3Array2);
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
        this.sbTemp.append(" " + nArray2[nArray[0]] + " " + nArray2[nArray[1]] + " " + nArray2[nArray[2]]);
        if (n == 4 && nArray.length == 4) {
            this.sbTemp.append(" " + nArray2[nArray[0]] + " " + nArray2[nArray[2]] + " " + nArray2[nArray[3]]);
        }
    }

    @Override
    protected void outputSurface(P3[] p3Array, V3[] v3Array, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, List<Short> list, Map<Short, Integer> map, P3 p3) {
        int n5;
        this.addColix(s, sArray2 != null || sArray != null);
        if (sArray2 != null) {
            return;
        }
        SB sB = this.sbTemp = new SB();
        int[] nArray2 = new int[n];
        int n6 = this.getCoordinateMap(p3Array, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bS, n4);
        SB sB2 = this.sbTemp = new SB();
        List<String> list2 = null;
        if (v3Array != null) {
            list2 = new List<String>();
            nArray2 = this.getNormalMap(v3Array, n, null, list2);
            this.outputIndices(nArray, nArray2, n2, bS, n4);
        }
        nArray2 = null;
        SB sB3 = new SB();
        if (list != null) {
            int n7;
            boolean bl = bS == null;
            n5 = n7 = bl ? n2 - 1 : bS.nextSetBit(0);
            while (n5 >= 0) {
                sB3.append(" " + map.get("" + sArray[nArray[n5][0]]) + " " + map.get("" + sArray[nArray[n5][1]]) + " " + map.get("" + sArray[nArray[n5][2]]));
                if (n4 == 4 && nArray[n5].length == 4) {
                    sB3.append(" " + map.get("" + sArray[nArray[n5][0]]) + " " + map.get("" + sArray[nArray[n5][2]]) + " " + map.get("" + sArray[nArray[n5][3]]));
                }
                n5 = bl ? n5 - 1 : bS.nextSetBit(n5 + 1);
            }
        }
        SB sB4 = this.sbTemp = new SB();
        this.outputVertices(p3Array, n, p3);
        SB sB5 = new SB();
        n5 = 0;
        if (v3Array != null) {
            n5 = list2.size();
            for (int i = 0; i < n5; ++i) {
                sB5.append((String)list2.get(i));
            }
            list2 = null;
        }
        SB sB6 = new SB();
        int n8 = 0;
        if (list != null) {
            n8 = list.size();
            for (int i = 0; i < n8; ++i) {
                short s2 = (Short)list.get(i);
                sB6.append(this.rgbFractionalFromColix(s2)).append(" ").append(_IdtfExporter.translucencyFractionalFromColix(s2)).append(" ");
            }
        }
        String string = "mesh" + ++this.iObj;
        this.addMeshData(string, n3, n6, n5, n8, sB, sB2, sB3, sB4, sB5, sB6);
        List<String> list3 = new List<String>();
        this.htNodes.put(string, list3);
        this.addShader(string, s);
        this.cylinderMatrix.setIdentity();
        list3.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private void addMeshData(String string, int n, int n2, int n3, int n4, SB sB, SB sB2, SB sB3, SB sB4, SB sB5, SB sB6) {
        this.getMeshHeader(string, n, n2, n3, n4, this.models);
        this.models.append("MESH_FACE_POSITION_LIST { ").appendSB(sB).append(" }\n").append("MESH_FACE_NORMAL_LIST { ").appendSB(sB2).append(" }\n");
        this.models.append("MESH_FACE_SHADING_LIST { ");
        for (int i = 0; i < n; ++i) {
            this.models.append("0 ");
        }
        this.models.append("}\n");
        if (n4 > 0) {
            this.models.append("MESH_FACE_DIFFUSE_COLOR_LIST { ").appendSB(sB3).append(" }\n");
        }
        this.models.append("MODEL_POSITION_LIST { ").appendSB(sB4).append(" }\n").append("MODEL_NORMAL_LIST { ").appendSB(sB5).append(" }\n");
        if (n4 > 0) {
            this.models.append("MODEL_DIFFUSE_COLOR_LIST { ").appendSB(sB6).append(" }\n");
        }
        this.models.append("}}}\n");
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        if (!this.haveCone) {
            this.models.append(this.getConeResource());
            this.haveCone = true;
        }
        this.checkPoint(p3);
        this.checkPoint(p32);
        this.addColix(s, false);
        String string = "Cone_" + s;
        List<String> list = this.htNodes.get(string);
        if (list == null) {
            list = new List();
            this.htNodes.put(string, list);
            this.addShader(string, s);
        }
        this.cylinderMatrix.setToM3(this.getRotationMatrix(p3, p32, f));
        this.cylinderMatrix.m03 = p3.x;
        this.cylinderMatrix.m13 = p3.y;
        this.cylinderMatrix.m23 = p3.z;
        this.cylinderMatrix.m33 = 1.0f;
        list.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getConeResource() {
        MeshSurface meshSurface = _IdtfExporter.getConeMesh(null, null, (short)0);
        return this.getMeshData("Cone", meshSurface.pis, meshSurface.vs, meshSurface.vs);
    }

    private String getCircleResource() {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + 1;
        int[][] nArray = AU.newInt2(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = new int[]{i, (i + 1) % n2, n2};
        }
        T3[] t3Array = new P3[n3];
        T3[] t3Array2 = new P3[n3];
        for (int i = 0; i < n2; ++i) {
            float f = (float)Math.cos((double)(i * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(i * n) / 180.0 * Math.PI);
            t3Array[i] = P3.new3(f, f2, 0.0f);
            t3Array2[i] = P3.new3(0.0f, 0.0f, 1.0f);
        }
        t3Array[n2] = P3.new3(0.0f, 0.0f, 0.0f);
        t3Array2[n2] = P3.new3(0.0f, 0.0f, 1.0f);
        return this.getMeshData("Circle", nArray, t3Array, t3Array2);
    }

    @Override
    protected void outputSphere(P3 p3, float f, short s, boolean bl) {
        this.setSphereMatrix(p3, f, f, f, null, this.sphereMatrix);
        this.outputEllipsoid(p3, this.sphereMatrix, s);
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
        short s = C.getColix(n);
        this.outputSphere(p3, 0.02f, s, true);
    }

    @Override
    protected void outputTriangle(P3 p3, P3 p32, P3 p33, short s) {
        this.addColix(s, false);
        String string = "T" + ++this.iObj;
        this.models.append(this.getTriangleResource(string, p3, p32, p33));
        List<String> list = new List<String>();
        this.htNodes.put(string, list);
        this.addShader(string, s);
        if (this.cylinderMatrix == null) {
            this.cylinderMatrix = new M4();
        }
        this.cylinderMatrix.setIdentity();
        list.addLast(this.getParentItem("Jmol", this.cylinderMatrix));
    }

    private String getTriangleResource(String string, P3 p3, P3 p32, P3 p33) {
        T3[] t3Array = new P3[]{p3, p32, p33};
        this.tempV1.sub2(p33, p3);
        this.tempV2.sub2(p32, p3);
        this.tempV2.cross(this.tempV2, this.tempV1);
        this.tempV2.normalize();
        T3[] t3Array2 = new V3[]{this.tempV2, this.tempV2, this.tempV2};
        return this.getMeshData(string, this.triangleFace, t3Array, t3Array2);
    }
}

