/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SiestaReader
extends AtomSetCollectionReader {
    private int noAtoms;
    private float[] unitCellData = new float[9];

    @Override
    protected void initializeReader() {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("%block LatticeVectors")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readCellThenAtomsCartesian();
            }
            return true;
        }
        if (this.line.contains("outcoor: Atomic coordinates")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomsCartGeomThenCell();
            }
            return true;
        }
        return true;
    }

    private void setCell() throws Exception {
        this.fillFloatArray(null, 0, this.unitCellData);
        this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
        this.addPrimitiveLatticeVector(1, this.unitCellData, 3);
        this.addPrimitiveLatticeVector(2, this.unitCellData, 6);
    }

    private void readCellThenAtomsCartesian() throws Exception {
        this.newAtomSet();
        this.setCell();
        this.discardLinesUntilContains("AtomicCoordinatesFormat Ang");
        this.rd();
        this.setFractionalCoordinates(false);
        while (this.rd() != null && this.line.indexOf("%endblock Atomic") < 0) {
            String[] stringArray = this.getTokens();
            this.addAtomXYZSymName(stringArray, 0, null, stringArray[4]);
        }
        this.noAtoms = this.asc.ac;
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readAtomsCartGeomThenCell() throws Exception {
        this.readLines(1);
        this.newAtomSet();
        int n = this.asc.ac;
        for (int i = 0; i < this.noAtoms; ++i) {
            String[] stringArray = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = stringArray[4];
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            atom.set(f, f2, f3);
            this.rd();
        }
        this.discardLinesUntilContains("outcell: Unit cell vectors");
        this.setCell();
        Atom[] atomArray = this.asc.atoms;
        int n2 = this.asc.ac;
        for (int i = n; i < n2; ++i) {
            this.setAtomCoord(atomArray[i]);
        }
        this.discardLinesUntilContains("siesta: E_KS(eV) = ");
        String[] stringArray = this.getTokens();
        Double d = Double.parseDouble(stringArray[3]);
        this.asc.setAtomSetEnergy("" + d, d.floatValue());
        this.asc.setAtomSetAuxiliaryInfo("Energy", d);
        this.asc.setAtomSetCollectionAuxiliaryInfo("Energy", d);
        this.asc.setAtomSetName("Energy = " + d + " eV");
    }
}

