/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.List;
import javajs.util.Matrix;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class JanaReader
extends AtomSetCollectionReader {
    private List<float[]> lattvecs;
    private int thisSub;
    private boolean modAverage;
    private String modAxes;
    private int modDim;
    static final String records = "tit  cell ndim qi   lat  sym  spg  end  wma";
    static final int TITLE = 0;
    static final int CELL = 5;
    static final int NDIM = 10;
    static final int QI = 15;
    static final int LATT = 20;
    static final int SYM = 25;
    static final int SPG = 30;
    static final int END = 35;
    static final int WMATRIX = 40;
    private int qicount;
    private final String LABELS = "xyz";
    public static final String U_LIST = "U11U22U33U12U13U23UISO";
    private float[] floats = new float[6];

    @Override
    public void initializeReader() throws Exception {
        this.modAverage = this.checkFilterKey("MODAVE");
        this.modAxes = this.getFilter("MODAXES=");
        this.setFractionalCoordinates(true);
        this.asc.newAtomSet();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.length() < 3) {
            return true;
        }
        Logger.info(this.line);
        this.parseTokenStr(this.line);
        switch (records.indexOf(this.line.substring(0, 3))) {
            case 0: {
                this.asc.setAtomSetName(this.line.substring(5).trim());
                break;
            }
            case 5: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 10: {
                this.ndim();
                break;
            }
            case 20: {
                if (this.lattvecs == null) {
                    this.lattvecs = new List();
                }
                if (this.ms.addLatticeVector(this.lattvecs, this.line.substring(8))) break;
                this.appendLoadNote(this.line + " not supported");
                break;
            }
            case 30: {
                this.setSpaceGroupName(this.getTokens()[1]);
                break;
            }
            case 25: {
                this.symmetry();
                break;
            }
            case 15: {
                if (this.modAverage) break;
                this.qi();
                break;
            }
            case 35: {
                this.continuing = false;
                break;
            }
            case 40: {
                Matrix matrix;
                int n = 3 + this.modDim;
                if (this.thisSub++ == 0) {
                    matrix = Matrix.identity(n, n);
                    this.ms.addSubsystem("" + this.thisSub++, matrix);
                }
                matrix = new Matrix(null, n, n);
                double[][] dArray = matrix.getArray();
                float[] fArray = new float[n * n];
                this.fillFloatArray(null, 0, fArray);
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    int n3 = 0;
                    while (n3 < n) {
                        dArray[i][n3] = fArray[n2];
                        ++n3;
                        ++n2;
                    }
                }
                this.ms.addSubsystem("" + this.thisSub, matrix);
            }
        }
        return true;
    }

    @Override
    public void finalizeReader() throws Exception {
        this.readM40Data();
        if (this.lattvecs != null && this.lattvecs.size() > 0) {
            this.asc.getSymmetry().addLatticeVectors(this.lattvecs);
        }
        if (this.ms != null) {
            this.ms.setModulation(false);
        }
        this.applySymmetryAndSetTrajectory();
        this.adjustM40Occupancies();
        if (this.ms != null) {
            this.ms.setModulation(true);
            this.ms.finalizeModulation();
        }
        this.finalizeReaderASCR();
    }

    private void cell() throws Exception {
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat());
        }
    }

    private void ndim() throws Exception {
        this.ms = (MSInterface)Interface.getOption("adapter.readers.cif.MSReader");
        this.modDim = this.ms.initialize(this, "" + (this.parseIntStr(this.getTokens()[1]) - 3));
    }

    private void qi() {
        double[] dArray = new double[this.modDim];
        dArray[this.qicount] = 1.0;
        this.ms.addModulation(null, "W_" + ++this.qicount, new double[]{this.parseFloat(), this.parseFloat(), this.parseFloat()}, -1);
        this.ms.addModulation(null, "F_" + this.qicount + "_coefs_", dArray, -1);
    }

    private void symmetry() throws Exception {
        this.setSymmetryOperator(PT.rep(this.line.substring(9).trim(), " ", ","));
    }

    private void readM40Data() throws Exception {
        BS bS;
        String string = this.filePath;
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return;
        }
        string = string.substring(0, n + 2) + "40";
        String string2 = string.substring(0, n);
        n = string2.lastIndexOf("/");
        BufferedReader bufferedReader = Rdr.getBR((String)this.vwr.getLigandModel(string2 = string2.substring(n + 1), string, "_file", "----"));
        if (this.readM40Floats(bufferedReader).startsWith("command")) {
            this.readM40WaveVectors(bufferedReader);
        }
        int n2 = (bS = this.getSubSystemList()) == null ? 0 : 1;
        int n3 = -1;
        while (this.readM40Floats(bufferedReader) != null) {
            int n4;
            int n5;
            float f;
            int n6;
            while (this.line != null && (this.line.length() == 0 || this.line.charAt(0) == ' ' || this.line.charAt(0) == '-')) {
                this.readM40Floats(bufferedReader);
            }
            if (this.line == null) break;
            ++n3;
            Atom atom = new Atom();
            Logger.info(this.line);
            atom.atomName = this.line.substring(0, 9).trim();
            if (!this.filterAtom(atom, 0)) continue;
            if (n2 > 0) {
                if (bS.get(n3)) {
                    ++n2;
                }
                atom.altLoc = ("" + n2).charAt(0);
            }
            float f2 = atom.foccupancy = this.floats[2];
            this.setAtomCoordXYZ(atom, this.floats[3], this.floats[4], this.floats[5]);
            this.asc.addAtom(atom);
            if (this.modDim == 0) continue;
            String string3 = ";" + atom.atomName;
            boolean bl = this.getInt(60, 61) > 0;
            boolean bl2 = this.getInt(61, 62) > 0;
            boolean bl3 = this.getInt(62, 63) > 0;
            int n7 = this.getInt(65, 68);
            int n8 = this.getInt(68, 71);
            int n9 = this.getInt(71, 74);
            this.readM40Floats(bufferedReader);
            boolean bl4 = false;
            if (Float.isNaN(this.floats[0])) {
                bl4 = true;
                this.readM40Floats(bufferedReader);
            }
            boolean bl5 = true;
            for (n6 = 1; n6 < 6; ++n6) {
                if (this.floats[n6] == 0.0f) continue;
                bl5 = false;
                break;
            }
            if (bl5) {
                if (this.floats[0] != 0.0f) {
                    this.setU(atom, 7, this.floats[0]);
                }
            } else {
                for (n6 = 0; n6 < 6; ++n6) {
                    this.setU(atom, n6, this.floats[n6]);
                }
            }
            if (bl4) {
                bufferedReader.readLine();
                bufferedReader.readLine();
            }
            float f3 = f = n7 > 0 && !bl ? this.parseFloatStr(bufferedReader.readLine()) : 1.0f;
            if (f != 1.0f) {
                this.ms.addModulation(null, "J_O#0;" + atom.atomName, new double[]{f2, f, 0.0}, -1);
            }
            atom.foccupancy = f * f2;
            int n10 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                float f4;
                float f5;
                if (bl) {
                    float[][] fArray = this.readM40FloatLines(2, 1, bufferedReader);
                    f5 = fArray[0][0];
                    f4 = fArray[1][0];
                } else {
                    n10 = n5 + 1;
                    this.readM40Floats(bufferedReader);
                    f5 = this.floats[0];
                    f4 = this.floats[1];
                }
                string2 = "O_" + n10 + "#0" + string3;
                double[] dArray = new double[]{f4, f5, 0.0};
                if (f4 == 0.0f && f5 == 0.0f) continue;
                this.ms.addModulation(null, string2, dArray, -1);
            }
            for (n5 = 0; n5 < n8; ++n5) {
                if (bl2) {
                    this.readM40Floats(bufferedReader);
                    float f6 = this.floats[3];
                    float f7 = this.floats[4];
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (this.floats[n4] == 0.0f) continue;
                        this.ms.addModulation(null, "D_S#" + "xyz".charAt(n4) + string3, new double[]{f6, f7, this.floats[n4]}, -1);
                    }
                    continue;
                }
                this.addSinCos(n5, "D_", string3, bufferedReader);
            }
            for (n5 = 0; n5 < n9; ++n5) {
                this.checkFourier(n5);
                if (bl5) {
                    this.addSinCos(n5, "U_", string3, bufferedReader);
                    continue;
                }
                if (bl3) {
                    Logger.error("JanaReader -- not interpreting SpecialUij flag: " + this.line);
                    continue;
                }
                float[][] fArray = this.readM40FloatLines(2, 6, bufferedReader);
                int n11 = 0;
                n4 = 0;
                while (n11 < 6) {
                    this.ms.addModulation(null, "U_" + (n5 + 1) + "#" + U_LIST.substring(n4, n4 + 3) + string3, new double[]{fArray[1][n11], fArray[0][n11], 0.0}, -1);
                    ++n11;
                    n4 += 3;
                }
            }
        }
        bufferedReader.close();
    }

    private BS getSubSystemList() {
        int n;
        if (this.thisSub == 0) {
            return null;
        }
        BS bS = new BS();
        String[] stringArray = this.getTokens();
        int n2 = 0;
        for (int i = 0; i < stringArray.length && (n = this.parseIntStr(stringArray[i])) != 0; i += 2) {
            bS.set(n2 += n);
        }
        return bS;
    }

    private void readM40WaveVectors(BufferedReader bufferedReader) throws Exception {
        while (!this.readM40Floats(bufferedReader).contains("end")) {
            if (!this.line.startsWith("wave")) continue;
            String[] stringArray = this.getTokens();
            double[] dArray = new double[this.modDim];
            for (int i = 0; i < this.modDim; ++i) {
                dArray[i] = this.parseFloatStr(stringArray[i + 2]);
            }
            this.ms.addModulation(null, "F_" + this.parseIntStr(stringArray[1]) + "_coefs_", dArray, -1);
        }
        this.readM40Floats(bufferedReader);
    }

    private void addSinCos(int n, String string, String string2, BufferedReader bufferedReader) throws Exception {
        this.checkFourier(n);
        this.readM40Floats(bufferedReader);
        for (int i = 0; i < 3; ++i) {
            float f = this.floats[i + 3];
            float f2 = this.floats[i];
            if (f2 == 0.0f && f == 0.0f) continue;
            String string3 = "" + "xyz".charAt(i % 3);
            if (this.modAxes != null && this.modAxes.indexOf(string3.toUpperCase()) < 0) continue;
            String string4 = string + (n + 1) + "#" + string3 + string2;
            this.ms.addModulation(null, string4, new double[]{f, f2, 0.0}, -1);
        }
    }

    private void checkFourier(int n) {
        double[] dArray;
        if (n > 0 && this.ms.getMod("F_" + ++n + "_coefs_") == null && (dArray = this.ms.getMod("F_1_coefs_")) != null) {
            double[] dArray2 = new double[this.modDim];
            int n2 = this.modDim;
            while (--n2 >= 0) {
                dArray2[n2] = dArray[n2] * (double)n;
            }
            this.ms.addModulation(null, "F_" + n + "_coefs_", dArray2, -1);
        }
    }

    private int getInt(int n, int n2) {
        int n3 = this.line.length();
        return n3 > n ? this.parseIntStr(this.line.substring(n, Math.min(n3, n2))) : 0;
    }

    private String readM40Floats(BufferedReader bufferedReader) throws Exception {
        this.line = bufferedReader.readLine();
        if (this.line == null || this.line.indexOf("-------") >= 0) {
            this.line = null;
            return null;
        }
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        int n = this.line.length() - 9;
        int n2 = 0;
        for (int i = 0; n2 < 6 && i <= n; ++n2, i += 9) {
            this.floats[n2] = this.parseFloatStr(this.line.substring(i, i + 9));
        }
        return this.line;
    }

    private float[][] readM40FloatLines(int n, int n2, BufferedReader bufferedReader) throws Exception {
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            this.readM40Floats(bufferedReader);
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = this.floats[j];
            }
        }
        return fArray;
    }

    private void adjustM40Occupancies() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.asc.atoms;
        SymmetryInterface symmetryInterface = this.asc.getSymmetry();
        int n = this.asc.ac;
        while (--n >= 0) {
            Atom atom = atomArray[n];
            Integer n2 = (Integer)hashtable.get(atom.atomName);
            if (n2 == null) {
                n2 = symmetryInterface.getSiteMultiplicity(atom);
                hashtable.put(atom.atomName, n2);
            }
            atom.foccupancy *= (float)n2.intValue();
        }
    }

    @Override
    public void doPreSymmetry() {
        if (this.ms != null) {
            this.ms.setModulation(false);
        }
    }
}

