/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.SymmetryInterface;

public class GulpReader
extends AtomSetCollectionReader {
    private boolean isSlab;
    private boolean isPolymer;
    private boolean isMolecular;
    private boolean isPrimitive;
    private String sep = "-------";
    private boolean coordinatesArePrimitive;
    private Map<String, Float> atomCharges;
    private boolean bTest;
    private float a;
    private float b;
    private float c;
    private float alpha;
    private float beta;
    private float gamma;
    private float[] primitiveData;
    private static String[] tags = AtomSetCollection.notionalUnitcellTags;
    private Double totEnergy;
    private String energyUnits;

    @Override
    protected void initializeReader() throws Exception {
        this.isPrimitive = !this.checkFilterKey("CONV");
        this.coordinatesArePrimitive = true;
        this.setFractionalCoordinates(this.readDimensionality());
    }

    @Override
    protected void finalizeReader() {
        if (this.atomCharges == null) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.ac;
        while (--n >= 0) {
            Float f = this.atomCharges.get(atomArray[n].atomName);
            if (f == null && (f = this.atomCharges.get(atomArray[n].getElementSymbol())) == null) continue;
            atomArray[n].partialCharge = f.floatValue();
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("Space group ")) {
            this.readSpaceGroup();
            return true;
        }
        if (this.isSlab ? this.line.contains("Surface cell parameters") : (this.isPolymer ? this.line.contains("Polymer cell parameter") : (this.bTest = this.line.contains("Cartesian lattice vectors")) || this.line.contains("Cell parameters (Angstroms/Degrees)") || this.line.contains("Primitive cell parameters"))) {
            this.readCellParameters(this.bTest);
            return true;
        }
        if (this.line.contains("Monopole - monopole (total)")) {
            this.readEnergy();
            return true;
        }
        if (this.line.contains("Fractional coordinates of asymmetric unit :") || (this.bTest = this.line.contains("Final asymmetric unit coordinates")) || (this.bTest = this.line.contains("Final fractional coordinates ")) || this.line.contains("Mixed fractional/Cartesian coordinates") || this.line.contains("Cartesian coordinates of cluster ") || this.line.contains("Final cartesian coordinates of atoms :") && this.isMolecular) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomicPos(!this.bTest);
            }
            return true;
        }
        if (this.line.contains("Species output for all configurations")) {
            this.readPartialCharges();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.contains("Final cell parameters and derivatives")) {
            this.readFinalCell();
            return true;
        }
        return true;
    }

    private boolean readDimensionality() throws Exception {
        this.discardLinesUntilContains("Dimensionality");
        String[] stringArray = this.getTokens();
        switch (this.parseIntStr(stringArray[2])) {
            case 0: {
                this.isMolecular = true;
                this.isPrimitive = false;
                return false;
            }
            case 1: {
                this.isPolymer = true;
                this.isPrimitive = false;
                break;
            }
            case 2: {
                this.isSlab = true;
                this.isPrimitive = false;
            }
        }
        return true;
    }

    private void readSpaceGroup() throws Exception {
        this.spaceGroup = this.line.substring(this.line.indexOf(":") + 1).trim();
    }

    private static int parameterIndex(String string) {
        int n = tags.length;
        while (--n >= 0) {
            if (!tags[n].equals(string)) continue;
            return n;
        }
        return -1;
    }

    private void setParameter(String string, float f) {
        switch (GulpReader.parameterIndex(string)) {
            case 0: {
                this.a = f;
                break;
            }
            case 1: {
                this.b = f;
                break;
            }
            case 2: {
                this.c = f;
                break;
            }
            case 3: {
                this.alpha = f;
                break;
            }
            case 4: {
                this.beta = f;
                break;
            }
            case 5: {
                this.gamma = f;
            }
        }
    }

    private void newAtomSet(boolean bl) {
        this.asc.newAtomSet();
        if (bl) {
            this.setModelParameters(this.coordinatesArePrimitive);
            if (this.totEnergy != null) {
                this.setEnergy();
            }
        }
    }

    private void setModelParameters(boolean bl) {
        if (this.spaceGroup != null) {
            this.setSpaceGroupName(bl ? "P1" : this.spaceGroup);
        }
        if (bl && this.primitiveData != null) {
            this.addPrimitiveLatticeVector(0, this.primitiveData, 0);
            this.addPrimitiveLatticeVector(1, this.primitiveData, 3);
            this.addPrimitiveLatticeVector(2, this.primitiveData, 6);
        } else if (this.a != 0.0f) {
            if (this.isSlab) {
                this.c = -1.0f;
                this.gamma = 90.0f;
                this.beta = 90.0f;
            } else if (this.isPolymer) {
                this.c = -1.0f;
                this.b = -1.0f;
                this.gamma = 90.0f;
                this.beta = 90.0f;
                this.alpha = 90.0f;
            }
            this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
        }
    }

    private void readCellParameters(boolean bl) throws Exception {
        if (bl) {
            this.rd();
            this.primitiveData = this.fillFloatArray(null, 0, new float[9]);
            this.a = 0.0f;
            return;
        }
        int n = this.line.indexOf("Full cell") < 0 ? 0 : 4;
        this.coordinatesArePrimitive = n == 0;
        this.rd();
        while (this.rd() != null && this.line.contains("=")) {
            String[] stringArray = GulpReader.getTokensStr(this.line.replace('=', ' '));
            for (int i = n; i < n + 4; i += 2) {
                if (stringArray.length <= i + 1) continue;
                this.setParameter(stringArray[i], this.parseFloatStr(stringArray[i + 1]));
            }
        }
    }

    private void readFinalCell() throws Exception {
        String[] stringArray;
        this.discardLinesUntilContains(this.sep);
        while (this.rd() != null && (stringArray = this.getTokens()).length >= 2) {
            this.setParameter(stringArray[0], this.parseFloatStr(stringArray[1]));
        }
        if (this.primitiveData != null) {
            this.scalePrimitiveData(0, this.a);
            this.scalePrimitiveData(3, this.b);
            this.scalePrimitiveData(6, this.c);
            if (!this.coordinatesArePrimitive) {
                while (this.rd() != null && this.line.indexOf("Final") < 0) {
                    if (this.line.indexOf("Non-primitive lattice parameters") <= 0) continue;
                    this.rd();
                    for (int i = 0; i < 2; ++i) {
                        stringArray = GulpReader.getTokensStr(this.rd().replace('=', ' '));
                        this.setParameter(stringArray[0], this.parseFloatStr(stringArray[1]));
                        this.setParameter(stringArray[2], this.parseFloatStr(stringArray[3]));
                        this.setParameter(stringArray[4], this.parseFloatStr(stringArray[5]));
                    }
                }
            }
        }
        this.setModelParameters(this.coordinatesArePrimitive);
        this.applySymmetryAndSetTrajectory();
        if (this.totEnergy != null) {
            this.setEnergy();
        }
    }

    private void scalePrimitiveData(int n, float f) {
        V3 v3 = V3.new3(this.primitiveData[n], this.primitiveData[n + 1], this.primitiveData[n + 2]);
        v3.normalize();
        v3.scale(f);
        this.primitiveData[n++] = v3.x;
        this.primitiveData[n++] = v3.y;
        this.primitiveData[n++] = v3.z;
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.coordinatesArePrimitive && this.iHaveUnitCell && this.doCheckUnitCell && this.primitiveData != null && !this.isPrimitive) {
            this.setModelParameters(false);
            SymmetryInterface symmetryInterface = this.symmetry;
            this.setModelParameters(true);
            Atom[] atomArray = this.asc.atoms;
            int n = this.asc.getLastAtomSetAtomIndex();
            int n2 = this.asc.ac;
            for (int i = n; i < n2; ++i) {
                Atom atom = atomArray[i];
                this.symmetry.toCartesian(atom, true);
                symmetryInterface.toFractional(atom, true);
            }
            this.setModelParameters(false);
        }
        this.applySymTrajASCR();
    }

    private void readAtomicPos(boolean bl) throws Exception {
        this.newAtomSet(bl);
        this.discardLinesUntilContains(this.sep);
        this.discardLinesUntilContains(this.sep);
        while (this.rd() != null && (this.line.indexOf(this.sep) < 0 || this.rd().indexOf("Region") >= 0)) {
            if (this.line.indexOf("Region") >= 0) {
                this.rd();
                continue;
            }
            this.line = this.line.replace('*', ' ');
            String[] stringArray = this.getTokens();
            if (!stringArray[2].equals("c")) continue;
            this.addAtomXYZSymName(stringArray, 3, null, stringArray[1]);
        }
        if (bl) {
            this.applySymmetryAndSetTrajectory();
        }
    }

    private void readPartialCharges() throws Exception {
        String[] stringArray;
        this.atomCharges = new Hashtable<String, Float>();
        this.discardLinesUntilContains(this.sep);
        this.discardLinesUntilContains(this.sep);
        while ((stringArray = GulpReader.getTokensStr(this.rd())).length > 5) {
            String string = stringArray[0];
            Float f = this.atomCharges.get(string);
            float f2 = f == null ? 0.0f : f.floatValue();
            this.atomCharges.put(string, Float.valueOf(f2 + this.parseFloatStr(stringArray[4])));
        }
    }

    private void readEnergy() throws Exception {
        if (this.line.indexOf("=") < 0) {
            this.discardLinesUntilContains("=");
        }
        String[] stringArray = GulpReader.getTokensStr(this.line.substring(this.line.indexOf("=")));
        this.totEnergy = Double.parseDouble(stringArray[1]);
        this.energyUnits = stringArray[2];
        this.discardLinesUntilContains(this.sep);
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totEnergy, this.totEnergy.floatValue());
        this.asc.setAtomSetCollectionAuxiliaryInfo("Energy", this.totEnergy);
        this.asc.setAtomSetName("E = " + this.totEnergy + " " + this.energyUnits);
        this.totEnergy = null;
    }
}

