/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.java.BS;

public class XmlXsdReader
extends XmlReader {
    private BS bsBackbone = new BS();
    private int iChain = -1;
    private int iGroup = 0;
    private int iAtom = 0;

    @Override
    protected String[] getDOMAttributes() {
        return new String[]{"ID", "XYZ", "Connections", "Components", "IsBackboneAtom", "Connects", "Type", "Name"};
    }

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.htParams.put("backboneAtoms", this.bsBackbone);
        this.PX(xmlReader, object);
        this.asc.clearSymbolicMap();
    }

    @Override
    public void processStartElement(String string) {
        System.out.println(" " + string + " " + this.atts);
        System.out.println("xmlchem3d: start " + string);
        if ("Molecule".equalsIgnoreCase(string)) {
            this.asc.newAtomSet();
            this.asc.setAtomSetName((String)this.atts.get("Name"));
            return;
        }
        if ("LinearChain".equalsIgnoreCase(string)) {
            this.iGroup = 0;
            ++this.iChain;
        }
        if ("RepeatUnit".equalsIgnoreCase(string)) {
            ++this.iGroup;
        }
        if ("Atom3d".equalsIgnoreCase(string)) {
            boolean bl;
            this.atom = new Atom();
            this.atom.elementSymbol = (String)this.atts.get("Components");
            this.atom.atomName = (String)this.atts.get("ID");
            this.atom.atomSerial = ++this.iAtom;
            if (this.iChain >= 0) {
                this.parent.setChainID(this.atom, (char)((this.iChain - 1) % 26 + 65));
            }
            this.atom.group3 = "UNK";
            if (this.iGroup == 0) {
                this.iGroup = 1;
            }
            this.atom.sequenceNumber = this.iGroup;
            String string2 = (String)this.atts.get("XYZ");
            if (string2 != null) {
                String[] stringArray = XmlXsdReader.getTokensStr(string2.replace(',', ' '));
                this.atom.set(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            }
            if (bl = "1".equals(this.atts.get("IsBackboneAtom"))) {
                this.bsBackbone.set(this.iAtom);
            }
            return;
        }
        if ("Bond".equalsIgnoreCase(string)) {
            String[] stringArray = PT.split((String)this.atts.get("Connects"), ",");
            int n = 1;
            if (this.atts.containsKey("Type")) {
                String string3 = (String)this.atts.get("Type");
                if (string3.equals("Double")) {
                    n = 2;
                } else if (string3.equals("Triple")) {
                    n = 3;
                }
            }
            this.asc.addNewBondFromNames(stringArray[0], stringArray[1], n);
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if ("Atom3d".equalsIgnoreCase(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

