/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javajs.util.List;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

abstract class SlaterReader
extends BasisFunctionReader {
    protected final List<SlaterData> slaters = new List();
    protected SlaterData[] slaterArray;
    private static final double _1_4pi = 0.07957747154594767;
    private static final double[] fact1 = new double[]{1.0, 2.0, 24.0, 720.0, 40320.0, 362880.0, 8.71782912E10};
    private static final double[] dfact2 = new double[]{1.0, 1.0, 3.0, 15.0, 105.0};

    SlaterReader() {
    }

    protected final void addSlater(int n, int n2, int n3, int n4, int n5, double d, float f) {
        System.out.println("SlaterReader " + this.slaters.size() + ": " + n + " " + n2 + " " + n3 + " " + n4 + " " + n5 + " " + d + " " + f);
        this.slaters.addLast(new SlaterData(n, n2, n3, n4, n5, d, f));
    }

    protected void addSlater(SlaterData slaterData, int n) {
        slaterData.index = n;
        this.slaters.addLast(slaterData);
    }

    protected final void setSlaters(boolean bl, boolean bl2) {
        int n;
        int n2;
        if (this.slaterArray == null) {
            n2 = this.slaters.size();
            this.slaterArray = new SlaterData[n2];
            for (n = 0; n < this.slaterArray.length; ++n) {
                this.slaterArray[n] = (SlaterData)this.slaters.get(n);
            }
        }
        if (bl) {
            for (n2 = 0; n2 < this.slaterArray.length; ++n2) {
                SlaterData slaterData = this.slaterArray[n2];
                slaterData.coef *= this.scaleSlater(slaterData.x, slaterData.y, slaterData.z, slaterData.r, slaterData.zeta);
                if (!Logger.debugging) continue;
                Logger.debug("SlaterReader " + n2 + ": " + slaterData.iAtom + " " + slaterData.x + " " + slaterData.y + " " + slaterData.z + " " + slaterData.r + " " + slaterData.zeta + " " + slaterData.coef);
            }
        }
        if (bl2) {
            Arrays.sort(this.slaterArray, new SlaterSorter());
            int[] nArray = new int[this.slaterArray.length];
            for (n = 0; n < this.slaterArray.length; ++n) {
                nArray[n] = this.slaterArray[n].index;
            }
            this.sortOrbitalCoefficients(nArray);
        }
        this.moData.put("slaters", this.slaterArray);
        this.asc.setAtomSetAuxiliaryInfo("moData", this.moData);
    }

    protected final void setMOs(String string) {
        this.moData.put("mos", this.orbitals);
        this.moData.put("energyUnits", string);
        this.finalizeMOData(this.moData);
    }

    protected void sortOrbitalCoefficients(int[] nArray) {
        int n = this.orbitals.size();
        while (--n >= 0) {
            Map map = (Map)this.orbitals.get(n);
            float[] fArray = (float[])map.get("coefficients");
            float[] fArray2 = new float[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 >= fArray.length) continue;
                fArray2[i] = fArray[n2];
            }
            map.put("coefficients", fArray2);
        }
    }

    protected void sortOrbitals() {
        Map[] mapArray = this.orbitals.toArray(new Map[0]);
        Arrays.sort(mapArray, new OrbitalSorter());
        this.orbitals.clear();
        for (int i = 0; i < mapArray.length; ++i) {
            this.orbitals.addLast(mapArray[i]);
        }
    }

    protected double scaleSlater(int n, int n2, int n3, int n4, double d) {
        int n5 = n + n2 + n3;
        switch (n5) {
            case 0: 
            case 1: {
                n3 = -1;
            }
        }
        return SlaterReader.getSlaterConstCartesian(n5 + n4 + 1, Math.abs(d), n5, n, n2, n3);
    }

    private static double fact(double d, double d2, int n) {
        return Math.pow(2.0 * d2, (double)n + 0.5) * Math.sqrt(d * 0.07957747154594767 / fact1[n]);
    }

    protected static final double getSlaterConstCartesian(int n, double d, int n2, int n3, int n4, int n5) {
        return SlaterReader.fact(n5 < 0 ? dfact2[n2 + 1] : dfact2[n2 + 1] / dfact2[n3] / dfact2[n4] / dfact2[n5], d, n);
    }

    protected static final double getSlaterConstDSpherical(int n, double d, int n2, int n3) {
        return SlaterReader.fact(15 / (n2 < 0 ? 12 : (n3 < 0 ? 4 : 1)), d, n);
    }

    class OrbitalSorter
    implements Comparator<Map<String, Object>> {
        OrbitalSorter() {
        }

        @Override
        public int compare(Map<String, Object> map, Map<String, Object> map2) {
            float f;
            float f2 = ((Float)map.get("energy")).floatValue();
            return f2 < (f = ((Float)map2.get("energy")).floatValue()) ? -1 : (f < f2 ? 1 : 0);
        }
    }

    class SlaterSorter
    implements Comparator<SlaterData> {
        SlaterSorter() {
        }

        @Override
        public int compare(SlaterData slaterData, SlaterData slaterData2) {
            return slaterData.iAtom < slaterData2.iAtom ? -1 : (slaterData.iAtom > slaterData2.iAtom ? 1 : 0);
        }
    }
}

