/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String moType = "";
    private int nOrbitals0;
    private static String P_LIST = "101   102   103";
    private static String SP_LIST = "1     101   102   103";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";

    @Override
    protected void initializeReader() throws Exception {
        boolean bl;
        String string = this.rd().trim();
        this.rd();
        boolean bl2 = this.isOutputFile = this.line.indexOf("***") >= 0;
        if (this.isOutputFile) {
            bl = this.readFile31();
            super.initializeReader();
            this.moData.put("isNormalized", Boolean.TRUE);
        } else if (this.line.indexOf("s in the AO basis:") >= 0) {
            this.moType = this.line.substring(1, this.line.indexOf("s"));
            this.asc.setCollectionName(string + ": " + this.moType + "s");
            bl = this.readFile31();
        } else {
            this.moType = "AO";
            this.asc.setCollectionName(string + ": " + this.moType + "s");
            bl = this.readData31(string, this.line);
        }
        if (!bl) {
            Logger.error("Unimplemented shell type -- no orbitals avaliable: " + this.line);
        }
        if (this.isOutputFile) {
            return;
        }
        if (bl) {
            this.readMOs();
        }
        this.continuing = false;
    }

    private void readMOs() throws Exception {
        this.nOrbitals0 = this.orbitals.size();
        this.readFile46();
        this.readOrbitalData(!this.moType.equals("AO"));
        this.setMOData(false);
        this.moData.put("isNormalized", Boolean.TRUE);
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0 && !this.orbitalsRead) {
            this.moType = "NBO";
            String string = this.getFileData(".37");
            if (string == null) {
                this.moType = "PNBO";
                string = this.getFileData(".36");
                if (string == null) {
                    return true;
                }
            }
            BufferedReader bufferedReader = this.reader;
            this.reader = Rdr.getBR(string);
            this.rd();
            this.rd();
            this.readMOs();
            this.reader = bufferedReader;
            this.orbitalsRead = false;
            return true;
        }
        return this.checkNboLine();
    }

    private String getFileData(String string) throws Exception {
        String string2;
        String string3 = (String)this.htParams.get("fullPathName");
        int n = string3.lastIndexOf(".");
        if (n < 0) {
            n = string3.length();
        }
        if ((string2 = this.vwr.getFileAsString(string3 = string3.substring(0, n) + string, false)).length() == 0 || string2.indexOf("java.io.FileNotFound") >= 0) {
            throw new Exception(" supplemental file " + string3 + " was not found");
        }
        return string2;
    }

    private boolean readFile31() throws Exception {
        String string = this.getFileData(".31");
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR(string);
        if (!this.readData31(null, null)) {
            return false;
        }
        this.reader = bufferedReader;
        return true;
    }

    private void readFile46() throws Exception {
        String string = this.getFileData(".46");
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR(string);
        this.readData46();
        this.reader = bufferedReader;
    }

    private boolean readData31(String string, String string2) throws Exception {
        int n;
        if (string == null) {
            string = this.rd();
        }
        if (string2 == null) {
            string2 = this.rd();
        }
        this.rd();
        String[] stringArray = GenNBOReader.getTokensStr(this.rd());
        int n2 = this.parseIntStr(stringArray[0]);
        this.shellCount = this.parseIntStr(stringArray[1]);
        this.gaussianCount = this.parseIntStr(stringArray[2]);
        this.rd();
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.moType + "s: " + string.trim());
        for (n = 0; n < n2; ++n) {
            stringArray = GenNBOReader.getTokensStr(this.rd());
            int n3 = this.parseIntStr(stringArray[0]);
            if (n3 < 0) continue;
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)n3;
            this.setAtomCoordTokens(atom, stringArray, 1);
        }
        this.shells = new List();
        this.gaussians = AU.newFloat2(this.gaussianCount);
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = new float[6];
        }
        this.rd();
        this.nOrbitals = 0;
        for (n = 0; n < this.shellCount; ++n) {
            stringArray = GenNBOReader.getTokensStr(this.rd());
            int[] nArray = new int[4];
            nArray[0] = this.parseIntStr(stringArray[0]) - 1;
            int n4 = this.parseIntStr(stringArray[1]);
            this.nOrbitals += n4;
            this.line = this.rd().trim();
            switch (n4) {
                case 1: {
                    nArray[1] = JmolAdapter.SHELL_S;
                    break;
                }
                case 3: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_P, P_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_P;
                    break;
                }
                case 4: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_SP, SP_LIST, 1)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_SP;
                    break;
                }
                case 5: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_D_SPHERICAL, DS_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_D_SPHERICAL;
                    break;
                }
                case 6: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_D_CARTESIAN, DC_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_D_CARTESIAN;
                    break;
                }
                case 7: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_F_SPHERICAL, FS_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_F_SPHERICAL;
                    break;
                }
                case 10: {
                    if (!this.getDFMap(this.line, JmolAdapter.SHELL_F_CARTESIAN, FC_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = JmolAdapter.SHELL_F_CARTESIAN;
                }
            }
            nArray[2] = this.parseIntStr(stringArray[2]) - 1;
            nArray[3] = this.parseIntStr(stringArray[3]);
            this.shells.addLast(nArray);
        }
        for (n = 0; n < 5; ++n) {
            this.rd();
            float[] fArray = this.fillFloatArray(null, 0, new float[this.gaussianCount]);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i][n] = fArray[i];
                if (n <= 1) continue;
                float[] fArray2 = this.gaussians[i];
                fArray2[5] = fArray2[5] + fArray[i];
            }
        }
        for (n = 0; n < this.gaussianCount; ++n) {
            if (this.gaussians[n][1] != 0.0f) continue;
            this.gaussians[n][1] = this.gaussians[n][5];
        }
        if (Logger.debugging) {
            Logger.debug(this.shells.size() + " slater shells read");
            Logger.debug(this.gaussians.length + " gaussian primitives read");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readData46() throws Exception {
        int n;
        String[] stringArray = GenNBOReader.getTokensStr(this.rd());
        int n2 = 1;
        if (stringArray[1].equals("ALPHA")) {
            n2 = 2;
            if (this.haveNboOrbitals) {
                stringArray = GenNBOReader.getTokensStr(this.discardLinesUntilContains("BETA"));
                this.alphaBeta = "beta";
            } else {
                this.alphaBeta = "alpha";
                this.haveNboOrbitals = true;
            }
        }
        if (this.parseIntStr(stringArray[n2]) != this.nOrbitals) {
            Logger.error("file 46 number of orbitals does not match nOrbitals: " + this.nOrbitals);
            return false;
        }
        String string = null;
        if (this.moType.equals("AO")) {
            string = "AO";
        } else if (this.moType.indexOf("NHO") >= 0) {
            string = "NHO";
        } else if (this.moType.indexOf("NBO") >= 0) {
            string = "NBO";
        } else if (this.moType.indexOf("NAO") >= 0) {
            string = "NAO";
        } else if (this.moType.indexOf("MO") >= 0) {
            string = "MO";
        }
        if (string == null) {
            Logger.error("uninterpretable type " + this.moType);
            return false;
        }
        if (!string.equals("AO")) {
            this.discardLinesUntilContains(string.equals("MO") ? "NBO" : string);
        }
        SB sB = new SB();
        while (this.rd() != null && this.line.indexOf("O    ") < 0 && this.line.indexOf("ALPHA") < 0 && this.line.indexOf("BETA") < 0) {
            sB.append(this.line);
        }
        sB.appendC(' ');
        String string2 = sB.toString();
        int n3 = string2.length() - 1;
        sB = new SB();
        block5: for (n = 0; n < n3; ++n) {
            char c = string2.charAt(n);
            switch (c) {
                case '(': 
                case '-': {
                    if (string2.charAt(n + 1) != ' ') break;
                    ++n;
                    break;
                }
                case ' ': {
                    if (Character.isDigit(string2.charAt(n + 1)) || string2.charAt(n + 1) == '(') continue block5;
                }
            }
            sB.appendC(c);
        }
        Logger.info(sB.toString());
        stringArray = GenNBOReader.getTokensStr(sB.toString());
        for (n = 0; n < stringArray.length; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            this.setMO(hashtable);
        }
        if (string.equals("MO")) {
            return true;
        }
        n = 0;
        while (n < stringArray.length) {
            Map map = (Map)this.orbitals.get(n + this.nOrbitals0);
            String string3 = stringArray[n];
            map.put("type", this.moType + " " + string3);
            map.put("occupancy", Float.valueOf(string3.indexOf("*") >= 0 ? 0.0f : 2.0f));
            ++n;
        }
        return true;
    }

    private void readOrbitalData(boolean bl) throws Exception {
        Object object;
        int n = this.nOrbitals;
        this.nOrbitals = this.orbitals.size();
        this.line = null;
        for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
            Map map = (Map)this.orbitals.get(i);
            object = new float[n];
            map.put("coefficients", object);
            if (bl) {
                if (this.line == null) {
                    while (this.rd() != null && Float.isNaN(this.parseFloatStr(this.line))) {
                    }
                } else {
                    this.line = null;
                }
                this.fillFloatArray(this.line, 0, (float[])object);
                this.line = null;
                continue;
            }
            object[i] = 1.0f;
        }
        if (this.moType.equals("NBO")) {
            float[] fArray = new float[this.nOrbitals - this.nOrbitals0];
            this.fillFloatArray(null, 0, fArray);
            for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
                object = (Map)this.orbitals.get(i);
                object.put("occupancy", Float.valueOf((int)(fArray[i - this.nOrbitals0] + 0.2f)));
            }
        }
    }
}

