/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    private boolean is2D;
    private boolean isV3000;
    private boolean haveAtomSerials;
    protected String dimension;
    protected boolean allow2D = true;
    private int iatom0;

    @Override
    public void initializeReader() throws Exception {
        this.is2D = this.checkFilterKey("2D");
    }

    @Override
    protected boolean checkLine() throws Exception {
        boolean bl = this.line.startsWith("$MDL");
        if (bl) {
            this.discardLinesUntilStartsWith("$HDR");
            this.rd();
            if (this.line == null) {
                Logger.warn("$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        }
        if (this.doGetModel(++this.modelNumber, null)) {
            this.processMolSdHeader();
            this.processCtab(bl);
            this.iatom0 = this.asc.ac;
            this.isV3000 = false;
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
            return true;
        }
        this.discardLinesUntilStartsWith("$$$$");
        return true;
    }

    private void readUserData(int n) throws Exception {
        if (this.isV3000) {
            return;
        }
        while (this.rd() != null && this.line.indexOf("$$$$") != 0) {
            if (!this.line.toUpperCase().contains("_PARTIAL_CHARGES")) continue;
            try {
                Atom[] atomArray = this.asc.atoms;
                int n2 = this.parseIntStr(this.rd());
                while (--n2 >= 0) {
                    String[] stringArray = MolReader.getTokensStr(this.rd());
                    int n3 = this.parseIntStr(stringArray[0]) + n - 1;
                    float f = this.parseFloatStr(stringArray[1]);
                    if (Float.isNaN(f)) continue;
                    atomArray[n3].partialCharge = f;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    @Override
    public void finalizeReader() throws Exception {
        this.finalizeReaderMR();
    }

    protected void finalizeReaderMR() throws Exception {
        if (this.is2D) {
            this.set2D();
        }
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void processMolSdHeader() throws Exception {
        String string = "";
        String string2 = this.line;
        string = string + this.line + "\n";
        this.asc.setCollectionName(this.line);
        this.rd();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        String string3 = this.dimension = this.line.length() < 22 ? "3D" : this.line.substring(20, 22);
        if (!this.allow2D && this.dimension.equals("2D")) {
            throw new Exception("File is 2D, not 3D");
        }
        this.asc.setAtomSetCollectionAuxiliaryInfo("dimension", this.dimension);
        this.rd();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        Logger.info(string);
        this.checkCurrentLineForScript();
        this.asc.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
        this.newAtomSet(string2);
    }

    private void processCtab(boolean bl) throws Exception {
        String[] stringArray = null;
        if (bl) {
            this.discardLinesUntilStartsWith("$CTAB");
        }
        boolean bl2 = this.isV3000 = this.rd() != null && this.line.indexOf("V3000") >= 0;
        if (this.isV3000) {
            this.is2D = this.dimension.equals("2D");
            this.discardLinesUntilContains("COUNTS");
            stringArray = this.getTokens();
        }
        if (this.line == null) {
            return;
        }
        int n = this.isV3000 ? this.parseIntStr((String)stringArray[3]) : this.parseIntRange(this.line, 0, 3);
        int n2 = this.isV3000 ? this.parseIntStr(stringArray[4]) : this.parseIntRange(this.line, 3, 6);
        int n3 = this.asc.ac;
        this.readAtoms(n);
        this.readBonds(n2);
        this.readUserData(n3);
        if (this.isV3000) {
            this.discardLinesUntilContains("END CTAB");
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtoms(int n) throws Exception {
        if (this.isV3000) {
            this.discardLinesUntilContains("BEGIN ATOM");
        }
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            float f3;
            String string;
            Object object;
            this.rd();
            int n2 = this.line.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = Integer.MIN_VALUE;
            if (this.isV3000) {
                this.checkLineContinuation();
                object = this.getTokens();
                n5 = this.parseIntStr(object[2]);
                string = object[3];
                if (string.equals("*")) continue;
                f3 = this.parseFloatStr(object[4]);
                f2 = this.parseFloatStr(object[5]);
                f = this.parseFloatStr(object[6]);
                for (int j = 7; j < ((String[])object).length; ++j) {
                    String string2 = object[j].toUpperCase();
                    if (string2.startsWith("CHG=")) {
                        n3 = this.parseIntStr(object[j].substring(4));
                        continue;
                    }
                    if (!string2.startsWith("MASS=")) continue;
                    n4 = this.parseIntStr(object[j].substring(5));
                }
                if (n4 > 1 && string.equals("H")) {
                    n4 = 1 - n4;
                }
            } else {
                f3 = this.parseFloatRange(this.line, 0, 10);
                f2 = this.parseFloatRange(this.line, 10, 20);
                f = this.parseFloatRange(this.line, 20, 30);
                if (n2 < 34) {
                    string = this.line.substring(31).trim();
                } else {
                    string = this.line.substring(31, 34).trim();
                    if (n2 >= 39) {
                        int n6 = this.parseIntRange(this.line, 36, 39);
                        if (n6 >= 1 && n6 <= 7) {
                            n3 = 4 - n6;
                        }
                        if ((n6 = this.parseIntRange(this.line, 34, 36)) != 0 && n6 >= -3 && n6 <= 4) {
                            n4 = JmolAdapter.getNaturalIsotope(JmolAdapter.getElementNumber(string));
                            switch (n4) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    n4 = -n6;
                                    break;
                                }
                                default: {
                                    n4 += n6;
                                }
                            }
                        }
                        if (n5 == Integer.MIN_VALUE && this.haveAtomSerials) {
                            n5 = i + 1;
                        }
                    }
                }
            }
            switch (n4) {
                case 0: {
                    break;
                }
                case -1: {
                    string = "D";
                    break;
                }
                case -2: {
                    string = "T";
                    break;
                }
                default: {
                    string = n4 + string;
                }
            }
            if (this.is2D && f != 0.0f) {
                this.is2D = false;
            }
            object = new Atom();
            object.elementSymbol = string;
            object.formalCharge = n3;
            this.setAtomCoordXYZ((Atom)object, f3, f2, f);
            if (n5 == Integer.MIN_VALUE) {
                this.asc.addAtom((Atom)object);
                continue;
            }
            this.haveAtomSerials = true;
            object.atomSerial = n5;
            this.asc.addAtomWithMappedSerialNumber((Atom)object);
        }
        if (this.isV3000) {
            this.discardLinesUntilContains("END ATOM");
        }
    }

    private void checkLineContinuation() throws Exception {
        while (this.line.endsWith("-")) {
            String string = this.line;
            this.rd();
            this.line = string + this.line;
        }
    }

    private void readBonds(int n) throws Exception {
        if (this.isV3000) {
            this.discardLinesUntilContains("BEGIN BOND");
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            this.rd();
            int n5 = 0;
            if (this.isV3000) {
                this.checkLineContinuation();
                String[] stringArray = this.getTokens();
                n4 = this.parseIntStr(stringArray[3]);
                n3 = this.parseIntStr(stringArray[4]);
                n2 = this.parseIntStr(stringArray[5]);
                for (int j = 6; j < stringArray.length; ++j) {
                    String string = stringArray[j].toUpperCase();
                    if (string.startsWith("CFG=")) {
                        n5 = this.parseIntStr(stringArray[j].substring(4));
                    } else {
                        if (!string.startsWith("ENDPTS=") || this.line.indexOf("ATTACH=ALL") < 0) continue;
                        stringArray = MolReader.getTokensAt(this.line, this.line.indexOf("ENDPTS=") + 8);
                        int n6 = this.parseIntStr(stringArray[0]);
                        n4 = this.fixOrder(n4, 0);
                        for (int k = 1; k <= n6; ++k) {
                            n2 = this.parseIntStr(stringArray[k]);
                            this.asc.addNewBondWithMappedSerialNumbers(n3, n2, n4);
                        }
                    }
                    break;
                }
            } else {
                n3 = this.parseIntRange(this.line, 0, 3);
                n2 = this.parseIntRange(this.line, 3, 6);
                n4 = this.parseIntRange(this.line, 6, 9);
                if (this.is2D && n4 == 1 && this.line.length() >= 12) {
                    n5 = this.parseIntRange(this.line, 9, 12);
                }
            }
            n4 = this.fixOrder(n4, n5);
            if (this.haveAtomSerials) {
                this.asc.addNewBondWithMappedSerialNumbers(n3, n2, n4);
                continue;
            }
            this.asc.addNewBondWithOrder(this.iatom0 + n3 - 1, this.iatom0 + n2 - 1, n4);
        }
        if (this.isV3000) {
            this.discardLinesUntilContains("END BOND");
        }
    }

    private int fixOrder(int n, int n2) {
        switch (n) {
            default: {
                return 1;
            }
            case 1: {
                switch (n2) {
                    case 1: {
                        return 1025;
                    }
                    case 3: 
                    case 6: {
                        return 1041;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return 515;
            }
            case 5: {
                return 66;
            }
            case 6: {
                return 513;
            }
            case 7: {
                return 514;
            }
            case 8: 
            case 9: {
                return 33;
            }
        }
        return n;
    }
}

