/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.util.CifDataParser;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MMCifInterface;
import org.jmol.adapter.readers.cif.MSCifInterface;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class CifReader
extends AtomSetCollectionReader
implements GenericLineReader {
    private MSCifInterface mr;
    private MMCifInterface pr;
    GenericCifDataParser parser = new CifDataParser().set(this, null);
    private boolean isMolecular;
    private boolean filterAssembly;
    private boolean allowRotations = true;
    private boolean checkSpecial = true;
    private boolean readIdeal = true;
    private int configurationPtr = Integer.MIN_VALUE;
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private boolean isPDB;
    private boolean isPDBX;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private boolean haveAromatic;
    private int conformationIndex;
    private int nMolecular = 0;
    private String appendedData;
    private boolean skipping;
    private int nAtoms;
    private String auditBlockCode;
    private String lastSpaceGroupName;
    private boolean modulated;
    private boolean lookingForPDB = true;
    private boolean isCourseGrained;
    private String latticeType = null;
    private Hashtable<String, Object> htAudit;
    private List<String> symops;
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    String key;
    String data;
    int[] propertyOf = new int[100];
    int[] fieldOf = new int[100];
    String field;
    private char firstChar = '\u0000';
    private int propertyCount;
    private Map<String, Float> atomTypes;
    private List<Object[]> bondTypes = new List();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private List<float[]> lattvecs;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_BETA_11 = 41;
    private static final byte ANISO_BETA_22 = 42;
    private static final byte ANISO_BETA_33 = 43;
    private static final byte ANISO_BETA_12 = 44;
    private static final byte ANISO_BETA_13 = 45;
    private static final byte ANISO_BETA_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CHEM_COMP_AC_ID = 48;
    private static final byte CHEM_COMP_AC_NAME = 49;
    private static final byte CHEM_COMP_AC_SYM = 50;
    private static final byte CHEM_COMP_AC_CHARGE = 51;
    private static final byte CHEM_COMP_AC_X = 52;
    private static final byte CHEM_COMP_AC_Y = 53;
    private static final byte CHEM_COMP_AC_Z = 54;
    private static final byte CHEM_COMP_AC_X_IDEAL = 55;
    private static final byte CHEM_COMP_AC_Y_IDEAL = 56;
    private static final byte CHEM_COMP_AC_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte ASYM_ID = 59;
    private static final byte SUBSYS_ID = 60;
    private static final byte SITE_MULT = 61;
    private static final byte THERMAL_TYPE = 62;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_cartn_x", "_atom_site_cartn_y", "_atom_site_cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_pdb_ins_code", "_atom_site_label_alt_id", "_atom_site_group_pdb", "_atom_site_pdbx_pdb_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_anisotrop_id", "_atom_site_aniso_u_11", "_atom_site_aniso_u_22", "_atom_site_aniso_u_33", "_atom_site_aniso_u_12", "_atom_site_aniso_u_13", "_atom_site_aniso_u_23", "_atom_site_anisotrop_u[1][1]", "_atom_site_anisotrop_u[2][2]", "_atom_site_anisotrop_u[3][3]", "_atom_site_anisotrop_u[1][2]", "_atom_site_anisotrop_u[1][3]", "_atom_site_anisotrop_u[2][3]", "_atom_site_u_iso_or_equiv", "_atom_site_aniso_b_11", "_atom_site_aniso_b_22", "_atom_site_aniso_b_33", "_atom_site_aniso_b_12", "_atom_site_aniso_b_13", "_atom_site_aniso_b_23", "_atom_site_aniso_beta_11", "_atom_site_aniso_beta_22", "_atom_site_aniso_beta_33", "_atom_site_aniso_beta_12", "_atom_site_aniso_beta_13", "_atom_site_aniso_beta_23", "_atom_site_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_cartn_x", "_chem_comp_atom_model_cartn_y", "_chem_comp_atom_model_cartn_z", "_chem_comp_atom_pdbx_model_cartn_x_ideal", "_chem_comp_atom_pdbx_model_cartn_y_ideal", "_chem_comp_atom_pdbx_model_cartn_z_ideal", "_atom_site_disorder_assembly", "_atom_site_label_asym_id", "_atom_site_subsystem_code", "_atom_site_symmetry_multiplicity", "_atom_site_thermal_displace_type"};
    private static final String singleAtomID = atomFields[48];
    private static final byte CITATION_ID = 0;
    private static final byte CITATION_TITLE = 1;
    private static final String[] citationFields = new String[]{"_citation_id", "_citation_title"};
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final byte SYM_SSG_XYZ = 2;
    private static final byte SYM_SSG_OP = 3;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "_space_group_symop_ssg_operation_algebraic"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private int ac;
    private Atom[] atoms;

    @Override
    public void initializeReader() throws Exception {
        this.allowPDBFilter = true;
        this.appendedData = (String)this.htParams.get("appendedData");
        String string = this.getFilter("CONF ");
        if (string != null) {
            this.configurationPtr = this.parseIntStr(string);
        }
        this.isMolecular = this.checkFilterKey("MOLECUL") && !this.checkFilterKey("BIOMOLECULE");
        this.readIdeal = !this.checkFilterKey("NOIDEAL");
        this.filterAssembly = this.checkFilterKey("$");
        if (this.isMolecular) {
            if (!this.doApplySymmetry) {
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.checkSpecial = !this.checkFilterKey("NOSPECIAL");
        this.asc.setCheckSpecial(this.checkSpecial);
        this.allowRotations = !this.checkFilterKey("NOSYM");
        this.readCifData();
        this.continuing = false;
    }

    private void readCifData() throws Exception {
        block2: {
            this.line = "";
            while ((this.key = this.parser.peekToken()) != null && this.readAllData()) {
            }
            if (this.appendedData == null) break block2;
            this.parser = Rdr.getCifParser().set(null, Rdr.getBR(this.appendedData));
            while ((this.key = this.parser.peekToken()) != null && this.readAllData()) {
            }
        }
    }

    @Override
    public String readNextLine() throws Exception {
        if (this.rd() != null && this.line.indexOf("#jmolscript:") >= 0) {
            this.checkCurrentLineForScript();
        }
        return this.line;
    }

    private boolean readAllData() throws Exception {
        if (this.key.startsWith("data_")) {
            if (this.iHaveDesiredModel) {
                return false;
            }
            this.newModel(++this.modelNumber);
            if (!this.skipping) {
                this.processDataParameter();
            }
            this.nAtoms = this.asc.ac;
            return true;
        }
        if (this.lookingForPDB && !this.isPDBX && this.key.indexOf(".pdb") >= 0) {
            this.initializeMMCIF();
        }
        if (this.skipping && this.key.equals("_audit_block_code")) {
            this.iHaveDesiredModel = false;
            this.skipping = false;
        }
        if (this.key.startsWith("loop_")) {
            if (this.skipping) {
                this.parser.getTokenPeeked();
                this.parser.skipLoop();
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
            this.parser.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key = this.fixKey(this.key);
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.equals("_cell_modulation_dimension")) {
                this.initializeMSCIF(this.data);
            } else if (this.key.equals("_citation_title")) {
                this.appendLoadNote("TITLE: " + this.parser.fullTrim(this.data));
            } else if (this.key.startsWith("_cell_")) {
                this.processCellParameter();
            } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.contains("_ssg_name")) {
                this.processSymmetrySpaceGroupName();
            } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
            } else if (this.key.equals("_audit_block_code")) {
                this.auditBlockCode = this.parser.fullTrim(this.data).toUpperCase();
                this.appendLoadNote(this.auditBlockCode);
                if (this.htAudit != null && this.auditBlockCode.contains("_MOD_")) {
                    String string = PT.rep(this.auditBlockCode, "_MOD_", "_REFRNCE_");
                    if (this.asc.setSymmetry((SymmetryInterface)this.htAudit.get(string)) != null) {
                        this.notionalUnitCell = this.asc.getSymmetry().getNotionalUnitCell();
                        this.iHaveUnitCell = true;
                    }
                } else if (this.htAudit != null && this.symops != null) {
                    for (int i = 0; i < this.symops.size(); ++i) {
                        this.setSymmetryOperator((String)this.symops.get(i));
                    }
                }
                if (this.lastSpaceGroupName != null) {
                    this.setSpaceGroupName(this.lastSpaceGroupName);
                }
            } else if (this.key.equals(singleAtomID)) {
                this.readSingleAtom();
            } else if (this.pr != null) {
                this.pr.processEntry();
            } else if (this.mr != null) {
                this.mr.processEntry();
            }
        }
        return true;
    }

    private void readSingleAtom() {
        Atom atom = new Atom();
        atom.set(0.0f, 0.0f, 0.0f);
        String string = atom.atomName = this.parser.fullTrim(this.data);
        atom.elementSymbol = string.length() == 1 ? string : string.substring(0, 1) + string.substring(1, 2).toLowerCase();
        this.asc.addAtom(atom);
    }

    private void initializeMMCIF() {
        this.isPDBX = true;
        this.lookingForPDB = false;
        if (this.pr == null) {
            this.pr = (MMCifInterface)Interface.getOption("adapter.readers.cif.MMCifReader");
        }
        this.isCourseGrained = this.pr.initialize(this);
    }

    private void initializeMSCIF(String string) throws Exception {
        if (this.mr == null) {
            this.mr = (MSCifInterface)Interface.getOption("adapter.readers.cif.MSCifReader");
            this.ms = this.mr;
        }
        this.addLatticeVectors();
        this.modulated = this.mr.initialize(this, string) > 0;
    }

    private String fixKey(String string) {
        return PT.rep(string, ".", "_").toLowerCase();
    }

    protected void newModel(int n) throws Exception {
        if (this.isPDB) {
            this.setIsPDB();
        }
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber = n, null);
        if (this.skipping) {
            this.parser.getTokenPeeked();
            return;
        }
        this.chemicalName = "";
        this.thisStructuralFormula = "";
        this.thisFormula = "";
        if (this.isCourseGrained) {
            this.asc.setAtomSetAuxiliaryInfo("courseGrained", Boolean.TRUE);
        }
        if (this.nAtoms == this.asc.ac) {
            this.asc.removeCurrentAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
    }

    @Override
    protected void finalizeReader() throws Exception {
        if (this.pr != null) {
            this.pr.finalizeReader(this.nAtoms);
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        int n = this.asc.atomSetCount;
        if (n > 1) {
            this.asc.setCollectionName("<collection of " + n + " models>");
        }
        this.finalizeReaderASCR();
        String string = this.parser.getFileHeader();
        if (string.length() > 0) {
            this.asc.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
        }
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
    }

    @Override
    public void doPreSymmetry() {
        if (this.mr != null) {
            this.mr.setModulation(false);
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.isPDB) {
            this.asc.setCheckSpecial(false);
        }
        boolean bl = this.doCheckUnitCell && !this.isPDB;
        SymmetryInterface symmetryInterface = this.applySymTrajASCR();
        if (this.mr != null) {
            this.mr.setModulation(true);
            this.mr.finalizeModulation();
        }
        if (this.auditBlockCode != null && this.auditBlockCode.contains("REFRNCE") && symmetryInterface != null) {
            if (this.htAudit == null) {
                this.htAudit = new Hashtable();
            }
            this.htAudit.put(this.auditBlockCode, symmetryInterface);
        }
        if (bl && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
        this.asc.setAtomSetAuxiliaryInfo("fileHasUnitCell", Boolean.TRUE);
        this.asc.xtalSymmetry = null;
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.parser.getTokenPeeked();
        this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        boolean bl = this.lookingForPDB = this.thisDataSetName.length() > 0 && !this.thisDataSetName.equals("global");
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (Logger.debugging) {
            Logger.debug(this.key);
        }
    }

    private void nextAtomSet() {
        this.asc.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.asc.currentAtomSetIndex >= 0) {
            this.asc.newAtomSet();
        } else {
            this.asc.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.parser.fullTrim(this.data);
            if (!this.data.equals("?")) {
                this.asc.setAtomSetCollectionAuxiliaryInfo("modelLoadNote", this.data);
            }
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.parser.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.parser.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug(string + " = " + this.data);
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        if (this.key.indexOf("_ssg_name") >= 0) {
            this.modulated = true;
            this.latticeType = this.data.substring(0, 1);
        } else if (this.modulated) {
            return;
        }
        this.data = this.parser.toUnicode(this.data);
        this.lastSpaceGroupName = (this.key.indexOf("h-m") > 0 ? "HM:" : (this.modulated ? "SSG:" : "Hall:")) + this.data;
        this.setSpaceGroupName(this.lastSpaceGroupName);
    }

    private void addLatticeVectors() {
        if (this.latticeType != null && "ABCFI".indexOf(this.latticeType) >= 0) {
            this.lattvecs = new List();
            try {
                this.ms.addLatticeVector(this.lattvecs, this.latticeType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.lattvecs != null && this.lattvecs.size() > 0 && this.asc.getSymmetry().addLatticeVectors(this.lattvecs)) {
                this.appendLoadNote("Note! Symmetry operators added for lattice centering " + this.latticeType);
            }
            this.latticeType = null;
        }
    }

    private void processCellParameter() throws Exception {
        int n = JmolAdapter.cellParamNames.length;
        while (--n >= 0) {
            if (!this.key.equals(JmolAdapter.cellParamNames[n])) continue;
            this.setUnitCellItem(n, this.parseFloatStr(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloatStr(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.parser.getTokenPeeked();
        this.data = this.parser.getNextToken();
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.parser.getTokenPeeked();
        this.key = this.parser.peekToken();
        if (this.key == null) {
            return;
        }
        boolean bl = false;
        this.key = this.fixKey(this.key);
        if (this.lookingForPDB && !this.isPDBX && this.key.indexOf("_pdb") >= 0) {
            this.initializeMMCIF();
        }
        if (this.mr != null) {
            switch (this.mr.processLoopBlock()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.parser.skipLoop();
                }
                case 1: {
                    return;
                }
            }
        }
        if (this.key.startsWith("_atom_site_") || (bl = this.key.equals("_chem_comp_atom_comp_id"))) {
            if (!this.processAtomSiteLoopBlock(bl)) {
                return;
            }
            this.asc.setAtomSetName(this.thisDataSetName);
            this.asc.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.asc.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.asc.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (this.key.startsWith("_symmetry_equiv_pos") || this.key.startsWith("_space_group_symop") || this.key.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.parser.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (this.key.startsWith("_citation")) {
            this.processCitationListBlock();
            return;
        }
        if (this.key.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (this.key.startsWith("_geom_bond") && (this.isMolecular || !this.doApplySymmetry)) {
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.pr != null && this.pr.processLoopBlock()) {
            return;
        }
        this.parser.skipLoop();
    }

    private int fieldProperty(int n) {
        this.field = this.parser.getLoopData(n);
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[n] : -1;
    }

    void parseLoopParameters(String[] stringArray) throws Exception {
        this.propertyCount = this.parser.parseLoopParameters(stringArray, this.fieldOf, this.propertyOf);
    }

    private void disableField(int n) {
        int n2 = this.fieldOf[n];
        if (n2 != -1) {
            this.propertyOf[n2] = -1;
        }
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            this.parser.skipLoop();
            return;
        }
        while (this.parser.getData()) {
            String string = null;
            float f = Float.NaN;
            int n2 = this.parser.getFieldCount();
            block7: for (int i = 0; i < n2; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = this.field;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloatStr(this.field);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable<String, Float>();
            }
            this.atomTypes.put(string, Float.valueOf(f));
        }
    }

    boolean processAtomSiteLoopBlock(boolean bl) throws Exception {
        this.lookingForPDB = false;
        int n = -1;
        boolean bl2 = false;
        String string = null;
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[55] != -1) {
            this.isPDB = false;
            this.setFractionalCoordinates(false);
        } else if (this.fieldOf[6] != -1 || this.fieldOf[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] != -1) {
            bl2 = true;
        } else if (this.fieldOf[21] != -1) {
            bl2 = true;
        } else {
            this.parser.skipLoop();
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (this.parser.getData()) {
            int n5;
            int n6;
            int n7;
            Atom atom = new Atom();
            string = null;
            if (this.isPDBX) {
                if (n3 == -1) {
                    n7 = this.parser.getFieldCount();
                    for (n6 = 0; n6 < n7; ++n6) {
                        if (this.fieldProperty(n6) != 17) continue;
                        n3 = n6;
                        this.isPDB = true;
                        break;
                    }
                    if (n3 == -1) {
                        n3 = -2;
                    }
                }
                if (n3 >= 0) {
                    this.fieldProperty(n3);
                    n7 = this.parseIntStr(this.field);
                    if (n7 != n) {
                        if (this.iHaveDesiredModel) {
                            this.parser.skipLoop();
                            this.skipping = false;
                            this.continuing = true;
                            break;
                        }
                        n = n7;
                        this.newModel(n7);
                        if (!this.skipping) {
                            this.nextAtomSet();
                        }
                    }
                    if (this.skipping) continue;
                }
            }
            n7 = this.parser.getFieldCount();
            block33: for (n6 = 0; n6 < n7; ++n6) {
                n5 = this.fieldProperty(n6);
                switch (n5) {
                    case -1: 
                    case 17: {
                        continue block33;
                    }
                    case 0: 
                    case 50: {
                        char c;
                        String string2 = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol2(this.firstChar, c = Character.toLowerCase(this.field.charAt(1))) ? "" + this.firstChar + c : "" + this.firstChar);
                        atom.elementSymbol = string2;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block33;
                        float f = this.atomTypes.get(this.field).floatValue();
                        atom.formalCharge = Math.round(f);
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !Logger.debugging) continue block33;
                        Logger.debug("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge);
                        continue block33;
                    }
                    case 1: 
                    case 2: 
                    case 49: {
                        atom.atomName = this.field;
                        continue block33;
                    }
                    case 55: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) continue block33;
                        atom.x = f;
                        continue block33;
                    }
                    case 56: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) continue block33;
                        atom.y = f;
                        continue block33;
                    }
                    case 57: {
                        float f = this.parseFloatStr(this.field);
                        if (!this.readIdeal || Float.isNaN(f)) continue block33;
                        atom.z = f;
                        continue block33;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloatStr(this.field);
                        continue block33;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloatStr(this.field);
                        continue block33;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloatStr(this.field);
                        continue block33;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(this.field);
                        continue block33;
                    }
                    case 9: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block33;
                        atom.foccupancy = f;
                        continue block33;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatStr(this.field) * (this.isPDB ? 1.0f : 100.0f);
                        continue block33;
                    }
                    case 11: 
                    case 48: {
                        atom.group3 = this.field;
                        continue block33;
                    }
                    case 59: {
                        string = this.field;
                        continue block33;
                    }
                    case 12: {
                        atom.chainID = this.vwr.getChainID(this.field);
                        continue block33;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseIntStr(this.field);
                        continue block33;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block33;
                    }
                    case 15: 
                    case 60: {
                        atom.altLoc = this.firstChar;
                        continue block33;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        continue block33;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.altLoc = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block33;
                        }
                        atom.altLoc = this.firstChar;
                        continue block33;
                    }
                    case 16: {
                        this.isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block33;
                        atom.isHetero = true;
                        continue block33;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block33;
                        atom.x = Float.NaN;
                        continue block33;
                    }
                    case 47: 
                    case 62: {
                        int n8;
                        if (!this.field.equalsIgnoreCase("Uiso") || (n8 = this.fieldOf[34]) == -1) continue block33;
                        this.setU(atom, 7, this.parseFloatStr(this.parser.getLoopData(n8)));
                        continue block33;
                    }
                    case 20: {
                        n2 = this.asc.getAtomIndexFromName(this.field);
                        if (n2 < 0) continue block33;
                        atom = this.asc.atoms[n2];
                        continue block33;
                    }
                    case 21: {
                        atom = this.asc.atoms[++n2];
                        continue block33;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.setU(atom, (this.propertyOf[n6] - 22) % 6, this.parseFloatStr(this.field));
                        continue block33;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.setU(atom, 6, 4.0f);
                        this.setU(atom, (this.propertyOf[n6] - 35) % 6, this.parseFloatStr(this.field));
                        continue block33;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.setU(atom, 6, 0.0f);
                        this.setU(atom, (this.propertyOf[n6] - 41) % 6, this.parseFloatStr(this.field));
                        continue block33;
                    }
                    case 61: {
                        if (!this.modulated) continue block33;
                        n4 = this.parseIntStr(this.field);
                    }
                }
            }
            if (bl2) continue;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (!this.filterCIFAtom(atom, n2, string)) continue;
            this.setAtomCoord(atom);
            if (this.pr != null && !this.pr.checkAtom(atom, string, this.ac)) continue;
            if (atom.elementSymbol == null && atom.atomName != null) {
                String string3 = atom.atomName;
                for (n5 = 0; n5 < string3.length() && Character.isLetter(string3.charAt(n5)); ++n5) {
                }
                atom.elementSymbol = n5 == 0 || n5 > 2 ? "Xx" : string3.substring(0, n5);
            }
            this.asc.addAtomWithMappedName(atom);
            ++this.ac;
            if (!this.modulated || n4 == 0) continue;
            atom.vib = V3.new3(n4, 0.0f, Float.NaN);
        }
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.asc.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.isPDBX && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, int n, String string) {
        if (!this.filterAtom(atom, n)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", string)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.altLoc != '\u0000') {
                if (this.conformationIndex >= 0 && atom.altLoc != this.lastAltLoc) {
                    this.lastAltLoc = atom.altLoc;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    private void processCitationListBlock() throws Exception {
        this.parseLoopParameters(citationFields);
        float[] fArray = new float[16];
        fArray[15] = 1.0f;
        while (this.parser.getData()) {
            int n = this.parser.getFieldCount();
            block5: for (int i = 0; i < n; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        this.appendLoadNote("TITLE: " + this.parser.toUnicode(this.field));
                    }
                }
            }
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        this.symops = new List();
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (this.fieldOf[n2] == -1) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.parser.skipLoop();
            return;
        }
        n2 = 0;
        while (this.parser.getData()) {
            boolean bl = false;
            int n3 = this.parser.getFieldCount();
            block7: for (int i = 0; i < n3; ++i) {
                switch (this.fieldProperty(i)) {
                    case 2: {
                        if (this.field.indexOf(126) >= 0) {
                            this.field = PT.rep(this.field, "~", "");
                        }
                    }
                    case 3: {
                        this.modulated = true;
                        bl = true;
                    }
                    case 0: 
                    case 1: {
                        if (!this.allowRotations && ++n2 != 1 || this.modulated && !bl) continue block7;
                        this.symops.addLast(this.field);
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
        if (this.ms != null) {
            this.addLatticeVectors();
        }
    }

    public int getBondOrder(String string) {
        switch (string.charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + string);
            }
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyOf[n] == 3 || this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing property: " + geomBondFields[n]);
            this.parser.skipLoop();
            return;
        }
        String string = null;
        String string2 = null;
        Integer n2 = 1;
        int n3 = 0;
        while (this.parser.getData()) {
            int n4 = -1;
            int n5 = -1;
            float f = 0.0f;
            float f2 = 0.0f;
            int n6 = this.parser.getFieldCount();
            block9: for (int i = 0; i < n6; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block9;
                    }
                    case 0: {
                        string = this.field;
                        n4 = this.asc.getAtomIndexFromName(string);
                        continue block9;
                    }
                    case 1: {
                        string2 = this.field;
                        n5 = this.asc.getAtomIndexFromName(string2);
                        continue block9;
                    }
                    case 2: {
                        f = this.parseFloatStr(this.field);
                        int n7 = this.field.indexOf(40);
                        if (n7 >= 0) {
                            char[] cArray = this.field.toCharArray();
                            String string3 = this.field.substring(n7 + 1, this.field.length() - 1);
                            int n8 = string3.length();
                            int n9 = n7;
                            while (--n9 >= 0) {
                                if (cArray[n9] == '.') {
                                    --n9;
                                }
                                cArray[n9] = --n8 < 0 ? 48 : (int)string3.charAt(n8);
                            }
                            f2 = this.parseFloatStr(String.valueOf(cArray));
                            if (!Float.isNaN(f2)) continue block9;
                            Logger.info("error reading uncertainty for " + this.line);
                            f2 = 0.015f;
                            continue block9;
                        }
                        f2 = 0.015f;
                        continue block9;
                    }
                    case 3: {
                        n2 = this.getBondOrder(this.field);
                    }
                }
            }
            if (n4 < 0 || n5 < 0 || f == 0.0f) continue;
            ++n3;
            this.bondTypes.addLast(new Object[]{string, string2, Float.valueOf(f), Float.valueOf(f2), n2});
        }
        if (n3 > 0) {
            Logger.info(n3 + " bonds read");
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.doApplySymmetry = true;
                this.latticeCells[2] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[0] = 1;
            }
        }
    }

    private void setBondingAndMolecules() {
        int n;
        int n2;
        Logger.info("CIF creating molecule " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.atoms = this.asc.atoms;
        this.firstAtom = this.asc.getLastAtomSetAtomIndex();
        int n3 = this.asc.getLastAtomSetAtomCount();
        this.ac = this.firstAtom + n3;
        this.bsSets = new BS[n3];
        this.symmetry = this.asc.getSymmetry();
        for (n2 = this.firstAtom; n2 < this.ac; ++n2) {
            n = this.asc.getAtomIndexFromName(this.atoms[n2].atomName) - this.firstAtom;
            if (this.bsSets[n] == null) {
                this.bsSets[n] = new BS();
            }
            this.bsSets[n].set(n2 - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.ac];
            for (n2 = this.firstAtom; n2 < this.ac; ++n2) {
                int n4;
                n = JmolAdapter.getElementNumber(this.atoms[n2].getElementSymbol());
                this.atoms[n2].elementNumber = (short)n;
                int n5 = n4 = this.atoms[n2].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[n2].formalCharge;
                if (n <= 0) continue;
                this.atomRadius[n2] = JmolAdapter.getBondingRadius(n, n4);
            }
            this.bsConnected = new BS[this.ac];
            for (n2 = this.firstAtom; n2 < this.ac; ++n2) {
                this.bsConnected[n2] = new BS();
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        n2 = 1;
        while (this.createBonds(n2 != 0)) {
            n2 = 0;
        }
        if (this.isMolecular) {
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            this.asc.bsAtoms.clearBits(this.firstAtom, this.ac);
            this.asc.bsAtoms.or(this.bsMolecule);
            this.asc.bsAtoms.andNot(this.bsExclude);
            for (n = this.firstAtom; n < this.ac; ++n) {
                if (this.asc.bsAtoms.get(n)) {
                    this.symmetry.toCartesian(this.atoms[n], true);
                    continue;
                }
                if (!Logger.debugging) continue;
                Logger.debug(this.molecularType + " removing " + n + " " + this.atoms[n].atomName + " " + this.atoms[n]);
            }
            this.asc.setAtomSetAuxiliaryInfo("notionalUnitcell", null);
            if (this.nMolecular++ == this.asc.currentAtomSetIndex) {
                this.asc.clearGlobalBoolean(0);
                this.asc.clearGlobalBoolean(1);
                this.asc.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.asc.setAtomSetAuxiliaryInfo("hasBonds", Boolean.TRUE);
        }
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private boolean createBonds(boolean bl) {
        int n;
        BS bS;
        int n2;
        int n3;
        int n4;
        int n5 = this.bondTypes.size();
        while (--n5 >= 0) {
            Object[] objectArray = (Object[])this.bondTypes.get(n5);
            float f = ((Float)objectArray[2]).floatValue();
            float f2 = ((Float)objectArray[3]).floatValue();
            n4 = (Integer)objectArray[4];
            n3 = this.asc.getAtomIndexFromName((String)objectArray[0]);
            n2 = this.asc.getAtomIndexFromName((String)objectArray[1]);
            BS bS2 = this.bsSets[n3 - this.firstAtom];
            bS = this.bsSets[n2 - this.firstAtom];
            if (bS2 == null || bS == null) continue;
            n = bS2.nextSetBit(0);
            while (n >= 0) {
                int n6 = bS.nextSetBit(0);
                while (n6 >= 0) {
                    if (!(this.isMolecular && this.bsConnected[n + this.firstAtom].get(n6) || !this.symmetry.checkDistance(this.atoms[n + this.firstAtom], this.atoms[n6 + this.firstAtom], f, f2, 0, 0, 0, this.ptOffset))) {
                        this.addNewBond(n + this.firstAtom, n6 + this.firstAtom, n4);
                    }
                    n6 = bS.nextSetBit(n6 + 1);
                }
                n = bS2.nextSetBit(n + 1);
            }
        }
        if (this.bondTypes.size() > 0) {
            for (n5 = this.firstAtom; n5 < this.ac; ++n5) {
                if (this.atoms[n5].elementNumber != 1) continue;
                boolean bl2 = this.atoms[n5].altLoc != '\u0000';
                for (int i = this.firstAtom; i < this.ac; ++i) {
                    if (i == n5 || this.atoms[i].elementNumber == 1 || bl2 && this.atoms[i].altLoc != '\u0000' && this.atoms[i].altLoc != this.atoms[n5].altLoc || this.bsConnected[n5].get(i) || !this.symmetry.checkDistance(this.atoms[n5], this.atoms[i], 1.1f, 0.0f, 0, 0, 0, this.ptOffset)) continue;
                    this.addNewBond(n5, i, 1);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (bl) {
            for (n5 = this.firstAtom; n5 < this.ac; ++n5) {
                if (this.atoms[n5].atomSite + this.firstAtom != n5 || this.bsMolecule.get(n5)) continue;
                this.setBs(this.atoms, n5, this.bsConnected, this.bsMolecule);
            }
        }
        float f = this.vwr.getFloat(0x22000004);
        BS bS3 = new BS();
        P3 p3 = new P3();
        P3 p32 = new P3();
        n4 = 2;
        for (n3 = this.firstAtom; n3 < this.ac; ++n3) {
            if (this.bsMolecule.get(n3) || this.bsExclude.get(n3)) continue;
            n2 = this.bsMolecule.nextSetBit(0);
            while (n2 >= 0) {
                if (this.symmetry.checkDistance(this.atoms[n2], this.atoms[n3], this.atomRadius[n3] + this.atomRadius[n2] + f, 0.0f, n4, n4, n4, this.ptOffset)) {
                    this.setBs(this.atoms, n3, this.bsConnected, bS3);
                    int n7 = bS3.nextSetBit(0);
                    while (n7 >= 0) {
                        this.atoms[n7].add(this.ptOffset);
                        p3.setT(this.atoms[n7]);
                        this.symmetry.toCartesian(p3, true);
                        bS = this.bsSets[this.asc.getAtomIndexFromName(this.atoms[n7].atomName) - this.firstAtom];
                        if (bS != null) {
                            n = bS.nextSetBit(0);
                            while (n >= 0) {
                                if (n + this.firstAtom != n7) {
                                    p32.setT(this.atoms[n + this.firstAtom]);
                                    this.symmetry.toCartesian(p32, true);
                                    if (p32.distance(p3) < 0.1f) {
                                        this.bsExclude.set(n7);
                                        break;
                                    }
                                }
                                n = bS.nextSetBit(n + 1);
                            }
                        }
                        this.bsMolecule.set(n7);
                        n7 = bS3.nextSetBit(n7 + 1);
                    }
                    return true;
                }
                n2 = this.bsMolecule.nextSetBit(n2 + 1);
            }
        }
        return false;
    }

    private void addNewBond(int n, int n2, int n3) {
        this.asc.addNewBondWithOrder(n, n2, n3);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[n].set(n2);
        this.bsConnected[n2].set(n);
    }

    private void setBs(Atom[] atomArray, int n, BS[] bSArray, BS bS) {
        BS bS2 = bSArray[n];
        bS.set(n);
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bS.get(n2)) {
                this.setBs(atomArray, n2, bSArray, bS);
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }
}

