/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.P3;

public class Matrix
implements Cloneable {
    protected double[][] a;
    protected int m;
    protected int n;

    public Matrix(double[][] dArray, int n, int n2) {
        this.a = dArray == null ? new double[n][n2] : dArray;
        this.m = n;
        this.n = n2;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double[][] getArray() {
        return this.a;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        int n = this.m;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                dArray[n][n2] = this.a[n][n2];
            }
        }
        return dArray;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(null, this.m, this.n);
        double[][] dArray = matrix.a;
        int n = this.m;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                dArray[n][n2] = this.a[n][n2];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public Matrix getSubmatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(null, n3, n4);
        double[][] dArray = matrix.a;
        int n5 = n3;
        while (--n5 >= 0) {
            int n6 = n4;
            while (--n6 >= 0) {
                dArray[n5][n6] = this.a[n + n5][n2 + n6];
            }
        }
        return matrix;
    }

    public Matrix getMatrixSelected(int[] nArray, int n) {
        Matrix matrix = new Matrix(null, nArray.length, n);
        double[][] dArray = matrix.a;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            double[] dArray2 = this.a[nArray[n2]];
            int n3 = n;
            while (--n3 >= 0) {
                dArray[n2][n3] = dArray2[n3];
            }
        }
        return matrix;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(null, this.n, this.m);
        double[][] dArray = matrix.a;
        int n = this.m;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                dArray[n2][n] = this.a[n][n2];
            }
        }
        return matrix;
    }

    public Matrix add(Matrix matrix) {
        return this.scaleAdd(matrix, 1.0);
    }

    public Matrix sub(Matrix matrix) {
        return this.scaleAdd(matrix, -1.0);
    }

    public Matrix scaleAdd(Matrix matrix, double d) {
        Matrix matrix2 = new Matrix(null, this.m, this.n);
        double[][] dArray = matrix2.a;
        double[][] dArray2 = matrix.a;
        int n = this.m;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                dArray[n][n2] = dArray2[n][n2] * d + this.a[n][n2];
            }
        }
        return matrix2;
    }

    public Matrix mul(Matrix matrix) {
        if (matrix.m != this.n) {
            return null;
        }
        Matrix matrix2 = new Matrix(null, this.m, matrix.n);
        double[][] dArray = matrix2.a;
        double[][] dArray2 = matrix.a;
        int n = matrix.n;
        while (--n >= 0) {
            int n2 = this.m;
            while (--n2 >= 0) {
                double[] dArray3 = this.a[n2];
                double d = 0.0;
                int n3 = this.n;
                while (--n3 >= 0) {
                    d += dArray3[n3] * dArray2[n3][n];
                }
                dArray[n2][n] = d;
            }
        }
        return matrix2;
    }

    public Matrix inverse() {
        return new LUDecomp(this.m, this.n).solve(Matrix.identity(this.m, this.m), this.n);
    }

    public double trace() {
        double d = 0.0;
        int n = Math.min(this.m, this.n);
        while (--n >= 0) {
            d += this.a[n][n];
        }
        return d;
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(null, n, n2);
        double[][] dArray = matrix.a;
        int n3 = Math.min(n, n2);
        while (--n3 >= 0) {
            dArray[n3][n3] = 1.0;
        }
        return matrix;
    }

    public Matrix getRotation() {
        return this.getSubmatrix(0, 0, this.m - 1, this.n - 1);
    }

    public Matrix getTranslation() {
        return this.getSubmatrix(0, this.n - 1, this.m - 1, 1);
    }

    public static Matrix newT(P3 p3, boolean bl) {
        return bl ? new Matrix(new double[][]{{p3.x}, {p3.y}, {p3.z}}, 3, 1) : new Matrix(new double[][]{{p3.x, p3.y, p3.z}}, 1, 3);
    }

    public String toString() {
        String string = "[\n";
        for (int i = 0; i < this.m; ++i) {
            string = string + "  [";
            for (int j = 0; j < this.n; ++j) {
                string = string + " " + this.a[i][j];
            }
            string = string + "]\n";
        }
        string = string + "]";
        return string;
    }

    private class LUDecomp {
        private double[][] LU;
        private int[] piv;
        private int pivsign;

        protected LUDecomp(int n, int n2) {
            this.LU = Matrix.this.getArrayCopy();
            this.piv = new int[n];
            int n3 = n;
            while (--n3 >= 0) {
                this.piv[n3] = n3;
            }
            this.pivsign = 1;
            double[] dArray = new double[n];
            for (int i = 0; i < n2; ++i) {
                double d;
                int n4;
                int n5 = n;
                while (--n5 >= 0) {
                    dArray[n5] = this.LU[n5][i];
                }
                n5 = n;
                while (--n5 >= 0) {
                    double[] dArray2 = this.LU[n5];
                    n4 = Math.min(n5, i);
                    d = 0.0;
                    int n6 = n4;
                    while (--n6 >= 0) {
                        d += dArray2[n6] * dArray[n6];
                    }
                    int n7 = n5;
                    double d2 = dArray[n7] - d;
                    dArray[n7] = d2;
                    dArray2[i] = d2;
                }
                n5 = i;
                n4 = n;
                while (--n4 > i) {
                    if (!(Math.abs(dArray[n4]) > Math.abs(dArray[n5]))) continue;
                    n5 = n4;
                }
                if (n5 != i) {
                    n4 = n2;
                    while (--n4 >= 0) {
                        d = this.LU[n5][n4];
                        this.LU[n5][n4] = this.LU[i][n4];
                        this.LU[i][n4] = d;
                    }
                    n4 = this.piv[n5];
                    this.piv[n5] = this.piv[i];
                    this.piv[i] = n4;
                    this.pivsign = -this.pivsign;
                }
                if (!(i < n & this.LU[i][i] != 0.0)) continue;
                n4 = n;
                while (--n4 > i) {
                    double[] dArray3 = this.LU[n4];
                    int n8 = i;
                    dArray3[n8] = dArray3[n8] / this.LU[i][i];
                }
            }
        }

        protected Matrix solve(Matrix matrix, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                if (this.LU[n5][n5] != 0.0) continue;
                return null;
            }
            n5 = matrix.n;
            Matrix matrix2 = matrix.getMatrixSelected(this.piv, n5);
            double[][] dArray = matrix2.a;
            for (n4 = 0; n4 < n; ++n4) {
                for (n3 = n4 + 1; n3 < n; ++n3) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        double[] dArray2 = dArray[n3];
                        int n6 = n2;
                        dArray2[n6] = dArray2[n6] - dArray[n4][n2] * this.LU[n3][n4];
                    }
                }
            }
            n4 = n;
            while (--n4 >= 0) {
                n3 = n5;
                while (--n3 >= 0) {
                    double[] dArray3 = dArray[n4];
                    int n7 = n3;
                    dArray3[n7] = dArray3[n7] / this.LU[n4][n4];
                }
                n3 = n4;
                while (--n3 >= 0) {
                    n2 = n5;
                    while (--n2 >= 0) {
                        double[] dArray4 = dArray[n3];
                        int n8 = n2;
                        dArray4[n8] = dArray4[n8] - dArray[n4][n2] * this.LU[n3][n4];
                    }
                }
            }
            return matrix2;
        }
    }
}

