/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class XplorReader
extends MapFileReader {
    private int nBlock;
    private int linePt = Integer.MAX_VALUE;
    private int nRead;

    XplorReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2MFR(surfaceGenerator, bufferedReader);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        int n;
        this.jvxlFileHeaderBuffer = new SB();
        int n2 = n = this.parseIntStr(this.getLine());
        while (--n2 >= 0) {
            this.line = this.br.readLine().trim();
            Logger.info((String)("XplorReader: " + this.line));
            this.jvxlFileHeaderBuffer.append("# ").append(this.line).appendC('\n');
        }
        this.jvxlFileHeaderBuffer.append("Xplor data\nJmol " + Viewer.getJmolVersion() + '\n');
        this.na = this.parseIntStr(this.getLine());
        this.nxyzStart[0] = this.parseInt();
        this.nx = this.parseInt() - this.nxyzStart[0] + 1;
        this.nb = this.parseInt();
        this.nxyzStart[1] = this.parseInt();
        this.ny = this.parseInt() - this.nxyzStart[1] + 1;
        this.nc = this.parseInt();
        this.nxyzStart[2] = this.parseInt();
        this.nz = this.parseInt() - this.nxyzStart[2] + 1;
        this.a = this.parseFloatStr(this.getLine());
        this.b = this.parseFloat();
        this.c = this.parseFloat();
        this.alpha = this.parseFloat();
        this.beta = this.parseFloat();
        this.gamma = this.parseFloat();
        this.getLine();
        this.maps = 3;
        this.mapr = 2;
        this.mapc = 1;
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
        this.nBlock = this.voxelCounts[2] * this.voxelCounts[1];
    }

    private String getLine() throws Exception {
        this.readLine();
        while (this.line != null && (this.line.length() == 0 || this.line.indexOf("REMARKS") >= 0 || this.line.indexOf("XPLOR:") >= 0)) {
            this.readLine();
        }
        return this.line;
    }

    @Override
    protected float nextVoxel() throws Exception {
        if (this.linePt >= this.line.length()) {
            this.readLine();
            this.linePt = 0;
            if (this.nRead % this.nBlock == 0) {
                this.readLine();
            }
        }
        if (this.line == null) {
            return 0.0f;
        }
        float f = this.parseFloatRange(this.line, this.linePt, this.linePt + 12);
        this.linePt += 12;
        ++this.nRead;
        return f;
    }
}

