/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Ellipsoid;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Tensor;
import org.jmol.util.Txt;

public class Ellipsoids
extends Shape {
    private static final String PROPERTY_MODES = "ax ce co de eq mo on op sc tr";
    public Map<String, Ellipsoid> simpleEllipsoids = new Hashtable<String, Ellipsoid>();
    public Map<Tensor, Ellipsoid> atomEllipsoids = new Hashtable<Tensor, Ellipsoid>();
    private String typeSelected = "1";
    private BS selectedAtoms;
    private List<Ellipsoid> ellipsoidSet;

    public boolean isActive() {
        return !this.atomEllipsoids.isEmpty() || !this.simpleEllipsoids.isEmpty();
    }

    public int getIndexFromName(String string) {
        return this.checkID(string) ? 1 : -1;
    }

    protected void setSize(int n, BS bS) {
        List list;
        boolean bl;
        if (this.ms.at == null || n == 0 && this.ms.atomTensors == null) {
            return;
        }
        boolean bl2 = bl = bS == null;
        if (!bl && this.selectedAtoms != null) {
            bS = this.selectedAtoms;
        }
        if ((list = this.vwr.ms.getAllAtomTensors(this.typeSelected)) == null) {
            return;
        }
        Atom[] atomArray = this.ms.at;
        int n2 = list.size();
        while (--n2 >= 0) {
            boolean bl3;
            Tensor tensor = (Tensor)list.get(n2);
            if (!bl && !tensor.isSelected(bS, -1)) continue;
            Ellipsoid ellipsoid = this.atomEllipsoids.get(tensor);
            boolean bl4 = bl3 = n != 0 && ellipsoid == null;
            if (bl3) {
                ellipsoid = Ellipsoid.getEllipsoidForAtomTensor(tensor, (P3)atomArray[tensor.atomIndex1]);
                this.atomEllipsoids.put(tensor, ellipsoid);
            }
            if (ellipsoid == null || !bl3 && n == Integer.MAX_VALUE) continue;
            ellipsoid.setScale(n, true);
        }
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "checkID") {
            return this.checkID((String)objectArray[0]);
        }
        return false;
    }

    private boolean checkID(String string) {
        Object object;
        this.ellipsoidSet = new List();
        if (string == null) {
            return false;
        }
        if (Txt.isWild((String)(string = string.toLowerCase()))) {
            object = this.simpleEllipsoids.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string2 = ((String)entry.getKey()).toLowerCase();
                if (!Txt.isMatch((String)string2, (String)string, (boolean)true, (boolean)true)) continue;
                this.ellipsoidSet.addLast(entry.getValue());
            }
        }
        if ((object = this.simpleEllipsoids.get(string)) != null) {
            this.ellipsoidSet.addLast(object);
        }
        return this.ellipsoidSet.size() > 0;
    }

    private boolean initEllipsoids(Object object) {
        boolean bl = object != null;
        this.checkID((String)object);
        if (bl) {
            this.typeSelected = null;
        }
        this.selectedAtoms = null;
        return bl;
    }

    public void setProperty(String string, Object object, BS bS) {
        if (string == "thisID") {
            if (this.initEllipsoids(object) && this.ellipsoidSet.size() == 0) {
                String string2 = (String)object;
                Ellipsoid ellipsoid = Ellipsoid.getEmptyEllipsoid(string2, this.vwr.getCurrentModelIndex());
                this.ellipsoidSet.addLast((Object)ellipsoid);
                this.simpleEllipsoids.put(string2, ellipsoid);
            }
            return;
        }
        if ("atoms" == string) {
            this.selectedAtoms = (BS)object;
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Iterator<Ellipsoid> iterator = this.simpleEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().tensor.modelIndex != n) continue;
                iterator.remove();
            }
            iterator = this.atomEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().modelIndex != n) continue;
                iterator.remove();
            }
            this.ellipsoidSet.clear();
            return;
        }
        int n = PROPERTY_MODES.indexOf((string + "  ").substring(0, 2));
        if (this.ellipsoidSet.size() > 0) {
            if ("translucentLevel" == string) {
                this.setPropS(string, object, bS);
                return;
            }
            if (n >= 0) {
                int n2 = this.ellipsoidSet.size();
                while (--n2 >= 0) {
                    this.setProp((Ellipsoid)this.ellipsoidSet.get(n2), n / 3, object);
                }
            }
            return;
        }
        if ("color" == string) {
            short s = C.getColixO((Object)object);
            byte by = PAL.pidOf((Object)object);
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.colix = this.getColixI(s, by, ellipsoid.tensor.atomIndex1);
                ellipsoid.pid = by;
            }
            return;
        }
        if ("on" == string) {
            boolean bl = (Boolean)object;
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            if (bl) {
                this.setSize(Integer.MAX_VALUE, bS);
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                Tensor tensor = ellipsoid.tensor;
                if (!tensor.type.equals(this.typeSelected) && !this.typeSelected.equals(tensor.altType) || !tensor.isSelected(bS, -1)) continue;
                ellipsoid.isOn = bl;
            }
            return;
        }
        if ("options" == string) {
            String string3 = ((String)object).toLowerCase().trim();
            if (string3.length() == 0) {
                string3 = null;
            }
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            if (string3 != null) {
                this.setSize(Integer.MAX_VALUE, bS);
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.options = string3;
            }
            return;
        }
        if ("params" == string) {
            Object[] objectArray = (Object[])object;
            objectArray[2] = null;
            this.typeSelected = "0";
            this.setSize(50, bS);
        }
        if ("points" == string) {
            return;
        }
        if ("scale" == string) {
            this.setSize((int)(((Float)object).floatValue() * 100.0f), bS);
            return;
        }
        if ("select" == string) {
            this.typeSelected = ((String)object).toLowerCase();
            return;
        }
        if ("translucency" == string) {
            boolean bl = object.equals("translucent");
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.colix = C.getColixTranslucent3((short)ellipsoid.colix, (boolean)bl, (float)this.translucentLevel);
            }
            return;
        }
        this.setPropS(string, object, bS);
    }

    private void setProp(Ellipsoid ellipsoid, int n, Object object) {
        switch (n) {
            case 0: {
                ellipsoid.setAxes((V3[])object);
                return;
            }
            case 1: {
                ellipsoid.setCenter((P3)object);
                return;
            }
            case 2: {
                ellipsoid.colix = C.getColixO((Object)object);
                return;
            }
            case 3: {
                this.simpleEllipsoids.remove(ellipsoid.id);
                return;
            }
            case 4: {
                ellipsoid.setEquation((double[])object);
                return;
            }
            case 5: {
                ellipsoid.tensor.modelIndex = (Integer)object;
                return;
            }
            case 6: {
                ellipsoid.isOn = (Boolean)object;
                return;
            }
            case 7: {
                ellipsoid.options = ((String)object).toLowerCase();
                return;
            }
            case 8: {
                ellipsoid.setScale(((Float)object).floatValue(), false);
                return;
            }
            case 9: {
                ellipsoid.colix = C.getColixTranslucent3((short)ellipsoid.colix, (boolean)object.equals("translucent"), (float)this.translucentLevel);
                return;
            }
        }
    }

    public String getShapeState() {
        if (!this.isActive()) {
            return "";
        }
        SB sB = new SB();
        sB.append("\n");
        if (!this.simpleEllipsoids.isEmpty()) {
            this.getStateID(sB);
        }
        if (!this.atomEllipsoids.isEmpty()) {
            this.getStateAtoms(sB);
        }
        return sB.toString();
    }

    private void getStateID(SB sB) {
        V3 v3 = new V3();
        for (Ellipsoid ellipsoid : this.simpleEllipsoids.values()) {
            Tensor tensor = ellipsoid.tensor;
            if (!ellipsoid.isValid || tensor == null) continue;
            sB.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").appendI(tensor.modelIndex).append(" center ").append(Escape.eP((T3)ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                v3.setT((T3)tensor.eigenVectors[i]);
                v3.scale(ellipsoid.lengths[i]);
                sB.append(" ").append(Escape.eP((T3)v3));
            }
            sB.append(" " + Ellipsoids.getColorCommandUnk((String)"", (short)ellipsoid.colix, (boolean)this.translucentAllowed));
            if (ellipsoid.options != null) {
                sB.append(" options ").append(PT.esc((String)ellipsoid.options));
            }
            if (!ellipsoid.isOn) {
                sB.append(" off");
            }
            sB.append(";\n");
        }
    }

    private void getStateAtoms(SB sB) {
        BS bS = new BS();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
            int n = ellipsoid.tensor.iType;
            if (bS.get(n + 1)) continue;
            bS.set(n + 1);
            boolean bl = ellipsoid.tensor.iType == 1;
            String string = bl ? null : "Ellipsoids set " + PT.esc((String)ellipsoid.tensor.type);
            for (Ellipsoid ellipsoid2 : this.atomEllipsoids.values()) {
                if (ellipsoid2.tensor.iType != n || bl && !ellipsoid2.isOn) continue;
                int n2 = ellipsoid2.tensor.atomIndex1;
                BSUtil.setMapBitSet(hashtable, (int)n2, (int)n2, (String)(bl ? "Ellipsoids " + ellipsoid2.percent : string + " scale " + ellipsoid2.scale + (ellipsoid2.options == null ? "" : " options " + PT.esc((String)ellipsoid2.options)) + (ellipsoid2.isOn ? " ON" : " OFF")));
                if (ellipsoid2.colix == 0) continue;
                BSUtil.setMapBitSet(hashtable2, (int)n2, (int)n2, (String)Ellipsoids.getColorCommand((String)string, (byte)ellipsoid2.pid, (short)ellipsoid2.colix, (boolean)this.translucentAllowed));
            }
        }
        sB.append(this.vwr.getCommands(hashtable, hashtable2, "select"));
    }

    public void setVisibilityFlags(BS bS) {
        if (!this.isActive()) {
            return;
        }
        Atom[] atomArray = this.vwr.ms.at;
        this.setVis(this.simpleEllipsoids, bS, atomArray);
        if (this.atomEllipsoids != null) {
            int n = atomArray.length;
            while (--n >= 0) {
                atomArray[n].setShapeVisibility(this.vf, false);
            }
        }
        this.setVis(this.atomEllipsoids, bS, atomArray);
    }

    private void setVis(Map<?, Ellipsoid> map, BS bS, Atom[] atomArray) {
        for (Ellipsoid ellipsoid : map.values()) {
            boolean bl;
            Tensor tensor = ellipsoid.tensor;
            boolean bl2 = bl = tensor != null && ellipsoid.isValid && ellipsoid.isOn;
            if (bl && tensor.atomIndex1 >= 0) {
                if (tensor.iType == 1) {
                    boolean bl3 = tensor.isModulated;
                    boolean bl4 = tensor.isUnmodulated;
                    boolean bl5 = this.ms.isModulated(tensor.atomIndex1);
                    bl = !bl3 && !bl4 || bl3 == bl5;
                }
                atomArray[tensor.atomIndex1].setShapeVisibility(this.vf, true);
            }
            ellipsoid.visible = bl && (ellipsoid.modelIndex < 0 || bS.get(ellipsoid.modelIndex));
        }
    }

    public void setModelClickability() {
        if (this.atomEllipsoids.isEmpty()) {
            return;
        }
        for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
            int n = ellipsoid.tensor.atomIndex1;
            Atom atom = this.ms.at[n];
            if ((atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(n)) continue;
            atom.setClickable(this.vf);
        }
    }
}

