/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Vectors;
import org.jmol.util.Vibration;

public class VectorsRenderer
extends ShapeRenderer {
    private static final float arrowHeadOffset = -0.2f;
    private final P3 pointVectorEnd = new P3();
    private final P3 pointArrowHead = new P3();
    private final P3i screenVectorEnd = new P3i();
    private final P3i screenArrowHead = new P3i();
    private final V3 headOffsetVector = new V3();
    private int diameter;
    private int headWidthPixels;
    private float vectorScale;
    private boolean vectorSymmetry;
    private float headScale;
    private boolean doShaft;
    private Vibration vibTemp;

    protected boolean render() {
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return false;
        }
        short[] sArray = vectors.mads;
        if (sArray == null) {
            return false;
        }
        Atom[] atomArray = vectors.atoms;
        short[] sArray2 = vectors.colixes;
        boolean bl = false;
        this.vectorScale = this.vwr.getFloat(1649410049);
        this.vectorSymmetry = this.vwr.getBoolean(603979973);
        int n = this.ms.getAtomCount();
        while (--n >= 0) {
            Vibration vibration;
            Atom atom = atomArray[n];
            if (!this.isVisibleForMe(atom) || (vibration = this.vwr.getVibration(n)) == null || !this.transform(sArray[n], atom, vibration)) continue;
            if (!this.g3d.setColix(Shape.getColix((short[])sArray2, (int)n, (Atom)atom))) {
                bl = true;
                continue;
            }
            this.renderVector(atom);
            if (!this.vectorSymmetry) continue;
            if (this.vibTemp == null) {
                this.vibTemp = new Vibration();
            }
            this.vibTemp.setT((T3)vibration);
            this.vibTemp.scale(-1.0f);
            this.transform(sArray[n], atom, this.vibTemp);
            this.renderVector(atom);
        }
        return bl;
    }

    private boolean transform(short s, Atom atom, Vibration vibration) {
        float f = vibration.length();
        if ((double)Math.abs(f * this.vectorScale) < 0.01) {
            return false;
        }
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        this.doShaft = 0.1 + (double)Math.abs(this.headScale / f) < (double)Math.abs(this.vectorScale);
        this.headOffsetVector.setT((T3)vibration);
        this.headOffsetVector.scale(this.headScale / f);
        this.pointVectorEnd.scaleAdd2(this.vectorScale, (T3)vibration, (T3)atom);
        this.pointArrowHead.add2((T3)this.pointVectorEnd, (T3)this.headOffsetVector);
        this.screenArrowHead.setT((T3i)this.vwr.transformPtVib(this.pointArrowHead, vibration));
        this.screenVectorEnd.setT((T3i)this.vwr.transformPtVib(this.pointVectorEnd, vibration));
        this.diameter = (int)(s < 1 ? 1.0f : (s <= 20 ? (float)s : this.vwr.scaleToScreen(this.screenVectorEnd.z, (int)s)));
        this.headWidthPixels = this.diameter << 1;
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    private void renderVector(Atom atom) {
        if (this.doShaft) {
            this.g3d.fillCylinderScreen((byte)1, this.diameter, atom.sX, atom.sY, atom.sZ, this.screenArrowHead.x, this.screenArrowHead.y, this.screenArrowHead.z);
        }
        this.g3d.fillConeScreen((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd, false);
    }
}

