/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.List;
import org.jmol.minimize.forcefield.Calculation;

class MMFFESCalc
extends Calculation {
    private static final double BUFF = 0.05;

    MMFFESCalc() {
    }

    @Override
    void setData(List<Object[]> list, int n, int n2, double d) {
        if (this.calcs.minAtoms[n].partialCharge == 0.0 || this.calcs.minAtoms[n2].partialCharge == 0.0) {
            return;
        }
        list.addLast((Object)new Object[]{new int[]{n, n2}, new double[]{this.calcs.minAtoms[n].partialCharge, this.calcs.minAtoms[n2].partialCharge, this.calcs.minAtoms[n].bs14.get(n2) ? 249.0537 : 332.0716}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        double d = this.dData[0] * this.dData[1] * this.dData[2];
        this.calcs.setPairVariables(this);
        double d2 = this.rab + 0.05;
        this.energy = d / d2;
        if (this.calcs.gradients) {
            this.dE = -this.energy / d2;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging && Math.abs(this.energy) > 20.0) {
            this.calcs.appendLogData(this.calcs.getDebugLine(6, this));
        }
        return this.energy;
    }
}

