/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.java.BS;
import org.jmol.modelset.ModelSet;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Rectangle;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class RepaintManager
implements JmolRepaintManager {
    private Viewer vwr;
    private ShapeManager shapeManager;
    private ShapeRenderer[] renderers;
    private final BS bsTranslucent = BS.newN(36);
    public int holdRepaint = 0;
    private boolean repaintPending;

    @Override
    public void set(Viewer viewer, ShapeManager shapeManager) {
        this.vwr = viewer;
        this.shapeManager = shapeManager;
    }

    @Override
    public boolean isRepaintPending() {
        return this.repaintPending;
    }

    @Override
    public void pushHoldRepaint(String string) {
        ++this.holdRepaint;
    }

    @Override
    public void popHoldRepaint(boolean bl, String string) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (bl) {
                this.repaintPending = true;
                this.repaintNow(string);
            }
        }
    }

    @Override
    public synchronized void requestRepaintAndWait(String string) {
        try {
            this.repaintNow(string);
            this.wait(this.vwr.g.repaintWaitMs);
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean repaintIfReady(String string) {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.repaintNow(string);
        }
        return true;
    }

    private void repaintNow(String string) {
        if (!this.vwr.haveDisplay) {
            return;
        }
        this.vwr.apiPlatform.repaint(this.vwr.getDisplay());
    }

    @Override
    public synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    @Override
    public void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            for (int i = 0; i < 36; ++i) {
                this.renderers[i] = null;
            }
        }
    }

    private ShapeRenderer getRenderer(int n) {
        if (this.renderers[n] != null) {
            return this.renderers[n];
        }
        String string = JC.getShapeClassName(n, true) + "Renderer";
        ShapeRenderer shapeRenderer = (ShapeRenderer)Interface.getInterface(string);
        if (shapeRenderer == null) {
            return null;
        }
        shapeRenderer.setViewerG3dShapeID(this.vwr, n);
        this.renderers[n] = shapeRenderer;
        return this.renderers[n];
    }

    @Override
    public void render(GData gData, ModelSet modelSet, boolean bl, int[] nArray) {
        boolean bl2 = this.vwr.getBoolean(603979934);
        try {
            Object object;
            JmolRendererInterface jmolRendererInterface = (JmolRendererInterface)((Object)gData);
            jmolRendererInterface.renderBackground(null);
            if (bl) {
                this.bsTranslucent.clearAll();
                if (nArray != null) {
                    jmolRendererInterface.renderCrossHairs(nArray, this.vwr.getScreenWidth(), this.vwr.getScreenHeight(), this.vwr.getNavigationOffset(), this.vwr.getNavigationDepthPercent());
                }
                if ((object = this.vwr.getRubberBandSelection()) != null && jmolRendererInterface.setColix(this.vwr.getColixRubberband())) {
                    jmolRendererInterface.drawRect(((Rectangle)object).x, ((Rectangle)object).y, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
                }
            }
            if (this.renderers == null) {
                this.renderers = new ShapeRenderer[36];
            }
            object = null;
            for (int i = 0; i < 36 && jmolRendererInterface.currentlyRendering(); ++i) {
                Shape shape = this.shapeManager.getShape(i);
                if (shape == null) continue;
                if (bl2) {
                    object = "rendering " + JC.getShapeClassName(i, false);
                    Logger.startTimer((String)object);
                }
                if ((bl || this.bsTranslucent.get(i)) && this.getRenderer(i).renderShape(jmolRendererInterface, modelSet, shape)) {
                    this.bsTranslucent.set(i);
                }
                if (!bl2) continue;
                Logger.checkTimer((String)object, false);
            }
            jmolRendererInterface.renderAllStrings(null);
        }
        catch (Exception exception) {
            if (!this.vwr.isJS) {
                exception.printStackTrace();
            }
            Logger.error("rendering error? " + exception);
        }
    }

    @Override
    public String renderExport(GData gData, ModelSet modelSet, Map<String, Object> map) {
        boolean bl;
        boolean bl2 = this.vwr.getBoolean(603979934);
        this.vwr.finalizeTransformParameters();
        this.shapeManager.finalizeAtoms(null, null);
        JmolRendererInterface jmolRendererInterface = this.vwr.initializeExporter(map);
        boolean bl3 = bl = jmolRendererInterface != null;
        if (!bl) {
            Logger.error("Cannot export " + map.get("type"));
            return null;
        }
        jmolRendererInterface.renderBackground(jmolRendererInterface);
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[36];
        }
        String string = null;
        for (int i = 0; i < 36; ++i) {
            Shape shape = this.shapeManager.getShape(i);
            if (shape == null) continue;
            if (bl2) {
                string = "rendering " + JC.getShapeClassName(i, false);
                Logger.startTimer(string);
            }
            this.getRenderer(i).renderShape(jmolRendererInterface, modelSet, shape);
            if (!bl2) continue;
            Logger.checkTimer(string, false);
        }
        jmolRendererInterface.renderAllStrings(jmolRendererInterface);
        return jmolRendererInterface.finalizeOutput();
    }
}

