/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Text;
import org.jmol.render.LabelsRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Echo;
import org.jmol.util.C;

public class EchoRenderer
extends LabelsRenderer {
    @Override
    protected boolean render() {
        if (this.vwr.isPreviewOnly()) {
            return false;
        }
        Echo echo = (Echo)this.shape;
        float f = this.vwr.getBoolean(603979845) ? this.vwr.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        this.imageFontScaling = this.vwr.getImageFontScaling();
        boolean bl = false;
        Object object = echo.objects.values().iterator();
        while (object.hasNext()) {
            Text text = (Text)object.next();
            if (!text.visible || text.hidden || text.pointerPt instanceof Atom && !((Atom)text.pointerPt).checkVisible()) continue;
            if (text.valign == 4) {
                this.vwr.transformPtScr(text.xyz, this.pt0i);
                text.setXYZs(this.pt0i.x, this.pt0i.y, this.pt0i.z, this.pt0i.z);
            } else if (text.movableZPercent != Integer.MAX_VALUE) {
                int n = this.vwr.zValueFromPercent(text.movableZPercent);
                text.setZs(n, n);
            }
            if (text.pointerPt == null) {
                text.pointer = 0;
            } else {
                text.pointer = 1;
                this.vwr.transformPtScr(text.pointerPt, this.pt0i);
                text.atomX = this.pt0i.x;
                text.atomY = this.pt0i.y;
                text.atomZ = this.pt0i.z;
                if (text.zSlab == Integer.MIN_VALUE) {
                    text.zSlab = 1;
                }
            }
            TextRenderer.render(text, this.vwr, this.g3d, f, this.imageFontScaling, false, null, this.xy);
            if (!C.isColixTranslucent(text.bgcolix) && !C.isColixTranslucent(text.colix)) continue;
            bl = true;
        }
        if (!this.isExport && (object = this.vwr.getFrameTitle()) != null && ((String)object).length() > 0 && this.g3d.setColix(this.vwr.getColixBackgroundContrast())) {
            if (((String)object).indexOf("%{") >= 0 || ((String)object).indexOf("@{") >= 0) {
                object = this.vwr.formatText((String)object);
            }
            this.renderFrameTitle((String)object);
        }
        return bl;
    }

    private void renderFrameTitle(String string) {
        byte by = this.g3d.getFontFidFS("Serif", 14.0f * this.imageFontScaling);
        this.g3d.setFontFid(by);
        int n = (int)Math.floor((float)(this.vwr.getScreenHeight() * (this.g3d.isAntialiased() ? 2 : 1)) - 10.0f * this.imageFontScaling);
        int n2 = (int)Math.floor(5.0f * this.imageFontScaling);
        this.g3d.drawStringNoSlab(string, null, n2, n, 0, (short)0);
    }
}

