/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.CU;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BNode;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Point3fi;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Atom
extends Point3fi
implements BNode {
    private static final byte VIBRATION_VECTOR_FLAG = 1;
    private static final byte IS_HETERO_FLAG = 2;
    private static final byte FLAG_MASK = 3;
    public static final int RADIUS_MAX = 16;
    public static final float RADIUS_GLOBAL = 16.1f;
    public static short MAD_GLOBAL = (short)32200;
    public char altloc = '\u0000';
    public byte atomID;
    public int atomSite;
    public Group group;
    private float userDefinedVanDerWaalRadius;
    byte valence;
    private short atomicAndIsotopeNumber;
    private BS atomSymmetry;
    private byte formalChargeAndFlags;
    public short madAtom;
    public short colixAtom;
    byte paletteID;
    Bond[] bonds;
    int nBondsDisplayed;
    int nBackbonesDisplayed;
    public int clickabilityFlags;
    public int shapeVisibilityFlags;

    public Atom() {
        this.paletteID = PAL.CPK.id;
        this.nBondsDisplayed = 0;
        this.nBackbonesDisplayed = 0;
    }

    public byte getAtomID() {
        return this.atomID;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setBonds(Bond[] bondArray) {
        this.bonds = bondArray;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public Atom setAtom(int n, int n2, P3 p3, float f, BS bS, int n3, short s, int n4, boolean bl) {
        this.mi = (short)n;
        this.atomSymmetry = bS;
        this.atomSite = n3;
        this.i = n2;
        this.atomicAndIsotopeNumber = s;
        if (bl) {
            this.formalChargeAndFlags = (byte)2;
        }
        if (n4 != 0 && n4 != Integer.MIN_VALUE) {
            this.setFormalCharge(n4);
        }
        this.userDefinedVanDerWaalRadius = f;
        this.setT(p3);
        return this;
    }

    public void setAltLoc(char c) {
        this.altloc = c;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public boolean isCovalentlyBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (!this.bonds[n].isCovalent() || this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, this.nBondsDisplayed > 0);
    }

    public void addDisplayedBackbone(int n, boolean bl) {
        this.nBackbonesDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    void deleteBond(Bond bond) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n] != bond) continue;
                this.deleteBondAt(n);
                return;
            }
        }
    }

    private void deleteBondAt(int n) {
        int n2;
        int n3 = this.bonds.length - 1;
        if (n3 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n3];
        for (n2 = 0; n2 < n; ++n2) {
            bondArray[n2] = this.bonds[n2];
        }
        while (n2 < n3) {
            bondArray[n2] = this.bonds[n2 + 1];
            ++n2;
        }
        this.bonds = bondArray;
    }

    void clearBonds() {
        this.bonds = null;
    }

    @Override
    public int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).i;
    }

    public void setMadAtom(Viewer viewer, RadiusData radiusData) {
        this.madAtom = this.calculateMad(viewer, radiusData);
    }

    public short calculateMad(Viewer viewer, RadiusData radiusData) {
        if (radiusData == null) {
            return 0;
        }
        float f = radiusData.value;
        if (f == 0.0f) {
            return 0;
        }
        switch (radiusData.factorType) {
            case SCREEN: {
                return (short)f;
            }
            case FACTOR: 
            case OFFSET: {
                float f2 = 0.0f;
                switch (radiusData.vdwType) {
                    case TEMP: {
                        float f3 = viewer.getBfactor100Hi();
                        f2 = f3 > 0.0f ? (float)this.getBfactor100() / f3 : 0.0f;
                        break;
                    }
                    case HYDRO: {
                        f2 = Math.abs(this.getHydrophobicity());
                        break;
                    }
                    case BONDING: {
                        f2 = this.getBondingRadius();
                        break;
                    }
                    case ADPMIN: 
                    case ADPMAX: {
                        f2 = this.getADPMinMax(radiusData.vdwType == VDW.ADPMAX);
                        break;
                    }
                    default: {
                        f2 = this.getVanderwaalsRadiusFloat(viewer, radiusData.vdwType);
                    }
                }
                if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
                    f *= f2;
                    break;
                }
                f += f2;
                break;
            }
            case ABSOLUTE: {
                if (f != 16.1f) break;
                return MAD_GLOBAL;
            }
        }
        short s = (short)(f < 0.0f ? f : f * 2000.0f);
        if (s < 0 && f > 0.0f) {
            s = 0;
        }
        return s;
    }

    public float getADPMinMax(boolean bl) {
        Object[] objectArray = this.getTensors();
        if (objectArray == null) {
            return 0.0f;
        }
        Tensor tensor = (Tensor)objectArray[0];
        if (tensor == null || tensor.iType != 1) {
            return 0.0f;
        }
        if (this.group.chain.model.ms.isModulated(this.i) && tensor.isUnmodulated) {
            tensor = (Tensor)objectArray[1];
        }
        return tensor.getFactoredValue(bl ? 2 : 1);
    }

    public Object[] getTensors() {
        return this.group.chain.model.ms.getAtomTensorList(this.i);
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    @Override
    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            if ((bond.order & 0x3FF) == 0 || bond.getOtherAtom(this).isDeleted()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0) continue;
            Atom atom = this.bonds[n2].getOtherAtom(this);
            if (atom.valence < 0 || atom.getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Edge[] getEdges() {
        return this.bonds;
    }

    public void setColixAtom(short s) {
        this.colixAtom = s;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = C.getColixTranslucent3(this.colixAtom, bl, f);
    }

    public boolean isTranslucent() {
        return C.isColixTranslucent(this.colixAtom);
    }

    @Override
    public int getElementNumber() {
        return Elements.getElementNumber(this.atomicAndIsotopeNumber);
    }

    @Override
    public int getIsotopeNumber() {
        return Elements.getIsotopeNumber(this.atomicAndIsotopeNumber);
    }

    @Override
    public int getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || (n & 0x7F) >= Elements.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbolIso(boolean bl) {
        return Elements.elementSymbolFromNumber(bl ? this.atomicAndIsotopeNumber : this.atomicAndIsotopeNumber & 0x7F);
    }

    public String getElementSymbol() {
        return this.getElementSymbolIso(true);
    }

    public char getAlternateLocationID() {
        return this.altloc;
    }

    boolean isAltLoc(String string) {
        if (string == null) {
            return this.altloc == '\u0000';
        }
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '*' || c == '?' && this.altloc != '\u0000' || this.altloc == c;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    public boolean hasVibration() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    public void setFormalCharge(int n) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 3 | (n == Integer.MIN_VALUE ? 0 : (n > 7 ? 7 : (n < -3 ? -3 : n))) << 2);
    }

    void setVibrationVector() {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 1);
    }

    @Override
    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 2;
    }

    public int getOccupancy100() {
        byte[] byArray = this.group.chain.model.ms.occupancies;
        return byArray == null ? 100 : byArray[this.i];
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.model.ms.bfactor100s;
        if (sArray == null) {
            return 0;
        }
        return sArray[this.i];
    }

    private float getHydrophobicity() {
        float[] fArray = this.group.chain.model.ms.hydrophobicities;
        if (fArray == null) {
            return Elements.getHydrophobicity(this.group.getGroupID());
        }
        return fArray[this.i];
    }

    public boolean setRadius(float f) {
        this.userDefinedVanDerWaalRadius = f > 0.0f ? f : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void deleteBonds(BS bS) {
        this.valence = (byte)-1;
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                Bond bond = this.bonds[n];
                bond.getOtherAtom(this).deleteBond(bond);
                bS.set(bond.index);
            }
        }
        this.bonds = null;
    }

    @Override
    public boolean isDeleted() {
        return this.valence < 0;
    }

    public void setValence(int n) {
        if (this.isDeleted()) {
            return;
        }
        this.valence = (byte)(n < 0 ? 0 : (n < 239 ? n : 239));
    }

    @Override
    public int getValence() {
        if (this.isDeleted()) {
            return -1;
        }
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        return n;
    }

    @Override
    public int getImplicitHydrogenCount() {
        return this.group.chain.model.ms.getImplicitHydrogenCount(this, false);
    }

    int getTargetValence() {
        switch (this.getElementNumber()) {
            case 6: 
            case 14: {
                return 4;
            }
            case 5: 
            case 7: 
            case 15: {
                return 3;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 1: 
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -1;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    public float getVanderwaalsRadiusFloat(Viewer viewer, VDW vDW) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)viewer.getVanderwaalsMarType(this.atomicAndIsotopeNumber, this.getVdwType(vDW)) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    private VDW getVdwType(VDW vDW) {
        switch (vDW) {
            case AUTO: {
                vDW = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                break;
            }
            case NOJMOL: {
                vDW = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                if (vDW != VDW.AUTO_JMOL) break;
                vDW = VDW.AUTO_BABEL;
            }
        }
        return vDW;
    }

    public float getBondingRadius() {
        float[] fArray = this.group.chain.model.ms.bondingRadii;
        float f = fArray == null ? 0.0f : fArray[this.i];
        return f == 0.0f ? Elements.getBondingRadius(this.atomicAndIsotopeNumber, this.getFormalCharge()) : f;
    }

    float getVolume(Viewer viewer, VDW vDW) {
        float f;
        float f2 = f = vDW == null ? this.userDefinedVanDerWaalRadius : Float.NaN;
        if (Float.isNaN(f)) {
            f = (float)viewer.getVanderwaalsMarType(this.getElementNumber(), this.getVdwType(vDW)) / 1000.0f;
        }
        double d = 0.0;
        if (this.bonds != null) {
            for (int i = 0; i < this.bonds.length; ++i) {
                float f3;
                float f4;
                if (!this.bonds[i].isCovalent()) continue;
                Atom atom = this.bonds[i].getOtherAtom(this);
                float f5 = f4 = vDW == null ? atom.userDefinedVanDerWaalRadius : Float.NaN;
                if (Float.isNaN(f4)) {
                    f4 = (float)viewer.getVanderwaalsMarType(atom.getElementNumber(), atom.getVdwType(vDW)) / 1000.0f;
                }
                if ((f3 = this.distance(atom)) > f + f4) continue;
                if (f3 + f <= f4) {
                    return 0.0f;
                }
                double d2 = (double)f - (double)(f * f + f3 * f3 - f4 * f4) / (2.0 * (double)f3);
                d -= 1.0471975511965976 * d2 * d2 * ((double)(3.0f * f) - d2);
            }
        }
        return (float)(d + 4.1887902047863905 * (double)f * (double)f * (double)f);
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public int getAtomSite() {
        return this.atomSite;
    }

    public void setAtomSymmetry(BS bS) {
        this.atomSymmetry = bS;
    }

    public BS getAtomSymmetry() {
        return this.atomSymmetry;
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    @Override
    public void getGroupBits(BS bS) {
        this.group.selectAtoms(bS);
    }

    @Override
    public String getAtomName() {
        return this.atomID > 0 ? JC.getSpecialAtomName(this.atomID) : this.group.chain.model.ms.atomNames[this.i];
    }

    @Override
    public String getAtomType() {
        String[] stringArray = this.group.chain.model.ms.atomTypes;
        String string = stringArray == null ? null : stringArray[this.i];
        return string == null ? this.getAtomName() : string;
    }

    public int getAtomNumber() {
        int[] nArray = this.group.chain.model.ms.atomSerials;
        return nArray != null ? nArray[this.i] : this.i;
    }

    public boolean isVisible(int n) {
        return (this.shapeVisibilityFlags & n) == n;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.model.ms.partialCharges;
        return fArray == null ? 0.0f : fArray[this.i];
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.atomSymmetry.get(n3 += n2)) continue;
            return nArray[i];
        }
        return 0;
    }

    public int getCellTranslation(int n, int[] nArray, int n2) {
        int n3 = n2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = 0;
            while (n4 < n2) {
                if (this.atomSymmetry.get(n3) && nArray[i] == n) {
                    return nArray[i];
                }
                ++n4;
                ++n3;
            }
        }
        return 0;
    }

    String getSymmetryOperatorList() {
        String string = "";
        ModelSet modelSet = this.group.chain.model.ms;
        int n = modelSet.getModelSymmetryCount(this.mi);
        if (n == 0 || this.atomSymmetry == null) {
            return "";
        }
        int[] nArray = modelSet.getModelCellRange(this.mi);
        int n2 = n;
        int n3 = nArray == null ? 1 : nArray.length;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.atomSymmetry.get(n2++)) continue;
                string = string + "," + (j + 1) + "" + nArray[i];
            }
        }
        return string.length() == 0 ? "" : string.substring(1);
    }

    @Override
    public int getModelIndex() {
        return this.mi;
    }

    int getMoleculeNumber(boolean bl) {
        return this.group.chain.model.ms.getMoleculeIndex(this.i, bl) + 1;
    }

    private float getFractionalCoord(char c, boolean bl) {
        P3 p3 = this.getFractionalCoordPt(bl);
        return c == 'X' ? p3.x : (c == 'Y' ? p3.y : p3.z);
    }

    private P3 getFractionalCoordPt(boolean bl) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this;
        }
        P3 p3 = P3.newP(this);
        symmetryInterface.toFractional(p3, bl);
        return p3;
    }

    SymmetryInterface getUnitCell() {
        return this.group.chain.model.ms.getUnitCellForAtom(this.i);
    }

    private float getFractionalUnitCoord(char c) {
        P3 p3 = this.getFractionalUnitCoordPt(false);
        return c == 'X' ? p3.x : (c == 'Y' ? p3.y : p3.z);
    }

    P3 getFractionalUnitCoordPt(boolean bl) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this;
        }
        P3 p3 = P3.newP(this);
        if (this.group.chain.model.isJmolDataFrame) {
            symmetryInterface.toFractional(p3, false);
            if (bl) {
                symmetryInterface.toCartesian(p3, false);
            }
        } else {
            symmetryInterface.toUnitCell(p3, null);
            if (!bl) {
                symmetryInterface.toFractional(p3, false);
            }
        }
        return p3;
    }

    float getFractionalUnitDistance(P3 p3, P3 p32, P3 p33) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this.distance(p3);
        }
        p32.setT(this);
        p33.setT(p3);
        if (this.group.chain.model.isJmolDataFrame) {
            symmetryInterface.toFractional(p32, true);
            symmetryInterface.toFractional(p33, true);
        } else {
            symmetryInterface.toUnitCell(p32, null);
            symmetryInterface.toUnitCell(p33, null);
        }
        return p32.distance(p33);
    }

    void setFractionalCoord(int n, float f, boolean bl) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toFractional(this, bl);
        }
        switch (n) {
            case 1112541188: 
            case 1112541191: {
                this.x = f;
                break;
            }
            case 1112541189: 
            case 1112541192: {
                this.y = f;
                break;
            }
            case 1112541190: 
            case 1112541193: {
                this.z = f;
            }
        }
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(this, bl);
        }
    }

    void setFractionalCoordTo(P3 p3, boolean bl) {
        this.setFractionalCoordPt(this, p3, bl);
    }

    public void setFractionalCoordPt(P3 p3, P3 p32, boolean bl) {
        p3.setT(p32);
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(p3, bl && !this.group.chain.model.isJmolDataFrame);
        }
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.sD / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.sX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.sY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.sZ;
        int n12 = atom.sZ;
        int n13 = atom.sD / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.sX - n;
        int n15 = n14 * n14;
        int n16 = atom.sY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    String getInfoXYZ(boolean bl) {
        if (bl) {
            String string = this.getGroup3(true);
            int n = this.getChainID();
            P3 p3 = this.getFractionalCoordPt(true);
            return "Atom: " + (string == null ? this.getElementSymbol() : this.getAtomName()) + " " + this.getAtomNumber() + (string != null && string.length() > 0 ? (this.isHetero() ? " Hetero: " : " Group: ") + string + " " + this.getResno() + (n != 0 && n != 32 ? " Chain: " + this.group.chain.getIDStr() : "") : "") + " Model: " + this.getModelNumber() + " Coordinates: " + this.x + " " + this.y + " " + this.z + (p3 == null ? "" : " Fractional: " + p3.x + " " + p3.y + " " + p3.z);
        }
        return this.getIdentityXYZ(true);
    }

    String getIdentityXYZ(boolean bl) {
        Atom atom = this.group.chain.model.isJmolDataFrame ? this.getFractionalCoordPt(false) : this;
        return this.getIdentity(bl) + " " + atom.x + " " + atom.y + " " + atom.z;
    }

    String getIdentity(boolean bl) {
        SB sB = new SB();
        String string = this.getGroup3(true);
        if (string != null && string.length() > 0) {
            int n;
            sB.append("[");
            sB.append(string);
            sB.append("]");
            String string2 = this.getSeqcodeString();
            if (string2 != null) {
                sB.append(string2);
            }
            if ((n = this.getChainID()) != 0 && n != 32) {
                sB.append(":");
                String string3 = this.getChainIDStr();
                if (n >= 256) {
                    string3 = PT.esc(string3);
                }
                sB.append(string3);
            }
            if (!bl) {
                return sB.toString();
            }
            sB.append(".");
        }
        sB.append(this.getAtomName());
        if (sB.length() == 0) {
            sB.append(this.getElementSymbolIso(false));
            sB.append(" ");
            sB.appendI(this.getAtomNumber());
        }
        if (this.altloc != '\u0000') {
            sB.append("%");
            sB.appendC(this.altloc);
        }
        if (this.group.chain.model.ms.mc > 1) {
            sB.append("/");
            sB.append(this.getModelNumberForLabel());
        }
        sB.append(" #");
        sB.appendI(this.getAtomNumber());
        return sB.toString();
    }

    @Override
    public String getGroup3(boolean bl) {
        String string = this.group.getGroup3();
        return bl || string != null && string.length() > 0 ? string : "UNK";
    }

    @Override
    public String getGroup1(char c) {
        char c2 = this.group.getGroup1();
        return c2 != '\u0000' ? "" + c2 : (c != '\u0000' ? "" + c : "");
    }

    @Override
    public boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    @Override
    public boolean isNucleic() {
        return this.group.isNucleic();
    }

    @Override
    public boolean isDna() {
        return this.group.isDna();
    }

    @Override
    public boolean isRna() {
        return this.group.isRna();
    }

    @Override
    public boolean isPurine() {
        return this.group.isPurine();
    }

    @Override
    public boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.seqcode;
    }

    @Override
    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        return this.checkVisible() && this.clickabilityFlags != 0 && ((this.shapeVisibilityFlags | this.group.shapeVisibilityFlags) & this.clickabilityFlags) != 0;
    }

    public void setClickable(int n) {
        this.clickabilityFlags = n == 0 ? 0 : (this.clickabilityFlags |= n);
    }

    public boolean checkVisible() {
        if (this.isVisible(2)) {
            return this.isVisible(4);
        }
        boolean bl = this.isVisible(9);
        if (bl) {
            int n = this.shapeVisibilityFlags;
            if (this.group.shapeVisibilityFlags != 0 && (this.group.shapeVisibilityFlags != 8192 || this.isLeadAtom())) {
                n |= this.group.shapeVisibilityFlags;
            }
            if ((n &= 0xFFFFFFF6) == 32 && this.clickabilityFlags == 0) {
                n = 0;
            }
            boolean bl2 = bl = n != 0;
            if (bl) {
                this.shapeVisibilityFlags |= 4;
            }
        }
        this.shapeVisibilityFlags |= 2;
        return bl;
    }

    @Override
    public boolean isLeadAtom() {
        return this.group.isLeadAtom(this.i);
    }

    public float getGroupParameter(int n) {
        return this.group.getGroupParameter(n);
    }

    @Override
    public int getChainID() {
        return this.group.chain.chainID;
    }

    @Override
    public String getChainIDStr() {
        return this.group.chain.getIDStr();
    }

    public int getSurfaceDistance100() {
        return this.group.chain.model.ms.getSurfaceDistance100(this.i);
    }

    public V3 getVibrationVector() {
        return this.group.chain.model.ms.getVibration(this.i, false);
    }

    public float getVibrationCoord(char c) {
        return this.group.chain.model.ms.getVibrationCoord(this.i, c);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    public int getPolymerIndexInModel() {
        return this.group.getBioPolymerIndexInModel();
    }

    public int getMonomerIndex() {
        return this.group.getMonomerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.selectedGroupCount;
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    public Chain getChain() {
        return this.group.chain;
    }

    public String getModelNumberForLabel() {
        return this.group.chain.model.ms.getModelNumberForAtomLabel(this.mi);
    }

    public int getModelNumber() {
        return this.group.chain.model.ms.getModelNumber(this.mi) % 1000000;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.model.ms.getModelFileNumber(this.mi);
    }

    @Override
    public String getBioStructureTypeName() {
        return this.getProteinStructureType().getBioStructureTypeName(true);
    }

    public STR getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public STR getProteinStructureSubType() {
        return this.group.getProteinStructureSubType();
    }

    public int getStrucNo() {
        return this.group.getStrucNo();
    }

    public String getStructureId() {
        return this.group.getStructureId();
    }

    public String getProteinStructureTag() {
        return this.group.getProteinStructureTag();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    public String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return this.i;
    }

    public Atom findAromaticNeighbor(int n) {
        if (this.bonds == null) {
            return null;
        }
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || atom.i == n) continue;
            return atom;
        }
        return null;
    }

    public static int atomPropertyInt(Atom atom, int n) {
        switch (n) {
            case 1095763969: {
                return atom.getAtomNumber();
            }
            case 1095761922: {
                return atom.atomID;
            }
            case 1095761923: {
                return atom.i;
            }
            case 1095761924: {
                return atom.getCovalentBondCount();
            }
            case 1095761927: {
                return atom.group.chain.index + 1;
            }
            case 1766856708: {
                return atom.group.chain.model.ms.vwr.getColorArgbOrGray(atom.getColix());
            }
            case 1087375365: 
            case 1095763978: {
                return atom.getElementNumber();
            }
            case 1095761929: {
                return atom.atomicAndIsotopeNumber;
            }
            case 1229984263: {
                return atom.getModelFileIndex() + 1;
            }
            case 1632634891: {
                return atom.getFormalCharge();
            }
            case 1095761932: {
                return atom.getGroupID();
            }
            case 1095761933: {
                return atom.group.getGroupIndex();
            }
            case 1095766030: {
                return atom.getModelNumber();
            }
            case -1095766030: {
                return atom.getModelFileNumber();
            }
            case 1095761935: {
                return atom.mi;
            }
            case 1095761936: {
                return atom.getMoleculeNumber(true);
            }
            case 1129318401: {
                return atom.getOccupancy100();
            }
            case 1095761937: {
                return atom.getGroup().getBioPolymerIndexInModel() + 1;
            }
            case 1095761938: {
                return atom.getPolymerLength();
            }
            case 1666189314: {
                return atom.getRasMolRadius();
            }
            case 1095761939: {
                return atom.getResno();
            }
            case 1095761940: {
                return atom.getAtomSite();
            }
            case 1641025539: {
                return atom.getProteinStructureType().getId();
            }
            case 1238369286: {
                return atom.getProteinStructureSubType().getId();
            }
            case 1095761941: {
                return atom.getStrucNo();
            }
            case 1297090050: {
                return atom.getSymOp();
            }
            case 1095763990: {
                return atom.getValence();
            }
        }
        return 0;
    }

    int getSymOp() {
        return this.atomSymmetry == null ? 0 : this.atomSymmetry.nextSetBit(0) + 1;
    }

    public static float atomPropertyFloat(Viewer viewer, Atom atom, int n) {
        switch (n) {
            case 1112539137: {
                return atom.getADPMinMax(true);
            }
            case 1112539138: {
                return atom.getADPMinMax(false);
            }
            case 1112541185: 
            case 1112541205: {
                return atom.x;
            }
            case 1112541186: 
            case 1112541206: {
                return atom.y;
            }
            case 1112541187: 
            case 1112541207: {
                return atom.z;
            }
            case 1113198595: 
            case 1113198596: 
            case 1113198597: 
            case 1113200642: 
            case 1113200646: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200652: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                return viewer.getAtomShapeValue(n, atom.group, atom.i);
            }
            case 1112541195: {
                return atom.getBondingRadius();
            }
            case 1112539139: {
                return viewer.getNMRCalculation().getChemicalShift(atom);
            }
            case 1112539140: {
                return Elements.getCovalentRadius(atom.atomicAndIsotopeNumber);
            }
            case 1112539141: 
            case 1112539150: 
            case 1112539152: {
                return atom.getGroupParameter(n);
            }
            case 1112541188: {
                return atom.getFractionalCoord('X', true);
            }
            case 1112541189: {
                return atom.getFractionalCoord('Y', true);
            }
            case 1112541190: {
                return atom.getFractionalCoord('Z', true);
            }
            case 1112541191: {
                return atom.getFractionalCoord('X', false);
            }
            case 1112541192: {
                return atom.getFractionalCoord('Y', false);
            }
            case 1112541193: {
                return atom.getFractionalCoord('Z', false);
            }
            case 1114638362: {
                return atom.getHydrophobicity();
            }
            case 1112539142: {
                return viewer.getNMRCalculation().getMagneticShielding(atom);
            }
            case 1112539143: {
                return atom.getMass();
            }
            case 1129318401: {
                return (float)atom.getOccupancy100() / 100.0f;
            }
            case 1112541196: {
                return atom.getPartialCharge();
            }
            case 1112539144: 
            case 1112539145: 
            case 1112539146: {
                if (atom.group.chain.model.isJmolDataFrame && atom.group.chain.model.jmolFrameType.startsWith("plot ramachandran")) {
                    switch (n) {
                        case 1112539145: {
                            return atom.getFractionalCoord('X', false);
                        }
                        case 1112539146: {
                            return atom.getFractionalCoord('Y', false);
                        }
                        case 1112539144: {
                            if (!atom.group.chain.model.isJmolDataFrame || !atom.group.chain.model.jmolFrameType.equals("plot ramachandran")) break;
                            float f = atom.getFractionalCoord('Z', false) - 180.0f;
                            return f < -180.0f ? 360.0f + f : f;
                        }
                    }
                }
                return atom.getGroupParameter(n);
            }
            case 1113200651: 
            case 1666189314: {
                return atom.getRadius();
            }
            case 1112539147: {
                return atom.sX;
            }
            case 1112539148: {
                return atom.group.chain.model.ms.vwr.getScreenHeight() - atom.sY;
            }
            case 1112539149: {
                return atom.sZ;
            }
            case 1114638363: {
                return viewer.isAtomSelected(atom.i) ? 1 : 0;
            }
            case 1112539151: {
                atom.group.chain.model.ms.getSurfaceDistanceMax();
                return (float)atom.getSurfaceDistance100() / 100.0f;
            }
            case 1112541199: {
                return (float)atom.getBfactor100() / 100.0f;
            }
            case 1112539153: {
                return atom.getFractionalUnitCoord('X');
            }
            case 1112539154: {
                return atom.getFractionalUnitCoord('Y');
            }
            case 1112539155: {
                return atom.getFractionalUnitCoord('Z');
            }
            case 1649412120: {
                return atom.getVanderwaalsRadiusFloat(viewer, VDW.AUTO);
            }
            case 1649410049: {
                V3 v3 = atom.getVibrationVector();
                return v3 == null ? 0.0f : v3.length() * viewer.getFloat(1649410049);
            }
            case 1112541202: {
                return atom.getVibrationCoord('X');
            }
            case 1112541203: {
                return atom.getVibrationCoord('Y');
            }
            case 1112541204: {
                return atom.getVibrationCoord('Z');
            }
            case 1313866249: {
                return atom.getVolume(viewer, VDW.AUTO);
            }
        }
        return Atom.atomPropertyInt(atom, n);
    }

    private float getMass() {
        float f = this.getIsotopeNumber();
        return f > 0.0f ? f : Elements.getAtomicMass(this.getElementNumber());
    }

    public static String atomPropertyString(Viewer viewer, Atom atom, int n) {
        switch (n) {
            case 1087373315: {
                char c = atom.altloc;
                return c == '\u0000' ? "" : "" + c;
            }
            case 1087375362: {
                return atom.getAtomName();
            }
            case 1087375361: {
                return atom.getAtomType();
            }
            case 0x40D00004: {
                return atom.getChainIDStr();
            }
            case 1087373320: {
                return atom.getGroup1('?');
            }
            case 1087373319: {
                return atom.getGroup1('\u0000');
            }
            case 1087373318: {
                return atom.getGroup3(false);
            }
            case 1087375365: {
                return atom.getElementSymbolIso(true);
            }
            case 1087373321: {
                return atom.getIdentity(true);
            }
            case 1087373322: {
                char c = atom.getInsertionCode();
                return c == '\u0000' ? "" : "" + c;
            }
            case 1288701959: 
            case 1826248716: {
                String string = atom.group.chain.model.ms.getAtomLabel(atom.i);
                if (string == null) {
                    string = "";
                }
                return string;
            }
            case 1641025539: {
                return atom.getProteinStructureType().getBioStructureTypeName(false);
            }
            case 1238369286: {
                return atom.getProteinStructureSubType().getBioStructureTypeName(false);
            }
            case 1087373324: {
                return atom.getStructureId();
            }
            case 1087373323: {
                return viewer.getHybridizationAndAxes(atom.i, null, null, "d");
            }
            case 1087375373: {
                return atom.getElementSymbolIso(false);
            }
            case 1089470478: {
                return atom.getSymmetryOperatorList();
            }
        }
        return "";
    }

    public static T3 atomPropertyTuple(Atom atom, int n) {
        switch (n) {
            case 1146095627: {
                return atom.getFractionalCoordPt(!atom.group.chain.model.isJmolDataFrame);
            }
            case 1146095629: {
                return atom.getFractionalCoordPt(false);
            }
            case 1146093582: {
                return atom.group.chain.model.isJmolDataFrame ? atom.getFractionalCoordPt(false) : atom.getFractionalUnitCoordPt(false);
            }
            case 1146095628: {
                return P3.new3(atom.sX, atom.group.chain.model.ms.vwr.getScreenHeight() - atom.sY, atom.sZ);
            }
            case 1146095631: {
                V3 v3 = atom.getVibrationVector();
                if (v3 == null) {
                    v3 = new V3();
                }
                return v3;
            }
            case 1146095626: {
                return atom;
            }
            case 1766856708: {
                return CU.colorPtFromInt(atom.group.chain.model.ms.vwr.getColorArgbOrGray(atom.getColix()));
            }
        }
        return null;
    }

    boolean isWithinStructure(STR sTR) {
        return this.group.isWithinStructure(sTR);
    }

    @Override
    public int getOffsetResidueAtom(String string, int n) {
        return this.group.getAtomIndex(string, n);
    }

    @Override
    public boolean isCrossLinked(BNode bNode) {
        return this.group.isCrossLinked(((Atom)bNode).getGroup());
    }

    @Override
    public boolean getCrossLinkLeadAtomIndexes(List<Integer> list) {
        return this.group.getCrossLinkLead(list);
    }

    @Override
    public String toString() {
        return this.getInfo();
    }

    public boolean isWithinFourBonds(Atom atom) {
        if (this.mi != atom.mi) {
            return false;
        }
        if (this.isCovalentlyBonded(atom)) {
            return true;
        }
        Bond[] bondArray = atom.bonds;
        for (int i = 0; i < bondArray.length; ++i) {
            Atom atom2 = bondArray[i].getOtherAtom(atom);
            if (this.isCovalentlyBonded(atom2)) {
                return true;
            }
            for (int j = 0; j < this.bonds.length; ++j) {
                if (!this.bonds[j].getOtherAtom(this).isCovalentlyBonded(atom2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BS findAtomsLike(String string) {
        return this.group.chain.model.ms.vwr.getAtomBitSet(string);
    }
}

