/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javajs.api.GenericBinaryDocument;
import javajs.util.DataReader;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.JmolBinary;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FilesReader
implements JmolFilesReaderInterface {
    private FileManager fm;
    private Viewer vwr;
    private String[] fullPathNamesIn;
    private String[] namesAsGivenIn;
    private String[] fileTypesIn;
    private Object atomSetCollection;
    private DataReader[] dataReaders;
    private Map<String, Object> htParams;
    private boolean isAppend;

    @Override
    public void set(FileManager fileManager, Viewer viewer, String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        this.fm = fileManager;
        this.vwr = viewer;
        this.fullPathNamesIn = stringArray;
        this.namesAsGivenIn = stringArray2;
        this.fileTypesIn = stringArray3;
        this.dataReaders = dataReaderArray;
        this.htParams = map;
        this.isAppend = bl;
    }

    @Override
    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        boolean bl = !this.vwr.displayLoadErrors;
        this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReaders(this, this.fullPathNamesIn, this.fileTypesIn, this.htParams, bl);
        this.dataReaders = null;
        if (bl && !(this.atomSetCollection instanceof String)) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionFromSet(this.atomSetCollection, null, this.htParams);
        }
        if (this.atomSetCollection instanceof String) {
            Logger.error("file ERROR: " + this.atomSetCollection);
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.fm.setFileInfo(new String[]{this.dataReaders == null ? "file[]" : "String[]"});
    }

    @Override
    public Object getBufferedReaderOrBinaryDocument(int n, boolean bl) {
        String[] stringArray;
        Object object;
        if (this.dataReaders != null) {
            return bl ? null : this.dataReaders[n].getBufferedReader();
        }
        String string = this.fullPathNamesIn[n];
        String[] stringArray2 = null;
        this.htParams.remove("subFileList");
        if (string.indexOf("|") >= 0) {
            stringArray2 = PT.split(string, "|");
            string = stringArray2[0];
        }
        if ((object = this.fm.getUnzippedReaderOrStreamFromName(string, null, true, bl, false, true, this.htParams)) instanceof ZipInputStream) {
            if (stringArray2 != null) {
                this.htParams.put("subFileList", stringArray2);
            }
            stringArray = this.fm.getZipDirectory(string, true);
            object = this.fm.getBufferedInputStreamOrErrorMessageFromName(string, this.fullPathNamesIn[n], false, false, null, false, true);
            object = JmolBinary.getAtomSetCollectionOrBufferedReaderFromZip(this.vwr.getModelAdapter(), (BufferedInputStream)object, string, stringArray, this.htParams, true);
        }
        if (object instanceof BufferedInputStream) {
            stringArray = (String[])Interface.getInterface("javajs.util.BinaryDocument");
            stringArray.setStream((BufferedInputStream)object, true);
            return stringArray;
        }
        return object instanceof BufferedReader || object instanceof GenericBinaryDocument ? object : (object == null ? "error opening:" + this.namesAsGivenIn[n] : (String)object);
    }

    @Override
    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

