/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.ZInputStream;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.io.JmolBinary;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FileReader {
    private final FileManager fm;
    private final Viewer vwr;
    private String fileNameIn;
    private String fullPathNameIn;
    private String nameAsGivenIn;
    private String fileTypeIn;
    private Object atomSetCollection;
    private Object reader;
    private Map<String, Object> htParams;
    private boolean isAppend;
    private byte[] bytes;

    public FileReader(FileManager fileManager, Viewer viewer, String string, String string2, String string3, String string4, Object object, Map<String, Object> map, boolean bl) {
        this.fm = fileManager;
        this.vwr = viewer;
        this.fileNameIn = string;
        this.fullPathNameIn = string2;
        this.nameAsGivenIn = string3;
        this.fileTypeIn = string4;
        this.reader = object instanceof BufferedReader ? object : (object instanceof Reader ? new BufferedReader((Reader)object) : null);
        this.bytes = PT.isAB(object) ? (byte[])object : null;
        this.htParams = map;
        this.isAppend = bl;
    }

    public void run() {
        Object object;
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        String string = null;
        Object object2 = null;
        if (this.reader == null) {
            object2 = this.fm.getUnzippedReaderOrStreamFromName(this.fullPathNameIn, this.bytes, true, false, false, true, this.htParams);
            if (object2 == null || object2 instanceof String) {
                String string2 = string = object2 == null ? "error opening:" + this.nameAsGivenIn : (String)object2;
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
                return;
            }
            if (object2 instanceof BufferedReader) {
                this.reader = object2;
            } else if (object2 instanceof ZInputStream) {
                object = this.fullPathNameIn;
                String[] stringArray = null;
                if (((String)(object = ((String)object).replace('\\', '/'))).indexOf("|") >= 0 && !((String)object).endsWith(".zip")) {
                    stringArray = PT.split((String)object, "|");
                    object = stringArray[0];
                }
                if (stringArray != null) {
                    this.htParams.put("subFileList", stringArray);
                }
                InputStream inputStream = (InputStream)object2;
                String[] stringArray2 = this.fm.getZipDirectory((String)object, true);
                this.atomSetCollection = object2 = JmolBinary.getAtomSetCollectionOrBufferedReaderFromZip(this.vwr.getModelAdapter(), inputStream, (String)object, stringArray2, this.htParams, false);
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (object2 instanceof BufferedInputStream) {
            object = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument");
            object.setStream((BufferedInputStream)object2, true);
            this.reader = object;
        }
        if (this.reader != null) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
            if (!(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
            }
            try {
                if (this.reader instanceof BufferedReader) {
                    ((BufferedReader)this.reader).close();
                } else if (this.reader instanceof GenericBinaryDocument) {
                    ((GenericBinaryDocument)this.reader).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.atomSetCollection instanceof String) {
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.fm.setFileInfo(new String[]{this.fullPathNameIn, this.nameAsGivenIn, this.fileNameIn});
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

