/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Dimension;
import javajs.util.PT;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import org.jmol.applet.WrappedApplet;
import org.jmol.awt.FileDropper;
import org.jmol.c.CBK;
import org.jmol.util.GenericApplet;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class Jmol
extends GenericApplet
implements WrappedApplet {
    private boolean isUpdating;
    private boolean showPaintTime;
    private int timeLast;
    private int timeCount;
    private int timeTotal;
    private int lastMotionEventNumber;
    private long timeBegin;
    private FileDropper dropper;
    private Applet applet;
    private Boolean allowJSEval;
    private JSObject jsoDocument = null;

    @Override
    public void setApplet(Applet applet, boolean bl) {
        this.applet = applet;
        this.appletObject = this.applet;
        this.isSigned = bl;
        this.init(this.appletObject);
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics, "paint ");
    }

    @Override
    public void update(Graphics graphics) {
        this.update(graphics, "update");
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.dropper != null) {
            this.dropper.dispose();
            this.dropper = null;
        }
        System.out.println("Jmol applet " + this.fullName + " destroyed");
        if (this.isJNLP) {
            System.exit(0);
        }
    }

    @Override
    public Object setStereoGraphics(boolean bl) {
        return bl ? this.applet.getGraphics() : null;
    }

    @Override
    protected void initOptions() {
        String string = this.getJmolParameter("mayscript");
        this.mayScript = string != null && !string.equalsIgnoreCase("false");
        URL uRL = this.applet.getDocumentBase();
        this.documentBase = uRL == null ? this.getValue("documentBase", null) : uRL.toString();
        uRL = this.applet.getCodeBase();
        String string2 = this.codeBase = uRL == null ? this.getValue("codePath", this.getValue("codeBase", null)) : uRL.toString();
        if (this.codeBase != null && !this.codeBase.endsWith("/")) {
            this.codeBase = this.codeBase + "/";
        }
        this.vwrOptions = new Hashtable();
        this.isSigned |= this.isJNLP || this.getBooleanValue("signed", false);
        if (this.isSigned) {
            this.addValue(this.vwrOptions, null, "signedApplet", Boolean.TRUE);
        }
        if (this.getBooleanValue("useCommandThread", this.isSigned)) {
            this.addValue(this.vwrOptions, null, "useCommandThread", Boolean.TRUE);
        }
        String string3 = "";
        if (this.isSigned && this.getBooleanValue("multiTouchSparshUI-simulated", false)) {
            string3 = string3 + "-multitouch-sparshui-simulated";
        } else if (this.isSigned && this.getBooleanValue("multiTouchSparshUI", false)) {
            string3 = string3 + "-multitouch-sparshui";
        }
        this.addValue(this.vwrOptions, null, "options", string3);
        this.addValue(this.vwrOptions, null, "display", this.applet);
        this.addValue(this.vwrOptions, null, "fullName", this.fullName);
        this.addValue(this.vwrOptions, null, "documentBase", this.documentBase);
        this.addValue(this.vwrOptions, null, "codePath", this.codeBase);
        if (this.getBooleanValue("noScripting", false)) {
            this.addValue(this.vwrOptions, null, "noScripting", Boolean.TRUE);
        }
        if (this.isJNLP) {
            this.addValue(this.vwrOptions, null, "isJNLP", Boolean.TRUE);
        }
        this.addValue(this.vwrOptions, "MaximumSize", "maximumSize", null);
        this.addValue(this.vwrOptions, "JmolAppletProxy", "appletProxy", null);
        this.addValue(this.vwrOptions, "documentLocation", null, null);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            System.err.println("Error loading L&F: " + throwable);
        }
        if (Logger.debugging) {
            Logger.debug("checking for jsoWindow mayScript=" + this.mayScript);
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)this.applet);
                if (Logger.debugging) {
                    Logger.debug("jsoWindow=" + jSObject);
                }
                if (jSObject == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                }
                jSObject2 = (JSObject)jSObject.getMember("document");
                if (jSObject2 == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Logger.debugging) {
                Logger.debug("jsoWindow:" + jSObject + " jsoDocument:" + jSObject2 + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess);
            }
        }
        if (this.isSigned) {
            try {
                this.dropper = new FileDropper(null, this.viewer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Jmol.cleanRegistry();
    }

    private void addValue(Map<String, Object> map, String string, String string2, Object object) {
        if (string != null) {
            object = this.getValue(string, null);
        }
        if (object != null) {
            map.put(string2 == null ? string : string2, object);
        }
        boolean bl = false;
        for (CBK cBK : CBK.values()) {
            if (this.callbacks.get((Object)cBK) == null) continue;
            bl = true;
            break;
        }
        if ((bl || this.statusForm != null || this.statusText != null) && !this.mayScript) {
            Logger.warn("MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
    }

    private static synchronized void cleanRegistry() {
        Applet applet = null;
        boolean bl = true;
        for (Map.Entry entry : htRegistry.entrySet()) {
            String string = (String)entry.getKey();
            try {
                applet = (Applet)entry.getValue();
                JSObject jSObject = JSObject.getWindow((Applet)applet);
                bl = (Boolean)jSObject.getMember("closed");
                if (bl || jSObject.hashCode() == 0) {
                    // empty if block
                }
                if (Logger.debugging) {
                    Logger.debug("Preserving registered applet " + string + " window: " + jSObject.hashCode());
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) continue;
            if (Logger.debugging) {
                Logger.debug("Dereferencing closed window applet " + string);
            }
            htRegistry.remove(string);
            applet.destroy();
        }
    }

    @Override
    protected String getJmolParameter(String string) {
        return this.applet.getParameter(string);
    }

    @Override
    protected void doSendJsTextStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.applet);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusText);
                jSObject4.setMember("value", string);
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + exception.toString());
        }
    }

    @Override
    protected void doSendJsTextareaStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.applet);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusTextarea);
                if (string == null) {
                    jSObject4.setMember("value", "");
                } else {
                    String string2 = (String)jSObject4.getMember("value");
                    jSObject4.setMember("value", string2 + "\n" + string);
                }
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + exception.toString());
        }
    }

    private void update(Graphics graphics, String string) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        java.awt.Dimension dimension = new java.awt.Dimension();
        this.applet.getSize(dimension);
        this.viewer.setScreenDimension(dimension.width, dimension.height);
        if (!this.isStereoSlave) {
            this.viewer.renderScreenImageStereo(graphics, true, dimension.width, dimension.height);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, graphics);
        }
        this.isUpdating = false;
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.timeTotal = 0;
            this.timeCount = 0;
            this.timeLast = -1;
        }
    }

    private void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = n;
    }

    private String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    private void showTimes(int n, int n2, Graphics graphics) {
        int n3 = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        graphics.setColor(Color.green);
        graphics.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(n3) + "ms", n, n2);
    }

    @Override
    public Dimension resizeInnerPanel(String string) {
        return new Dimension(0, 0);
    }

    @Override
    protected String doSendCallback(String string, Object[] objectArray, String string2) {
        JSObject jSObject = JSObject.getWindow((Applet)this.applet);
        if (string.equals("alert")) {
            jSObject.call(string, string2);
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.indexOf(".") > 0) {
            String[] stringArray = PT.split(string, ".");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                jSObject = (JSObject)jSObject.getMember(stringArray[i]);
            }
            string = stringArray[stringArray.length - 1];
        }
        return "" + jSObject.call(string, objectArray);
    }

    @Override
    protected String doEval(String string) {
        Object var2_2 = null;
        if (this.allowJSEval == null) {
            try {
                this.jsoDocument = (JSObject)JSObject.getWindow((Applet)this.applet).getMember("document");
                try {
                    if (((Boolean)this.jsoDocument.eval("!!Jmol._noEval")).booleanValue()) {
                        this.allowJSEval = Boolean.FALSE;
                    }
                }
                catch (Exception exception) {
                    try {
                        if (((Boolean)this.jsoDocument.eval("!!_jmol.noEval")).booleanValue()) {
                            this.allowJSEval = Boolean.FALSE;
                        }
                    }
                    catch (Exception exception2) {
                        this.allowJSEval = Boolean.FALSE;
                        Logger.error("# no Jmol or _jmol object in evaluating " + string + ":" + exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (Logger.debugging) {
                    Logger.debug(" error setting jsoWindow or jsoDocument:" + var2_2 + ", " + this.jsoDocument);
                }
                this.allowJSEval = Boolean.FALSE;
            }
        }
        if (this.allowJSEval == Boolean.FALSE) {
            this.jsoDocument = null;
            return "NO EVAL ALLOWED";
        }
        try {
            return "" + this.jsoDocument.eval(string);
        }
        catch (Exception exception) {
            Logger.error("# error evaluating " + string + ":" + exception.toString());
            return "";
        }
    }

    @Override
    public float[][] doFunctionXY(String string, int n, int n2) {
        float[][] fArray = new float[Math.abs(n)][Math.abs(n2)];
        if (!this.mayScript || n == 0 || n2 == 0) {
            return fArray;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.applet);
            if (n > 0 && n2 > 0) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        fArray[i][j] = ((Double)jSObject.call(string, this.htmlName, i, j)).floatValue();
                    }
                }
            } else if (n2 > 0) {
                String string2 = (String)jSObject.call(string, this.htmlName, n, n2);
                n = Math.abs(n);
                float[] fArray2 = new float[n * n2];
                Parser.parseStringInfestedFloatArray(string2, null, fArray2);
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    int n4 = 0;
                    while (n4 < n2) {
                        fArray[i][n4] = fArray2[n3];
                        ++n4;
                        ++n3;
                    }
                }
            } else {
                jSObject.call(string, new Object[]{this.htmlName, n, n2, fArray});
            }
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception.getMessage() + " with nX, nY: " + n + " " + n2);
        }
        return fArray;
    }

    @Override
    public float[][][] doFunctionXYZ(String string, int n, int n2, int n3) {
        float[][][] fArray = new float[Math.abs(n)][Math.abs(n2)][Math.abs(n3)];
        if (!this.mayScript || n == 0 || n2 == 0 || n3 == 0) {
            return fArray;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.applet);
            jSObject.call(string, new Object[]{this.htmlName, n, n2, n3, fArray});
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception.getMessage() + " for " + string + " with nX, nY, nZ: " + n + " " + n2 + " " + n3);
        }
        return fArray;
    }

    @Override
    protected void doShowDocument(URL uRL) {
        this.applet.getAppletContext().showDocument(uRL, "_blank");
    }

    @Override
    protected void doShowStatus(String string) {
        try {
            System.out.println(string);
            this.applet.showStatus(PT.rep(PT.split(string, "\n")[0], "'", "\\'"));
            this.doSendJsTextStatus(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

