/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class XtalSymmetry {
    private AtomSetCollection asc;
    private SymmetryInterface symmetry;
    private float[] notionalUnitCell = new float[6];
    private float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private boolean applySymmetryToBonds = false;
    private int[] latticeCells;
    private P3 ptSupercell;
    private float[] fmatSupercell;
    private boolean doNormalize = true;
    private boolean doPackUnitCell = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    private P3 unitCellOffset;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3 minXYZ0;
    private P3 maxXYZ0;
    private boolean checkAll = false;
    private int bondCount0;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    private int latticeOp;
    private boolean latticeOnly;
    private int noSymmetryCount;
    private int firstSymmetryAtom;
    private static final int PARTICLE_NONE = 0;
    private static final int PARTICLE_CHAIN = 1;
    private static final int PARTICLE_SYMOP = 2;
    private P3 ptTemp;
    private M3 mTemp;

    public XtalSymmetry set(AtomSetCollection atomSetCollection) {
        this.asc = atomSetCollection;
        this.getSymmetry();
        return this;
    }

    SymmetryInterface getSymmetry() {
        return this.symmetry == null ? (this.symmetry = Interface.getSymmetry()) : this.symmetry;
    }

    SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        this.symmetry = symmetryInterface;
        return this.symmetry;
    }

    private void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.asc.setAtomSetCollectionAuxiliaryInfo("symmetryRange", Float.valueOf(f));
    }

    void setLatticeCells(AtomSetCollectionReader atomSetCollectionReader) {
        this.latticeCells = atomSetCollectionReader.latticeCells;
        boolean bl = this.latticeCells[0] <= 555 && this.latticeCells[1] >= 555 && (this.latticeCells[2] == 0 || this.latticeCells[2] == 1 || this.latticeCells[2] == -1);
        this.doNormalize = this.latticeCells[0] != 0 && (!bl || this.latticeCells[2] == 1);
        this.applySymmetryToBonds = atomSetCollectionReader.applySymmetryToBonds;
        this.doPackUnitCell = atomSetCollectionReader.doPackUnitCell;
        this.doCentroidUnitCell = atomSetCollectionReader.doCentroidUnitCell;
        this.centroidPacked = atomSetCollectionReader.centroidPacked;
        if (atomSetCollectionReader.strSupercell != null) {
            this.setSuperCell(atomSetCollectionReader.strSupercell);
        } else {
            this.ptSupercell = atomSetCollectionReader.ptSupercell;
        }
    }

    public void setSupercellFromPoint(P3 p3) {
        this.ptSupercell = p3;
        Logger.info("Using supercell " + Escape.eP(p3));
    }

    private void setSuperCell(String string) {
        if (this.fmatSupercell != null) {
            return;
        }
        this.fmatSupercell = new float[16];
        if (this.symmetry.getMatrixFromString(string, this.fmatSupercell, true, 0) == null) {
            this.fmatSupercell = null;
            return;
        }
        Logger.info("Using supercell \n" + M4.newA16(this.fmatSupercell));
    }

    private void setNotionalUnitCell(float[] fArray, M3 m3, P3 p3) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = p3;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.asc.haveUnitCell = true;
        this.asc.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.asc.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.asc.setAtomSetAuxiliaryInfo("unitCellOffset", p3);
        }
        if (m3 != null) {
            this.symmetry.setUnitCellOrientation(m3);
            this.asc.setAtomSetAuxiliaryInfo("matUnitCellOrientation", m3);
        }
    }

    int addSpaceGroupOperation(AtomSetCollectionReader atomSetCollectionReader, String string) {
        if (atomSetCollectionReader != null) {
            this.setLatticeCells(atomSetCollectionReader);
        }
        this.symmetry.setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.symmetry.setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    SymmetryInterface applySymmetryFromReader(AtomSetCollectionReader atomSetCollectionReader, SymmetryInterface symmetryInterface) throws Exception {
        this.asc.setCoordinatesAreFractional(atomSetCollectionReader.iHaveFractionalCoordinates);
        this.setNotionalUnitCell(atomSetCollectionReader.notionalUnitCell, atomSetCollectionReader.matUnitCellOrientation, atomSetCollectionReader.unitCellOffset);
        this.asc.setAtomSetSpaceGroupName(atomSetCollectionReader.spaceGroup);
        this.setSymmetryRange(atomSetCollectionReader.symmetryRange);
        if (atomSetCollectionReader.doConvertToFractional || atomSetCollectionReader.fileCoordinatesAreFractional) {
            this.setLatticeCells(atomSetCollectionReader);
            boolean bl = true;
            if (atomSetCollectionReader.ignoreFileSpaceGroupName || !atomSetCollectionReader.iHaveSymmetryOperators) {
                if (!atomSetCollectionReader.merging || symmetryInterface == null) {
                    symmetryInterface = atomSetCollectionReader.getNewSymmetry();
                }
                bl = symmetryInterface.createSpaceGroup(atomSetCollectionReader.desiredSpaceGroupIndex, atomSetCollectionReader.spaceGroup.indexOf("!") >= 0 ? "P1" : atomSetCollectionReader.spaceGroup, atomSetCollectionReader.notionalUnitCell);
            } else {
                atomSetCollectionReader.doPreSymmetry();
                symmetryInterface = null;
            }
            if (bl) {
                if (symmetryInterface != null) {
                    this.symmetry.setSpaceGroupFrom(symmetryInterface);
                }
                this.applySymmetryLattice(atomSetCollectionReader.ms);
                if (symmetryInterface != null) {
                    this.asc.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
                }
            }
        }
        if (atomSetCollectionReader.iHaveFractionalCoordinates && atomSetCollectionReader.merging && symmetryInterface != null) {
            this.asc.toCartesian(symmetryInterface);
            this.asc.setCoordinatesAreFractional(false);
            atomSetCollectionReader.addVibrations = false;
        }
        return this.symmetry;
    }

    private void applySymmetryLattice(MSInterface mSInterface) throws Exception {
        if (!this.asc.coordinatesAreFractional || this.symmetry.getSpaceGroup() == null) {
            return;
        }
        int n = this.latticeCells[0];
        int n2 = this.latticeCells[1];
        int n3 = Math.abs(this.latticeCells[2]);
        if (this.fmatSupercell != null) {
            int n4;
            int n5;
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
            P3 p3 = this.setSym(0, 1, 2);
            P3 p32 = this.setSym(4, 5, 6);
            P3 p33 = this.setSym(8, 9, 10);
            this.minXYZ = P3i.new3((int)this.rminx, (int)this.rminy, (int)this.rminz);
            this.maxXYZ = P3i.new3((int)this.rmaxx, (int)this.rmaxy, (int)this.rmaxz);
            this.applyAllSymmetry(mSInterface);
            Atom[] atomArray = this.asc.atoms;
            int n6 = this.asc.ac;
            for (n5 = n4 = this.asc.getLastAtomSetAtomIndex(); n5 < n6; ++n5) {
                this.symmetry.toCartesian(atomArray[n5], true);
            }
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p3.x, p3.y, p3.z, p32.x, p32.y, p32.z, p33.x, p33.y, p33.z}, null, (P3)this.asc.getAtomSetAuxiliaryInfoValue(-1, "unitCellOffset"));
            this.asc.setAtomSetSpaceGroupName("P1");
            this.symmetry.setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            for (n5 = n4; n5 < n6; ++n5) {
                this.symmetry.toFractional(atomArray[n5], true);
            }
            this.asc.haveAnisou = false;
            this.asc.setAtomSetAuxiliaryInfo("matUnitCellOrientation", null);
            this.doPackUnitCell = false;
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n, n2, n3);
        this.applyAllSymmetry(mSInterface);
        this.fmatSupercell = null;
    }

    private P3 setSym(int n, int n2, int n3) {
        P3 p3 = new P3();
        p3.set(this.fmatSupercell[n], this.fmatSupercell[n2], this.fmatSupercell[n3]);
        this.setSymmetryMinMax(p3);
        this.symmetry.toCartesian(p3, false);
        return p3;
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    private boolean isInSymmetryRange(P3 p3) {
        return p3.x >= this.rminx && p3.y >= this.rminy && p3.z >= this.rminz && p3.x <= this.rmaxx && p3.y <= this.rmaxy && p3.z <= this.rmaxz;
    }

    public boolean isWithinCell(int n, P3 p3, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return p3.x > f - f7 && p3.x < f2 + f7 && (n < 2 || p3.y > f3 - f7 && p3.y < f4 + f7) && (n < 3 || p3.z > f5 - f7 && p3.z < f6 + f7);
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, P3[] p3Array, MSInterface mSInterface) throws Exception {
        int[] nArray;
        boolean bl = n4 == 0;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl2 ? new int[this.noSymmetryCount] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n, n2, n3);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = this.symmetryRange > 0.0f;
        boolean bl5 = bl && bl4;
        bl4 &= !bl;
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        if (n7 == 1) {
            this.asc.checkSpecial = false;
        }
        boolean bl6 = this.asc.checkSpecial;
        boolean bl7 = bl3 || bl4;
        boolean bl8 = bl6 || bl7;
        boolean bl9 = bl6 || bl5;
        SymmetryInterface symmetryInterface = this.symmetry;
        if (bl3) {
            n4 = this.noSymmetryCount;
        }
        int n8 = this.firstSymmetryAtom + this.noSymmetryCount;
        P3 p3 = new P3();
        String string = null;
        char c = '\u0000';
        for (int i = 0; i < n7; ++i) {
            int n9;
            Object object;
            Atom[] atomArray;
            if (bl && i == 0 || this.latticeOnly && i > 0 && i != this.latticeOp) continue;
            int n10 = bl6 ? n5 : (bl4 ? n4 : 0);
            for (int j = this.firstSymmetryAtom; j < n8; ++j) {
                Object object2;
                atomArray = this.asc.atoms[j];
                if (atomArray.ignoreSymmetry || this.asc.bsAtoms != null && !this.asc.bsAtoms.get(j)) continue;
                if (mSInterface == null) {
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                } else {
                    symmetryInterface = mSInterface.getAtomSymmetry((Atom)atomArray, this.symmetry);
                    symmetryInterface.newSpaceGroupPoint(i, (P3)atomArray, p3, n, n2, n3);
                    string = symmetryInterface.getSpaceGroupOperationCode(i);
                    if (string != null) {
                        c = string.charAt(0);
                        symmetryInterface = mSInterface.getSymmetryFromCode(string);
                        if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                            this.finalizeSymmetry(symmetryInterface);
                        }
                    }
                }
                Atom atom = null;
                object = P3.newP(p3);
                symmetryInterface.toCartesian((T3)object, false);
                if (this.doPackUnitCell) {
                    symmetryInterface.toUnitCell((P3)object, this.ptOffset);
                    p3.setT((T3)object);
                    symmetryInterface.toFractional(p3, false);
                    if (!this.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z, 0.02f)) continue;
                }
                if (bl5) {
                    this.setSymmetryMinMax((P3)object);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange((P3)object)) continue;
                    int n11 = this.checkAll ? this.asc.ac : n10;
                    object2 = atomArray.atomName;
                    n9 = string == null ? atomArray.altLoc : c;
                    int n12 = n11;
                    while (--n12 >= 0) {
                        float f3 = ((T3)object).distanceSquared(p3Array[n12]);
                        if (bl6 && (double)f3 < 1.0E-4) {
                            atom = this.asc.atoms[this.firstSymmetryAtom + n12];
                            if ((atom.atomName == null || atom.atomName.equals(object2)) && atom.altLoc == n9) break;
                            atom = null;
                        }
                        if (!bl4 || n12 >= n4 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl4 && f2 > f) continue;
                }
                int n13 = atomArray.atomSite;
                if (atom != null) {
                    if (bl2) {
                        nArray[n13] = atom.index;
                    }
                    atom.bsSymmetry.set(n6 + i);
                    atom.bsSymmetry.set(i);
                    continue;
                }
                if (bl2) {
                    nArray[n13] = this.asc.ac;
                }
                Atom atom2 = this.asc.newCloneAtom((Atom)atomArray);
                atom2.setT(p3);
                atom2.atomSite = n13;
                if (string != null) {
                    atom2.altLoc = c;
                }
                atom2.bsSymmetry = BSUtil.newAndSetBit(n6 + i);
                atom2.bsSymmetry.set(i);
                if (bl9) {
                    p3Array[n5++] = object;
                }
                if ((object2 = atomArray.tensors) == null) continue;
                atom2.tensors = null;
                n9 = ((ArrayList)object2).size();
                while (--n9 >= 0) {
                    Tensor tensor = (Tensor)((ArrayList)object2).get(n9);
                    if (tensor == null) continue;
                    if (n7 == 1) {
                        atom2.addTensor(tensor.copyTensor(), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom2, tensor, i, false, symmetryInterface);
                }
            }
            if (!bl2) continue;
            Bond[] bondArray = this.asc.bonds;
            atomArray = this.asc.atoms;
            for (int j = this.asc.bondIndex0; j < this.bondCount0; ++j) {
                object = bondArray[j];
                Atom atom = atomArray[((Bond)object).atomIndex1];
                Atom atom3 = atomArray[((Bond)object).atomIndex2];
                if (atom == null || atom3 == null) continue;
                int n14 = nArray[atom.atomSite];
                n9 = nArray[atom3.atomSite];
                if (n14 < n8 && n9 < n8) continue;
                this.asc.addNewBondWithOrder(n14, n9, ((Bond)object).order);
            }
        }
        return n5;
    }

    private void applyAllSymmetry(MSInterface mSInterface) throws Exception {
        int n;
        int n2;
        int n3;
        SymmetryInterface symmetryInterface;
        boolean bl;
        int n4;
        if (this.asc.ac == 0) {
            return;
        }
        this.noSymmetryCount = this.asc.baseSymmetryAtomCount == 0 ? this.asc.getLastAtomSetAtomCount() : this.asc.baseSymmetryAtomCount;
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        this.asc.setTensors();
        this.bondCount0 = this.asc.bondCount;
        this.finalizeSymmetry(this.symmetry);
        int n5 = this.symmetry.getSpaceGroupOperationCount();
        this.dtype = (int)this.symmetry.getUnitCellInfoType(6);
        this.symmetry.setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doCentroidUnitCell) {
            this.asc.setAtomSetCollectionAuxiliaryInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.asc.setAtomSetAuxiliaryInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            if (mSInterface != null) {
                mSInterface.setMinMax0(this.minXYZ0, this.maxXYZ0);
                this.minXYZ.set((int)this.minXYZ0.x, (int)this.minXYZ0.y, (int)this.minXYZ0.z);
                this.maxXYZ.set((int)this.maxXYZ0.x, (int)this.maxXYZ0.y, (int)this.maxXYZ0.z);
            }
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n6 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n7 = this.asc.checkSpecial ? this.noSymmetryCount * n5 * n6 : (this.symmetryRange > 0.0f ? this.noSymmetryCount * n5 : (this.symmetryRange < 0.0f ? 1 : 1));
        P3[] p3Array = new P3[n7];
        for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
            this.asc.atoms[n4 + this.firstSymmetryAtom].bsSymmetry = BS.newN(n5 * (n6 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n6];
        this.unitCellTranslations = new V3[n6];
        int n8 = 0;
        int n9 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        SymmetryInterface symmetryInterface2 = symmetryInterface = this.symmetry;
        this.latticeOp = symmetryInterface.getLatticeOp();
        this.checkAll = this.asc.atomSetCount == 1 && this.asc.checkSpecial && this.latticeOp >= 0;
        this.latticeOnly = this.asc.checkLatticeOnly && this.latticeOp >= 0;
        M4 m4 = symmetryInterface.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n8] = V3.new3(n3, n2, n);
                    nArray[n8++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || p3Array.length == 0) continue;
                    for (n4 = 0; n4 < this.noSymmetryCount; ++n4) {
                        Atom atom = this.asc.atoms[this.firstSymmetryAtom + n4];
                        if (mSInterface != null && (symmetryInterface = mSInterface.getAtomSymmetry(atom, this.symmetry)) != symmetryInterface2) {
                            if (symmetryInterface.getSpaceGroupOperationCount() == 0) {
                                symmetryInterface2 = symmetryInterface;
                                this.finalizeSymmetry(symmetryInterface2);
                            }
                            m4 = symmetryInterface.getSpaceGroupOperation(0);
                        }
                        P3 p3 = P3.newP(atom);
                        m4.rotTrans(p3);
                        symmetryInterface.toCartesian(p3, false);
                        if (this.doPackUnitCell) {
                            symmetryInterface.toUnitCell(p3, this.ptOffset);
                            atom.setT(p3);
                            symmetryInterface.toFractional(atom, false);
                        }
                        atom.bsSymmetry.set(n8 * n5);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(p3);
                        }
                        if (n4 >= n7) continue;
                        p3Array[n4] = p3;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n9 = n4 = this.symmetryAddAtoms(0, 0, 0, 0, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n8 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n8;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n3, n2, n, n9, n4, n8 * n5, p3Array, mSInterface);
                }
            }
        }
        if (n8 * this.noSymmetryCount == this.asc.ac - this.firstSymmetryAtom) {
            this.appendAtomProperties(n8);
        }
        this.setSymmetryOps();
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setAtomSetAuxiliaryInfo("latticeDesignation", symmetryInterface.getLatticeDesignation());
        this.asc.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.asc.setAtomSetAuxiliaryInfo("unitCellTranslations", this.unitCellTranslations);
        this.notionalUnitCell = new float[6];
        this.reset();
    }

    private void appendAtomProperties(int n) {
        Map map = (Map)this.asc.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            SB sB = new SB();
            int n2 = n;
            while (--n2 >= 0) {
                sB.append(string2);
            }
            map.put(string, sB.toString());
        }
    }

    private void finalizeSymmetry(SymmetryInterface symmetryInterface) {
        String string = (String)this.asc.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        symmetryInterface.setFinalOperations(string, this.asc.atoms, this.firstSymmetryAtom, this.noSymmetryCount, this.doNormalize);
        if (string == null || string.equals("unspecified!")) {
            this.asc.setAtomSetSpaceGroupName(symmetryInterface.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.asc.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.asc.setAtomSetAuxiliaryInfo("symmetryCount", n);
    }

    /*
     * WARNING - void declaration
     */
    public void applySymmetryBio(Map<String, Object> map, float[] fArray, boolean bl, String string) {
        int n;
        Cloneable cloneable;
        Object object;
        int n2;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        int n3 = string.indexOf("BYCHAIN") >= 0 ? 1 : (string.indexOf("BYSYMOP") >= 0 ? 2 : 0);
        this.doNormalize = false;
        List list = (List)map.get("biomts");
        if (list.size() < 2) {
            return;
        }
        this.symmetry = null;
        if (!Float.isNaN(fArray[0])) {
            this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        }
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation(null, "x,y,z");
        String string2 = (String)map.get("name");
        this.asc.setAtomSetSpaceGroupName(string2);
        int n4 = list.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.asc.bondCount;
        boolean bl2 = this.bondCount0 > this.asc.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.asc.ac] : null;
        this.firstSymmetryAtom = this.asc.getLastAtomSetAtomIndex();
        int n5 = this.asc.ac;
        Hashtable<Serializable, BS> hashtable = new Hashtable<Serializable, BS>();
        int n6 = 0;
        Atom[] atomArray = this.asc.atoms;
        switch (n3) {
            case 1: {
                n2 = n5;
                while (--n2 >= this.firstSymmetryAtom) {
                    void object2;
                    object = atomArray[n2].chainID;
                    BS n7 = (BS)hashtable.get(object);
                    if (n7 == null) {
                        ++n6;
                        BS bS = new BS();
                        hashtable.put((Serializable)object, bS);
                    }
                    object2.set(n2);
                }
                this.asc.bsAtoms = new BS();
                for (n2 = 0; n2 < n6; ++n2) {
                    this.asc.bsAtoms.set(n5 + n2);
                    object = new Atom();
                    ((T3)object).set(0.0f, 0.0f, 0.0f);
                    ((Atom)object).radius = 16.0f;
                    this.asc.addAtom((Atom)object);
                }
                n2 = 0;
                for (Map.Entry entry : hashtable.entrySet()) {
                    Atom atom = atomArray[n5 + n2++];
                    cloneable = (BS)entry.getValue();
                    n = ((BS)cloneable).nextSetBit(0);
                    while (n >= 0) {
                        atom.add(atomArray[n]);
                        n = ((BS)cloneable).nextSetBit(n + 1);
                    }
                    atom.scale(1.0f / (float)((BS)cloneable).cardinality());
                    atom.atomName = "Pt" + n2;
                    atom.chainID = (Integer)entry.getKey();
                }
                this.firstSymmetryAtom = n5;
                n5 += n6;
                break;
            }
            case 2: {
                void var17_23;
                this.asc.bsAtoms = new BS();
                this.asc.bsAtoms.set(n5);
                atomArray[n5] = new Atom();
                object = atomArray[n5];
                ((T3)object).set(0.0f, 0.0f, 0.0f);
                int n7 = n5;
                while (--var17_23 >= this.firstSymmetryAtom) {
                    ((T3)object).add(atomArray[var17_23]);
                }
                ((T3)object).scale(1.0f / (float)(n5 - this.firstSymmetryAtom));
                ((Atom)object).atomName = "Pt";
                ((Atom)object).radius = 16.0f;
                this.firstSymmetryAtom = n5++;
            }
        }
        if (string.indexOf("#<") >= 0) {
            n4 = Math.min(n4, PT.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = PT.rep(string, "#<", "_<");
        }
        for (n2 = this.firstSymmetryAtom; n2 < n5; ++n2) {
            atomArray[n2].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        for (n2 = 1; n2 < n4; ++n2) {
            if (string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n2 + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n2 + 1) + ";") < 0) continue;
            object = (M4)list.get(n2);
            for (int i = this.firstSymmetryAtom; i < n5; ++i) {
                if (this.asc.bsAtoms != null && !this.asc.bsAtoms.get(i)) continue;
                try {
                    int n8 = atomArray[i].atomSite;
                    if (bl2) {
                        nArray[n8] = this.asc.ac;
                    }
                    cloneable = this.asc.newCloneAtom(atomArray[i]);
                    if (this.asc.bsAtoms != null) {
                        this.asc.bsAtoms.set(((Atom)cloneable).index);
                    }
                    ((Atom)cloneable).atomSite = n8;
                    ((M4)object).rotTrans((T3)((Object)cloneable));
                    ((Atom)cloneable).bsSymmetry = BSUtil.newAndSetBit(n2);
                    if (!bl2) continue;
                    for (n = this.asc.bondIndex0; n < this.bondCount0; ++n) {
                        Bond bond = this.asc.bonds[n];
                        int n9 = nArray[atomArray[bond.atomIndex1].atomSite];
                        int n10 = nArray[atomArray[bond.atomIndex2].atomSite];
                        if (n9 < n5 && n10 < n5) continue;
                        this.asc.addNewBondWithOrder(n9, n10, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.asc.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            if (n2 <= 0) continue;
            this.symmetry.addBioMoleculeOperation((M4)object, false);
        }
        this.noSymmetryCount = n5 - this.firstSymmetryAtom;
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", this.firstSymmetryAtom);
        this.asc.setAtomSetAuxiliaryInfo("presymmetryAtomCount", this.noSymmetryCount);
        this.asc.setAtomSetAuxiliaryInfo("biosymmetryCount", n4);
        this.asc.setAtomSetAuxiliaryInfo("biosymmetry", this.symmetry);
        this.finalizeSymmetry(this.symmetry);
        this.setSymmetryOps();
        this.reset();
    }

    private void reset() {
        this.asc.coordinatesAreFractional = false;
        this.asc.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.asc.setGlobalBoolean(1);
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl, SymmetryInterface symmetryInterface) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new M3();
        }
        return atom.addTensor(((Tensor)Interface.getUtil("Tensor")).setFromEigenVectors(symmetryInterface.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id), null, bl);
    }

    void setTensors() {
        int n = this.asc.ac;
        for (int i = this.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
            Atom atom = this.asc.atoms[i];
            atom.addTensor(this.symmetry.getTensor(atom.anisoBorU), null, false);
        }
    }
}

