/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.V3;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveThread
extends JmolThread {
    private TransformManager transformManager;
    private float floatSecondsTotal;
    private int iStep;
    private int timePerStep;
    private int totalSteps;
    private float radiansXStep;
    private float radiansYStep;
    private float radiansZStep;
    private V3 dRot;
    private V3 dTrans;
    private float dZoom;
    private float dSlab;
    private float zoomPercent0;
    private int slab;
    private float transX;
    private float transY;
    private float transZ;

    @Override
    public int setManager(Object object, Viewer viewer, Object object2) {
        Object[] objectArray = (Object[])object2;
        this.setViewer(viewer, "MoveThread");
        this.transformManager = (TransformManager)object;
        this.dRot = (V3)objectArray[0];
        this.dTrans = (V3)objectArray[1];
        float[] fArray = (float[])objectArray[2];
        this.dZoom = fArray[0];
        this.dSlab = fArray[1];
        this.floatSecondsTotal = fArray[2];
        int n = (int)fArray[3];
        this.slab = this.transformManager.getSlabPercentSetting();
        this.transX = this.transformManager.getTranslationXPercent();
        this.transY = this.transformManager.getTranslationYPercent();
        this.transZ = this.transformManager.getTranslationZPercent();
        this.timePerStep = 1000 / n;
        this.totalSteps = (int)((float)n * this.floatSecondsTotal);
        if (this.totalSteps <= 0) {
            this.totalSteps = 1;
        }
        float f = (float)(Math.PI / 180 / (double)this.totalSteps);
        this.radiansXStep = f * this.dRot.x;
        this.radiansYStep = f * this.dRot.y;
        this.radiansZStep = f * this.dRot.z;
        this.zoomPercent0 = this.transformManager.zmPct;
        this.iStep = 0;
        return this.totalSteps;
    }

    @Override
    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(true);
                    }
                    n = 0;
                    break;
                }
                case 0: {
                    int n2;
                    int n3;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        n = -2;
                        break;
                    }
                    if (this.dRot.x != 0.0f) {
                        this.transformManager.rotateXRadians(this.radiansXStep, null);
                    }
                    if (this.dRot.y != 0.0f) {
                        this.transformManager.rotateYRadians(this.radiansYStep, null);
                    }
                    if (this.dRot.z != 0.0f) {
                        this.transformManager.rotateZRadians(this.radiansZStep);
                    }
                    if (this.dZoom != 0.0f) {
                        this.transformManager.zoomToPercent(this.zoomPercent0 + this.dZoom * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.x != 0.0f) {
                        this.transformManager.translateToPercent('x', this.transX + this.dTrans.x * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.y != 0.0f) {
                        this.transformManager.translateToPercent('y', this.transY + this.dTrans.y * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dTrans.z != 0.0f) {
                        this.transformManager.translateToPercent('z', this.transZ + this.dTrans.z * (float)this.iStep / (float)this.totalSteps);
                    }
                    if (this.dSlab != 0.0f) {
                        this.transformManager.slabToPercent((int)Math.floor((float)this.slab + this.dSlab * (float)this.iStep / (float)this.totalSteps));
                    }
                    if ((n3 = (int)(System.currentTimeMillis() - this.startTime)) >= (n2 = this.iStep * this.timePerStep)) break;
                    this.vwr.requestRepaintAndWait("moveThread");
                    if (!this.isJS && !this.vwr.isScriptExecuting()) {
                        n = -2;
                        break;
                    }
                    n3 = (int)(System.currentTimeMillis() - this.startTime);
                    this.sleepTime = n2 - n3;
                    if (this.runSleep(this.sleepTime, 0)) break;
                    return;
                }
                case -2: {
                    if (this.floatSecondsTotal > 0.0f) {
                        this.vwr.setInMotion(false);
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }
}

