/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    private SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;
    private boolean isBio;

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, Atom[] atomArray, BS bS, boolean bl, float f, float f2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, atomArray, bS, bl, f, f2);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2, f)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    @Override
    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = SpaceGroup.getNull(true).set(bl);
        }
    }

    @Override
    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n, false);
    }

    @Override
    public int addBioMoleculeOperation(M4 m4, boolean bl) {
        this.spaceGroup.isBio = true;
        this.isBio = true;
        return this.spaceGroup.addSymmetry((bl ? "!" : "") + "[[bio" + m4, 0, false);
    }

    @Override
    public void setLattice(int n) {
        this.spaceGroup.setLatticeParam(n);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.spaceGroup : (this.spaceGroup != null ? this.spaceGroup.getName() : "");
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public void setSpaceGroupFrom(SymmetryInterface symmetryInterface) {
        this.spaceGroup = (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    @Override
    public boolean createSpaceGroup(int n, String string, Object object) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, object);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo(null));
        }
        return this.spaceGroup != null;
    }

    @Override
    public String getSpaceGroupInfo(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(String string, P3[] p3Array, int n, int n2, boolean bl) {
        if (string != null && string.startsWith("bio")) {
            this.spaceGroup.name = string;
        }
        this.spaceGroup.setFinalOperations(p3Array, n, n2, bl);
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.symmetryInfo != null ? this.symmetryInfo.symmetryOperations.length : (this.spaceGroup != null && this.spaceGroup.finalOperations != null ? this.spaceGroup.finalOperations.length : 0);
    }

    @Override
    public M4 getSpaceGroupOperation(int n) {
        return n >= this.spaceGroup.operations.length ? null : (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations[n] : this.spaceGroup.finalOperations[n]);
    }

    @Override
    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.getXyz(n, bl);
    }

    @Override
    public void newSpaceGroupPoint(int n, P3 p3, P3 p32, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(p3, p32, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(p3, p32, n2, n3, n4);
    }

    @Override
    public V3[] rotateAxes(int n, V3[] v3Array, P3 p3, M3 m3) {
        return n == 0 ? v3Array : this.spaceGroup.finalOperations[n].rotateAxes(v3Array, this.unitCell, p3, m3);
    }

    public Object[] getSymmetryOperationDescription(ModelSet modelSet, int n, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        return this.spaceGroup.operations[n].getDescription(modelSet, symmetryInterface, p3, p32, string);
    }

    @Override
    public String fcoord(T3 t3) {
        return SymmetryOperation.fcoord(t3);
    }

    @Override
    public String getMatrixFromString(String string, float[] fArray, boolean bl, int n) {
        return SymmetryOperation.getMatrixFromString(null, string, fArray, bl);
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo == null || this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoString() {
        return this.symmetryInfo.symmetryInfoString;
    }

    @Override
    public String[] getSymmetryOperations() {
        return this.symmetryInfo == null ? this.spaceGroup.getOperationList() : this.symmetryInfo.symmetryOperations;
    }

    @Override
    public boolean isPeriodic() {
        return this.symmetryInfo == null ? false : this.symmetryInfo.isPeriodic();
    }

    @Override
    public void setSymmetryInfo(int n, Map<String, Object> map) {
        M3 m3;
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray = this.symmetryInfo.setSymmetryInfo(map);
        if (fArray == null) {
            return;
        }
        this.setUnitCell(fArray);
        map.put("infoUnitCell", this.getUnitCellAsArray(false));
        this.setOffsetPt((P3)map.get("unitCellOffset"));
        if (map.containsKey("jmolData")) {
            this.setUnitCellAllFractionalRelative(true);
        }
        if ((m3 = (M3)map.get("matUnitCellOrientation")) != null) {
            this.setUnitCellOrientation(m3);
        }
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    @Override
    public void setUnitCell(float[] fArray) {
        this.unitCell = UnitCell.newA(fArray);
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public void setUnitCellOrientation(M3 m3) {
        this.unitCell.setOrientation(m3);
    }

    @Override
    public void unitize(P3 p3) {
        this.unitCell.unitize(p3);
    }

    @Override
    public void toUnitCell(P3 p3, P3 p32) {
        this.unitCell.toUnitCell(p3, p32);
    }

    @Override
    public void toCartesian(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toCartesian(t3, bl);
        }
    }

    @Override
    public P3 toSupercell(P3 p3) {
        return this.unitCell.toSupercell(p3);
    }

    @Override
    public void toFractional(T3 t3, boolean bl) {
        if (!this.isBio) {
            this.unitCell.toFractional(t3, bl);
        }
    }

    @Override
    public float[] getNotionalUnitCell() {
        return this.unitCell.getNotionalUnitCell();
    }

    @Override
    public float[] getUnitCellAsArray(boolean bl) {
        return this.unitCell.getUnitCellAsArray(bl);
    }

    @Override
    public Tensor getTensor(float[] fArray) {
        if (this.unitCell == null) {
            this.unitCell = UnitCell.newA(new float[]{1.0f, 1.0f, 1.0f, 90.0f, 90.0f, 90.0f});
        }
        return this.unitCell.getTensor(fArray);
    }

    @Override
    public P3[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    @Override
    public P3 getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public void setCartesianOffset(T3 t3) {
        this.unitCell.setCartesianOffset(t3);
    }

    @Override
    public P3 getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public void setOffsetPt(P3 p3) {
        this.unitCell.setOffset(p3);
    }

    @Override
    public void setOffset(int n) {
        P3 p3 = new P3();
        SimpleUnitCell.ijkToPoint3f(n, p3, 0);
        this.unitCell.setOffset(p3);
    }

    @Override
    public P3 getUnitCellMultiplier() {
        return this.unitCell.getUnitCellMultiplier();
    }

    @Override
    public P3[] getCanonicalCopy(float f, boolean bl) {
        return this.unitCell.getCanonicalCopy(f, bl);
    }

    @Override
    public float getUnitCellInfoType(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public String getUnitCellInfo() {
        return this.unitCell.dumpInfo(false);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell.isPolymer();
    }

    @Override
    public void setMinMaxLatticeParameters(P3i p3i, P3i p3i2) {
        this.unitCell.setMinMaxLatticeParameters(p3i, p3i2);
    }

    @Override
    public void setUnitCellAllFractionalRelative(boolean bl) {
        this.unitCell.setAllFractionalRelative(bl);
    }

    @Override
    public boolean checkDistance(P3 p3, P3 p32, float f, float f2, int n, int n2, int n3, P3 p33) {
        return this.unitCell.checkDistance(p3, p32, f, f2, n, n2, n3, p33);
    }

    @Override
    public V3[] getUnitCellVectors() {
        return this.unitCell.getUnitCellVectors();
    }

    @Override
    public SymmetryInterface getUnitCell(T3[] t3Array, boolean bl) {
        this.unitCell = UnitCell.newP(t3Array, bl);
        return this;
    }

    @Override
    public boolean isSupercell() {
        return this.unitCell.isSupercell();
    }

    @Override
    public String getSymmetryInfoString(Map<String, Object> map, int n, String string, boolean bl) {
        Object[][] objectArray = (Object[][])map.get("operations");
        if (objectArray == null) {
            return "";
        }
        SB sB = new SB();
        --n;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n >= 0 && n != i) continue;
            if (string != null) {
                return (String)objectArray[i][3];
            }
            if (sB.length() > 0) {
                sB.appendC('\n');
            }
            if (!bl) {
                if (n < 0) {
                    sB.appendI(i + 1).append("\t");
                }
                sB.append((String)objectArray[i][0]).append("\t");
            }
            sB.append((String)objectArray[i][2]);
        }
        if (sB.length() == 0 && string != null) {
            sB.append("draw " + string + "* delete");
        }
        return sB.toString();
    }

    @Override
    public Map<String, Object> getSpaceGroupInfo(ModelSet modelSet, int n, String string, int n2, P3 p3, P3 p32, String string2) {
        String string3 = null;
        Map<String, Object> map = null;
        SymmetryInterface symmetryInterface = null;
        Object[][] objectArray = null;
        if (string == null) {
            if (n <= 0) {
                n = p3 instanceof Atom ? ((Atom)p3).mi : modelSet.vwr.getCurrentModelIndex();
            }
            boolean bl = false;
            if (n < 0) {
                string3 = "no single current model";
            } else {
                symmetryInterface = modelSet.am[n].biosymmetry;
                bl = symmetryInterface != null;
                if (!bl && (symmetryInterface = modelSet.getUnitCell(n)) == null) {
                    string3 = "not applicable";
                }
            }
            if (string3 != null) {
                map = new Hashtable();
                map.put("spaceGroupInfo", string3);
                map.put("symmetryInfo", "");
            } else if (p3 == null && string2 == null && n2 != 0) {
                map = (Map)modelSet.getModelAuxiliaryInfoValue(n, "spaceGroupInfo");
            }
            if (map != null) {
                return map;
            }
            map = new Hashtable();
            if (p3 == null && string2 == null && n2 == 0) {
                modelSet.setModelAuxiliaryInfo(n, "spaceGroupInfo", map);
            }
            string = symmetryInterface.getSpaceGroupName();
            String[] stringArray = symmetryInterface.getSymmetryOperations();
            SpaceGroup spaceGroup = bl ? ((Symmetry)symmetryInterface).spaceGroup : null;
            String string4 = "";
            if (stringArray == null) {
                string3 = "\n no symmetry operations employed";
            } else {
                if (bl) {
                    this.spaceGroup = SpaceGroup.getNull(false).set(false);
                } else {
                    this.setSpaceGroup(false);
                }
                string3 = "\n" + stringArray.length + " symmetry operations employed:";
                objectArray = new Object[stringArray.length][];
                for (int i = 0; i < stringArray.length; ++i) {
                    int n3;
                    int n4 = n3 = bl ? this.addBioMoleculeOperation(spaceGroup.finalOperations[i], false) : this.addSpaceGroupOperation("=" + stringArray[i], i + 1);
                    if (n3 < 0) continue;
                    string4 = string4 + ";" + stringArray[i];
                    Object[] objectArray2 = objectArray[i] = n2 > 0 && n2 - 1 != n3 ? null : this.getSymmetryOperationDescription(modelSet, n3, symmetryInterface, p3, p32, string2);
                    if (objectArray[i] == null) continue;
                    string3 = string3 + "\n" + (i + 1) + "\t" + objectArray[i][0] + "\t" + objectArray[i][2];
                }
            }
            string4 = string4.substring(string4.indexOf(";") + 1);
            if (string.indexOf("[--]") >= 0) {
                string = string4;
            }
        } else {
            map = new Hashtable<String, Object>();
        }
        map.put("spaceGroupName", string);
        if (objectArray != null) {
            map.put("operations", objectArray);
            map.put("symmetryInfo", string3);
        }
        if (!string.startsWith("bio")) {
            String string5 = this.getSpaceGroupInfo(string, symmetryInterface);
            if (string5 == null || string5.equals("?")) {
                string5 = "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
            }
            map.put("spaceGroupInfo", string5);
        }
        return map;
    }

    @Override
    public Object getSymmetryInfo(ModelSet modelSet, int n, int n2, SymmetryInterface symmetryInterface, String string, int n3, P3 p3, P3 p32, String string2, int n4) {
        int n5;
        if (p32 != null) {
            return modelSet.getSymmetryInfoString(n, null, n3, p3, p32, string2 == null ? "sym" : string2, n4 == 1826248716);
        }
        SymmetryInterface symmetryInterface2 = modelSet.getSymTemp(false);
        boolean bl = symmetryInterface.isBio();
        Symmetry symmetry = (Symmetry)symmetryInterface;
        int n6 = n3;
        if (string == null) {
            String[] stringArray = symmetry.getSymmetryOperations();
            if (stringArray == null || n3 == 0 || Math.abs(n3) > stringArray.length) {
                return "";
            }
            if (n3 > 0) {
                n6 = n3 - 1;
                string = stringArray[n6];
            } else {
                n6 = -1 - n3;
                string = stringArray[n6];
            }
        } else {
            n3 = 0;
            n6 = 0;
        }
        symmetryInterface2.setSpaceGroup(false);
        int n7 = bl ? symmetryInterface2.addBioMoleculeOperation(symmetry.spaceGroup.finalOperations[n6], n3 < 0) : (n5 = symmetryInterface2.addSpaceGroupOperation((n3 < 0 ? "!" : "=") + string, Math.abs(n3)));
        if (n5 < 0) {
            return "";
        }
        p3 = P3.newP(p3 == null ? modelSet.at[n2] : p3);
        if (n4 == 0x8100010) {
            if (bl) {
                return "";
            }
            symmetryInterface2.setUnitCell(symmetryInterface.getNotionalUnitCell());
            symmetryInterface.toFractional(p3, false);
            if (Float.isNaN(p3.x)) {
                return "";
            }
            P3 p33 = new P3();
            symmetryInterface2.newSpaceGroupPoint(n5, p3, p33, 0, 0, 0);
            symmetryInterface2.toCartesian(p33, false);
            return p33;
        }
        Object[] objectArray = ((Symmetry)symmetryInterface2).getSymmetryOperationDescription(modelSet, n5, symmetryInterface, p3, p32, string2 == null ? "sym" : string2);
        int n8 = (Integer)objectArray[9];
        switch (n4) {
            case 135266306: {
                return objectArray;
            }
            case 1073742001: {
                String[] stringArray = new String[]{(String)objectArray[0], (String)objectArray[1], (String)objectArray[2], Escape.eP((V3)objectArray[4]), Escape.eP((V3)objectArray[5]), Escape.eP((P3)objectArray[6]), Escape.eP((P3)objectArray[7]), Escape.eP((V3)objectArray[8]), "" + objectArray[9], "" + Escape.e(objectArray[10])};
                return stringArray;
            }
            case 1073741982: {
                return objectArray[0];
            }
            default: {
                return objectArray[2];
            }
            case 135176: {
                return objectArray[3];
            }
            case 1073742178: {
                return objectArray[5];
            }
            case 12289: {
                return objectArray[6];
            }
            case 0x8100010: {
                return objectArray[7];
            }
            case 135266319: 
            case 1073741854: {
                return n8 == 0 == (n4 == 135266319) ? (V3)objectArray[8] : null;
            }
            case 0x8100001: {
                return objectArray[9];
            }
            case 12: 
        }
        return objectArray[10];
    }

    @Override
    public BS notInCentroid(ModelSet modelSet, BS bS, int[] nArray) {
        try {
            BS bS2 = new BS();
            int n = bS.nextSetBit(0);
            JmolMolecule[] jmolMoleculeArray = modelSet.getMolecules();
            int n2 = jmolMoleculeArray.length;
            Atom[] atomArray = modelSet.at;
            boolean bl = jmolMoleculeArray[n2 - 1].firstAtomIndex == modelSet.am[atomArray[n].mi].firstAtomIndex;
            P3 p3 = new P3();
            boolean bl2 = nArray[6] == 1;
            int n3 = n2;
            block2: while (--n3 >= 0 && bS.get(jmolMoleculeArray[n3].firstAtomIndex)) {
                BS bS3 = jmolMoleculeArray[n3].atomList;
                p3.set(0.0f, 0.0f, 0.0f);
                int n4 = 0;
                int n5 = bS3.nextSetBit(0);
                while (n5 >= 0) {
                    if (bl || bl2) {
                        p3.setT(atomArray[n5]);
                        if (this.isNotCentroid(p3, 1, nArray, bl2)) {
                            if (bl) {
                                bS2.set(n5);
                            }
                        } else if (!bl) {
                            continue block2;
                        }
                    } else {
                        p3.add(atomArray[n5]);
                        ++n4;
                    }
                    n5 = bS3.nextSetBit(n5 + 1);
                }
                if (!bl2 && (n4 <= 0 || !this.isNotCentroid(p3, n4, nArray, false))) continue;
                bS2.or(bS3);
            }
            return bS2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isNotCentroid(P3 p3, int n, int[] nArray, boolean bl) {
        p3.scale(1.0f / (float)n);
        this.toFractional(p3, false);
        if (bl) {
            return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x - 5.0E-6f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y - 5.0E-6f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z - 5.0E-6f > (float)nArray[5];
        }
        return p3.x + 5.0E-6f <= (float)nArray[0] || p3.x + 5.0E-5f > (float)nArray[3] || p3.y + 5.0E-6f <= (float)nArray[1] || p3.y + 5.0E-5f > (float)nArray[4] || p3.z + 5.0E-6f <= (float)nArray[2] || p3.z + 5.0E-5f > (float)nArray[5];
    }

    @Override
    public boolean checkUnitCell(SymmetryInterface symmetryInterface, P3 p3, P3 p32, boolean bl) {
        symmetryInterface.toFractional(p32, bl);
        float f = 0.02f;
        return p32.x >= p3.x - 1.0f - f && p32.x <= p3.x + f && p32.y >= p3.y - 1.0f - f && p32.y <= p3.y + f && p32.z >= p3.z - 1.0f - f && p32.z <= p3.z + f;
    }

    @Override
    public boolean unitCellEquals(SymmetryInterface symmetryInterface) {
        return ((Symmetry)symmetryInterface).unitCell.isSameAs(this.unitCell);
    }

    @Override
    public boolean addLatticeVectors(List<float[]> list) {
        return this.spaceGroup.addLatticeVectors(list);
    }

    @Override
    public int getLatticeOp() {
        return this.spaceGroup.latticeOp;
    }

    @Override
    public Matrix getOperationRsVs(int n) {
        return (this.spaceGroup.finalOperations == null ? this.spaceGroup.operations : this.spaceGroup.finalOperations)[n].rsvs;
    }

    @Override
    public int getSiteMultiplicity(P3 p3) {
        return this.spaceGroup.getSiteMultiplicity(p3, this.unitCell);
    }

    @Override
    public boolean isBio() {
        return this.isBio;
    }

    @Override
    public String addOp(String string, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.spaceGroup.isSSG = true;
        String string2 = SymmetryOperation.getXYZFromRsVs(matrix, matrix2, false);
        int n = this.spaceGroup.addSymmetry(string2, -1, true);
        this.spaceGroup.operations[n].setSigma(string, matrix3);
        return string2;
    }

    @Override
    public String getUnitCellState() {
        return this.unitCell == null ? "" : this.unitCell.getState();
    }

    @Override
    public String getSpaceGroupOperationCode(int n) {
        return this.spaceGroup.operations[n].subsystemCode;
    }
}

