/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapecgo;

import javajs.util.CU;
import javajs.util.List;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class CGOMesh
extends DrawMesh {
    public List<Object> cmds;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    private static final int[] sizes = new int[]{0, 0, 1, 0, 3, 3, 3, 4, 27, 13, 1, 1, 1, 1, 13, 15, 1, 35, 13, 3, 2, 3, 9, 1, 2, 1, 14, 16, 1, 2};
    public static final int STOP = 0;
    public static final int SIMPLE_LINE = 1;
    public static final int BEGIN = 2;
    public static final int END = 3;
    public static final int VERTEX = 4;
    public static final int NORMAL = 5;
    public static final int COLOR = 6;
    public static final int SPHERE = 7;
    public static final int TRICOLOR_TRIANGLE = 8;
    public static final int CYLINDER = 9;
    public static final int LINEWIDTH = 10;
    public static final int WIDTHSCALE = 11;
    public static final int ENABLE = 12;
    public static final int DISABLE = 13;
    public static final int SAUSAGE = 14;
    public static final int CUSTOM_CYLINDER = 15;
    public static final int DOTWIDTH = 16;
    public static final int ALPHA_TRIANGLE = 17;
    public static final int ELLIPSOID = 18;
    public static final int FONT = 19;
    public static final int FONT_SCALE = 20;
    public static final int FONT_VERTEX = 21;
    public static final int FONT_AXES = 22;
    public static final int CHAR = 23;
    public static final int INDENT = 24;
    public static final int ALPHA = 25;
    public static final int QUADRIC = 26;
    public static final int CONE = 27;
    public static final int RESET_NORMAL = 28;
    public static final int PICK_COLOR = 29;
    public List<Short> nList = new List();
    public List<Short> cList = new List();

    CGOMesh(String string, short s, int n) {
        super(string, s, n);
    }

    public static int getSize(int n) {
        return n >= 0 && n < sizes.length ? sizes[n] : -1;
    }

    @Override
    public void clear(String string) {
        super.clear(string);
        this.useColix = false;
    }

    boolean set(List<Object> list) {
        this.width = 200.0f;
        this.diameter = 0;
        this.useColix = true;
        this.bsTemp = new BS();
        try {
            if (list.get(0) instanceof Float) {
                this.cmds = list;
            } else {
                this.cmds = (List)list.get(1);
                if (this.cmds == null) {
                    this.cmds = (List)list.get(0);
                }
                this.cmds = (List)this.cmds.get(1);
            }
            int n = this.cmds.size();
            for (int i = 0; i < n; ++i) {
                int n2 = ((Number)this.cmds.get(i)).intValue();
                int n3 = CGOMesh.getSize(n2);
                if (n3 < 0) {
                    Logger.error("CGO unknown type: " + n2);
                    return false;
                }
                switch (n2) {
                    case 1: {
                        n3 = 8;
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    case 5: {
                        this.addNormix(i);
                        break;
                    }
                    case 6: {
                        this.addColix(i);
                        this.useColix = false;
                        break;
                    }
                    case 14: {
                        this.addColix(i + 7);
                        this.addColix(i + 10);
                        break;
                    }
                    case 8: {
                        this.addNormix(i + 9);
                        this.addNormix(i + 12);
                        this.addNormix(i + 15);
                        this.addColix(i + 18);
                        this.addColix(i + 21);
                        this.addColix(i + 24);
                    }
                }
                i += n3;
            }
            return true;
        }
        catch (Exception exception) {
            Logger.error("CGOMesh error: " + exception);
            this.cmds = null;
            return false;
        }
    }

    private void addColix(int n) {
        this.getPoint(n, this.vTemp);
        this.cList.addLast(C.getColix(CU.colorPtToFFRGB(this.vTemp)));
    }

    private void addNormix(int n) {
        this.getPoint(n, this.vTemp);
        this.nList.addLast(Normix.get2SidedNormix(this.vTemp, this.bsTemp));
    }

    public void getPoint(int n, T3 t3) {
        t3.set(this.getFloat(++n), this.getFloat(++n), this.getFloat(++n));
    }

    public int getInt(int n) {
        return ((Number)this.cmds.get(n)).intValue();
    }

    public float getFloat(int n) {
        return ((Number)this.cmds.get(n)).floatValue();
    }
}

