/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.Base64;
import javajs.util.CU;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPatternMatcher;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.BondSet;
import org.jmol.script.JmolMathExtension;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Txt;
import org.jmol.viewer.Viewer;

public class MathExt
implements JmolMathExtension {
    private Viewer vwr;
    private ScriptEval e;
    private JmolPatternMatcher pm;

    @Override
    public JmolMathExtension init(Object object) {
        this.e = (ScriptEval)object;
        this.vwr = this.e.vwr;
        return this;
    }

    @Override
    public boolean evaluate(ScriptMathProcessor scriptMathProcessor, T t, SV[] sVArray, int n) throws ScriptException {
        switch (n) {
            case 135266318: 
            case 135266819: 
            case 135266820: 
            case 135266821: 
            case 135266822: 
            case 135266826: {
                return this.evaluateMath(scriptMathProcessor, sVArray, n);
            }
            case 1276117504: 
            case 1276117507: 
            case 1276117508: 
            case 1276117511: 
            case 1276118017: 
            case 1276383249: 
            case 1276383749: {
                return this.evaluateList(scriptMathProcessor, t.intValue, sVArray);
            }
            case 135266306: 
            case 0x10100040: {
                return this.evaluateArray(scriptMathProcessor, sVArray, n == 0x10100040);
            }
            case 135266307: 
            case 135270418: {
                return this.evaluateQuaternion(scriptMathProcessor, sVArray, n);
            }
            case 1276118529: {
                return this.evaluateBin(scriptMathProcessor, sVArray);
            }
            case 135270423: {
                return this.evaluateCache(scriptMathProcessor, sVArray);
            }
            case 1276117514: 
            case 1276117515: {
                return this.evaluateRowCol(scriptMathProcessor, sVArray, n);
            }
            case 1766856708: {
                return this.evaluateColor(scriptMathProcessor, sVArray);
            }
            case 135270405: {
                return this.evaluateCompare(scriptMathProcessor, sVArray);
            }
            case 135266310: {
                return this.evaluateConnected(scriptMathProcessor, sVArray);
            }
            case 135402505: {
                return this.evaluateContact(scriptMathProcessor, sVArray);
            }
            case 135267329: {
                return this.evaluateCross(scriptMathProcessor, sVArray);
            }
            case 0x8101008: {
                return this.evaluateData(scriptMathProcessor, sVArray);
            }
            case 1276117505: 
            case 1276118018: {
                if (t.tok == 0x101000D1) {
                    return this.evaluateDot(scriptMathProcessor, sVArray, n, t.intValue);
                }
            }
            case 0x8100001: 
            case 1746538509: {
                return this.evaluateMeasure(scriptMathProcessor, sVArray, t.tok);
            }
            case 135271426: 
            case 1229984263: {
                return this.evaluateLoad(scriptMathProcessor, sVArray, n == 1229984263);
            }
            case 1276118531: {
                return this.evaluateFind(scriptMathProcessor, sVArray);
            }
            case 1288701959: 
            case 1826248716: {
                return this.evaluateLabel(scriptMathProcessor, t.intValue, sVArray);
            }
            case 135368713: {
                return this.evaluateUserFunction(scriptMathProcessor, (String)t.value, sVArray, t.intValue, t.tok == 0x101000D1);
            }
            case 1276121098: {
                return this.evaluateGetProperty(scriptMathProcessor, sVArray, t.tok == 0x101000D1);
            }
            case 137363467: {
                return this.evaluateHelix(scriptMathProcessor, sVArray);
            }
            case 135266319: 
            case 135267841: 
            case 135267842: {
                return this.evaluatePlane(scriptMathProcessor, sVArray, n);
            }
            case 135271429: 
            case 135287308: {
                return this.evaluateScript(scriptMathProcessor, sVArray, n);
            }
            case 1276117506: 
            case 1276117510: 
            case 1276117512: {
                return this.evaluateString(scriptMathProcessor, t.intValue, sVArray);
            }
            case 0x8100010: {
                return this.evaluatePoint(scriptMathProcessor, sVArray);
            }
            case 135304707: {
                return this.evaluatePrompt(scriptMathProcessor, sVArray);
            }
            case 135267332: {
                return this.evaluateRandom(scriptMathProcessor, sVArray);
            }
            case 1276118019: {
                return this.evaluateReplace(scriptMathProcessor, sVArray);
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                return this.evaluateSubstructure(scriptMathProcessor, sVArray, n);
            }
            case 1276121113: {
                return this.evaluateModulation(scriptMathProcessor, sVArray);
            }
            case 1276117011: 
            case 1276117012: {
                return this.evaluateSort(scriptMathProcessor, sVArray, n);
            }
            case 1297090050: {
                return this.evaluateSymop(scriptMathProcessor, sVArray, t.tok == 0x101000D1);
            }
            case 1276117016: {
                return this.evaluateTensor(scriptMathProcessor, sVArray);
            }
            case 135266325: {
                return this.evaluateWithin(scriptMathProcessor, sVArray);
            }
            case 135270422: {
                return this.evaluateWrite(scriptMathProcessor, sVArray);
            }
        }
        return false;
    }

    private boolean evaluateArray(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) {
        int n;
        int n2 = sVArray.length;
        if (bl && (n2 == 4 || n2 == 3)) {
            boolean bl2 = true;
            for (n = 0; n < n2 && bl2; ++n) {
                bl2 = sVArray[n].tok == 7 && sVArray[n].getList().size() == n2;
            }
            if (bl2) {
                float[] fArray = new float[n2 * n2];
                int n3 = 0;
                block1: for (int i = 0; i < n2 && bl2; ++i) {
                    List<SV> list = sVArray[i].getList();
                    for (int j = 0; j < n2; ++j) {
                        float f = SV.fValue((T)list.get(j));
                        if (Float.isNaN(f)) {
                            bl2 = false;
                            continue block1;
                        }
                        fArray[n3++] = f;
                    }
                }
                if (bl2) {
                    return n2 == 3 ? scriptMathProcessor.addXM3(M3.newA9(fArray)) : scriptMathProcessor.addXM4(M4.newA16(fArray));
                }
            }
        }
        SV[] sVArray2 = new SV[sVArray.length];
        if (!bl && sVArray.length == 1 && sVArray[0].tok == 4 && sVArray[0].asString().startsWith(";base64,")) {
            return scriptMathProcessor.addXObj(SV.newV(15, Base64.decodeBase64(sVArray[0].asString())));
        }
        n = sVArray2.length;
        while (--n >= 0) {
            sVArray2[n] = SV.newT(sVArray[n]);
        }
        return scriptMathProcessor.addXAV(sVArray2);
    }

    private boolean evaluateBin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        float[] fArray;
        boolean bl;
        if (sVArray.length != 3) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        boolean bl2 = bl = sV.tok == 13;
        if (!bl && sV.tok != 7) {
            return scriptMathProcessor.addX(sV);
        }
        float f = SV.fValue(sVArray[0]);
        float f2 = SV.fValue(sVArray[1]);
        float f3 = SV.fValue(sVArray[2]);
        if (bl) {
            fArray = (float[])sV.value;
        } else {
            List<SV> list = sV.getList();
            fArray = new float[list.size()];
            int n = list.size();
            while (--n >= 0) {
                fArray[n] = SV.fValue((T)list.get(n));
            }
        }
        int n = Math.max((int)Math.floor((f2 - f) / f3 + 0.01f), 1);
        int[] nArray = new int[n];
        for (float f4 : fArray) {
            int n2 = (int)Math.floor((f4 - f) / f3);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= n) {
                n2 = n - 1;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        return scriptMathProcessor.addXAI(nArray);
    }

    private boolean evaluateCache(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 0) {
            return false;
        }
        return scriptMathProcessor.addXMap(this.vwr.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        Object object;
        boolean bl;
        ColorEncoder colorEncoder;
        String string = sVArray.length > 0 ? SV.sValue(sVArray[0]) : "";
        boolean bl2 = string.startsWith("$");
        if (sVArray.length == 2 && string.equalsIgnoreCase("TOHSL")) {
            return scriptMathProcessor.addXPt(CU.rgbToHSL(P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString(), new P3())), true));
        }
        if (sVArray.length == 2 && string.equalsIgnoreCase("TORGB")) {
            P3 p3 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString(), new P3()));
            return scriptMathProcessor.addXPt(sVArray[1].tok == 8 ? CU.hslToRGB(p3) : p3);
        }
        if (sVArray.length == 4 && (sVArray[3].tok == 0x10000D || sVArray[3].tok == 0x10000C)) {
            boolean bl3;
            P3 p3 = P3.newP(sVArray[0].tok == 8 ? SV.ptValue(sVArray[0]) : CU.colorPtFromString(sVArray[0].asString(), new P3()));
            P3 p32 = P3.newP(sVArray[1].tok == 8 ? SV.ptValue(sVArray[1]) : CU.colorPtFromString(sVArray[1].asString(), new P3()));
            boolean bl4 = bl3 = sVArray[3].tok == 0x10000D;
            if (bl3) {
                p3 = CU.rgbToHSL(p3, false);
                p32 = CU.rgbToHSL(p32, false);
            }
            SB sB = new SB();
            V3 v3 = V3.newVsub(p32, p3);
            int n = sVArray[2].asInt();
            if (n < 2) {
                n = 20;
            }
            v3.scale(1.0f / (float)(n - 1));
            for (int i = 0; i < n; ++i) {
                sB.append(Escape.escapeColor(CU.colorPtToFFRGB(bl3 ? CU.hslToRGB(p3) : p3)));
                p3.add(v3);
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.vwr.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return scriptMathProcessor.addXStr("");
        }
        float f = sVArray.length > 1 ? SV.fValue(sVArray[1]) : Float.MAX_VALUE;
        Object object2 = sVArray.length > 2 ? SV.fValue(sVArray[2]) : Float.MAX_VALUE;
        float f2 = sVArray.length > 3 ? SV.fValue(sVArray[3]) : Float.MAX_VALUE;
        boolean bl5 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object2 == Float.MAX_VALUE;
        boolean bl6 = bl = object2 != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            object = this.vwr.getCurrentColorRange();
            f = (float)object[0];
            object2 = object[1];
        }
        if (bl2) {
            object = string.substring(1);
            Object[] objectArray = new Object[]{object, null};
            if (!this.vwr.getShapePropertyData(24, "colorEncoder", objectArray)) {
                return scriptMathProcessor.addXStr("");
            }
            colorEncoder = (ColorEncoder)objectArray[1];
        } else {
            colorEncoder.setRange(f, (float)object2, f > object2);
        }
        object = colorEncoder.getColorKey();
        if (bl5) {
            return scriptMathProcessor.addXPt(CU.colorPtFromInt(colorEncoder.getArgb(object2 == Float.MAX_VALUE ? f : f2)));
        }
        return scriptMathProcessor.addX(SV.getVariableMap(object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean evaluateCompare(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 2 || sVArray.length > 5) {
            return false;
        }
        String string = SV.sValue(sVArray[sVArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = string.equalsIgnoreCase("BONDS");
        boolean bl4 = !bl2 && sVArray.length > (bl ? 3 : 2);
        BS bS = sVArray[0].tok == 10 ? (BS)sVArray[0].value : null;
        BS bS2 = sVArray[1].tok == 10 ? (BS)sVArray[1].value : null;
        String string2 = bS == null ? SV.sValue(sVArray[0]) : "";
        String string3 = bS2 == null ? SV.sValue(sVArray[1]) : "";
        M4 m4 = new M4();
        float f = Float.NaN;
        if (bl4 && (bS == null || bS2 == null)) {
            return false;
        }
        if (bl3) {
            if (sVArray.length != 4) {
                return false;
            }
            string2 = SV.sValue(sVArray[2]);
            bl4 = string2.equalsIgnoreCase("SMILES");
            try {
                if (bl4) {
                    string2 = this.vwr.getSmiles(bS);
                }
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
            float[] fArray = this.e.getSmilesExt().getFlexFitList(bS, bS2, string2, !bl4);
            return fArray == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXAF(fArray);
        }
        try {
            if (bl2) {
                boolean bl5;
                String string4;
                if (sVArray.length != 3) {
                    return false;
                }
                if (bS == null && bS2 == null) {
                    return scriptMathProcessor.addXStr(this.vwr.getSmilesMatcher().getRelationship(string2, string3).toUpperCase());
                }
                String string5 = bS == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormula(this.vwr.getModelSet().at, bS, false);
                String string6 = string4 = bS2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormula(this.vwr.getModelSet().at, bS2, false);
                if (!string5.equals(string4)) {
                    return scriptMathProcessor.addXStr("NONE");
                }
                if (bS != null) {
                    string2 = (String)this.e.getSmilesExt().getSmilesMatches("", null, bS, null, false, true);
                }
                if (bS2 == null) {
                    bl5 = this.vwr.getSmilesMatcher().areEqual(string3, string2) > 0;
                } else {
                    boolean bl6 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
                }
                if (!bl5) {
                    String string7 = string2 + string3;
                    if (string7.indexOf("/") < 0 && string7.indexOf("\\") < 0 && string7.indexOf("@") < 0) return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                    if (string2.indexOf("@") >= 0 && (bS2 != null || string3.indexOf("@") >= 0)) {
                        string2 = this.vwr.getSmilesMatcher().reverseChirality(string2);
                        if (bS2 == null) {
                            bl5 = this.vwr.getSmilesMatcher().areEqual(string2, string3) > 0;
                        } else {
                            boolean bl7 = bl5 = ((BS)this.e.getSmilesExt().getSmilesMatches(string2, null, bS2, null, false, true)).nextSetBit(0) >= 0;
                        }
                        if (bl5) {
                            return scriptMathProcessor.addXStr("ENANTIOMERS");
                        }
                    }
                    if (bS2 == null) {
                        bl5 = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                    } else {
                        Object object = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + string2, null, bS2, null, false, true);
                        boolean bl8 = bl5 = ((BS)object).nextSetBit(0) >= 0;
                    }
                    if (!bl5) return scriptMathProcessor.addXStr("CONSTITUTIONAL ISOMERS");
                    return scriptMathProcessor.addXStr("DIASTERIOMERS");
                }
                if (bS != null && bS2 != null) return scriptMathProcessor.addXStr((f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string2, null, null, null, null, false, false, null, null, false, false)) < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
                return scriptMathProcessor.addXStr("IDENTICAL");
            }
            if (bl4) {
                boolean bl9;
                boolean bl10;
                List<P3> list = new List<P3>();
                List<P3> list2 = new List<P3>();
                string = SV.sValue(sVArray[2]);
                boolean bl11 = string.equalsIgnoreCase("MAP");
                bl4 = string.equalsIgnoreCase("SMILES");
                boolean bl12 = bl10 = bl11 || string.equalsIgnoreCase("SMARTS");
                if (bl4 || bl10) {
                    string = sVArray.length > 3 ? SV.sValue(sVArray[3]) : null;
                }
                boolean bl13 = "H".equals(string) || "allH".equals(string) || "bestH".equals(string);
                boolean bl14 = "all".equals(string) || "allH".equals(string);
                boolean bl15 = bl9 = "best".equals(string) || "bestH".equals(string);
                if (string == null || bl13 || bl14 || bl9) {
                    if (!bl11 && !bl4) return false;
                    string = "/noaromatic" + (bl14 || bl9 ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(bl13 ? "H" : "", null, bS, null, false, true);
                } else {
                    bl14 = true;
                }
                f = this.e.getSmilesExt().getSmilesCorrelation(bS, bS2, string, list, list2, m4, null, !bl4, bl11, null, null, !bl14 && !bl9, bl9);
                if (!bl11) return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
                int n = list.size();
                if (n == 0) {
                    return scriptMathProcessor.addXStr("");
                }
                int n2 = list2.size() / n;
                List<int[][]> list3 = new List<int[][]>();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    int[][] nArray = AU.newInt2(n);
                    list3.addLast(nArray);
                    int n4 = 0;
                    while (n4 < n) {
                        nArray[n4] = new int[]{((Atom)list.get((int)n4)).i, ((Atom)list2.get((int)n3)).i};
                        ++n4;
                        ++n3;
                    }
                }
                if (bl14) return scriptMathProcessor.addXList(list3);
                return list3.size() > 0 ? scriptMathProcessor.addXAII((int[][])list3.get(0)) : scriptMathProcessor.addXStr("");
            }
            List<P3> list = this.e.getPointVector(sVArray[0], 0);
            List<P3> list4 = this.e.getPointVector(sVArray[1], 0);
            if (list == null || list4 == null) return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
            f = Measure.getTransformMatrix4(list, list4, m4, null, false);
            return bl || Float.isNaN(f) ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXM4(m4);
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage() == null ? exception.toString() : exception.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 5) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n = 65535;
        BS bS = null;
        BS bS2 = null;
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = 0; i < sVArray.length; ++i) {
            SV sV = sVArray[i];
            switch (sV.tok) {
                case 10: {
                    bl2 = sV.value instanceof BondSet;
                    if (bl2 && bS != null) {
                        return false;
                    }
                    if (bS == null) {
                        bS = SV.bsSelectVar(sV);
                        continue block5;
                    }
                    if (bS2 == null) {
                        bS2 = SV.bsSelectVar(sV);
                        continue block5;
                    }
                    return false;
                }
                case 4: {
                    String string = SV.sValue(sV);
                    n = string.equalsIgnoreCase("hbond") ? 30720 : ScriptParam.getBondOrderFromString(string);
                    if (n != 131071) continue block5;
                    return false;
                }
                case 3: {
                    bl = true;
                }
                default: {
                    int n2 = sV.asInt();
                    float f5 = sV.asFloat();
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n2, 0);
                        f3 = f5;
                        continue block5;
                    }
                    f2 = n2;
                    f4 = f5;
                }
            }
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        if (bl && bS2 == null) {
            bS2 = bS;
        }
        if (bS2 != null) {
            BS bS3 = new BS();
            this.vwr.makeConnections(f3, f4, n, 1087373321, bS, bS2, bS3, bl2, false, 0.0f);
            return scriptMathProcessor.addX(SV.newV(10, new BondSet(bS3, this.vwr.getAtomIndices(this.vwr.getAtomBits(1678770178, bS3)))));
        }
        return scriptMathProcessor.addXBs(this.vwr.ms.getAtomsConnected(f, f2, n, bS));
    }

    private boolean evaluateContact(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length < 1 || sVArray.length > 3) {
            return false;
        }
        int n = 0;
        float f = 100.0f;
        int n2 = sVArray[0].tok;
        switch (n2) {
            case 2: 
            case 3: {
                f = SV.fValue(sVArray[n++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n == sVArray.length || !(sVArray[n].value instanceof BS)) {
            return false;
        }
        BS bS = BSUtil.copy(SV.bsSelectVar(sVArray[n++]));
        BS bS2 = n < sVArray.length ? BSUtil.copy(SV.bsSelectVar(sVArray[n])) : null;
        RadiusData radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bS2 = this.setContactBitSets(bS, bS2, true, Float.NaN, radiusData, false);
        bS2.or(bS);
        return scriptMathProcessor.addXBs(bS2);
    }

    private boolean evaluateCross(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length != 2) {
            return false;
        }
        SV sV = sVArray[0];
        SV sV2 = sVArray[1];
        if (sV.tok != 8 || sV2.tok != 8) {
            return false;
        }
        V3 v3 = V3.newV((P3)sV.value);
        V3 v32 = V3.newV((P3)sV2.value);
        v3.cross(v3, v32);
        return scriptMathProcessor.addXPt(P3.newP(v3));
    }

    private boolean evaluateData(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        String string;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 4) {
            return false;
        }
        String string2 = SV.sValue(sVArray[0]);
        String string3 = string = sVArray.length == 2 ? SV.sValue(sVArray[1]) : "";
        if (sVArray.length == 4) {
            int n = sVArray[1].asInt();
            int n2 = sVArray[2].asInt();
            int n3 = sVArray[3].asInt();
            float[] fArray = Parser.parseFloatArrayFromMatchAndField(string2, null, 0, 0, null, n, n2, null, n3);
            return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray, false));
        }
        if (string2.indexOf("data2d_") == 0) {
            float[][] fArray = this.vwr.getDataFloat2D(string2);
            if (fArray == null) {
                return scriptMathProcessor.addXStr("");
            }
            if (sVArray.length == 2 && sVArray[1].tok == 2) {
                int n = sVArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray[n], false));
                }
                return scriptMathProcessor.addXStr("");
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatAA(fArray, false));
        }
        if (string2.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = this.vwr.getDataFloat(string2);
            if (fArray2 == null) {
                return scriptMathProcessor.addXStr("");
            }
            float[] fArray3 = fArray = string.indexOf("property_") == 0 ? this.vwr.getDataFloat(string) : null;
            if (fArray != null) {
                fArray2 = AU.arrayCopyF(fArray2, -1);
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return scriptMathProcessor.addXStr(Escape.escapeFloatA(fArray2, false));
        }
        if (sVArray.length == 1) {
            Object[] objectArray = this.vwr.getData(string2);
            return scriptMathProcessor.addXStr(objectArray == null ? "" : "" + objectArray[1]);
        }
        return scriptMathProcessor.addXStr(this.vwr.getData(string2, string));
    }

    private boolean evaluateDot(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n, int n2) throws ScriptException {
        switch (sVArray.length) {
            case 1: {
                if (n == 1276117505) {
                    return false;
                }
            }
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        SV sV = scriptMathProcessor.getX();
        SV sV2 = sVArray[0];
        P3 p3 = sV2.tok == 7 ? null : scriptMathProcessor.ptValue(sV2, false);
        P4 p4 = scriptMathProcessor.planeValue(sV2);
        if (n == 1276118018) {
            int n3 = n2 & 0x1E0;
            boolean bl = n3 == 32 || n3 == 64;
            boolean bl2 = n3 == 480;
            switch (sV.tok) {
                case 10: {
                    BS bS = SV.bsSelectVar(sV);
                    BS bS2 = null;
                    boolean bl3 = bl && sVArray.length == 2 && sVArray[1].asBoolean();
                    switch (sV2.tok) {
                        case 10: {
                            bS2 = sV2.tok == 10 ? SV.bsSelectVar(sV2) : null;
                        }
                        case 8: {
                            Atom[] atomArray = this.vwr.ms.at;
                            if (bl3) {
                                float f = Float.NaN;
                                int n4 = Integer.MAX_VALUE;
                                int n5 = bS.nextSetBit(0);
                                while (n5 >= 0) {
                                    float f2;
                                    float f3 = f2 = bS2 == null ? atomArray[n5].distanceSquared(p3) : ((Float)this.e.getBitsetProperty(bS2, n2, atomArray[n5], p4, sV.value, null, false, sV.index, false)).floatValue();
                                    if (!(n3 == 32 ? f2 >= f : f2 <= f)) {
                                        f = f2;
                                        n4 = n5;
                                    }
                                    n5 = bS.nextSetBit(n5 + 1);
                                }
                                return scriptMathProcessor.addXBs(n4 == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit(n4));
                            }
                            if (bl2) {
                                if (bS2 == null) {
                                    float[] fArray = new float[bS.cardinality()];
                                    int n6 = 0;
                                    int n7 = bS.nextSetBit(0);
                                    while (n7 >= 0) {
                                        fArray[n6] = atomArray[n7].distance(p3);
                                        n7 = bS.nextSetBit(n7 + 1);
                                        ++n6;
                                    }
                                    return scriptMathProcessor.addXAF(fArray);
                                }
                                float[][] fArray = new float[bS.cardinality()][bS2.cardinality()];
                                int n8 = 0;
                                int n9 = bS.nextSetBit(0);
                                while (n9 >= 0) {
                                    int n10 = 0;
                                    int n11 = bS2.nextSetBit(0);
                                    while (n11 >= 0) {
                                        fArray[n8][n10] = atomArray[n9].distance(atomArray[n11]);
                                        n11 = bS2.nextSetBit(n11 + 1);
                                        ++n10;
                                    }
                                    n9 = bS.nextSetBit(n9 + 1);
                                    ++n8;
                                }
                                return scriptMathProcessor.addXAFF(fArray);
                            }
                            if (bl) {
                                float[] fArray = new float[bS.cardinality()];
                                int n12 = bS.nextSetBit(0);
                                int n13 = 0;
                                while (n12 >= 0) {
                                    fArray[n13++] = ((Float)this.e.getBitsetProperty(bS2, n2, atomArray[n12], p4, sV.value, null, false, sV.index, false)).floatValue();
                                    n12 = bS.nextSetBit(n12 + 1);
                                }
                                return scriptMathProcessor.addXAF(fArray);
                            }
                            return scriptMathProcessor.addXObj(this.e.getBitsetProperty(bS, n2, p3, p4, sV.value, null, false, sV.index, false));
                        }
                    }
                }
            }
        }
        return scriptMathProcessor.addXFloat(this.getDistance(scriptMathProcessor, sV, sV2, n));
    }

    private boolean evaluateHelix(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length > 2 ? 3 : 1;
        String string = n >= sVArray.length ? "array" : SV.sValue(sVArray[n]);
        int n2 = T.getTokFromName(string);
        if (sVArray.length > 2) {
            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], true);
            P3 p32 = scriptMathProcessor.ptValue(sVArray[1], true);
            if (sVArray[2].tok != 9) {
                return false;
            }
            Quat quat = Quat.newP4((P4)sVArray[2].value);
            switch (n2) {
                case 0: {
                    break;
                }
                case 0x8100001: 
                case 0x8100010: 
                case 1073741854: 
                case 1666189314: 
                case 1746538509: {
                    return scriptMathProcessor.addXObj(Measure.computeHelicalAxis(null, n2, p3, p32, quat));
                }
                case 135266306: {
                    String[] stringArray = (String[])Measure.computeHelicalAxis(null, 1073742001, p3, p32, quat);
                    if (stringArray == null) {
                        return false;
                    }
                    return scriptMathProcessor.addXAS(stringArray);
                }
                default: {
                    return scriptMathProcessor.addXObj(Measure.computeHelicalAxis(string, 135176, p3, p32, quat));
                }
            }
        } else {
            BS bS = sVArray[0].value instanceof BS ? (BS)sVArray[0].value : this.vwr.getAtomBits(1095761939, new Integer(sVArray[0].asInt()));
            switch (n2) {
                case 0x8100010: {
                    return scriptMathProcessor.addXObj(this.vwr.getHelixData(bS, 0x8100010));
                }
                case 1073741854: {
                    return scriptMathProcessor.addXObj(this.vwr.getHelixData(bS, 1073741854));
                }
                case 1666189314: {
                    return scriptMathProcessor.addXObj(this.vwr.getHelixData(bS, 1666189314));
                }
                case 0x8100001: {
                    return scriptMathProcessor.addXFloat(((Float)this.vwr.getHelixData(bS, 0x8100001)).floatValue());
                }
                case 135176: 
                case 1746538509: {
                    return scriptMathProcessor.addXObj(this.vwr.getHelixData(bS, n2));
                }
                case 135266306: {
                    String[] stringArray = (String[])this.vwr.getHelixData(bS, 1073742001);
                    if (stringArray == null) {
                        return false;
                    }
                    return scriptMathProcessor.addXAS(stringArray);
                }
            }
        }
        return false;
    }

    private boolean evaluateFind(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        boolean bl;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        String string = SV.sValue(sVArray[0]);
        String string2 = sVArray.length > 1 && sVArray[1].tok != 0x10000D && sVArray[1].tok != 0x10000C ? SV.sValue(sVArray[1]) : "";
        boolean bl2 = string.equalsIgnoreCase("SEQUENCE");
        boolean bl3 = string.equalsIgnoreCase("SMILES");
        boolean bl4 = string.equalsIgnoreCase("SMARTS");
        boolean bl5 = string.equalsIgnoreCase("CHEMICAL");
        boolean bl6 = string.equalsIgnoreCase("MF");
        try {
            if (bl5) {
                String string3;
                String string4 = string3 = sV.tok == 10 ? this.vwr.getSmiles(SV.getBitSet(sV, false)) : SV.sValue(sV);
                String string5 = string3.length() == 0 ? "" : (string3 = this.vwr.getChemicalInfo(string3, sVArray.length > 1 ? T.getTokenFromName(string2.toLowerCase()) : null));
                if (string3.endsWith("\n")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (string3.startsWith("InChI")) {
                    string3 = PT.rep(PT.rep(string3, "InChI=", ""), "InChIKey=", "");
                }
                return scriptMathProcessor.addXStr(string3);
            }
            if (bl3 || bl4 || sV.tok == 10) {
                int n = bl3 || bl4 ? 2 : 1;
                BS bS = n < sVArray.length && sVArray[n].tok == 10 ? (BS)sVArray[n++].value : null;
                boolean bl7 = "bonds".equalsIgnoreCase(SV.sValue(sVArray[sVArray.length - 1]));
                boolean bl8 = bl7 || sVArray[sVArray.length - 1].tok == 0x10000D;
                Object object = null;
                switch (sV.tok) {
                    case 4: {
                        String string6 = SV.sValue(sV);
                        if (bS != null) {
                            return false;
                        }
                        if (string2.equalsIgnoreCase("mf")) {
                            object = this.vwr.getSmilesMatcher().getMolecularFormula(string6, bl4);
                            break;
                        }
                        object = this.e.getSmilesExt().getSmilesMatches(string2, string6, null, null, bl4, !bl8);
                        break;
                    }
                    case 10: {
                        if (bl6) {
                            return scriptMathProcessor.addXStr(JmolMolecule.getMolecularFormula(this.vwr.getModelSet().at, (BS)sV.value, false));
                        }
                        if (bl2) {
                            return scriptMathProcessor.addXStr(this.vwr.getSmilesOpt((BS)sV.value, -1, -1, false, true, bl8, bl8, false));
                        }
                        if (bl3 || bl4) {
                            string = string2;
                        }
                        BS bS2 = bS;
                        if (bl7) {
                            int[][] nArray = this.vwr.getSmilesMatcher().getCorrelationMaps(string, this.vwr.ms.at, this.vwr.getAtomCount(), (BS)sV.value, !bl3, true);
                            object = nArray.length > 0 ? (Object)this.vwr.getDihedralMap(nArray[0]) : new int[]{};
                            break;
                        }
                        object = this.e.getSmilesExt().getSmilesMatches(string, null, (BS)sV.value, bS2, !bl3, !bl8);
                    }
                }
                if (object == null) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(object);
            }
        }
        catch (Exception exception) {
            this.e.evalError(exception.getMessage(), null);
        }
        boolean bl9 = string2.indexOf("v") >= 0;
        boolean bl10 = string2.indexOf("i") >= 0;
        boolean bl11 = string2.indexOf("m") >= 0;
        boolean bl12 = sV.tok == 7;
        boolean bl13 = bl = sVArray.length == 2;
        if (bl12 || bl) {
            JmolPatternMatcher jmolPatternMatcher = this.getPatternMatcher();
            Pattern pattern = null;
            try {
                pattern = jmolPatternMatcher.compile(string, bl10);
            }
            catch (Exception exception) {
                this.e.evalError(exception.toString(), null);
            }
            String[] stringArray = SV.listValue(sV);
            if (Logger.debugging) {
                Logger.debug("finding " + string);
            }
            BS bS = new BS();
            int n = 0;
            int n2 = 0;
            Matcher matcher = null;
            List<String> list = bl11 ? new List<String>() : null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = stringArray[i];
                matcher = pattern.matcher(string7);
                boolean bl14 = matcher.find();
                if ((!bl11 || !bl14) && (bl11 || bl14 != !bl9)) continue;
                ++n2;
                n = i;
                bS.set(i);
                if (!bl11) continue;
                list.addLast(bl9 ? string7.substring(0, matcher.start()) + string7.substring(matcher.end()) : matcher.group());
            }
            if (!bl12) {
                return bl11 ? scriptMathProcessor.addXStr(list.size() == 1 ? (String)list.get(0) : "") : (bl9 ? scriptMathProcessor.addXBool(n2 == 1) : (bl11 ? scriptMathProcessor.addXStr(n2 == 0 ? "" : matcher.group()) : scriptMathProcessor.addXInt(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (n2 == 1) {
                return scriptMathProcessor.addXStr(bl11 ? (String)list.get(0) : stringArray[n]);
            }
            String[] stringArray2 = new String[n2];
            if (n2 > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (!bS.get(n3)) continue;
                    String string8 = bl11 ? (String)list.get(--n2) : stringArray[n3];
                    stringArray2[n2] = string8;
                }
            }
            return scriptMathProcessor.addXAS(stringArray2);
        }
        return scriptMathProcessor.addXInt(SV.sValue(sV).indexOf(string) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        int n;
        Object object;
        int n2 = 0;
        String string = sVArray.length > n2 ? SV.sValue(sVArray[n2++]).toLowerCase() : "";
        boolean bl2 = false;
        if (string.equals("json") && sVArray.length > n2) {
            bl2 = true;
            string = SV.sValue(sVArray[n2++]);
        }
        if (string.startsWith("$")) {
            // empty if block
        }
        if (bl && !string.equalsIgnoreCase("bondInfo")) {
            string = "atomInfo." + string;
        }
        BS[] bSArray = "";
        if (string.equalsIgnoreCase("fileContents") && sVArray.length > 2) {
            object = SV.sValue(sVArray[1]);
            for (n = 2; n < sVArray.length; ++n) {
                object = (String)object + "|" + SV.sValue(sVArray[n]);
            }
            bSArray = object;
            n2 = sVArray.length;
        } else if (sVArray.length > n2) {
            switch (sVArray[n2].tok) {
                case 10: {
                    bSArray = SV.bsSelectVar(sVArray[n2++]);
                    if (!string.equalsIgnoreCase("bondInfo") || sVArray.length <= n2 || sVArray[n2].tok != 10) break;
                    bSArray = new BS[]{(BS)bSArray, SV.bsSelectVar(sVArray[n2])};
                    break;
                }
                case 4: {
                    if (!this.vwr.checkPropertyParameter(string)) break;
                    bSArray = sVArray[n2++].value;
                }
            }
        }
        if (bl) {
            object = scriptMathProcessor.getX();
            if (((SV)object).tok != 10) {
                return false;
            }
            n = SV.bsSelectVar((SV)object).nextSetBit(0);
            if (n < 0) {
                return scriptMathProcessor.addXStr("");
            }
            bSArray = BSUtil.newAndSetBit(n);
        }
        object = this.vwr.getProperty(null, string, bSArray);
        if (n2 < sVArray.length) {
            object = this.vwr.extractProperty(object, sVArray, n2);
        }
        if (bl && object instanceof List) {
            Object object2 = object = ((List)object).size() > 0 ? ((List)object).get(0) : "";
        }
        return scriptMathProcessor.addXObj(bl2 ? "{" + PT.toJSON("value", object) + "}" : (SV.isVariableType(object) ? object : Escape.toReadable(string, object)));
    }

    private boolean evaluateLabel(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        SV sV = sVArray.length < 2 ? scriptMathProcessor.getX() : null;
        String string = sVArray.length == 0 ? "%U" : SV.sValue(sVArray[0]);
        boolean bl = T.tokAttr(n, 480);
        if (sV == null) {
            if (sVArray.length < 2 || sVArray[1].tok != 7) {
                return scriptMathProcessor.addXStr(SV.sprintfArray(sVArray));
            }
            List<SV> list = sVArray[1].getList();
            SV[] sVArray2 = new SV[]{sVArray[0], null};
            String[] stringArray = new String[list.size()];
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                sVArray2[1] = (SV)list.get(n2);
                stringArray[n2] = SV.sprintfArray(sVArray2);
            }
            return scriptMathProcessor.addXAS(stringArray);
        }
        BS bS = SV.getBitSet(sV, true);
        if (bS == null) {
            return scriptMathProcessor.addXObj(SV.sprintf(Txt.formatCheck(string), sV));
        }
        return scriptMathProcessor.addXObj(this.e.getCmdExt().getBitsetIdent(bS, string, sV.value, true, sV.index, bl));
    }

    private boolean evaluateList(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        boolean bl;
        int n2 = sVArray.length;
        SV sV = scriptMathProcessor.getX();
        switch (n) {
            case 1276383749: {
                return n2 == 1 && scriptMathProcessor.addX(sV.pushPop(sVArray[0]));
            }
            case 1276383249: {
                return n2 == 0 && scriptMathProcessor.addX(sV.pushPop(null));
            }
            case 1276118017: {
                if (n2 == 1 || n2 == 2) break;
                return false;
            }
            default: {
                if (n2 == 1) break;
                return false;
            }
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (n2 == 2) {
            int n3 = sVArray[0].tok == 4 ? 0 : 1;
            String string = SV.sValue(sVArray[n3]);
            stringArray = sV.tok == 7 ? SV.listValue(sV) : PT.split(SV.sValue(sV), "\n");
            SV sV2 = sVArray[1 - n3];
            stringArray2 = sV2.tok == 7 ? SV.listValue(sV2) : PT.split(SV.sValue(sV2), "\n");
            n2 = Math.max(stringArray.length, stringArray2.length);
            stringArray3 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray3[i] = (i >= stringArray.length ? "" : stringArray[i]) + string + (i >= stringArray2.length ? "" : stringArray2[i]);
            }
            return scriptMathProcessor.addXAS(stringArray3);
        }
        SV sV3 = n2 == 0 ? SV.newV(0x100003, "all") : sVArray[0];
        boolean bl2 = bl = sV3.tok == 0x100003;
        if (sV.tok != 7 && sV.tok != 4) {
            return scriptMathProcessor.binaryOp(this.opTokenFor(n), sV, sV3);
        }
        boolean bl3 = SV.isScalar(sV);
        boolean bl4 = SV.isScalar(sV3);
        float[] fArray = null;
        float[] fArray2 = null;
        List<SV> list = sV.getList();
        List<SV> list2 = sV3.getList();
        if (sV.tok == 7) {
            n2 = list.size();
        } else if (bl3) {
            n2 = Integer.MAX_VALUE;
        } else {
            stringArray = PT.split(SV.sValue(sV), "\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            PT.parseFloatArrayData(stringArray, fArray);
        }
        if (bl) {
            float f = 0.0f;
            if (sV.tok == 7) {
                int n4 = n2;
                while (--n4 >= 0) {
                    f += SV.fValue((T)list.get(n4));
                }
            } else if (!bl3) {
                int n5 = n2;
                while (--n5 >= 0) {
                    f += fArray[n5];
                }
            }
            return scriptMathProcessor.addXFloat(f);
        }
        if (n == 1276117506 && sV3.tok == 4) {
            SB sB = new SB();
            if (bl3) {
                sB.append(SV.sValue(sV));
            } else {
                for (int i = 0; i < n2; ++i) {
                    sB.appendO(i > 0 ? sV3.value : null).append(SV.sValue((T)list.get(i)));
                }
            }
            return scriptMathProcessor.addXStr(sB.toString());
        }
        SV sV4 = null;
        if (bl4) {
            sV4 = sV3;
        } else if (sV3.tok == 7) {
            n2 = Math.min(n2, list2.size());
        } else {
            stringArray2 = PT.split(SV.sValue(sV3), "\n");
            fArray2 = new float[stringArray2.length];
            PT.parseFloatArrayData(stringArray2, fArray2);
            n2 = Math.min(n2, fArray2.length);
        }
        T t = this.opTokenFor(n);
        SV[] sVArray2 = new SV[n2];
        SV sV5 = bl3 ? sV : null;
        for (int i = 0; i < n2; ++i) {
            SV sV6 = bl4 ? sV4 : (sV3.tok == 7 ? (SV)list2.get(i) : (Float.isNaN(fArray2[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray2[i])) : SV.newV(3, Float.valueOf(fArray2[i]))));
            if (!bl3) {
                sV5 = sV.tok == 7 ? (SV)list.get(i) : (Float.isNaN(fArray[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(stringArray[i])) : SV.newV(3, Float.valueOf(fArray[i])));
            }
            if (n == 1276117506 && sV5.tok != 7) {
                List<SV> list3 = new List<SV>();
                list3.addLast(sV5);
                sV5 = SV.getVariableList(list3);
            }
            if (!scriptMathProcessor.binaryOp(t, sV5, sV6)) {
                return false;
            }
            sVArray2[i] = scriptMathProcessor.getX();
        }
        return scriptMathProcessor.addXAV(sVArray2);
    }

    private boolean evaluateLoad(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        boolean bl2;
        if (sVArray.length > 2 || sVArray.length < 1) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        string = string.replace('\\', '/');
        int n = sVArray.length == 2 ? sVArray[1].asInt() : -1;
        boolean bl3 = bl2 = sVArray.length == 2 && sVArray[1].tok == 0x10000D;
        if (bl2) {
            return scriptMathProcessor.addXMap(this.vwr.getFileAsMap(string));
        }
        if (this.vwr.isJS && string.startsWith("?")) {
            if (bl) {
                return scriptMathProcessor.addXStr("");
            }
            string = this.e.loadFileAsync("load()_", string, scriptMathProcessor.oPt, true);
        }
        return scriptMathProcessor.addXStr(bl ? this.vwr.getFilePath(string, false) : this.vwr.getFileAsString4(string, n, false, false, true));
    }

    private boolean evaluateMath(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) {
        if (n == 135266318) {
            if (sVArray.length == 1 && sVArray[0].tok == 4) {
                return scriptMathProcessor.addXStr(new Date() + "\t" + SV.sValue(sVArray[0]));
            }
            return scriptMathProcessor.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (sVArray.length == 0 ? 0 : sVArray[0].asInt()));
        }
        if (sVArray.length != 1) {
            return false;
        }
        if (n == 135266826) {
            if (sVArray[0].tok == 2) {
                return scriptMathProcessor.addXInt(Math.abs(sVArray[0].asInt()));
            }
            return scriptMathProcessor.addXFloat(Math.abs(sVArray[0].asFloat()));
        }
        double d = SV.fValue(sVArray[0]);
        switch (n) {
            case 135266819: {
                return scriptMathProcessor.addXFloat((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 135266821: {
                return scriptMathProcessor.addXFloat((float)Math.cos(d * Math.PI / 180.0));
            }
            case 135266820: {
                return scriptMathProcessor.addXFloat((float)Math.sin(d * Math.PI / 180.0));
            }
            case 135266822: {
                return scriptMathProcessor.addXFloat((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateMeasure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1746538509: {
                List<Object> list = new List<Object>();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                RadiusData radiusData = null;
                int n4 = 0;
                float f = Float.MAX_VALUE;
                boolean bl4 = false;
                boolean bl5 = false;
                block15: for (int i = 0; i < sVArray.length; ++i) {
                    switch (sVArray[i].tok) {
                        case 10: {
                            BS bS = (BS)sVArray[i].value;
                            if (bS.length() == 0) {
                                bl3 = true;
                            }
                            list.addLast(bS);
                            ++n2;
                            ++n4;
                            continue block15;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi();
                            point3fi.setT((P3)sVArray[i].value);
                            list.addLast(point3fi);
                            ++n2;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = SV.fValue(sVArray[i]);
                            continue block15;
                        }
                        case 4: {
                            String string3 = SV.sValue(sVArray[i]);
                            if (string3.equalsIgnoreCase("vdw") || string3.equalsIgnoreCase("vanderwaals")) {
                                f = (float)(i + 1 < sVArray.length && sVArray[i + 1].tok == 2 ? sVArray[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("minArray")) {
                                bl4 = n4 >= 1;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("asArray")) {
                                bl5 = n4 >= 1;
                                continue block15;
                            }
                            if (PT.isOneOf(string3.toLowerCase(), ";nm;nanometers;pm;picometers;angstroms;ang;au;") || string3.endsWith("hz")) {
                                string2 = string3.toLowerCase();
                                continue block15;
                            }
                            string = n2 + ":" + string3;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return scriptMathProcessor.addXStr("");
                }
                if (f != Float.MAX_VALUE && (n4 != 2 || n2 != 2)) {
                    return scriptMathProcessor.addXStr("");
                }
                radiusData = f == Float.MAX_VALUE ? new RadiusData(fArray, 0.0f, null, null) : new RadiusData(null, f, RadiusData.EnumType.FACTOR, VDW.AUTO);
                return scriptMathProcessor.addXObj(this.vwr.newMeasurementData(null, list).set(0, null, radiusData, string, string2, null, bl, bl2, null, true, 0, (short)0, null).getMeasurements(bl5, bl4));
            }
            case 0x8100001: {
                n2 = sVArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = sVArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        P3[] p3Array = new P3[n2];
        for (int i = 0; i < n2; ++i) {
            p3Array[i] = scriptMathProcessor.ptValue(sVArray[i], true);
        }
        switch (n2) {
            case 2: {
                return scriptMathProcessor.addXFloat(p3Array[0].distance(p3Array[1]));
            }
            case 3: {
                return scriptMathProcessor.addXFloat(Measure.computeAngleABC(p3Array[0], p3Array[1], p3Array[2], true));
            }
            case 4: {
                return scriptMathProcessor.addXFloat(Measure.computeTorsion(p3Array[0], p3Array[1], p3Array[2], p3Array[3], true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string = "D";
        float f = Float.NaN;
        P3 p3 = null;
        int n = -1;
        switch (sVArray.length) {
            case 0: {
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                string = SV.sValue(sVArray[0]).toUpperCase();
                f = SV.fValue(sVArray[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (n >= 0) {
            if (sVArray[n].tok == 8) {
                p3 = (P3)sVArray[n].value;
            } else {
                f = SV.fValue(sVArray[n]);
            }
        }
        if (p3 == null && (double)f < 1000000.0) {
            p3 = P3.new3(f, f, f);
        }
        BS bS = SV.getBitSet(scriptMathProcessor.getX(), false);
        return scriptMathProcessor.addXList(this.vwr.getModulationList(bS, string, p3));
    }

    private boolean evaluatePlane(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        block31: {
            if (n == 135267841 && sVArray.length != 3 || n == 135267842 && sVArray.length != 2 && sVArray.length != 3 || sVArray.length == 0 || sVArray.length > 4) {
                return false;
            }
            switch (sVArray.length) {
                case 1: {
                    Object object;
                    if (sVArray[0].tok == 10 && ((BS)(object = SV.getBitSet(sVArray[0], false))).cardinality() == 3) {
                        List<P3> list = this.vwr.getAtomPointVector((BS)object);
                        V3 v3 = new V3();
                        V3 v32 = new V3();
                        V3 v33 = new V3();
                        P4 p4 = new P4();
                        Measure.getPlaneThroughPoints((P3)list.get(0), (P3)list.get(1), (P3)list.get(2), v3, v32, v33, p4);
                        return scriptMathProcessor.addXPt4(p4);
                    }
                    object = Escape.uP(SV.sValue(sVArray[0]));
                    if (object instanceof P4) {
                        return scriptMathProcessor.addXPt4((P4)object);
                    }
                    return scriptMathProcessor.addXStr("" + object);
                }
                case 2: {
                    if (n == 135267842) {
                        if (sVArray[1].tok != 9) {
                            return false;
                        }
                        P3 p3 = new P3();
                        V3 v3 = new V3();
                        V3 v34 = new V3();
                        P4 p4 = (P4)sVArray[1].value;
                        if (sVArray[0].tok == 9) {
                            List<Object> list = Measure.getIntersectionPP((P4)sVArray[0].value, p4);
                            if (list == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            return scriptMathProcessor.addXList(list);
                        }
                        P3 p32 = scriptMathProcessor.ptValue(sVArray[0], false);
                        if (p32 == null) {
                            return scriptMathProcessor.addXStr("");
                        }
                        return scriptMathProcessor.addXPt(Measure.getIntersection(p32, null, p4, p3, v3, v34));
                    }
                }
                case 3: 
                case 4: {
                    switch (n) {
                        case 135267841: {
                            return scriptMathProcessor.addXPt4(this.e.getHklPlane(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2]))));
                        }
                        case 135267842: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], false);
                            P3 p33 = scriptMathProcessor.ptValue(sVArray[1], false);
                            if (p3 == null || p33 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v3 = V3.newV(p33);
                            v3.normalize();
                            if (sVArray[2].tok == 9) {
                                P3 p34 = new P3();
                                V3 v35 = new V3();
                                V3 v36 = new V3();
                                if ((p3 = Measure.getIntersection(p3, v3, (P4)sVArray[2].value, p34, v35, v36)) == null) {
                                    return scriptMathProcessor.addXStr("");
                                }
                                return scriptMathProcessor.addXPt(p3);
                            }
                            P3 p35 = scriptMathProcessor.ptValue(sVArray[2], false);
                            if (p35 == null) {
                                return scriptMathProcessor.addXStr("");
                            }
                            V3 v37 = new V3();
                            Measure.projectOntoAxis(p35, p3, v3, v37);
                            return scriptMathProcessor.addXPt(p35);
                        }
                    }
                    switch (sVArray[0].tok) {
                        case 2: 
                        case 3: {
                            if (sVArray.length == 3) {
                                float f = SV.fValue(sVArray[0]);
                                float f2 = SV.fValue(sVArray[1]);
                                float f3 = SV.fValue(sVArray[2]);
                                V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
                                P3 p3 = P3.new3(0.0f, 1.0f, 0.0f);
                                Quat quat = Quat.newVA(p3, f3);
                                quat.getMatrix().rotate(v3);
                                p3.set(0.0f, 0.0f, 1.0f);
                                quat = Quat.newVA(p3, f2);
                                quat.getMatrix().rotate(v3);
                                p3.setT(v3);
                                p3.scale(f);
                                P4 p4 = new P4();
                                Measure.getPlaneThroughPoint(p3, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            break block31;
                        }
                        case 8: 
                        case 10: {
                            P3 p3 = scriptMathProcessor.ptValue(sVArray[0], false);
                            P3 p36 = scriptMathProcessor.ptValue(sVArray[1], false);
                            if (p36 == null) {
                                return false;
                            }
                            P3 p37 = sVArray.length > 2 && (sVArray[2].tok == 10 || sVArray[2].tok == 8) ? scriptMathProcessor.ptValue(sVArray[2], false) : null;
                            V3 v3 = V3.newV(p36);
                            if (p37 == null) {
                                P4 p4 = new P4();
                                if (sVArray.length == 2 || !sVArray[2].asBoolean()) {
                                    p37 = P3.newP(p3);
                                    p37.add(p36);
                                    p37.scale(0.5f);
                                    v3.sub(p3);
                                    v3.normalize();
                                } else {
                                    p37 = p3;
                                }
                                Measure.getPlaneThroughPoint(p37, v3, p4);
                                return scriptMathProcessor.addXPt4(p4);
                            }
                            V3 v38 = new V3();
                            V3 v39 = new V3();
                            float f = Measure.getDirectedNormalThroughPoints(p3, p36, p37, sVArray.length == 4 ? scriptMathProcessor.ptValue(sVArray[3], true) : null, v3, v38, v39);
                            return scriptMathProcessor.addXPt4(P4.new4(v3.x, v3.y, v3.z, f));
                        }
                    }
                }
            }
        }
        if (sVArray.length != 4) {
            return false;
        }
        float f = SV.fValue(sVArray[0]);
        float f4 = SV.fValue(sVArray[1]);
        float f5 = SV.fValue(sVArray[2]);
        float f6 = SV.fValue(sVArray[3]);
        return scriptMathProcessor.addXPt4(P4.new4(f, f4, f5, f6));
    }

    private boolean evaluatePoint(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length != 1 && sVArray.length != 3 && sVArray.length != 4) {
            return false;
        }
        switch (sVArray.length) {
            case 1: {
                Object object;
                if (sVArray[0].tok == 3 || sVArray[0].tok == 2) {
                    return scriptMathProcessor.addXInt(sVArray[0].asInt());
                }
                String string = SV.sValue(sVArray[0]);
                if (sVArray[0].tok == 7) {
                    string = "{" + string + "}";
                }
                if ((object = Escape.uP(string)) instanceof P3) {
                    return scriptMathProcessor.addXPt((P3)object);
                }
                return scriptMathProcessor.addXStr("" + object);
            }
            case 3: {
                return scriptMathProcessor.addXPt(P3.new3(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat()));
            }
            case 4: {
                return scriptMathProcessor.addXPt4(P4.new4(sVArray[0].asFloat(), sVArray[1].asFloat(), sVArray[2].asFloat(), sVArray[3].asFloat()));
            }
        }
        return false;
    }

    private boolean evaluatePrompt(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        boolean bl;
        if (sVArray.length != 1 && sVArray.length != 2 && sVArray.length != 3) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        String[] stringArray = sVArray.length > 1 && sVArray[1].tok == 7 ? SV.listValue(sVArray[1]) : null;
        boolean bl2 = bl = stringArray != null || sVArray.length == 1 || sVArray.length == 3 && sVArray[2].asBoolean();
        String string2 = stringArray != null ? null : (sVArray.length >= 2 ? SV.sValue(sVArray[1]) : "OK");
        String string3 = "" + this.vwr.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? scriptMathProcessor.addXInt(Integer.parseInt(string3) + 1) : scriptMathProcessor.addXStr(string3);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        Object object;
        P3 p3 = null;
        int n2 = sVArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 135270418) {
            if (n2 > 1 && sVArray[n2 - 1].tok == 4 && ((String)sVArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && sVArray[n2 - 1].tok == 2 && sVArray[0].tok == 10) {
                n3 = sVArray[n2 - 1].asInt();
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 135270418 && (sVArray[0].tok == 7 && (sVArray[1].tok == 7 || sVArray[1].tok == 0x10000D) || sVArray[0].tok == 10 && (sVArray[1].tok == 2 || sVArray[1].tok == 10)) || (p3 = scriptMathProcessor.ptValue(sVArray[0], false)) != null && (n == 135270418 || sVArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 135270418) {
                    return false;
                }
                if (sVArray[0].tok == 9) {
                    if (sVArray[2].tok == 8 || sVArray[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (sVArray[i].tok == 8 || sVArray[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat quat = null;
        Quat[] quatArray = null;
        P4 p4 = null;
        switch (n2) {
            case 0: {
                return scriptMathProcessor.addXPt4(Quat.newQ(this.vwr.getRotationQuaternion()).toPoint4f());
            }
            default: {
                Object object2;
                if (n == 135270418 && sVArray[0].tok == 7) {
                    object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                    object2 = Quat.sphereMean((Quat[])object, null, 1.0E-4f);
                    quat = object2 instanceof Quat ? (Quat)object2 : null;
                    break;
                }
                if (n == 135270418 && sVArray[0].tok == 10) {
                    quatArray = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, n3);
                } else if (sVArray[0].tok == 11) {
                    quat = Quat.newM((M3)sVArray[0].value);
                } else if (sVArray[0].tok == 9) {
                    p4 = (P4)sVArray[0].value;
                } else {
                    object = SV.sValue(sVArray[0]);
                    object2 = Escape.uP((String)(((String)object).equalsIgnoreCase("best") ? this.vwr.getOrientationText(1073741863, null) : object));
                    if (!(object2 instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)object2;
                }
                if (n != 135266307) break;
                quat = Quat.newVA(P3.new3(p4.x, p4.y, p4.z), p4.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 135270418) {
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 7) {
                        object = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        object2 = this.e.getQuaternionArray(sVArray[1].getList(), 1073742001);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                    if (sVArray[0].tok == 7 && sVArray[1].tok == 0x10000D) {
                        Quat[] quatArray2 = this.e.getQuaternionArray(sVArray[0].getList(), 1073742001);
                        float[] fArray = new float[1];
                        Quat.sphereMean(quatArray2, fArray, 1.0E-4f);
                        return scriptMathProcessor.addXFloat(fArray[0]);
                    }
                    if (sVArray[0].tok == 10 && sVArray[1].tok == 10) {
                        object = this.vwr.getAtomGroupQuaternions((BS)sVArray[0].value, Integer.MAX_VALUE);
                        object2 = this.vwr.getAtomGroupQuaternions((BS)sVArray[1].value, Integer.MAX_VALUE);
                        quatArray = Quat.div((Quat[])object2, (Quat[])object, n3, bl);
                        break;
                    }
                }
                object = scriptMathProcessor.ptValue(sVArray[1], false);
                p4 = scriptMathProcessor.planeValue(sVArray[0]);
                if (object != null) {
                    quat = Quat.getQuaternionFrame(P3.new3(0.0f, 0.0f, 0.0f), p3, (T3)object);
                    break;
                }
                quat = Quat.newVA(p3, SV.fValue(sVArray[1]));
                break;
            }
            case 3: {
                if (sVArray[0].tok == 9) {
                    P3 p32 = sVArray[2].tok == 8 ? (P3)sVArray[2].value : this.vwr.getAtomSetCenter((BS)sVArray[2].value);
                    return scriptMathProcessor.addXStr(Escape.drawQuat(Quat.newP4((P4)sVArray[0].value), "q", SV.sValue(sVArray[1]), p32, 1.0f));
                }
                Object object2 = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    object2[i] = sVArray[i].tok == 8 ? (P3)sVArray[i].value : this.vwr.getAtomSetCenter((BS)sVArray[i].value);
                }
                quat = Quat.getQuaternionFrame(object2[0], object2[1], object2[2]);
                break;
            }
            case 4: {
                if (n == 135270418) {
                    p4 = P4.new4(SV.fValue(sVArray[1]), SV.fValue(sVArray[2]), SV.fValue(sVArray[3]), SV.fValue(sVArray[0]));
                    break;
                }
                quat = Quat.newVA(P3.new3(SV.fValue(sVArray[0]), SV.fValue(sVArray[1]), SV.fValue(sVArray[2])), SV.fValue(sVArray[3]));
            }
        }
        if (quatArray != null) {
            if (n3 != Integer.MAX_VALUE) {
                object = new List();
                for (int i = 0; i < quatArray.length; ++i) {
                    ((List)object).addLast(quatArray[i].toPoint4f());
                }
                return scriptMathProcessor.addXList((List<?>)object);
            }
            quat = quatArray.length > 0 ? quatArray[0] : null;
        }
        return scriptMathProcessor.addXPt4((quat == null ? Quat.newP4(p4) : quat).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) {
        if (sVArray.length > 2) {
            return false;
        }
        float f = sVArray.length < 2 ? 0.0f : SV.fValue(sVArray[0]);
        float f2 = sVArray.length == 0 ? 1.0f : SV.fValue(sVArray[sVArray.length - 1]);
        return scriptMathProcessor.addXFloat((float)(Math.random() * (double)(f2 -= f)) + f);
    }

    private boolean evaluateRowCol(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length != 1) {
            return false;
        }
        int n2 = sVArray[0].asInt() - 1;
        SV sV = scriptMathProcessor.getX();
        switch (sV.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M3 m3 = (M3)sV.value;
                switch (n) {
                    case 1276117515: {
                        float[] fArray = new float[3];
                        m3.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[3];
                m3.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                M4 m4 = (M4)sV.value;
                switch (n) {
                    case 1276117515: {
                        float[] fArray = new float[4];
                        m4.getRow(n2, fArray);
                        return scriptMathProcessor.addXAF(fArray);
                    }
                }
                float[] fArray = new float[4];
                m4.getColumn(n2, fArray);
                return scriptMathProcessor.addXAF(fArray);
            }
        }
        return false;
    }

    private boolean evaluateReplace(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        String string;
        if (sVArray.length != 2) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        String string2 = SV.sValue(sVArray[0]);
        String string3 = SV.sValue(sVArray[1]);
        String string4 = string = sV.tok == 7 ? null : SV.sValue(sV);
        if (string != null) {
            return scriptMathProcessor.addXStr(PT.rep(string, string2, string3));
        }
        String[] stringArray = SV.listValue(sV);
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = PT.rep(stringArray[n], string2, string3);
        }
        return scriptMathProcessor.addXAS(stringArray);
    }

    private boolean evaluateScript(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (n == 135287308 && sVArray.length != 1 || sVArray.length == 0 || sVArray.length > 2) {
            return false;
        }
        String string = SV.sValue(sVArray[0]);
        SB sB = new SB();
        switch (n) {
            case 135271429: {
                String string2;
                String string3 = string2 = sVArray.length == 2 ? SV.sValue(sVArray[1]) : ".";
                if (!string2.equals(".")) {
                    sB.append(this.vwr.jsEval(string2 + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.e.runScriptBuffer(string, sB);
                break;
            }
            case 135287308: {
                sB.append(this.vwr.jsEval(string));
            }
        }
        string = sB.toString();
        float f = PT.parseFloatStrict(string);
        return Float.isNaN(f) ? scriptMathProcessor.addXStr(string) : (string.indexOf(".") >= 0 ? scriptMathProcessor.addXFloat(f) : scriptMathProcessor.addXInt(PT.parseInt(string)));
    }

    private boolean evaluateSort(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        SV sV;
        if (sVArray.length > 1) {
            return false;
        }
        if (n == 1276117011) {
            int n2 = sVArray.length == 0 ? 0 : sVArray[0].asInt();
            return scriptMathProcessor.addX(scriptMathProcessor.getX().sortOrReverse(n2));
        }
        SV sV2 = scriptMathProcessor.getX();
        SV sV3 = sV = sVArray.length == 0 ? null : sVArray[0];
        if (sV2.tok == 4) {
            int n3;
            int n4 = 0;
            String string = SV.sValue(sV2);
            if (sV == null) {
                return scriptMathProcessor.addXInt(0);
            }
            String string2 = SV.sValue(sV);
            for (int i = 0; i < string.length() && (n3 = string.indexOf(string2, i)) >= 0; ++i) {
                ++n4;
                i = n3;
            }
            return scriptMathProcessor.addXInt(n4);
        }
        List<SV> list = new List<SV>();
        SV sV4 = null;
        SV sV5 = null;
        List<SV> list2 = SV.getVariable(sV2.value).sortOrReverse(0).getList();
        if (list2 == null) {
            return sV == null ? scriptMathProcessor.addXStr("") : scriptMathProcessor.addXInt(0);
        }
        int n5 = list2.size();
        for (int i = 0; i <= n5; ++i) {
            SV sV6;
            SV sV7 = sV6 = i == n5 ? null : (SV)list2.get(i);
            if (sV != null && sV6 != null && !SV.areEqual(sV6, sV)) continue;
            if (SV.areEqual(sV6, sV4)) {
                ++sV5.intValue;
                continue;
            }
            if (sV4 != null) {
                List<SV> list3 = new List<SV>();
                list3.addLast(sV4);
                list3.addLast(sV5);
                list.addLast(SV.getVariableList(list3));
            }
            sV5 = SV.newI(1);
            sV4 = sV6;
        }
        if (sV == null) {
            return scriptMathProcessor.addX(SV.getVariableList(list));
        }
        if (list.isEmpty()) {
            return scriptMathProcessor.addXInt(0);
        }
        return scriptMathProcessor.addX((SV)((SV)list.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor scriptMathProcessor, int n, SV[] sVArray) throws ScriptException {
        String string;
        if (sVArray.length > 1) {
            return false;
        }
        SV sV = scriptMathProcessor.getX();
        if (sV.tok == 7 && n != 1276117510 && n != 1276117512) {
            scriptMathProcessor.addX(sV);
            return this.evaluateList(scriptMathProcessor, n, sVArray);
        }
        String string2 = string = n == 1276117510 && sV.tok == 10 || n == 1276117512 && sV.tok == 7 ? null : SV.sValue(sV);
        String string3 = sVArray.length == 1 ? SV.sValue(sVArray[0]) : (n == 1276117512 ? "" : "\n");
        switch (n) {
            case 1276117510: {
                if (sV.tok == 10) {
                    BS bS = SV.bsSelectVar(sV);
                    string3 = "\n";
                    int n2 = this.vwr.getModelCount();
                    string = "";
                    for (int i = 0; i < n2; ++i) {
                        string = string + (i == 0 ? "" : "\n");
                        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(i);
                        bS2.and(bS);
                        string = string + Escape.eBS(bS2);
                    }
                }
                return scriptMathProcessor.addXAS(PT.split(string, string3));
            }
            case 1276117506: {
                if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
                return scriptMathProcessor.addXStr(PT.rep(string, "\n", string3));
            }
            case 1276117512: {
                if (string != null) {
                    return scriptMathProcessor.addXStr(PT.trim(string, string3));
                }
                String[] stringArray = SV.listValue(sV);
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    stringArray[n3] = PT.trim(stringArray[n3], string3);
                }
                return scriptMathProcessor.addXAS(stringArray);
            }
        }
        return scriptMathProcessor.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, int n) throws ScriptException {
        if (sVArray.length == 0) {
            return false;
        }
        BS bS = new BS();
        String string = SV.sValue(sVArray[0]);
        if (string.length() > 0) {
            try {
                BS bS2 = sVArray.length == 2 && sVArray[1].tok == 10 ? SV.bsSelectVar(sVArray[1]) : null;
                bS = this.vwr.getSmilesMatcher().getSubstructureSet(string, this.vwr.getModelSet().at, this.vwr.getAtomCount(), bS2, n != 135267336, false);
            }
            catch (Exception exception) {
                this.e.evalError(exception.getMessage(), null);
            }
        }
        return scriptMathProcessor.addXBs(bS);
    }

    private boolean evaluateSymop(ScriptMathProcessor scriptMathProcessor, SV[] sVArray, boolean bl) throws ScriptException {
        P3 p3;
        String string;
        SV sV;
        if (sVArray.length == 0) {
            return false;
        }
        SV sV2 = sV = bl ? scriptMathProcessor.getX() : null;
        if (sV != null && sV.tok != 10) {
            return false;
        }
        BS bS = sV != null ? (BS)sV.value : (sVArray.length > 2 && sVArray[1].tok == 10 ? (BS)sVArray[1].value : this.vwr.getAllAtoms());
        switch (sVArray[0].tok) {
            case 4: {
                string = SV.sValue(sVArray[0]);
                break;
            }
            case 12: {
                string = sVArray[0].escape();
                break;
            }
            default: {
                string = null;
            }
        }
        int n = string == null ? sVArray[0].asInt() : 0;
        P3 p32 = p3 = sVArray.length > 1 ? scriptMathProcessor.ptValue(sVArray[1], true) : null;
        if (sVArray.length == 2 && !Float.isNaN(p3.x)) {
            return scriptMathProcessor.addXObj(this.vwr.getSymmetryInfo(bS, string, n, p3, null, null, 0x8100010));
        }
        String string2 = (sVArray.length == 1 ? "" : SV.sValue(sVArray[sVArray.length - 1])).toLowerCase();
        int n2 = 135176;
        if (sVArray.length == 1 || string2.equalsIgnoreCase("matrix")) {
            n2 = 12;
        } else if (string2.equalsIgnoreCase("array") || string2.equalsIgnoreCase("list")) {
            n2 = 1073742001;
        } else if (string2.equalsIgnoreCase("description")) {
            n2 = 1826248716;
        } else if (string2.equalsIgnoreCase("xyz")) {
            n2 = 1073741982;
        } else if (string2.equalsIgnoreCase("translation")) {
            n2 = 1073742178;
        } else if (string2.equalsIgnoreCase("axis")) {
            n2 = 1073741854;
        } else if (string2.equalsIgnoreCase("plane")) {
            n2 = 135266319;
        } else if (string2.equalsIgnoreCase("angle")) {
            n2 = 0x8100001;
        } else if (string2.equalsIgnoreCase("axispoint")) {
            n2 = 0x8100010;
        } else if (string2.equalsIgnoreCase("center")) {
            n2 = 12289;
        }
        return scriptMathProcessor.addXObj(this.vwr.getSymmetryInfo(bS, string, n, p3, null, string2, n2));
    }

    private boolean evaluateTensor(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length > 2) {
            return false;
        }
        BS bS = SV.getBitSet(scriptMathProcessor.getX(), false);
        String string = sVArray.length == 0 ? null : SV.sValue(sVArray[0]).toLowerCase();
        JmolNMRInterface jmolNMRInterface = this.vwr.getNMRCalculation();
        if ("unique".equals(string)) {
            return scriptMathProcessor.addXBs(jmolNMRInterface.getUniqueTensorSet(bS));
        }
        String string2 = sVArray.length < 2 ? null : SV.sValue(sVArray[1]).toLowerCase();
        return scriptMathProcessor.addXList(jmolNMRInterface.getTensorInfo(string, string2, bS));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor scriptMathProcessor, String string, SV[] sVArray, int n, boolean bl) throws ScriptException {
        SV sV = null;
        if (bl) {
            sV = scriptMathProcessor.getX();
            if (sV.tok != 10) {
                return false;
            }
        }
        scriptMathProcessor.wasX = false;
        List<SV> list = new List<SV>();
        for (int i = 0; i < sVArray.length; ++i) {
            list.addLast(sVArray[i]);
        }
        if (bl) {
            return scriptMathProcessor.addXObj(this.e.getBitsetProperty(SV.bsSelectVar(sV), n, null, null, sV.value, new Object[]{string, list}, false, sV.index, false));
        }
        SV sV2 = this.e.getUserFunctionResult(string, list, null);
        return sV2 == null ? false : scriptMathProcessor.addX(sV2);
    }

    private boolean evaluateWithin(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        BS bS;
        Object object;
        boolean bl;
        if (sVArray.length < 1 || sVArray.length > 5) {
            return false;
        }
        int n = sVArray.length;
        float f = 0.0f;
        Object object2 = sVArray[0].value;
        String string = "" + object2;
        int n2 = sVArray[0].tok;
        if (n2 == 4) {
            n2 = T.getTokFromName(string);
        }
        boolean bl2 = bl = n2 == 1649412120;
        if (bl) {
            f = 100.0f;
            object2 = null;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl || n2 == 3 || n2 == 2;
        RadiusData radiusData = null;
        switch (n2) {
            case 0x100004: {
                if (n != 3 || !(sVArray[1].value instanceof BS) || !(sVArray[2].value instanceof BS)) {
                    return false;
                }
                return scriptMathProcessor.addXBs(this.vwr.getBranchBitSet(((BS)sVArray[2].value).nextSetBit(0), ((BS)sVArray[1].value).nextSetBit(0), true));
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                BS bS2 = null;
                boolean bl6 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl7 = bl6 = sVArray[2].tok == 10;
                        if (!bl6) break;
                        bS2 = (BS)sVArray[2].value;
                        break;
                    }
                    default: {
                        bl6 = false;
                    }
                }
                if (!bl6) {
                    this.e.invArg();
                }
                return scriptMathProcessor.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue(sVArray[1]), null, bS2, null, n2 == 135267335, scriptMathProcessor.asBitSet));
            }
        }
        if (object2 instanceof String) {
            if (n2 == 0) {
                n2 = 1048614;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (bl5) {
            if (!bl) {
                f = SV.fValue(sVArray[0]);
            }
            if (n < 2) {
                return false;
            }
            n2 = sVArray[1].tok;
            switch (n2) {
                case 0x10000C: 
                case 0x10000D: {
                    bl3 = sVArray[1].asBoolean();
                    n = 0;
                    break;
                }
                case 4: {
                    object = SV.sValue(sVArray[1]);
                    if (((String)object).startsWith("$")) {
                        return scriptMathProcessor.addXBs(this.getAtomsNearSurface(f, ((String)object).substring(1)));
                    }
                    bl4 = ((String)object).equalsIgnoreCase("group");
                    bl = ((String)object).equalsIgnoreCase("vanderwaals");
                    if (bl) {
                        object2 = null;
                        n2 = 1649412120;
                        break;
                    }
                    n2 = 1087373318;
                }
            }
        } else {
            return false;
        }
        object = null;
        P4 p4 = null;
        block12 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x300020: 
                    case 137363467: 
                    case 1679429641: {
                        return scriptMathProcessor.addXBs(this.vwr.getAtomBits(n2, null));
                    }
                    case 1073741864: {
                        return scriptMathProcessor.addXBs(this.vwr.getAtomBits(n2, ""));
                    }
                    case 1048614: {
                        return scriptMathProcessor.addXBs(this.vwr.getAtomBits(1087373320, string));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1048614: {
                        n2 = 1087373320;
                        break block12;
                    }
                    case 1073741864: 
                    case 1087373320: 
                    case 1087375361: 
                    case 1087375362: {
                        return scriptMathProcessor.addXBs(this.vwr.getAtomBits(n2, SV.sValue(sVArray[sVArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0x100005: 
                    case 0x10000C: 
                    case 0x10000D: 
                    case 135266319: 
                    case 135267841: 
                    case 1087373318: 
                    case 1649412120: {
                        break block12;
                    }
                    case 1087373320: {
                        string = SV.sValue(sVArray[2]);
                        break block12;
                    }
                }
                return false;
            }
        }
        n = sVArray.length - 1;
        if (sVArray[n].value instanceof P4) {
            p4 = (P4)sVArray[n].value;
        } else if (sVArray[n].value instanceof P3) {
            object = (P3)sVArray[n].value;
            if (SV.sValue(sVArray[1]).equalsIgnoreCase("hkl")) {
                p4 = this.e.getHklPlane((P3)object);
            }
        }
        if (n > 0 && p4 == null && object == null && !(sVArray[n].value instanceof BS)) {
            return false;
        }
        if (p4 != null) {
            return scriptMathProcessor.addXBs(this.vwr.getAtomsNearPlane(f, p4));
        }
        if (object != null) {
            return scriptMathProcessor.addXBs(this.vwr.getAtomsNearPt(f, (P3)object));
        }
        BS bS3 = bS = sVArray[n].tok == 10 ? SV.bsSelectVar(sVArray[n]) : null;
        if (n2 == 1087373320) {
            return scriptMathProcessor.addXBs(this.vwr.getSequenceBits(string, bS));
        }
        if (bS == null) {
            bS = new BS();
        }
        if (!bl5) {
            return scriptMathProcessor.addXBs(this.vwr.getAtomBits(n2, bS));
        }
        if (bl4) {
            return scriptMathProcessor.addXBs(this.vwr.getGroupsWithin((int)f, bS));
        }
        if (bl) {
            radiusData = new RadiusData(null, f > 10.0f ? f / 100.0f : f, f > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        }
        return scriptMathProcessor.addXBs(this.vwr.getAtomsWithinRadius(f, bS, bl3, radiusData));
    }

    private boolean evaluateWrite(ScriptMathProcessor scriptMathProcessor, SV[] sVArray) throws ScriptException {
        if (sVArray.length == 0) {
            return false;
        }
        if (sVArray.length == 1 && sVArray[0].tok == 4 && sVArray[0].asString().equalsIgnoreCase("PNGJ")) {
            return scriptMathProcessor.addXMap(this.vwr.getFileAsMap(null));
        }
        return scriptMathProcessor.addXStr(this.e.getCmdExt().write(sVArray));
    }

    private BS getAtomsNearSurface(float f, String string) {
        Object[] objectArray = new Object[]{string, null, null};
        if (this.e.getShapePropertyData(24, "getVertices", objectArray)) {
            return this.vwr.getAtomsNearPts(f, (P3[])objectArray[1], (BS)objectArray[2]);
        }
        objectArray[1] = 0;
        objectArray[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", objectArray)) {
            return this.vwr.getAtomsNearPt(f, (P3)objectArray[2]);
        }
        return new BS();
    }

    private float getDistance(ScriptMathProcessor scriptMathProcessor, SV sV, SV sV2, int n) throws ScriptException {
        P3 p3 = scriptMathProcessor.ptValue(sV, true);
        P4 p4 = scriptMathProcessor.planeValue(sV);
        P3 p32 = scriptMathProcessor.ptValue(sV2, true);
        P4 p42 = scriptMathProcessor.planeValue(sV2);
        if (n == 1276117505) {
            if (p4 != null && p42 != null) {
                return p4.x * p42.x + p4.y * p42.y + p4.z * p42.z + p4.w * p42.w;
            }
            if (p4 != null) {
                p3 = P3.new3(p4.x, p4.y, p4.z);
            }
            if (p42 != null) {
                p32 = P3.new3(p42.x, p42.y, p42.z);
            }
            return p3.x * p32.x + p3.y * p32.y + p3.z * p32.z;
        }
        if (p4 == null) {
            return p42 == null ? p32.distance(p3) : Measure.distanceToPlane(p42, p3);
        }
        return Measure.distanceToPlane(p4, p32);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getMinMax(Object object, int n) {
        double d;
        float[] fArray = null;
        List list = null;
        int n2 = 0;
        if (PT.isAF(object)) {
            fArray = (float[])object;
            n2 = fArray.length;
            if (n2 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof List) || (n2 = (list = (List)object).size()) == 0) return "NaN";
            SV sV = (SV)list.get(0);
            if (sV.tok == 4 && ((String)sV.value).startsWith("{")) {
                P3 p3 = SV.ptValue(sV);
                if (p3 instanceof P3) {
                    return this.getMinMaxPoint(list, n);
                }
                if (!(p3 instanceof P4)) return "NaN";
                return this.getMinMaxQuaternion(list, n);
            }
        }
        switch (n) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            float f;
            float f2 = f = fArray == null ? SV.fValue((T)list.get(n4)) : fArray[n4];
            if (Float.isNaN(f)) continue;
            ++n3;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 32: {
                    if (!((double)f < d)) break;
                    d = f;
                    break;
                }
                case 64: {
                    if (!((double)f > d)) break;
                    d = f;
                }
            }
        }
        if (n3 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n3;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n3 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n3) / (double)(n3 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: 
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private Object getMinMaxPoint(Object object, int n) {
        P3[] p3Array = null;
        List list = null;
        int n2 = 0;
        if (object instanceof Quat[]) {
            p3Array = (P3[])object;
            n2 = p3Array.length;
        } else if (object instanceof List) {
            list = (List)object;
            n2 = list.size();
        }
        if (list != null || p3Array != null) {
            P3 p3 = new P3();
            float[] fArray = new float[n2];
            boolean bl = true;
            block10: for (int i = 0; i < 3 && bl; ++i) {
                Object object2;
                block11: for (int j = 0; j < n2; ++j) {
                    P3 p32;
                    P3 p33 = p32 = p3Array == null ? SV.ptValue((SV)list.get(j)) : p3Array[j];
                    if (p32 == null) {
                        bl = false;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            fArray[j] = p32.x;
                            continue block11;
                        }
                        case 1: {
                            fArray[j] = p32.y;
                            continue block11;
                        }
                        case 2: {
                            fArray[j] = p32.z;
                        }
                    }
                }
                if (!bl || !((object2 = this.getMinMax(fArray, n)) instanceof Float)) break;
                float f = ((Float)object2).floatValue();
                switch (i) {
                    case 0: {
                        p3.x = f;
                        continue block10;
                    }
                    case 1: {
                        p3.y = f;
                        continue block10;
                    }
                    case 2: {
                        p3.z = f;
                    }
                }
            }
            return p3;
        }
        return "NaN";
    }

    private Object getMinMaxQuaternion(List<SV> list, int n) {
        block7: {
            switch (n) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quat[] quatArray = this.e.getQuaternionArray(list, 1073742001);
            if (quatArray == null) break block7;
            float[] fArray = new float[1];
            Quat quat = Quat.sphereMean(quatArray, fArray, 1.0E-4f);
            switch (n) {
                case 96: {
                    return quat;
                }
                case 192: {
                    return Float.valueOf(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    private JmolPatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (JmolPatternMatcher)Interface.getUtil("PatternMatcher")) : this.pm;
    }

    private T opTokenFor(int n) {
        switch (n) {
            case 1276117506: 
            case 1276118017: {
                return T.tokenPlus;
            }
            case 1276117511: {
                return T.tokenMinus;
            }
            case 1276117507: {
                return T.tokenTimes;
            }
            case 1276117508: {
                return T.tokenMul3;
            }
            case 1276117504: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    @Override
    public BS setContactBitSets(BS bS, BS bS2, boolean bl, float f, RadiusData radiusData, boolean bl2) {
        int n;
        BS bS3;
        boolean bl3;
        if (bS2 == null) {
            bS2 = BSUtil.setAll(this.vwr.getAtomCount());
            BSUtil.andNot(bS2, this.vwr.getDeletedAtoms());
            bS2.andNot(bS);
            bl3 = false;
        } else {
            bS3 = BSUtil.copy(bS);
            bS3.or(bS2);
            n = this.vwr.getModelBitSet(bS3, false).cardinality();
            boolean bl4 = bl3 = n > 1;
            if (bl2 && n > 1 && !this.e.tQuiet) {
                this.e.showString(GT._("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bS.equals(bS2)) {
            int n2 = n = !bl || bS.cardinality() < bS2.cardinality() ? 1 : 0;
            if (n != 0) {
                bS3 = this.vwr.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                bS2.and(bS3);
            }
            if (bl) {
                bS3 = this.vwr.getAtomsWithinRadius(f, bS2, bl3, Float.isNaN(f) ? radiusData : null);
                bS.and(bS3);
                if (n == 0) {
                    bS3 = this.vwr.getAtomsWithinRadius(f, bS, bl3, Float.isNaN(f) ? radiusData : null);
                    bS2.and(bS3);
                }
                bS3 = BSUtil.copy(bS2);
                bS3.and(bS);
                if (bS3.equals(bS)) {
                    bS2.andNot(bS);
                } else if (bS3.equals(bS2)) {
                    bS.andNot(bS2);
                }
            }
        }
        return bS2;
    }
}

