/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.A4;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.render.MeshRenderer;
import org.jmol.shape.Mesh;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.Measure;

public class DrawRenderer
extends MeshRenderer {
    private Draw.EnumDrawType drawType;
    private DrawMesh dmesh;
    private P3[] controlHermites;
    protected P3 pt0 = new P3();
    protected P3 pt1 = new P3();
    protected P3 pt2 = new P3();
    protected final V3 vTemp = new V3();
    protected final V3 vTemp2 = new V3();
    private final P3 pt0f = new P3();
    protected P3i pt0i = new P3i();
    private final BS bsHandles = new BS();

    @Override
    protected boolean render() {
        this.needTranslucent = false;
        this.imageFontScaling = this.vwr.getImageFontScaling();
        Draw draw = (Draw)this.shape;
        int n = draw.meshCount;
        while (--n >= 0) {
            this.dmesh = (DrawMesh)draw.meshes[n];
            if (!this.renderMesh(this.dmesh)) continue;
            this.renderInfo();
        }
        return this.needTranslucent;
    }

    @Override
    protected boolean isPolygonDisplayable(int n) {
        return Draw.isPolygonDisplayable(this.dmesh, n) && (this.dmesh.modelFlags == null || this.dmesh.bsMeshesVisible.get(n));
    }

    @Override
    public boolean renderMesh(Mesh mesh) {
        if (mesh.connections != null) {
            if (mesh.connections[0] < 0) {
                return false;
            }
            mesh.vs = new P3[4];
            mesh.vc = 4;
            int[] nArray = mesh.connections;
            for (int i = 0; i < 4; ++i) {
                mesh.vs[i] = nArray[i] < 0 ? mesh.vs[i - 1] : this.vwr.getAtomPoint3f(nArray[i]);
            }
            mesh.recalcAltVertices = true;
        }
        return this.renderMesh2(mesh);
    }

    @Override
    protected void render2(boolean bl) {
        int n;
        int n2;
        boolean bl2;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        if (this.mesh.connections != null) {
            this.getConnectionPoints();
        }
        if (this.mesh.lineData != null) {
            this.drawLineData(this.mesh.lineData);
            return;
        }
        boolean bl3 = this.vwr.getPickingMode() == 4;
        int n3 = this.vertexCount;
        boolean bl4 = (this.drawType == Draw.EnumDrawType.CURVE || this.drawType == Draw.EnumDrawType.ARROW || this.drawType == Draw.EnumDrawType.ARC) && this.vertexCount >= 2;
        boolean bl5 = bl2 = this.drawType == Draw.EnumDrawType.LINE_SEGMENT;
        if (this.width > 0.0f && bl4) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            n2 = this.drawType == Draw.EnumDrawType.ARC ? 2 : this.vertexCount;
            for (n = 0; n < n2; ++n) {
                this.pt1f.add(this.vertices[n]);
            }
            this.pt1f.scale(1.0f / (float)n2);
            this.vwr.transformPtScr(this.pt1f, this.pt1i);
            this.diameter = (int)this.vwr.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        if (this.dmesh.isVector && this.dmesh.haveXyPoints) {
            n2 = 0;
            for (n = 0; n < 2; ++n) {
                if (this.vertices[n].z != Float.MAX_VALUE && this.vertices[n].z != -3.4028235E38f) continue;
                n2 += n + 1;
            }
            if (--n2 < 2) {
                this.renderXyArrow(n2);
                return;
            }
        }
        n2 = 5;
        switch (this.drawType) {
            default: {
                this.render2b(false);
                break;
            }
            case CIRCULARPLANE: {
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                this.render2b(false);
                break;
            }
            case CIRCLE: {
                this.vwr.transformPtScr(this.vertices[0], this.pt1i);
                if (this.diameter == 0 && this.width == 0.0f) {
                    this.width = 1.0f;
                }
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                if (this.width > 0.0f) {
                    this.diameter = (int)this.vwr.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
                }
                if (this.diameter <= 0 || !this.mesh.drawTriangles && !this.mesh.fillTriangles) break;
                this.g3d.addRenderer(1073741880);
                this.g3d.drawFilledCircle(this.colix, this.mesh.fillTriangles ? this.colix : (short)0, this.diameter, this.pt1i.x, this.pt1i.y, this.pt1i.z);
                break;
            }
            case CURVE: 
            case LINE_SEGMENT: {
                break;
            }
            case ARC: {
                int n4;
                float f;
                float f2 = this.vertexCount > 3 ? this.vertices[3].x : 0.0f;
                float f3 = f = this.vertexCount > 3 ? this.vertices[3].y : 360.0f;
                if (f == 0.0f) {
                    return;
                }
                float f4 = this.vertexCount > 3 ? this.vertices[3].z : 0.0f;
                this.vTemp.sub2(this.vertices[1], this.vertices[0]);
                this.pt1f.scaleAdd2(f4, this.vTemp, this.vertices[0]);
                M3 m3 = new M3();
                m3.setAA(A4.newVA(this.vTemp, (float)((double)f2 * Math.PI / 180.0)));
                this.vTemp2.sub2(this.vertexCount > 2 ? this.vertices[2] : Draw.randomPoint(), this.vertices[0]);
                this.vTemp2.cross(this.vTemp, this.vTemp2);
                this.vTemp2.cross(this.vTemp2, this.vTemp);
                this.vTemp2.normalize();
                this.vTemp2.scale(this.dmesh.scale / 2.0f);
                m3.rotate(this.vTemp2);
                float f5 = f / 5.0f;
                while (Math.abs(f5) > 5.0f) {
                    f5 /= 2.0f;
                }
                n3 = Math.round(f / f5) + 1;
                while (n3 < 10) {
                    n3 = Math.round(f / (f5 /= 2.0f)) + 1;
                }
                m3.setAA(A4.newVA(this.vTemp, (float)((double)f5 * Math.PI / 180.0)));
                this.screens = this.vwr.allocTempScreens(n3);
                int n5 = n3 - (this.dmesh.scale < 2.0f ? 3 : 3);
                for (n4 = 0; n4 < n3; ++n4) {
                    if (n4 == n5) {
                        this.pt0.setT(this.pt1);
                    }
                    this.pt1.scaleAdd2(1.0f, this.vTemp2, this.pt1f);
                    if (n4 == 0) {
                        this.pt2.setT(this.pt1);
                    }
                    this.vwr.transformPtScr(this.pt1, this.screens[n4]);
                    m3.rotate(this.vTemp2);
                }
                if (this.dmesh.isVector && !this.dmesh.noHead) {
                    this.renderArrowHead(this.pt0, this.pt1, 0.3f, false, false, this.dmesh.isBarb);
                    this.vwr.transformPtScr(this.pt1f, this.screens[n3 - 1]);
                }
                this.pt1f.setT(this.pt2);
                break;
            }
            case ARROW: {
                if (this.vertexCount == 2) {
                    this.renderArrowHead(this.vertices[0], this.vertices[1], 0.0f, false, true, this.dmesh.isBarb);
                    break;
                }
                int n4 = 5;
                if (this.controlHermites == null || this.controlHermites.length < n4 + 1) {
                    this.controlHermites = new P3[n4 + 1];
                }
                GData.getHermiteList(n2, this.vertices[this.vertexCount - 3], this.vertices[this.vertexCount - 2], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.vertices[this.vertexCount - 1], this.controlHermites, 0, n4, true);
                this.renderArrowHead(this.controlHermites[n4 - 2], this.controlHermites[n4 - 1], 0.0f, false, false, this.dmesh.isBarb);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (bl4) {
            this.g3d.addRenderer(553648147);
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3 - 1) {
                this.g3d.fillHermite(n2, this.diameter, this.diameter, this.diameter, this.screens[n7], this.screens[n6], this.screens[n6 + 1], this.screens[n6 + (n6 == n3 - 2 ? 1 : 2)]);
                n7 = n6++;
            }
        } else if (bl2) {
            for (int i = 0; i < n3 - 1; ++i) {
                this.drawLine(i, i + 1, true, this.vertices[i], this.vertices[i + 1], this.screens[i], this.screens[i + 1]);
            }
        }
        if (bl3 && !bl) {
            this.renderHandles();
        }
    }

    private void getConnectionPoints() {
        float f;
        int n;
        this.vertexCount = 3;
        float f2 = Float.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 2; ++n) {
            for (int i = 2; i < 4; ++i) {
                f = this.vertices[n].distance(this.vertices[i]);
                if (!(f < f2)) continue;
                f2 = f;
                n2 = n;
                n3 = i;
            }
        }
        this.pt0.ave(this.vertices[0], this.vertices[1]);
        this.pt2.ave(this.vertices[2], this.vertices[3]);
        this.pt1.ave(this.pt0, this.pt2);
        this.vertices[3] = P3.newP(this.vertices[n2]);
        this.vertices[3].add(this.vertices[n3]);
        this.vertices[3].scale(0.5f);
        this.vertices[1] = P3.newP(this.pt1);
        this.vertices[0] = P3.newP(this.pt0);
        this.vertices[2] = P3.newP(this.pt2);
        for (n = 0; n < 4; ++n) {
            this.vwr.transformPtScr(this.vertices[n], this.screens[n]);
        }
        float f3 = 4.0f * this.getArrowScale();
        float f4 = 0.2f;
        f = this.width == 0.0f ? 0.1f : this.width;
        this.pt0.set(this.screens[0].x, this.screens[0].y, this.screens[0].z);
        this.pt1.set(this.screens[1].x, this.screens[1].y, this.screens[1].z);
        this.pt2.set(this.screens[3].x, this.screens[3].y, this.screens[3].z);
        float f5 = (float)(this.screens[1].x - this.screens[0].x) * f3;
        float f6 = (float)(this.screens[1].y - this.screens[0].y) * f3;
        if (f2 == 0.0f || Measure.computeTorsion(this.pt2, this.pt0, P3.new3(this.pt0.x, this.pt0.y, 10000.0f), this.pt1, false) > 0.0f) {
            f5 = -f5;
            f6 = -f6;
        }
        this.pt2.set(f6, -f5, 0.0f);
        this.pt1.add(this.pt2);
        this.vwr.unTransformPoint(this.pt1, this.vertices[1]);
        this.pt2.scale(f);
        this.vTemp.sub2(this.vertices[1], this.vertices[0]);
        this.vTemp.scale(f4);
        this.vertices[0].add(this.vTemp);
        this.vTemp.sub2(this.vertices[1], this.vertices[2]);
        this.vTemp.scale(f4);
        this.vertices[2].add(this.vTemp);
        for (int i = 0; i < 3; ++i) {
            this.vwr.transformPtScr(this.vertices[i], this.screens[i]);
            if (f == 0.0f) continue;
            this.screens[i].x += Math.round(this.pt2.x);
            this.screens[i].y += Math.round(this.pt2.y);
            this.pt1.set(this.screens[i].x, this.screens[i].y, this.screens[i].z);
            this.vwr.unTransformPoint(this.pt1, this.vertices[i]);
        }
    }

    private void drawLineData(List<P3[]> list) {
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        int n = list.size();
        while (--n >= 0) {
            P3[] p3Array = (P3[])list.get(n);
            this.vwr.transformPtScr(p3Array[0], this.pt1i);
            this.vwr.transformPtScr(p3Array[1], this.pt2i);
            this.drawLine(-1, -2, true, p3Array[0], p3Array[1], this.pt1i, this.pt2i);
        }
    }

    private void renderXyArrow(int n) {
        int n2 = 1 - n;
        P3[] p3Array = new P3[2];
        p3Array[n2] = this.pt1;
        p3Array[n] = this.pt0;
        this.pt0.set(this.screens[n].x, this.screens[n].y, this.screens[n].z);
        this.vwr.rotatePoint(this.vertices[n2], this.pt1);
        this.pt1.z *= -1.0f;
        float f = this.vwr.getScreenDim();
        float f2 = f / 20.0f;
        this.pt1.scaleAdd2(this.dmesh.scale * f2, this.pt1, this.pt0);
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        this.pt1i.set(Math.round(this.pt0.x), Math.round(this.pt0.y), Math.round(this.pt0.z));
        this.pt2i.set(Math.round(this.pt1.x), Math.round(this.pt1.y), Math.round(this.pt1.z));
        if (this.diameter < 0) {
            this.g3d.drawDottedLine(this.pt1i, this.pt2i);
        } else {
            this.g3d.fillCylinder((byte)2, this.diameter, this.pt1i, this.pt2i);
        }
        this.renderArrowHead(this.pt0, this.pt1, 0.0f, true, false, false);
    }

    private void renderArrowHead(P3 p3, P3 p32, float f, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (this.dmesh.noHead) {
            return;
        }
        float f2 = this.getArrowScale();
        if (bl) {
            f2 *= 40.0f;
        }
        if (f > 0.0f) {
            f2 *= f;
        }
        this.pt0f.setT(p3);
        this.pt2f.setT(p32);
        float f3 = this.pt0f.distance(this.pt2f);
        if (f3 == 0.0f) {
            return;
        }
        this.vTemp.sub2(this.pt2f, this.pt0f);
        this.vTemp.normalize();
        this.vTemp.scale(f2 / 5.0f);
        if (!bl2) {
            this.pt2f.add(this.vTemp);
        }
        this.vTemp.scale(5.0f);
        this.pt1f.sub2(this.pt2f, this.vTemp);
        if (bl) {
            this.pt1i.set(Math.round(this.pt1f.x), Math.round(this.pt1f.y), Math.round(this.pt1f.z));
            this.pt2i.set(Math.round(this.pt2f.x), Math.round(this.pt2f.y), Math.round(this.pt2f.z));
        } else {
            this.vwr.transformPtScr(this.pt2f, this.pt2i);
            this.vwr.transformPtScr(this.pt1f, this.pt1i);
            this.vwr.transformPtScr(this.pt0f, this.pt0i);
        }
        if (this.pt2i.z == 1 || this.pt1i.z == 1) {
            return;
        }
        if (this.diameter > 0) {
            n = this.diameter * 3;
        } else {
            this.vTemp.set(this.pt2i.x - this.pt1i.x, this.pt2i.y - this.pt1i.y, this.pt2i.z - this.pt1i.z);
            n = Math.round(this.vTemp.length() * 0.5f);
            this.diameter = n / 5;
        }
        if (this.diameter < 1) {
            this.diameter = 1;
        }
        if (n > 2) {
            this.g3d.fillConeScreen((byte)2, n, this.pt1i, this.pt2i, bl3);
        }
        if (bl2) {
            this.g3d.fillCylinderScreen3I((byte)4, this.diameter, this.pt0i, this.pt1i, null, null, 0.0f);
        }
    }

    private float getArrowScale() {
        float f;
        float f2 = f = this.dmesh.isScaleSet ? this.dmesh.scale : 0.0f;
        if (f == 0.0f) {
            f = this.vwr.getFloat(0x22000008) * (this.dmesh.connections == null ? 1.0f : 0.5f);
        }
        if (f <= 0.0f) {
            f = 0.5f;
        }
        return f;
    }

    private void renderHandles() {
        int n = Math.round(10.0f * this.imageFontScaling);
        switch (this.drawType) {
            case NONE: {
                return;
            }
        }
        short s = C.getColixTranslucent3((short)23, true, 0.5f);
        this.bsHandles.clearAll();
        this.g3d.addRenderer(1073741880);
        int n2 = this.dmesh.pc;
        while (--n2 >= 0) {
            int n3;
            int[] nArray;
            if (!this.isPolygonDisplayable(n2) || (nArray = this.dmesh.pis[n2]) == null) continue;
            int n4 = n3 = this.dmesh.isTriangleSet ? 3 : nArray.length;
            while (--n3 >= 0) {
                int n5 = nArray[n3];
                if (this.bsHandles.get(n5)) continue;
                this.bsHandles.set(n5);
                this.g3d.drawFilledCircle((short)23, s, n, this.screens[n5].x, this.screens[n5].y, this.screens[n5].z);
            }
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.vwr.getDrawHover() || !this.g3d.setColix(this.vwr.getColixBackgroundContrast())) {
            return;
        }
        int n = this.dmesh.pc;
        while (--n >= 0) {
            if (!this.isPolygonDisplayable(n)) continue;
            float f = this.vwr.getFloat(0x2200000C);
            if (f <= 0.0f) {
                f = 14.0f;
            }
            byte by = this.g3d.getFontFid(f * this.imageFontScaling);
            this.g3d.setFontFid(by);
            String string = this.mesh.title[n < this.mesh.title.length ? n : this.mesh.title.length - 1];
            int n2 = 0;
            if (string.length() > 1 && string.charAt(0) == '>') {
                n2 = this.dmesh.pis[n].length - 1;
                string = string.substring(1);
                if (this.drawType == Draw.EnumDrawType.ARC) {
                    this.pt1f.setT(this.pt2f);
                }
            }
            if (this.drawType != Draw.EnumDrawType.ARC) {
                this.pt1f.setT(this.vertices[this.dmesh.pis[n][n2]]);
            }
            this.vwr.transformPtScr(this.pt1f, this.pt1i);
            int n3 = Math.round(5.0f * this.imageFontScaling);
            this.g3d.drawString(string, null, this.pt1i.x + n3, this.pt1i.y - n3, this.pt1i.z, this.pt1i.z, (short)0);
            break;
        }
    }
}

