/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Measure;

public class Sheet
extends ProteinStructure {
    AlphaPolymer alphaPolymer;
    V3 widthUnitVector;
    V3 heightUnitVector;

    Sheet(AlphaPolymer alphaPolymer, int n, int n2, STR sTR) {
        this.setupPS(alphaPolymer, STR.SHEET, n, n2);
        this.alphaPolymer = alphaPolymer;
        this.subtype = sTR;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.alphaPolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new P3();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new P3();
            this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new V3();
        this.axisUnitVector.sub2(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        P3 p3 = new P3();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst, p3);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(p3, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        P3 p32 = new P3();
        this.alphaPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount, p32);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Measure.projectOntoAxis(p32, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = p3;
        this.axisB = p32;
    }

    void calcSheetUnitVectors() {
        if (!(this.alphaPolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            V3 v3 = new V3();
            V3 v32 = new V3();
            AminoMonomer aminoMonomer = (AminoMonomer)this.alphaPolymer.monomers[this.monomerIndexFirst];
            v32.sub2(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
            int n = this.monomerCount;
            while (--n > this.monomerIndexFirst) {
                aminoMonomer = (AminoMonomer)this.alphaPolymer.monomers[n];
                v3.sub2(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
                if (v32.angle(v3) < 1.5707964f) {
                    v32.add(v3);
                    continue;
                }
                v32.sub(v3);
            }
            this.heightUnitVector = v3;
            this.heightUnitVector.cross(this.axisUnitVector, v32);
            this.heightUnitVector.normalize();
            this.widthUnitVector = v32;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public V3 getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    public V3 getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

