/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.api.JmolBioResolver;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.JC;

public final class Resolver
implements JmolBioResolver {
    private ModelLoader ml;
    private ModelSet ms;
    private BS bsAddedHydrogens;
    private BS bsAtomsForHs;
    private Map<String, String> htBondMap;
    private Map<String, Boolean> htGroupBonds;
    private String[] hNames;
    private int lastSetH = Integer.MIN_VALUE;
    private int maxSerial = 0;
    private int baseBondIndex = 0;
    private boolean haveHsAlready;
    private V3 vAB;
    private V3 vAC;
    private V3 vNorm;
    private P4 plane;
    private BS bsAssigned;

    @Override
    public Model getBioModel(int n, int n2, String string, Properties properties, Map<String, Object> map) {
        return new BioModel(this.ms, n, n2, string, properties, map);
    }

    @Override
    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int n4, int[] nArray, Atom[] atomArray) {
        int n5 = n3 - 1;
        int n6 = 0;
        int n7 = JC.ATOMID_MAX;
        while (--n7 >= 0) {
            nArray[n7] = Integer.MIN_VALUE;
        }
        n7 = n3;
        while (--n7 >= n2) {
            byte by = atomArray[n7].getAtomID();
            if (by <= 0) continue;
            if (by < 14) {
                n6 |= 1 << by;
            }
            nArray[by] = n7;
        }
        if (n5 < n2) {
            throw new NullPointerException();
        }
        Monomer monomer = null;
        if ((n6 & 0xE) == 14) {
            monomer = AminoMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray, atomArray);
        } else if (n6 == 4) {
            monomer = AlphaMonomer.validateAndAllocateA(chain, string, n, n2, n5, nArray);
        } else if ((n6 & 0x1FC0) == 8128) {
            monomer = NucleicMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        } else if (n6 == 8192) {
            monomer = PhosphorusMonomer.validateAndAllocateP(chain, string, n, n2, n5, nArray);
        } else if (JC.checkCarbohydrate(string)) {
            monomer = CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n5);
        }
        return monomer != null && monomer.leadAtomIndex >= 0 ? monomer : null;
    }

    @Override
    public void setHaveHsAlready(boolean bl) {
        this.haveHsAlready = bl;
    }

    @Override
    public void initialize(ModelLoader modelLoader) {
        this.ml = modelLoader;
        this.ms = modelLoader.ms;
    }

    @Override
    public void initializeHydrogenAddition() {
        this.baseBondIndex = this.ml.ms.bondCount;
        this.bsAddedHydrogens = new BS();
        this.bsAtomsForHs = new BS();
        this.htBondMap = new Hashtable<String, String>();
        this.htGroupBonds = new Hashtable<String, Boolean>();
        this.hNames = new String[3];
        this.vAB = new V3();
        this.vAC = new V3();
        this.vNorm = new V3();
        this.plane = new P4();
    }

    @Override
    public void addImplicitHydrogenAtoms(JmolAdapter jmolAdapter, int n, int n2) {
        int n3;
        String string = this.ml.getGroup3(n);
        if (this.haveHsAlready || string == null || (n3 = JC.getStandardPdbHydrogenCount(Group.lookupGroupID(string))) == 0) {
            return;
        }
        n2 = n3 < 0 ? -1 : n3 + n2;
        Object object = null;
        int n4 = this.ml.getFirstAtomIndex(n);
        int n5 = this.ms.getAtomCount();
        if (n2 < 0) {
            if (n5 - n4 == 1) {
                return;
            }
            object = this.ms.vwr.getLigandModel(string, "ligand_", "_data", null);
            if (object == null) {
                return;
            }
            n2 = jmolAdapter.getHydrogenAtomCount(object);
            if (n2 < 1) {
                return;
            }
        }
        this.getBondInfo(jmolAdapter, string, object);
        this.ms.am[this.ms.at[n4].mi].isPdbWithMultipleBonds = true;
        this.bsAtomsForHs.setBits(n4, n5);
        this.bsAddedHydrogens.setBits(n5, n5 + n2);
        boolean bl = this.ms.at[n4].isHetero();
        P3 p3 = P3.new3(Float.NaN, Float.NaN, Float.NaN);
        for (int i = 0; i < n2; ++i) {
            this.ms.addAtom(this.ms.at[n4].mi, this.ms.at[n4].getGroup(), 1, "H", 0, 0, p3, Float.NaN, null, 0, 0.0f, 1, 0.0f, null, bl, (byte)0, null).deleteBonds(null);
        }
    }

    public void getBondInfo(JmolAdapter jmolAdapter, String string, Object object) {
        if (this.htGroupBonds.get(string) != null) {
            return;
        }
        String[][] stringArray = object == null ? this.ms.vwr.getPdbBondInfo(string) : this.getLigandBondInfo(jmolAdapter, object, string);
        if (stringArray == null) {
            return;
        }
        this.htGroupBonds.put(string, Boolean.TRUE);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i][1].charAt(0) == 'H') {
                this.htBondMap.put(string + "." + stringArray[i][0], stringArray[i][1]);
                continue;
            }
            this.htBondMap.put(string + ":" + stringArray[i][0] + ":" + stringArray[i][1], stringArray[i][2]);
        }
    }

    private String[][] getLigandBondInfo(JmolAdapter jmolAdapter, Object object, String string) {
        String[][] stringArray = jmolAdapter.getBondList(object);
        Hashtable<String, P3> hashtable = new Hashtable<String, P3>();
        JmolAdapterAtomIterator jmolAdapterAtomIterator = jmolAdapter.getAtomIterator(object);
        while (jmolAdapterAtomIterator.hasNext()) {
            hashtable.put(jmolAdapterAtomIterator.getAtomName(), jmolAdapterAtomIterator.getXYZ());
        }
        String[][] stringArray2 = new String[stringArray.length * 2][];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringArray3[0].charAt(0) != 'H') {
                stringArray2[n++] = new String[]{stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[1].startsWith("H") ? "0" : "1"};
            }
            if (stringArray3[1].charAt(0) == 'H') continue;
            stringArray2[n++] = new String[]{stringArray3[1], stringArray3[0], stringArray3[2], stringArray3[0].startsWith("H") ? "0" : "1"};
        }
        Arrays.sort(stringArray2, new BondSorter());
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray4 = stringArray2[n2];
            String string2 = stringArray4[0];
            int n3 = 0;
            int n4 = 0;
            while (n2 < n && (stringArray4 = stringArray2[n2])[0].equals(string2)) {
                if (stringArray4[3].equals("0")) {
                    ++n3;
                } else if (stringArray4[3].equals("1")) {
                    ++n4;
                }
                ++n2;
            }
            int n5 = n2 - n3 - n4;
            if (n3 == 1) continue;
            switch (n4) {
                case 1: {
                    char c = n3 == 2 ? (char)'@' : '|';
                    for (int i = 1; i < n3; ++i) {
                        String[] stringArray5 = stringArray2[n5];
                        stringArray5[1] = stringArray5[1] + c + stringArray2[n5 + i][1];
                        stringArray2[n5 + i] = null;
                    }
                    break;
                }
                case 2: {
                    if (n3 != 2) break;
                    String string3 = stringArray2[n5][0];
                    String string4 = stringArray2[n5 + n3][1];
                    String string5 = stringArray2[n5 + n3 + 1][1];
                    int n6 = string4.compareTo(string5);
                    Measure.getPlaneThroughPoints((P3)hashtable.get(string4), (P3)hashtable.get(string3), (P3)hashtable.get(string5), this.vNorm, this.vAB, this.vAC, this.plane);
                    float f = Measure.distanceToPlane(this.plane, (P3)hashtable.get(stringArray2[n5][1])) * (float)n6;
                    stringArray2[n5][1] = f > 0.0f ? stringArray2[n5][1] + "@" + stringArray2[n5 + 1][1] : stringArray2[n5 + 1][1] + "@" + stringArray2[n5][1];
                    stringArray2[n5 + 1] = null;
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            String[] stringArray6 = stringArray2[n2];
            if (stringArray6 != null && stringArray6[1].charAt(0) != 'H' && stringArray6[0].compareTo(stringArray6[1]) > 0) {
                stringArray2[n2] = null;
                continue;
            }
            if (stringArray6 == null) continue;
            Logger.info(" ligand " + string + ": " + stringArray2[n2][0] + " - " + stringArray2[n2][1] + " order " + stringArray2[n2][2]);
        }
        return stringArray2;
    }

    @Override
    public void finalizeHydrogens() {
        this.ms.vwr.getLigandModel(null, null, null, null);
        this.finalizePdbMultipleBonds();
        this.addHydrogens();
    }

    private void addHydrogens() {
        if (this.bsAddedHydrogens.nextSetBit(0) < 0) {
            return;
        }
        this.finalizePdbCharges();
        int[] nArray = new int[1];
        P3[][] p3Array = this.ms.calculateHydrogens(this.bsAtomsForHs, nArray, true, false, null);
        Group group = null;
        int n = 0;
        block8: for (int i = 0; i < p3Array.length; ++i) {
            if (p3Array[i] == null) continue;
            Atom atom = this.ms.at[i];
            Group group2 = atom.getGroup();
            if (group2 != group) {
                group = group2;
                n = group2.lastAtomIndex;
                while (this.bsAddedHydrogens.get(n)) {
                    --n;
                }
            }
            String string = atom.getGroup3(false);
            String string2 = atom.getAtomName();
            String string3 = this.htBondMap.get(string + "." + string2);
            if (string3 == null) continue;
            boolean bl = string3.contains("@");
            boolean bl2 = string3.endsWith("?") || string3.indexOf("|") >= 0;
            int n2 = p3Array[i].length;
            if (n2 == 3 && !bl2 && string3.equals("H@H2")) {
                string3 = "H|H2|H3";
                bl2 = true;
                bl = false;
            }
            if (bl && n2 == 3 || bl2 != (n2 == 3)) {
                Logger.info("Error adding H atoms to " + string + group2.getResno() + ": " + p3Array[i].length + " atoms should not be added to " + string2);
                continue;
            }
            int n3 = string3.indexOf("@");
            switch (p3Array[i].length) {
                case 1: {
                    if (n3 > 0) {
                        string3 = string3.substring(0, n3);
                    }
                    this.setHydrogen(i, ++n, string3, p3Array[i][0]);
                    continue block8;
                }
                case 2: {
                    String string4;
                    String string5;
                    float f = -1.0f;
                    Bond[] bondArray = atom.getBonds();
                    if (bondArray != null) {
                        switch (bondArray.length) {
                            case 2: {
                                Atom atom2 = bondArray[0].getOtherAtom(atom);
                                Atom atom3 = bondArray[1].getOtherAtom(atom);
                                int n4 = atom2.getAtomName().compareTo(atom3.getAtomName());
                                Measure.getPlaneThroughPoints(atom2, atom, atom3, this.vNorm, this.vAB, this.vAC, this.plane);
                                f = Measure.distanceToPlane(this.plane, p3Array[i][0]) * (float)n4;
                            }
                        }
                    }
                    if (n3 < 0) {
                        Logger.info("Error adding H atoms to " + string + group2.getResno() + ": expected to only need 1 H but needed 2");
                        string5 = "H";
                        string4 = "H";
                    } else if (f < 0.0f) {
                        string5 = string3.substring(0, n3);
                        string4 = string3.substring(n3 + 1);
                    } else {
                        string4 = string3.substring(0, n3);
                        string5 = string3.substring(n3 + 1);
                    }
                    this.setHydrogen(i, ++n, string4, p3Array[i][0]);
                    this.setHydrogen(i, ++n, string5, p3Array[i][1]);
                    continue block8;
                }
                case 3: {
                    int n5 = string3.indexOf(124);
                    if (n5 >= 0) {
                        int n6 = string3.lastIndexOf(124);
                        this.hNames[0] = string3.substring(0, n5);
                        this.hNames[1] = string3.substring(n5 + 1, n6);
                        this.hNames[2] = string3.substring(n6 + 1);
                    } else {
                        this.hNames[0] = string3.replace('?', '1');
                        this.hNames[1] = string3.replace('?', '2');
                        this.hNames[2] = string3.replace('?', '3');
                    }
                    this.setHydrogen(i, ++n, this.hNames[0], p3Array[i][0]);
                    this.setHydrogen(i, ++n, this.hNames[1], p3Array[i][2]);
                    this.setHydrogen(i, ++n, this.hNames[2], p3Array[i][1]);
                }
            }
        }
        this.deleteUnneededAtoms();
        this.ms.fixFormalCharges(BSUtil.newBitSet2(this.ml.baseAtomIndex, this.ml.ms.ac));
    }

    private void deleteUnneededAtoms() {
        BS bS = new BS();
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.ms.at[n];
            if (atom.isHetero() && atom.getElementNumber() == 8 && atom.getFormalCharge() == 0 && atom.getCovalentBondCount() == 2) {
                Bond[] bondArray;
                Bond[] bondArray2 = atom.getBonds();
                Bond[] bondArray3 = bondArray2[0].getOtherAtom(atom);
                Atom atom2 = bondArray2[1].getOtherAtom(atom);
                if (bondArray3.getElementNumber() == 1) {
                    bondArray = bondArray3;
                    bondArray3 = atom2;
                    atom2 = bondArray;
                }
                if (atom2.getElementNumber() == 1) {
                    bondArray = bondArray3.getBonds();
                    for (int i = 0; i < bondArray.length; ++i) {
                        Atom atom3;
                        if (bondArray[i].order != 2 || (atom3 = bondArray[i].getOtherAtom((Atom)bondArray3)).getElementNumber() != 8) continue;
                        this.bsAddedHydrogens.set(atom2.i);
                        atom2.deleteBonds(bS);
                        break;
                    }
                }
            }
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
        this.ms.deleteBonds(bS, true);
        this.ml.deleteAtoms(this.bsAddedHydrogens);
    }

    private void finalizePdbCharges() {
        Atom[] atomArray = this.ms.at;
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.getGroup().getNitrogenAtom() == atom && atom.getCovalentBondCount() == 1) {
                atom.setFormalCharge(1);
            }
            if ((n = this.bsAtomsForHs.nextClearBit(n + 1)) < 0) break;
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finalizePdbMultipleBonds() {
        void var5_11;
        Object object;
        Object object2;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = this.ms.bondCount;
        Bond[] bondArray = this.ms.bo;
        for (int i = this.baseBondIndex; i < n; ++i) {
            Atom object4 = bondArray[i].getAtom1();
            Atom atom = bondArray[i].getAtom2();
            object2 = object4.getGroup();
            if (object2 != atom.getGroup()) continue;
            object = new SB().append(((Group)object2).getGroup3());
            ((SB)object).append(":");
            String string = object4.getAtomName();
            String string2 = atom.getAtomName();
            if (string.compareTo(string2) > 0) {
                ((SB)object).append(string2).append(":").append(string);
            } else {
                ((SB)object).append(string).append(":").append(string2);
            }
            String string3 = ((SB)object).toString();
            String string4 = this.htBondMap.get(string3);
            if (string4 == null) continue;
            hashtable.put(string3, Boolean.TRUE);
            bondArray[i].setOrder(PT.parseInt(string4));
        }
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            if (string.indexOf(":") < 0) {
                hashtable.put(string, Boolean.TRUE);
                continue;
            }
            String string5 = this.htBondMap.get(string);
            Logger.info("bond " + string + " was not used; order=" + string5);
            if (!this.htBondMap.get(string).equals("1")) continue;
            hashtable.put(string, Boolean.TRUE);
        }
        Hashtable hashtable2 = new Hashtable();
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            hashtable2.put(string.substring(0, string.lastIndexOf(":")), this.htBondMap.get(string));
        }
        if (hashtable2.isEmpty()) {
            return;
        }
        boolean bl = false;
        while (var5_11 < n) {
            Atom atom = bondArray[var5_11].getAtom1();
            object2 = bondArray[var5_11].getAtom2();
            if (atom.getGroup() != ((Atom)object2).getGroup() && ((object = (String)hashtable2.get(atom.getGroup3(false) + ":" + atom.getAtomName())) != null || (object = (String)hashtable2.get(((Atom)object2).getGroup3(false) + ":" + ((Atom)object2).getAtomName())) != null)) {
                bondArray[var5_11].setOrder(PT.parseInt((String)object));
                Logger.info("assigning order " + bondArray[var5_11].order + " to bond " + bondArray[var5_11]);
            }
            ++var5_11;
        }
    }

    private void setHydrogen(int n, int n2, String string, P3 p3) {
        if (!this.bsAddedHydrogens.get(n2)) {
            return;
        }
        Atom[] atomArray = this.ms.at;
        if (this.lastSetH == Integer.MIN_VALUE || atomArray[n2].mi != atomArray[this.lastSetH].mi) {
            this.lastSetH = n2;
            this.maxSerial = ((int[])this.ms.getModelAuxiliaryInfoValue(atomArray[this.lastSetH].mi, "PDB_CONECT_firstAtom_count_max"))[2];
        }
        this.bsAddedHydrogens.clear(n2);
        this.ms.setAtomName(n2, string);
        atomArray[n2].setT(p3);
        this.ms.setAtomNumber(n2, ++this.maxSerial);
        atomArray[n2].setAtomSymmetry(atomArray[n].getAtomSymmetry());
        this.ml.undeleteAtom(n2);
        this.ms.bondAtoms(atomArray[n], atomArray[n2], 1, this.ms.getDefaultMadFromOrder(1), null, 0.0f, true, false);
    }

    @Override
    public String fixPropertyValue(BS bS, String string) {
        String[] stringArray = PT.split(string, "\n");
        Atom[] atomArray = this.ms.at;
        String[] stringArray2 = new String[bS.cardinality()];
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            if (atomArray[n3].getElementNumber() != 1) {
                string2 = stringArray[n++];
            }
            stringArray2[n2] = string2;
            n3 = bS.nextSetBit(n3);
            ++n2;
        }
        return PT.join(stringArray2, '\n', 0);
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n, boolean bl) {
        Group group;
        Object object = null;
        int n2 = 0;
        for (int i = n; i < groupArray.length && (group = groupArray[i]) instanceof Monomer; ++i) {
            Monomer monomer = (Monomer)group;
            if (monomer.bioPolymer != null || object != null && object.getClass() != monomer.getClass() || bl && !monomer.isConnectedAfter((Monomer)object)) break;
            object = monomer;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (Monomer)groupArray[n + i];
        }
        if (object instanceof AminoMonomer) {
            return new AminoPolymer(monomerArray);
        }
        if (object instanceof AlphaMonomer) {
            return new AlphaPolymer(monomerArray);
        }
        if (object instanceof NucleicMonomer) {
            return new NucleicPolymer(monomerArray);
        }
        if (object instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomerArray);
        }
        if (object instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error("Polymer.allocatePolymer() ... no matching polymer for monomor " + object);
        throw new NullPointerException();
    }

    @Override
    public void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapterStructureIterator jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        if (jmolAdapterStructureIterator == null) {
            return;
        }
        BS bS = jmolAdapterStructureIterator.getStructuredModels();
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.ml.structuresDefinedInFile.set(this.ml.baseModelIndex + n);
                n = bS.nextSetBit(n + 1);
            }
        }
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() == STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
        jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() != STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
    }

    private void setStructure(JmolAdapterStructureIterator jmolAdapterStructureIterator) {
        STR sTR = jmolAdapterStructureIterator.getSubstructureType();
        String string = jmolAdapterStructureIterator.getStructureID();
        int n = jmolAdapterStructureIterator.getSerialID();
        int n2 = jmolAdapterStructureIterator.getStrandCount();
        int[] nArray = jmolAdapterStructureIterator.getAtomIndices();
        int[] nArray2 = jmolAdapterStructureIterator.getModelIndices();
        if (this.bsAssigned == null) {
            this.bsAssigned = new BS();
        }
        this.defineStructure(sTR, string, n, n2, jmolAdapterStructureIterator.getStartChainID(), jmolAdapterStructureIterator.getStartSequenceNumber(), jmolAdapterStructureIterator.getStartInsertionCode(), jmolAdapterStructureIterator.getEndChainID(), jmolAdapterStructureIterator.getEndSequenceNumber(), jmolAdapterStructureIterator.getEndInsertionCode(), nArray, nArray2, this.bsAssigned);
    }

    private void defineStructure(STR sTR, String string, int n, int n2, int n3, int n4, char c, int n5, int n6, char c2, int[] nArray, int[] nArray2, BS bS) {
        STR sTR2 = sTR == STR.NOT ? STR.NONE : sTR;
        int n7 = Group.getSeqcodeFor(n4, c);
        int n8 = Group.getSeqcodeFor(n6, c2);
        Model[] modelArray = this.ms.am;
        if (this.ml.isTrajectory) {
            nArray2[1] = nArray2[0];
        } else {
            nArray2[0] = nArray2[0] + this.ml.baseModelIndex;
            nArray2[1] = nArray2[1] + this.ml.baseModelIndex;
        }
        this.ml.structuresDefinedInFile.setBits(nArray2[0], nArray2[1] + 1);
        for (int i = nArray2[0]; i <= nArray2[1]; ++i) {
            int n9 = modelArray[i].firstAtomIndex;
            if (!(modelArray[i] instanceof BioModel)) continue;
            ((BioModel)modelArray[i]).addSecondaryStructure(sTR2, string, n, n2, n3, n7, n5, n8, n9 + nArray[0], n9 + nArray[1], bS);
        }
    }

    protected class BondSorter
    implements Comparator<String[]> {
        protected BondSorter() {
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return stringArray2 == null ? (stringArray == null ? 0 : -1) : (stringArray == null ? 1 : (stringArray[0].compareTo(stringArray2[0]) < 0 ? -1 : (stringArray[0].compareTo(stringArray2[0]) > 0 ? 1 : (stringArray[3].compareTo(stringArray2[3]) < 0 ? -1 : (stringArray[3].compareTo(stringArray2[3]) > 0 ? 1 : (stringArray[1].compareTo(stringArray2[1]) < 0 ? -1 : (stringArray[1].compareTo(stringArray2[1]) > 0 ? 1 : 0)))))));
        }
    }
}

