/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.api.JSONEncodable;
import javajs.util.AU;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import javajs.util.XmlUtil;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.c.PAL;
import org.jmol.c.STR;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinModelSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.modelset.StateScript;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Tensor;
import org.jmol.util.Triangulator;
import org.jmol.util.Txt;
import org.jmol.util.Vibration;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={XmlUtil.class})
public abstract class ModelCollection
extends BondCollection {
    protected BS bsSymmetry;
    public String modelSetName;
    public Model[] am = new Model[1];
    public int mc;
    public SymmetryInterface[] unitCells;
    public boolean haveUnitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    public String[] frameTitles = new String[1];
    protected BS[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    public Properties modelSetProperties;
    protected Map<String, Object> modelSetAuxiliaryInfo;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    protected final P3 ptTemp = new P3();
    private boolean isBbcageDefault;
    private BS bboxModels;
    private BS bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    public List<StateScript> stateScripts;
    private int thisStateModel;
    public List<P3[]> trajectorySteps;
    protected List<V3[]> vibrationSteps;
    private BS selectedMolecules;
    boolean showRebondTimes;
    protected BS bsAll;
    public ShapeManager sm;
    private final P3 ptTemp1;
    private final P3 ptTemp2;
    private static float hbondMin = 2.5f;
    public boolean proteinStructureTainted;
    private SymmetryInterface symTemp;
    public Hashtable<String, BS> htPeaks;
    private Quat[] vOrientations;
    private Triangulator triangulator;

    public ModelCollection() {
        this.boxInfo.addBoundBoxPoint(P3.new3(-10.0f, -10.0f, -10.0f));
        this.boxInfo.addBoundBoxPoint(P3.new3(10.0f, 10.0f, 10.0f));
        this.stateScripts = new List();
        this.thisStateModel = 0;
        this.selectedMolecules = new BS();
        this.showRebondTimes = true;
        this.ptTemp1 = new P3();
        this.ptTemp2 = new P3();
        this.proteinStructureTainted = false;
    }

    protected void mergeModelArrays(ModelSet modelSet) {
        this.at = modelSet.at;
        this.bo = modelSet.bo;
        this.stateScripts = modelSet.stateScripts;
        this.proteinStructureTainted = modelSet.proteinStructureTainted;
        this.thisStateModel = -1;
        this.bsSymmetry = modelSet.bsSymmetry;
        this.modelFileNumbers = modelSet.modelFileNumbers;
        this.modelNumbersForAtomLabel = modelSet.modelNumbersForAtomLabel;
        this.modelNames = modelSet.modelNames;
        this.modelNumbers = modelSet.modelNumbers;
        this.frameTitles = modelSet.frameTitles;
        this.mergeAtomArrays(modelSet);
    }

    @Override
    protected void releaseModelSet() {
        this.am = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        this.releaseModelSetBC();
    }

    public SymmetryInterface getUnitCell(int n) {
        if (!this.haveUnitCells || n < 0 || n >= this.mc) {
            return null;
        }
        if (this.am[n].simpleCage != null) {
            return this.am[n].simpleCage;
        }
        return this.unitCells == null || n >= this.unitCells.length || !this.unitCells[n].haveUnitCell() ? null : this.unitCells[n];
    }

    public void setModelCage(int n, SymmetryInterface symmetryInterface) {
        if (n < 0 || n >= this.mc) {
            return;
        }
        this.am[n].simpleCage = symmetryInterface;
        this.haveUnitCells = true;
    }

    public List<Object> getPlaneIntersection(int n, P4 p4, float f, int n2, SymmetryInterface symmetryInterface) {
        P3[] p3Array = null;
        switch (n) {
            case 1614417948: {
                if (symmetryInterface == null) {
                    return null;
                }
                p3Array = symmetryInterface.getCanonicalCopy(f, true);
                break;
            }
            case 1679429641: {
                p3Array = this.boxInfo.getCanonicalCopy(f);
            }
        }
        List<Object> list = new List<Object>();
        list.addLast(p3Array);
        return this.intersectPlane(p4, list, n2);
    }

    public String getModelName(int n) {
        return this.mc < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "fileName");
    }

    public String getModelFileType(int n) {
        return (String)this.getModelAuxiliaryInfoValue(n, "fileType");
    }

    public void setFrameTitle(BS bS, Object object) {
        if (object instanceof String) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.frameTitles[n] = (String)object;
                n = bS.nextSetBit(n + 1);
            }
        } else {
            String[] stringArray = (String[])object;
            int n = bS.nextSetBit(0);
            int n2 = 0;
            while (n >= 0) {
                if (n2 < stringArray.length) {
                    this.frameTitles[n] = stringArray[n2++];
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.mc ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(Group[] groupArray, int n, int n2, BS bS) {
        if (!this.isPDB) {
            return;
        }
        boolean bl = !this.vwr.getBoolean(603979892);
        for (int i = 0; i < this.mc; ++i) {
            if (bS != null && bS.get(i) || !this.am[i].isBioModel) continue;
            this.am[i].calculatePolymers(groupArray, n, n2, bS, bl);
            return;
        }
    }

    public Group[] getGroups() {
        int n = 0;
        for (int i = 0; i < this.mc; ++i) {
            n += this.am[i].getGroupCount();
        }
        Group[] groupArray = new Group[n];
        int n2 = 0;
        for (int i = 0; i < this.mc; ++i) {
            for (int j = 0; j < this.am[i].chainCount; ++j) {
                for (int k = 0; k < this.am[i].chains[j].groupCount; ++k) {
                    groupArray[n2] = this.am[i].chains[j].groups[k];
                    groupArray[n2].groupIndex = n2;
                    ++n2;
                }
            }
        }
        return groupArray;
    }

    public float[] getNotionalUnitcell() {
        SymmetryInterface symmetryInterface = this.getUnitCell(0);
        return symmetryInterface == null ? null : symmetryInterface.getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return !this.isPDB && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public P3 getBoundBoxCenter(int n) {
        if (this.isJmolDataFrameForModel(n)) {
            return new P3();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public V3 getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBboxVertices() {
        return this.boxInfo.getBoundBoxVertices();
    }

    public BS getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(P3 p3, P3 p32, boolean bl, float f) {
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(p3, p32, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.eBS(this.bboxAtoms);
        }
        this.ptTemp.setT(this.boxInfo.getBoundBoxCenter());
        V3 v3 = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.eP(this.ptTemp) + " " + Escape.eP(v3) + "\n#or\n" : "";
        this.ptTemp.sub(v3);
        string = string + "boundbox corners " + Escape.eP(this.ptTemp) + " ";
        this.ptTemp.scaleAdd2(2.0f, v3, this.ptTemp);
        float f = Math.abs(8.0f * v3.x * v3.y * v3.z);
        string = string + Escape.eP(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public VDW getDefaultVdwType(int n) {
        return !this.am[n].isBioModel ? VDW.AUTO_BABEL : (this.am[n].hydrogenCount == 0 ? VDW.AUTO_JMOL : VDW.AUTO_BABEL);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrameForModel(n)) {
            this.am[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, P3 p3) {
        if (this.isJmolDataFrameForModel(n)) {
            float f = this.am[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        float f = 0.0f;
        int n2 = this.ac;
        while (--n2 >= 0) {
            if (this.isJmolDataFrameForAtom(this.at[n2])) {
                n = this.at[n2].mi;
                while (n2 >= 0 && this.at[n2].mi == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.at[n2];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BS bS, float f) {
        if (bS != null && bS.nextSetBit(0) < 0) {
            bS = null;
        }
        if (bS == null && this.isBbcageDefault || this.ac == 0) {
            return;
        }
        this.bboxAtoms = BSUtil.copy(bS);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bS, this.boxInfo) == this.ac) {
            this.isBbcageDefault = true;
        }
        if (bS == null && this.unitCells != null) {
            this.calcUnitCellMinMax();
        }
        this.boxInfo.setBbcage(f);
    }

    public BoxInfo getBoxInfo(BS bS, float f) {
        if (bS == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bS, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BS bS, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bS == null;
        int n3 = n = bl ? this.ac - 1 : bS.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrameForAtom(this.at[n3])) {
                boxInfo.addBoundBoxPoint(this.at[n3]);
            }
            n3 = bl ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.mc; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            P3[] p3Array = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(p3Array[j]);
            }
        }
    }

    public float calcRotationRadiusBs(BS bS) {
        P3 p3 = this.getAtomSetCenter(bS);
        float f = 0.0f;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.at[n];
            float f2 = p3.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bS.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public P3[][] getCenterAndPoints(List<Object[]> list, boolean bl) {
        BS bS;
        BS bS2;
        int n = bl ? 1 : 0;
        int n2 = list.size();
        while (--n2 >= 0) {
            Object[] objectArray = (Object[])list.get(n2);
            bS2 = (BS)objectArray[0];
            if (objectArray[1] instanceof BS) {
                bS = (BS)objectArray[1];
                n += Math.min(bS2.cardinality(), bS.cardinality());
                continue;
            }
            n += Math.min(bS2.cardinality(), ((P3[])objectArray[1]).length);
        }
        P3[][] p3Array = new P3[2][n];
        if (bl) {
            p3Array[0][0] = new P3();
            p3Array[1][0] = new P3();
        }
        int n3 = list.size();
        while (--n3 >= 0) {
            int n4;
            Object[] objectArray = (Object[])list.get(n3);
            bS2 = (BS)objectArray[0];
            if (objectArray[1] instanceof BS) {
                bS = (BS)objectArray[1];
                int n5 = bS2.nextSetBit(0);
                n4 = bS.nextSetBit(0);
                while (n5 >= 0 && n4 >= 0) {
                    p3Array[0][--n] = this.at[n5];
                    p3Array[1][n] = this.at[n4];
                    if (bl) {
                        p3Array[0][0].add(this.at[n5]);
                        p3Array[1][0].add(this.at[n4]);
                    }
                    n5 = bS2.nextSetBit(n5 + 1);
                    n4 = bS.nextSetBit(n4 + 1);
                }
                continue;
            }
            P3[] p3Array2 = (P3[])objectArray[1];
            n4 = bS2.nextSetBit(0);
            for (int i = 0; n4 >= 0 && i < p3Array2.length; ++i) {
                p3Array[0][--n] = this.at[n4];
                p3Array[1][n] = p3Array2[i];
                if (bl) {
                    p3Array[0][0].add(this.at[n4]);
                    p3Array[1][0].add(p3Array2[i]);
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
        }
        if (bl) {
            p3Array[0][0].scale(1.0f / (float)(p3Array[0].length - 1));
            p3Array[1][0].scale(1.0f / (float)(p3Array[1].length - 1));
        }
        return p3Array;
    }

    public P3 getAtomSetCenter(BS bS) {
        P3 p3 = new P3();
        int n = 0;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (!this.isJmolDataFrameForAtom(this.at[n2])) {
                ++n;
                p3.add(this.at[n2]);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        if (n > 0) {
            p3.scale(1.0f / (float)n);
        }
        return p3;
    }

    public P3 getAverageAtomPoint() {
        if (this.averageAtomPoint == null) {
            this.averageAtomPoint = new P3();
            this.averageAtomPoint.setT(this.getAtomSetCenter(this.vwr.getAllAtoms()));
        }
        return this.averageAtomPoint;
    }

    protected void setAPm(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        this.setAPa(bS, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 1095763990: 
            case 1632634891: {
                if (!this.vwr.getBoolean(603979944)) break;
                this.assignAromaticBonds();
            }
        }
    }

    public StateScript addStateScript(String string, BS bS, BS bS2, BS bS3, String string2, boolean bl, boolean bl2) {
        int n = this.vwr.getCurrentModelIndex();
        if (bl) {
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "all #" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bS, bS2, bS3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.addLast(stateScript);
        }
        return stateScript;
    }

    protected String calculateStructuresAllExcept(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.freezeModels();
        String string = "";
        BS bS2 = BSUtil.copyInvert(bS, this.mc);
        if (bl4) {
            this.setDefaultStructure(bS2);
        }
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            string = string + this.am[n].calculateStructures(bl, bl2, bl3, bl4, bl5);
            n = bS2.nextSetBit(n + 1);
        }
        if (bl4) {
            this.setStructureIndexes();
        }
        return string;
    }

    public void setDefaultStructure(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.am[n].isBioModel && this.am[n].defaultStructure == null) {
                this.am[n].defaultStructure = this.getProteinStructureState(this.am[n].bsAtoms, false, false, 0);
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    public void setProteinType(BS bS, STR sTR) {
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BS bS2 = this.getModelBitSet(bS, false);
        this.setDefaultStructure(bS2);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (n3 != n4 - 1) {
                n2 = -1;
            }
            n2 = this.at[n4].group.setProteinStructureType(sTR, n2);
            n = this.at[n4].mi;
            this.am[n].structureTainted = true;
            this.proteinStructureTainted = true;
            n3 = n4 = this.at[n4].group.lastAtomIndex;
            n4 = bS.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.mc];
        n = 0;
        while (n < this.ac) {
            s = this.at[n].mi;
            if (!bS2.get(s)) {
                n = this.am[s].firstAtomIndex + this.am[s].ac;
                continue;
            }
            n3 = this.at[n].getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = this.at[n].group.lastAtomIndex + 1;
        }
        n = 0;
        while (n < this.ac) {
            s = this.at[n].mi;
            if (!bS2.get(s)) {
                n = this.am[s].firstAtomIndex + this.am[s].ac;
                continue;
            }
            if (this.at[n].getStrucNo() > 1000) {
                short s2 = s;
                int n5 = nArray[s2] + 1;
                nArray[s2] = n5;
                this.at[n].group.setStrucNo(n5);
            }
            n = this.at[n].group.lastAtomIndex + 1;
        }
    }

    void freezeModels() {
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].freeze();
        }
    }

    public Map<STR, float[]> getStructureList() {
        return this.vwr.getStructureList();
    }

    public void setStructureList(Map<STR, float[]> map) {
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].setStructureList(map);
        }
    }

    public BS setConformation(BS bS) {
        BS bS2 = this.getModelBitSet(bS, false);
        int n = bS2.nextSetBit(0);
        while (n >= 0) {
            this.am[n].setConformation(bS);
            n = bS2.nextSetBit(n + 1);
        }
        return bS;
    }

    public BS getConformation(int n, int n2, boolean bl) {
        BS bS = new BS();
        int n3 = this.mc;
        while (--n3 >= 0) {
            if (n3 != n && n >= 0) continue;
            String string = this.getAltLocListInModel(n3);
            int n4 = this.getAltLocCountInModel(n3);
            if (n2 > 0 && n2 >= n4) continue;
            BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n3);
            if (n2 >= 0 && !this.am[n3].getPdbConformation(bS2, n2)) {
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bS2.andNot(this.getAtomBitsMDa(0x10001F, string.substring(n5, n5 + 1)));
                }
            }
            if (bS2.nextSetBit(0) < 0) continue;
            bS.or(bS2);
            if (!bl) continue;
            this.am[n3].setConformation(bS2);
        }
        return bS;
    }

    public Map<String, String> getHeteroList(int n) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        int n2 = this.mc;
        while (--n2 >= 0) {
            Map map;
            if (n >= 0 && n2 != n || (map = (Map)this.getModelAuxiliaryInfoValue(n2, "hetNames")) == null) continue;
            bl = true;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                hashtable.put(string, (String)entry.getValue());
            }
        }
        return bl ? hashtable : (Map)this.getModelSetAuxiliaryInfoValue("hetNames");
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Map<String, Object> getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfoValue(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    public boolean getModelSetAuxiliaryInfoBoolean(String string) {
        Object object = this.getModelSetAuxiliaryInfoValue(string);
        return object instanceof Boolean && (Boolean)object != false;
    }

    protected int mergeTrajectories(boolean bl) {
        if (this.trajectorySteps == null) {
            if (!bl) {
                return 0;
            }
            this.trajectorySteps = new List();
        }
        for (int i = this.trajectorySteps.size(); i < this.mc; ++i) {
            this.trajectorySteps.addLast(null);
        }
        return this.mc;
    }

    public int getTrajectoryIndex(int n) {
        return this.am[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.am[n].isTrajectory;
    }

    public boolean isTrajectoryMeasurement(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray[0];
        for (int i = 1; i <= n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || !this.am[this.at[n2].mi].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BS getModelBitSet(BS bS, boolean bl) {
        int n;
        BS bS2 = new BS();
        short s = 0;
        boolean bl2 = bS == null;
        int n2 = n = bl2 ? 0 : bS.nextSetBit(0);
        while (n2 >= 0 && n2 < this.ac) {
            s = this.at[n2].mi;
            bS2.set(s);
            if (bl) {
                int n3 = this.am[s].trajectoryBaseIndex;
                for (int i = 0; i < this.mc; ++i) {
                    if (this.am[i].trajectoryBaseIndex != n3) continue;
                    bS2.set(i);
                }
            }
            n2 = this.am[s].firstAtomIndex + this.am[s].ac - 1;
            n2 = bl2 ? n2 + 1 : bS.nextSetBit(n2 + 1);
        }
        return bS2;
    }

    public BS getIterativeModels(boolean bl) {
        BS bS = new BS();
        for (int i = 0; i < this.mc; ++i) {
            if (!bl && this.isJmolDataFrameForModel(i) || this.am[i].trajectoryBaseIndex != i) continue;
            bS.set(i);
        }
        return bS;
    }

    public boolean isTrajectorySubFrame(int n) {
        return this.am[n].isTrajectory && this.am[n].trajectoryBaseIndex != n;
    }

    public BS selectDisplayedTrajectories(BS bS) {
        for (int i = 0; i < this.mc; ++i) {
            if (!this.am[i].isTrajectory || this.at[this.am[i].firstAtomIndex].mi == i) continue;
            bS.clear(i);
        }
        return bS;
    }

    public void fillAtomData(AtomData atomData, int n) {
        Object object;
        if ((n & 4) != 0) {
            this.getMolecules();
            atomData.bsMolecules = new BS[this.molecules.length];
            atomData.atomMolecule = new int[this.ac];
            for (int i = 0; i < this.molecules.length; ++i) {
                atomData.bsMolecules[i] = this.molecules[i].atomList;
                object = atomData.bsMolecules[i];
                int n2 = ((BS)object).nextSetBit(0);
                while (n2 >= 0) {
                    atomData.atomMolecule[n2] = i;
                    n2 = ((BS)object).nextSetBit(n2 + 1);
                }
            }
        }
        if ((n & 8) != 0) {
            object = new int[1];
            atomData.hAtomRadius = (float)this.vwr.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.calculateHydrogens(atomData.bsSelected, (int[])object, false, true, null);
            atomData.hydrogenAtomCount = object[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.am[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.ac == 0 ? 0 : (int)this.at[atomData.firstAtomIndex].mi;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        this.fillADa(atomData, n);
    }

    public String getModelNumberDotted(int n) {
        return this.mc < 1 || n >= this.mc || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        if (n == Integer.MAX_VALUE) {
            n = this.mc - 1;
        }
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.am[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.am[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Map<String, Object> getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.am[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.am[n].auxiliaryInfo.put((String)object, object2);
    }

    public Object getModelAuxiliaryInfoValue(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.am[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Map<String, Object> map = this.am[n].auxiliaryInfo;
        return map != null && map.containsKey(string) && (Boolean)map.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Map<String, Object> map = this.am[n].auxiliaryInfo;
        if (map != null && map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public String getModelAtomProperty(Atom atom, String string) {
        Object object = this.getModelAuxiliaryInfoValue(atom.mi, string);
        if (!(object instanceof Object[])) {
            return "";
        }
        int n = atom.i - this.am[atom.mi].firstAtomIndex;
        Object[] objectArray = (Object[])object;
        return n < objectArray.length ? objectArray[n].toString() : "";
    }

    public int getInsertionCountInModel(int n) {
        return this.am[n].nInsertions;
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)Math.floor(f);
        for (n = (int)Math.floor(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getAltLocCountInModel(int n) {
        return this.am[n].nAltLocs;
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.mc;
        while (--n2 >= 0) {
            n += this.am[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.mc;
        while (--n2 >= 0) {
            if (this.isTrajectorySubFrame(n2)) continue;
            n += this.am[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        return n < 0 ? this.getBioPolymerCount() : (this.isTrajectorySubFrame(n) ? 0 : this.am[n].getBioPolymerCount());
    }

    public void getPolymerPointsAndVectors(BS bS, List<P3[]> list, boolean bl, float f) {
        for (int i = 0; i < this.mc; ++i) {
            this.am[i].getPolymerPointsAndVectors(bS, list, bl, f);
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.mc; ++i) {
                if (this.isTrajectorySubFrame(i)) continue;
                this.am[i].recalculateLeadMidpointsAndWingVectors();
            }
            return;
        }
        this.am[n].recalculateLeadMidpointsAndWingVectors();
    }

    public P3[] getPolymerLeadMidPoints(int n, int n2) {
        return this.am[n].getPolymerLeadMidPoints(n2);
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.am[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.mc;
        while (--n2 >= 0) {
            n += this.am[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.am[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BS bS) {
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].calcSelectedGroupsCount(bS);
        }
    }

    public void calcSelectedMonomersCount(BS bS) {
        int n = this.mc;
        while (--n >= 0) {
            this.am[n].calcSelectedMonomersCount(bS);
        }
    }

    public void calcRasmolHydrogenBonds(BS bS, BS bS2, List<Bond> list, boolean bl, int n, boolean bl2, BS bS3) {
        boolean bl3 = bS2 == null || bS.equals(bS2);
        int n2 = this.mc;
        while (--n2 >= 0) {
            if (!this.am[n2].isBioModel || this.am[n2].trajectoryBaseIndex != n2) continue;
            if (list == null) {
                this.am[n2].clearRasmolHydrogenBonds(bS);
                if (!bl3) {
                    this.am[n2].clearRasmolHydrogenBonds(bS2);
                }
            }
            this.am[n2].getRasmolHydrogenBonds(bS, bS2, list, bl, n, bl2, bS3);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char c = 'S';
        char c2 = this.vwr.getQuaternionFrame();
        int n = this.vwr.getInt(0x21000012);
        int n2 = this.mc;
        while (--n2 >= 0) {
            this.am[n2].calculateStraightness(this.vwr, c, c2, n);
        }
        this.setHaveStraightness(true);
    }

    public Quat[] getAtomGroupQuaternions(BS bS, int n, char c) {
        int n2 = 0;
        List<Quat> list = new List<Quat>();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block6: {
                Quat quat;
                Group group;
                block5: {
                    group = this.at[n3].group;
                    quat = group.getQuaternion(c);
                    if (quat != null) break block5;
                    if (group.seqcode == Integer.MIN_VALUE) {
                        quat = group.getQuaternionFrame(this.at);
                    }
                    if (quat == null) break block6;
                }
                ++n2;
                list.addLast(quat);
                n3 = group.lastAtomIndex;
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return list.toArray(new Quat[list.size()]);
    }

    public String getPdbAtomData(BS bS, OC oC) {
        int n;
        if (this.ac == 0 || bS.nextSetBit(0) < 0) {
            return "";
        }
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        }
        short s = this.at[bS.nextSetBit((int)0)].mi;
        short s2 = -1;
        boolean bl = "PQR".equals(oC.getType());
        String string = "%6.2Q%6.2b          ";
        if (bl) {
            string = "%8.4P%7.4V       ";
            float f = 0.0f;
            n = bS.nextSetBit(0);
            while (n >= 0) {
                f += this.at[n].getPartialCharge();
                n = bS.nextSetBit(n + 1);
            }
            oC.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + f + " e\nREMARK   6\n");
        }
        int n2 = bS.length() - 1;
        n = s != this.at[n2].mi ? 1 : 0;
        SB sB = n != 0 ? null : new SB();
        boolean bl2 = this.am[s].isPdbWithMultipleBonds;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Bond[] bondArray;
            Atom atom = this.at[n3];
            if (n != 0 && atom.mi != s2) {
                if (s2 != -1) {
                    oC.append("ENDMDL\n");
                }
                s2 = atom.mi;
                oC.append("MODEL     " + (s2 + 1) + "\n");
            }
            String string2 = atom.getAtomName();
            boolean bl3 = atom.getElementSymbol().length() == 2 || string2.length() >= 4 || Character.isDigit(string2.charAt(0));
            boolean bl4 = this.am[atom.mi].isBioModel;
            boolean bl5 = atom.isHetero();
            LabelToken[] labelTokenArray = !bl4 ? (bl3 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl5 ? (bl3 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)) : (bl3 ? LabelToken.compile(this.vwr, "ATOM  %5.-5i %-4.4a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null) : LabelToken.compile(this.vwr, "ATOM  %5.-5i  %-3.3a%1A%3.-3n %1c%4.-4R%1E   %8.3x%8.3y%8.3z" + string, '\u0000', null)));
            String string3 = atom.getElementSymbolIso(false).toUpperCase();
            oC.append(LabelToken.formatLabelAtomArray(this.vwr, atom, labelTokenArray, '\u0000', null)).append(string3.length() == 1 ? " " + string3 : string3.substring(0, 2)).append("  \n");
            if (n == 0 && (!bl4 || bl5 || bl2) && (bondArray = atom.getBonds()) != null) {
                block6: for (int i = 0; i < bondArray.length; ++i) {
                    int n4;
                    int n5 = atom.getAtomNumber();
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (!bS.get(atom2.i) || (n4 = bondArray[i].getCovalentOrder()) == 1 && bl2 && !bl5) continue;
                    int n6 = atom2.getAtomNumber();
                    switch (n4) {
                        case 2: 
                        case 3: {
                            if (n6 < n5) continue block6;
                        }
                        case 1: {
                            sB.append("CONECT").append(Txt.formatStringI("%5i", "i", n5));
                            for (int j = 0; j < n4; ++j) {
                                sB.append(Txt.formatStringI("%5i", "i", n6));
                            }
                            sB.appendC('\n');
                        }
                    }
                }
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (n != 0) {
            oC.append("ENDMDL\n");
        } else {
            oC.append(sB.toString());
        }
        return oC.toString();
    }

    public String getPdbData(int n, String string, BS bS, Object[] objectArray, OC oC) {
        if (this.isJmolDataFrameForModel(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        boolean bl = this.am[n].isBioModel;
        if (objectArray == null && !bl) {
            return null;
        }
        Model model = this.am[n];
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        }
        SB sB = new SB();
        boolean bl2 = string.indexOf("draw") >= 0;
        BS bS2 = null;
        BS bS3 = new BS();
        char c = '\u0000';
        this.getLabeler();
        LabelToken[] labelTokenArray = LabelToken.compile(this.vwr, "ATOM  %-6i%4a%1A%3n %1c%4R%1E   ", '\u0000', null);
        if (objectArray == null) {
            c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            model.getPdbData(this.vwr, string, c, bl2, bS, oC, labelTokenArray, sB, bS3);
            bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        } else {
            bS2 = (BS)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl3 = fArray3 != null;
            P3 p3 = (P3)objectArray[4];
            P3 p32 = (P3)objectArray[5];
            P3 p33 = (P3)objectArray[6];
            P3 p34 = (P3)objectArray[7];
            oC.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append(";\n");
            oC.append("REMARK   6 Jmol data").append(" min = ").append(Escape.eP(p3)).append(" max = ").append(Escape.eP(p32)).append(" unScaledXyz = xyz * ").append(Escape.eP(p33)).append(" + ").append(Escape.eP(p34)).append(";\n");
            String string2 = "";
            Atom atom = null;
            int n2 = bS2.nextSetBit(0);
            int n3 = 0;
            while (n2 >= 0) {
                float f;
                float f2 = fArray[n3];
                float f3 = fArray2[n3];
                float f4 = f = bl3 ? fArray3[n3] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom2 = this.at[n2];
                    oC.append(LabelToken.formatLabelAtomArray(this.vwr, atom2, labelTokenArray, '\u0000', null));
                    if (bl) {
                        bS3.set(n2);
                    }
                    oC.append(Txt.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", "ssF", new Object[]{atom2.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                    if (atom != null && atom.getPolymerIndexInModel() == atom2.getPolymerIndexInModel()) {
                        sB.append("CONECT").append(Txt.formatStringI("%5i", "i", atom.getAtomNumber())).append(Txt.formatStringI("%5i", "i", atom2.getAtomNumber())).appendC('\n');
                    }
                    atom = atom2;
                }
                n2 = bS2.nextSetBit(n2 + 1);
                ++n3;
            }
        }
        oC.append(sB.toString());
        if (bl2) {
            return oC.toString();
        }
        bS.and(bS2);
        if (bl) {
            oC.append("\n\n" + this.getProteinStructureState(bS3, false, c == 'R', 1));
        }
        return oC.toString();
    }

    public boolean isJmolDataFrameForModel(int n) {
        return n >= 0 && n < this.mc && this.am[n].isJmolDataFrame;
    }

    private boolean isJmolDataFrameForAtom(Atom atom) {
        return this.am[atom.mi].isJmolDataFrame;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.am[string == null ? this.am[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.am[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable<String, Integer>();
            }
            this.am[n2].dataSourceFrame = n;
            this.am[n2].jmolFrameType = string;
            model.dataFrames.put(string, n2);
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, n2);
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.am[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = this.am[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.mc; ++i) {
            Map<String, Integer> map = this.am[i].dataFrames;
            if (map == null) continue;
            Iterator<Integer> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != n) continue;
                iterator.remove();
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.mc ? this.am[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.mc ? this.am[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, Orientation orientation) {
        this.am[n].orientation = orientation;
    }

    public Orientation getModelOrientation(int n) {
        return this.am[n].orientation;
    }

    public String getPDBHeader(int n) {
        return this.am[n].isBioModel ? this.am[n].getFullPDBHeader() : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.am[n].isBioModel) {
            return this.am[n].getFullPDBHeader();
        }
        String string = (String)this.getModelAuxiliaryInfoValue(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfoValue(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfoValue(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        return this.am[n].biosymmetryCount > 0 ? this.am[n].biosymmetryCount : (this.unitCells == null || this.unitCells[n] == null ? 0 : this.unitCells[n].getSpaceGroupOperationCount());
    }

    public String getSymmetryInfoString(int n, String string, int n2, P3 p3, P3 p32, String string2, boolean bl) {
        Map<String, Object> map = this.getSymTemp(true).getSpaceGroupInfo((ModelSet)this, n, string, n2, p3, p32, string2);
        if (map == null) {
            return "";
        }
        return this.symTemp.getSymmetryInfoString(map, n2, string2, bl);
    }

    public int[] getModelCellRange(int n) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[n].getCellRange();
    }

    public int getLastVibrationVector(int n, int n2) {
        if (this.vibrations != null) {
            int n3 = this.ac;
            while (--n3 >= 0) {
                if (n >= 0 && this.at[n3].mi != n || this.vibrations[n3] == null || !(this.vibrations[n3].length() > 0.0f) || n2 != 0 && n2 == 1276121113 != this.vibrations[n3] instanceof JmolModulationSet) continue;
                return n3;
            }
        }
        return -1;
    }

    public List<Object> getModulationList(BS bS, String string, P3 p3) {
        List<Object> list = new List<Object>();
        if (this.vibrations != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (this.vibrations[n] instanceof JmolModulationSet) {
                    list.addLast(((JmolModulationSet)((Object)this.vibrations[n])).getModulation(string, p3));
                } else {
                    list.addLast((Object)null);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        return list;
    }

    public BS getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BS bS = new BS();
        for (int i = 0; i < this.mc; ++i) {
            bS.or(this.elementsPresent[i]);
        }
        return bS;
    }

    private String getSymmetryInfoAsStringForModel(int n) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoString();
    }

    public int getMoleculeIndex(int n, boolean bl) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return bl ? this.molecules[i].indexInModel : i;
        }
        return 0;
    }

    public BS getMoleculeBitSet(BS bS) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BS bS2 = BSUtil.copy(bS);
        BS bS3 = BSUtil.copy(bS);
        int n = 0;
        BS bS4 = new BS();
        while ((n = bS3.length() - 1) >= 0) {
            bS4 = this.getMoleculeBitSetForAtom(n);
            if (bS4 == null) {
                bS3.clear(n);
                bS2.clear(n);
                continue;
            }
            bS3.andNot(bS4);
            bS2.or(bS4);
        }
        return bS2;
    }

    public BS getMoleculeBitSetForAtom(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public V3 getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        V3 v3 = (V3)this.getModelAuxiliaryInfoValue(n, "dipole");
        if (v3 == null) {
            v3 = (V3)this.getModelAuxiliaryInfoValue(n, "DIPOLE_VEC");
        }
        return v3;
    }

    public V3 calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        for (int i = 0; i < this.ac; ++i) {
            if (this.at[i].mi != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                v32.scaleAdd2(f3, this.at[i], v32);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            v3.scaleAdd2(f3, this.at[i], v3);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        v3.scale(1.0f / f);
        v32.scale(1.0f / f2);
        v3.sub(v32);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        v3.scale(f * 4.8f);
        return v3;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.mc; ++i) {
            if (n != i) continue;
            n2 += this.am[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BS bS) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        BS bS2 = new BS();
        for (int i = 0; i < this.moleculeCount; ++i) {
            BSUtil.copy2(bS, bS2);
            bS2.and(this.molecules[i].atomList);
            if (bS2.length() <= 0) continue;
            this.selectedMolecules.set(i);
        }
    }

    public void setCentroid(BS bS, int[] nArray) {
        BS bS2 = this.getNotInCentroid(bS, nArray);
        if (bS2 != null && bS2.nextSetBit(0) >= 0) {
            this.vwr.deleteAtoms(bS2, false);
        }
    }

    private BS getNotInCentroid(BS bS, int[] nArray) {
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return null;
        }
        SymmetryInterface symmetryInterface = this.getUnitCell(this.at[n].mi);
        return symmetryInterface == null ? null : symmetryInterface.notInCentroid((ModelSet)this, bS, nArray);
    }

    public JmolMolecule[] getMolecules() {
        int n;
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new JmolMolecule[4];
        }
        this.moleculeCount = 0;
        Model model = null;
        BS[] bSArray = new BS[this.mc];
        List<BS> list = null;
        for (n = 0; n < this.mc; ++n) {
            bSArray[n] = this.vwr.getModelUndeletedAtomsBitSet(n);
            model = this.am[n];
            model.moleculeCount = 0;
            list = model.getBioBranches(list);
        }
        this.molecules = JmolMolecule.getMolecules(this.at, bSArray, list, null);
        n = this.moleculeCount = this.molecules.length;
        while (--n >= 0) {
            model = this.am[this.molecules[n].modelIndex];
            model.firstMoleculeIndex = n;
            ++model.moleculeCount;
        }
        return this.molecules;
    }

    protected void initializeBspf() {
        if (this.bspf != null && this.bspf.isInitialized()) {
            return;
        }
        if (this.showRebondTimes) {
            Logger.startTimer("build bspf");
        }
        Bspf bspf = new Bspf(3);
        if (Logger.debugging) {
            Logger.debug("sequential bspt order");
        }
        BS bS = BS.newN(this.mc);
        int n = this.ac;
        while (--n >= 0) {
            Atom atom = this.at[n];
            if (atom.isDeleted() || this.isTrajectorySubFrame(atom.mi)) continue;
            bspf.addTuple(this.am[atom.mi].trajectoryBaseIndex, atom);
            bS.set(atom.mi);
        }
        if (this.showRebondTimes) {
            Logger.checkTimer("build bspf", false);
            bspf.stats();
        }
        n = bS.nextSetBit(0);
        while (n >= 0) {
            bspf.validateModel(n, true);
            n = bS.nextSetBit(n + 1);
        }
        bspf.validate(true);
        this.bspf = bspf;
    }

    protected void initializeBspt(int n) {
        this.initializeBspf();
        if (this.bspf.isInitializedIndex(n)) {
            return;
        }
        this.bspf.initialize(n, this.at, this.vwr.getModelUndeletedAtomsBitSet(n));
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, P3 p3, float f) {
        if (n < 0) {
            atomIndexIterator.setCenter(p3, f);
            return;
        }
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.am[n].firstAtomIndex, Integer.MAX_VALUE, p3, f, null);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, int n2, float f, RadiusData radiusData) {
        if (n < 0) {
            n = this.at[n2].mi;
        }
        n = this.am[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        atomIndexIterator.setModel(this, n, this.am[n].firstAtomIndex, n2, this.at[n2], f, radiusData);
    }

    public AtomIndexIterator getSelectedAtomIterator(BS bS, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AtomIteratorWithinModel atomIteratorWithinModel;
        this.initializeBspf();
        if (bl4) {
            BS bS2 = this.getModelBitSet(bS, false);
            int n = bS2.nextSetBit(0);
            while (n >= 0) {
                this.initializeBspt(n);
                n = bS2.nextSetBit(n + 1);
            }
            atomIteratorWithinModel = new AtomIteratorWithinModelSet(bS2);
        } else {
            atomIteratorWithinModel = new AtomIteratorWithinModel();
        }
        atomIteratorWithinModel.initialize(this.bspf, bS, bl, bl2, bl3, this.vwr.isParallel());
        return atomIteratorWithinModel;
    }

    @Override
    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.am[n].getBondCount();
    }

    public int calculateStruts(BS bS, BS bS2) {
        return this.calculateStrutsMC(bS, bS2);
    }

    protected int calculateStrutsMC(BS bS, BS bS2) {
        this.makeConnections2(0.0f, Float.MAX_VALUE, 32768, 12291, bS, bS2, null, false, false, 0.0f);
        int n = bS.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        Model model = this.am[this.at[n].mi];
        return model.isBioModel ? model.calculateStruts((ModelSet)this, bS, bS2) : 0;
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.ac : this.am[n].ac;
    }

    public BS getModelAtomBitSetIncludingDeletedBs(BS bS) {
        BS bS2 = new BS();
        if (bS == null && this.bsAll == null) {
            this.bsAll = BSUtil.setAll(this.ac);
        }
        if (bS == null) {
            bS2.or(this.bsAll);
        } else {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                bS2.or(this.getModelAtomBitSetIncludingDeleted(n, false));
                n = bS.nextSetBit(n + 1);
            }
        }
        return bS2;
    }

    public BS getModelAtomBitSetIncludingDeleted(int n, boolean bl) {
        BS bS;
        BS bS2 = bS = n < 0 ? this.bsAll : this.am[n].bsAtoms;
        if (bS == null) {
            bS = this.bsAll = BSUtil.setAll(this.ac);
        }
        return bl ? BSUtil.copy(bS) : bS;
    }

    protected BS getAtomBitsMaybeDeleted(int n, Object object) {
        switch (n) {
            default: {
                return this.getAtomBitsMDa(n, object);
            }
            case 0x100009: 
            case 1678770178: {
                return this.getAtomBitsMDb(n, object);
            }
            case 1073741864: {
                return this.getBasePairBits((String)object);
            }
            case 1679429641: {
                BoxInfo boxInfo = this.getBoxInfo((BS)object, 1.0f);
                BS bS = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.at[n2])) {
                        bS.clear(n2);
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                return bS;
            }
            case 1095761925: {
                BS bS = new BS();
                int[] nArray = (int[])object;
                this.ptTemp1.set((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
                boolean bl = !this.vwr.getBoolean(603979848);
                int n3 = this.ac;
                while (--n3 >= 0) {
                    if (!this.isInLatticeCell(n3, this.ptTemp1, this.ptTemp2, bl)) continue;
                    bS.set(n3);
                }
                return bS;
            }
            case 1095761926: {
                BS bS = BSUtil.newBitSet2(0, this.ac);
                int[] nArray = (int[])object;
                int[] nArray2 = new int[]{nArray[0] / 1000 - 1, nArray[1] / 1000 - 1, nArray[2] / 1000 - 1, nArray[0] / 1000, nArray[1] / 1000, nArray[2] / 1000, 0};
                int n4 = this.mc;
                while (--n4 >= 0) {
                    SymmetryInterface symmetryInterface = this.getUnitCell(n4);
                    if (symmetryInterface == null) {
                        BSUtil.andNot(bS, this.am[n4].bsAtoms);
                        continue;
                    }
                    bS.andNot(symmetryInterface.notInCentroid((ModelSet)this, this.am[n4].bsAtoms, nArray2));
                }
                return bS;
            }
            case 1095761936: {
                return this.getMoleculeBitSet((BS)object);
            }
            case 1087373320: {
                return this.getSequenceBits((String)object, null);
            }
            case 1048615: {
                int[] nArray = (int[])object;
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = nArray[2];
                BS bS = new BS();
                boolean bl = this.vwr.getBoolean(603979823);
                if (n7 >= 0 && n7 < 256 && !bl) {
                    n7 = ModelCollection.chainToUpper(n7);
                }
                int n8 = this.mc;
                while (--n8 >= 0) {
                    if (!this.am[n8].isBioModel) continue;
                    this.am[n8].selectSeqcodeRange(n5, n6, n7, bS, bl);
                }
                return bS;
            }
            case 3145772: {
                BS bS = BS.newN(this.ac);
                short s = -1;
                int n9 = 0;
                int n10 = this.ac;
                block17: while (--n10 >= 0) {
                    Atom atom = this.at[n10];
                    BS bS2 = atom.getAtomSymmetry();
                    if (bS2 == null) continue;
                    if (atom.mi != s) {
                        s = atom.mi;
                        if (this.getModelCellRange(s) == null) continue;
                        n9 = this.getModelSymmetryCount(s);
                    }
                    int n11 = 0;
                    int n12 = n9;
                    while (--n12 >= 0) {
                        if (!bS2.get(n12) || ++n11 <= 1) continue;
                        bS.set(n10);
                        continue block17;
                    }
                }
                return bS;
            }
            case 1089470478: {
                return BSUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = BS.newN(this.ac)) : this.bsSymmetry);
            }
            case 1614417948: 
        }
        BS bS = new BS();
        SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return bS;
        }
        this.ptTemp1.set(1.0f, 1.0f, 1.0f);
        int n13 = this.ac;
        while (--n13 >= 0) {
            if (!this.isInLatticeCell(n13, this.ptTemp1, this.ptTemp2, false)) continue;
            bS.set(n13);
        }
        return bS;
    }

    private boolean isInLatticeCell(int n, P3 p3, P3 p32, boolean bl) {
        short s = this.at[n].mi;
        SymmetryInterface symmetryInterface = this.getUnitCell(s);
        p32.setT(this.at[n]);
        return symmetryInterface != null && symmetryInterface.checkUnitCell(symmetryInterface, p3, p32, bl);
    }

    public BS getAtomsWithinRD(float f, BS bS, boolean bl, RadiusData radiusData) {
        BS bS2 = new BS();
        BS bS3 = this.getIterativeModels(false);
        bS = BSUtil.andNot(bS, this.vwr.getDeletedAtoms());
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        if (bl) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                int n2 = this.mc;
                while (--n2 >= 0) {
                    if (!bS3.get(n2)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(f, this.at[n].getFractionalUnitCoordPt(true), bS2, -1);
                        continue;
                    }
                    this.setIteratorForAtom(atomIndexIterator, n2, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        } else {
            bS2.or(bS);
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(f, this.at[n], bS2, this.at[n].mi);
                } else {
                    this.setIteratorForAtom(atomIndexIterator, -1, n, f, radiusData);
                    atomIndexIterator.addAtoms(bS2);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        atomIndexIterator.release();
        return bS2;
    }

    public BS getGroupsWithin(int n, BS bS) {
        BS bS2 = this.getIterativeModels(false);
        BS bS3 = new BS();
        int n2 = this.mc;
        while (--n2 >= 0) {
            if (!bS2.get(n2) || !this.am[n2].isBioModel) continue;
            this.am[n2].getGroupsWithin(n, bS, bS3);
        }
        return bS3;
    }

    public BS getAtomsWithin(float f, P3 p3, BS bS, int n) {
        if (bS == null) {
            bS = new BS();
        }
        if (f < 0.0f) {
            f = -f;
            int n2 = this.ac;
            while (--n2 >= 0) {
                Atom atom = this.at[n2];
                if (n >= 0 && this.at[n2].mi != n || bS.get(n2) || !(atom.getFractionalUnitDistance(p3, this.ptTemp1, this.ptTemp2) <= f)) continue;
                bS.set(atom.i);
            }
            return bS;
        }
        BS bS2 = this.getIterativeModels(true);
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, false, false);
        int n3 = this.mc;
        while (--n3 >= 0) {
            if (!bS2.get(n3)) continue;
            this.setIteratorForAtom(atomIndexIterator, -1, this.am[n3].firstAtomIndex, -1.0f, null);
            atomIndexIterator.setCenter(p3, f);
            atomIndexIterator.addAtoms(bS);
        }
        atomIndexIterator.release();
        return bS;
    }

    private BS getBasePairBits(String string) {
        BS bS = new BS();
        if (string.length() % 2 != 0) {
            return bS;
        }
        BS bS2 = null;
        BS bS3 = null;
        List<Bond> list = new List<Bond>();
        if (string.length() == 0) {
            bS2 = bS3 = this.vwr.getAllAtoms();
            this.calcRasmolHydrogenBonds(bS2, bS3, list, true, 1, false, null);
        } else {
            int n = 0;
            while (n < string.length()) {
                if ((bS2 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0 || (bS3 = this.getSequenceBits(string.substring(n++, n), null)).cardinality() == 0) continue;
                this.calcRasmolHydrogenBonds(bS2, bS3, list, true, 1, false, null);
            }
        }
        BS bS4 = new BS();
        int n = list.size();
        while (--n >= 0) {
            Bond bond = (Bond)list.get(n);
            bS4.set(bond.atom1.i);
            bS4.set(bond.atom2.i);
        }
        return this.getAtomBitsMDb(1087373318, bS4);
    }

    public BS getSequenceBits(String string, BS bS) {
        if (bS == null) {
            bS = this.vwr.getAllAtoms();
        }
        BS bS2 = new BS();
        if (string.length() > 0) {
            for (int i = 0; i < this.mc; ++i) {
                if (!this.am[i].isBioModel) continue;
                this.am[i].getSequenceBits(string, bS, bS2);
            }
        }
        return bS2;
    }

    public void deleteBonds(BS bS, boolean bl) {
        if (!bl) {
            BS bS2 = new BS();
            BS bS3 = new BS();
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                Atom atom = this.bo[n].atom1;
                if (!this.am[atom.mi].isModelKit) {
                    bS2.clearAll();
                    bS3.clearAll();
                    bS2.set(atom.i);
                    bS3.set(this.bo[n].getAtomIndex2());
                    this.addStateScript("connect ", null, bS2, bS3, "delete", false, true);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
        this.dBb(bS, bl);
    }

    protected int[] makeConnections2(float f, float f2, int n, int n2, BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, float f3) {
        boolean bl3;
        boolean bl4;
        if (bS3 == null) {
            bS3 = new BS();
        }
        boolean bl5 = n == 65535;
        boolean bl6 = bl4 = n == 131071;
        if (bl4) {
            n = 1;
        }
        boolean bl7 = Bond.isOrderH(n);
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        switch (n2) {
            case 12291: {
                return this.deleteConnections(f, f2, n, bS, bS2, bl, bl4);
            }
            case 603979874: 
            case 1073741852: {
                if (n != 515) {
                    return this.autoBond(bS, bS2, bS3, bl, bl7, n2 == 603979874);
                }
                bl11 = true;
                bl9 = true;
                break;
            }
            case 1087373321: {
                bl9 = true;
                bl8 = true;
                break;
            }
            case 1073742025: {
                bl9 = true;
                break;
            }
            case 0x40000050: {
                bl10 = true;
            }
        }
        boolean bl12 = !bl8 || bl5;
        boolean bl13 = !bl8 && !bl5;
        this.defaultCovalentMad = this.vwr.getMadBond();
        boolean bl14 = f < 0.0f;
        boolean bl15 = f2 < 0.0f;
        boolean bl16 = bl14 || bl15;
        boolean bl17 = bl3 = !bl || f != 0.1f || f2 != 1.0E8f;
        if (bl3) {
            f = this.fixD(f, bl14);
            f2 = this.fixD(f2, bl15);
        }
        short s = this.getDefaultMadFromOrder(n);
        int n3 = 0;
        int n4 = 0;
        Bond bond = null;
        Atom atom = null;
        Atom atom2 = null;
        char c = '\u0000';
        short s2 = (short)(n | 0x20000);
        try {
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                block28: {
                    int n6;
                    block27: {
                        block26: {
                            if (!bl) break block26;
                            bond = this.bo[n5];
                            atom = bond.atom1;
                            atom2 = bond.atom2;
                            break block27;
                        }
                        atom = this.at[n5];
                        if (atom.isDeleted()) break block28;
                        c = this.isModulated(n5) ? (char)'\u0000' : atom.altloc;
                    }
                    int n7 = n6 = bl ? 0 : bS2.nextSetBit(0);
                    while (n6 >= 0) {
                        block31: {
                            block30: {
                                block29: {
                                    if (!bl) break block29;
                                    n6 = 0x7FFFFFFE;
                                    break block30;
                                }
                                if (n6 == n5) break block31;
                                atom2 = this.at[n6];
                                if (atom.mi != atom2.mi || atom2.isDeleted() || c != '\u0000' && c != atom2.altloc && atom2.altloc != '\u0000') break block31;
                                bond = atom.getBond(atom2);
                            }
                            if (!(bond != null ? bl10 : bl9)) {
                                if (!bl3 || this.isInRange(atom, atom2, f, f2, bl14, bl15, bl16)) {
                                    if (bond == null) {
                                        bS3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BS)bS3, (float)f3, (boolean)bl2, (boolean)true).index);
                                        ++n3;
                                    } else {
                                        if (bl13) {
                                            bond.setOrder(n);
                                            this.bsAromatic.clear(bond.index);
                                        }
                                        if (bl12 || n == bond.order || s2 == bond.order || bl7 && bond.isHydrogen()) {
                                            bS3.set(bond.index);
                                            ++n4;
                                        }
                                    }
                                }
                            }
                        }
                        n6 = bS2.nextSetBit(n6 + 1);
                    }
                }
                n5 = bS.nextSetBit(n5 + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl11) {
            this.assignAromaticBondsBs(true, bS3);
        }
        if (!bl8) {
            this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS3);
        }
        return new int[]{n3, n4};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBondBs4(BS bS, BS bS2, BS bS3, BS bS4, short s, boolean bl) {
        BS bS5;
        int n;
        boolean bl2;
        if (bl) {
            return this.autoBond_Pre_11_9_24(bS, bS2, bS3, bS4, s);
        }
        if (this.ac == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.vwr.getFloat(0x22000004);
        float f2 = this.vwr.getFloat(570425364);
        float f3 = f2 * f2;
        int n2 = 0;
        if (this.showRebondTimes) {
            Logger.startTimer("autobond");
        }
        short s2 = -1;
        boolean bl3 = bl2 = bS == null;
        if (bl2) {
            n = 0;
            bS5 = null;
        } else {
            if (bS.equals(bS2)) {
                bS5 = bS;
            } else {
                bS5 = BSUtil.copy(bS);
                bS5.or(bS2);
            }
            n = bS5.nextSetBit(0);
        }
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(null, false, false, true, false);
        int n3 = n;
        while (true) {
            block13: {
                boolean bl4;
                float f4;
                Atom atom;
                boolean bl5;
                boolean bl6;
                block15: {
                    block12: {
                        block14: {
                            if (n3 < 0 || n3 >= this.ac) break block12;
                            bl6 = bl2 || bS.get(n3);
                            bl5 = bl2 || bS2.get(n3);
                            atom = this.at[n3];
                            if (atom.isDeleted()) break block13;
                            short s3 = atom.mi;
                            if (s3 == s2) break block14;
                            s2 = s3;
                            if (!this.isJmolDataFrameForModel(s3)) break block14;
                            n3 = this.am[s3].firstAtomIndex + this.am[s3].ac - 1;
                            break block13;
                        }
                        if ((f4 = atom.getBondingRadius()) == 0.0f) break block13;
                        bl4 = bS3 != null && bS3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        this.setIteratorForAtom(atomIndexIterator, -1, n3, f5, null);
                        break block15;
                    }
                    if (this.showRebondTimes) {
                        Logger.checkTimer("autoBond", false);
                    }
                    return n2;
                }
                while (atomIndexIterator.hasNext()) {
                    short s4;
                    boolean bl7;
                    Atom atom2 = this.at[atomIndexIterator.next()];
                    if (atom2.isDeleted()) continue;
                    int n4 = atom2.i;
                    boolean bl8 = bl2 || bS.get(n4);
                    boolean bl9 = bl7 = bl2 || bS2.get(n4);
                    if (!bl8 && !bl7 || (!bl6 || !bl7) && (!bl5 || !bl8) || bl4 && bS3.get(n4) || (s4 = ModelCollection.getBondOrderFull(f4, atom2.getBondingRadius(), atomIndexIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bS4)) continue;
                    ++n2;
                }
                atomIndexIterator.release();
            }
            n3 = bl2 ? n3 + 1 : bS5.nextSetBit(n3 + 1);
        }
    }

    private int autoBond_Pre_11_9_24(BS bS, BS bS2, BS bS3, BS bS4, short s) {
        if (this.ac == 0) {
            return 0;
        }
        if (s == 0) {
            s = 1;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.vwr.getFloat(0x22000004);
        float f2 = this.vwr.getFloat(570425364);
        float f3 = f2 * f2;
        int n = 0;
        this.initializeBspf();
        short s2 = -1;
        int n2 = this.ac;
        while (--n2 >= 0) {
            float f4;
            Atom atom;
            boolean bl;
            boolean bl2 = bS == null || bS.get(n2);
            boolean bl3 = bl = bS2 == null || bS2.get(n2);
            if (!bl2 && !bl || (atom = this.at[n2]).isDeleted()) continue;
            short s3 = atom.mi;
            if (s3 != s2) {
                s2 = s3;
                if (this.isJmolDataFrameForModel(s3)) {
                    while (--n2 >= 0 && this.at[n2].mi == s3) {
                    }
                    ++n2;
                    continue;
                }
            }
            if ((f4 = atom.getBondingRadius()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            this.initializeBspt(s3);
            CubeIterator cubeIterator = this.bspf.getCubeIterator(s3);
            cubeIterator.initialize(atom, f5, true);
            while (cubeIterator.hasMoreElements()) {
                short s4;
                boolean bl4;
                Atom atom2 = (Atom)cubeIterator.nextElement();
                if (atom2 == atom || atom2.isDeleted()) continue;
                int n3 = atom2.i;
                boolean bl5 = bS == null || bS.get(n3);
                boolean bl6 = bl4 = bS2 == null || bS2.get(n3);
                if (!bl5 && !bl4 || bS3 != null && bS3.get(n3) && bS3.get(n2) || (!bl2 || !bl4) && (!bl || !bl5) || (s4 = ModelCollection.getBondOrderFull(f4, atom2.getBondingRadius(), cubeIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bS4)) continue;
                ++n;
            }
            cubeIterator.release();
        }
        return n;
    }

    private int[] autoBond(BS bS, BS bS2, BS bS3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            BS bS4 = bS;
            bS = new BS();
            bS2 = new BS();
            int n = bS4.nextSetBit(0);
            while (n >= 0) {
                bS.set(this.bo[n].atom1.i);
                bS2.set(this.bo[n].atom2.i);
                n = bS4.nextSetBit(n + 1);
            }
        }
        return new int[]{bl2 ? this.autoHbond(bS, bS2, false) : this.autoBondBs4(bS, bS2, null, bS3, this.vwr.getMadBond(), bl3), 0};
    }

    public int autoHbond(BS bS, BS bS2, boolean bl) {
        int n;
        if (bl) {
            BS bS3 = this.getModelBitSet(bS, false);
            n = bS3.nextSetBit(0);
            while (n >= 0 && bl) {
                bl = !this.am[n].hasRasmolHBonds;
                n = bS3.nextSetBit(n + 1);
            }
            if (bl) {
                return 0;
            }
        }
        boolean bl2 = false;
        n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.at[n].getElementNumber() == 1) {
                bl2 = true;
                break;
            }
            n = bS.nextSetBit(n + 1);
        }
        BS bS4 = new BS();
        boolean bl3 = this.vwr.getBoolean(603979853);
        if (bS2 == null || bl3 && !bl2) {
            Logger.info((bS2 == null ? "DSSP " : "RasMol") + " pseudo-hbond calculation");
            this.calcRasmolHydrogenBonds(bS, bS2, null, false, Integer.MAX_VALUE, false, bS4);
            return -BSUtil.cardinalityOf(bS4);
        }
        Logger.info(bl2 ? "Standard Hbond calculation" : "Jmol pseudo-hbond calculation");
        BS bS5 = null;
        if (!bl2) {
            bS5 = new BS();
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                byte by = this.at[n2].atomID;
                switch (by) {
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 64: {
                        bS5.set(n2);
                    }
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        float f = this.vwr.getFloat(0x22000011);
        float f2 = (float)((double)this.vwr.getFloat(0x22000010) * Math.PI / 180.0);
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        float f5 = 1.0f;
        float f6 = f > hbondMin ? f4 : f3;
        float f7 = f > hbondMin ? hbondMin : f;
        int n3 = 0;
        float f8 = 0.0f;
        V3 v3 = new V3();
        V3 v32 = new V3();
        if (this.showRebondTimes && Logger.debugging) {
            Logger.startTimer("hbond");
        }
        T3 t3 = null;
        P3 p3 = null;
        AtomIndexIterator atomIndexIterator = this.getSelectedAtomIterator(bS2, false, false, false, false);
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            block19: {
                boolean bl4;
                float f9;
                float f10;
                float f11;
                int n5;
                Object object;
                boolean bl5;
                Atom atom;
                block21: {
                    block20: {
                        atom = this.at[n4];
                        int n6 = atom.getElementNumber();
                        boolean bl6 = bl5 = n6 == 1;
                        if (!bl5 && (bl2 || n6 != 7 && n6 != 8) || bl5 && !bl2) break block19;
                        if (!bl5) break block20;
                        object = atom.bonds;
                        if (object == null) break block19;
                        n5 = 0;
                        for (int i = 0; i < ((Bond[])object).length && n5 == 0; ++i) {
                            Atom atom2 = object[i].getOtherAtom(atom);
                            int n7 = atom2.getElementNumber();
                            n5 = n7 == 7 || n7 == 8 ? 1 : 0;
                        }
                        if (n5 == 0) break block19;
                        f11 = f7;
                        f10 = f5;
                        f9 = f6;
                        bl4 = false;
                        break block21;
                    }
                    f11 = f;
                    f10 = f4;
                    f9 = f3;
                    bl4 = bS5.get(n4);
                }
                this.setIteratorForAtom(atomIndexIterator, -1, atom.i, f11, null);
                while (atomIndexIterator.hasNext()) {
                    int n8;
                    object = this.at[atomIndexIterator.next()];
                    n5 = ((Atom)object).getElementNumber();
                    if (object == atom || !bl5 && n5 != 7 && n5 != 8 || bl5 && n5 == 1 || (f8 = atomIndexIterator.foundDistance2()) < f10 || f8 > f9 || bl4 && bS5.get(((Atom)object).i) || atom.isBonded((Atom)object)) continue;
                    if (f2 > 0.0f) {
                        v3.sub2(atom, (T3)object);
                        p3 = ModelCollection.checkMinAttachedAngle(atom, f2, v3, v32, bl2);
                        if (p3 == null) continue;
                        v3.scale(-1.0f);
                        t3 = ModelCollection.checkMinAttachedAngle((Atom)object, f2, v3, v32, bl2);
                        if (t3 == null) continue;
                    }
                    float f12 = 0.0f;
                    if (bl5 && !Float.isNaN(((P3)t3).x) && !Float.isNaN(p3.x)) {
                        n8 = 4096;
                        f12 = (float)HBond.getEnergy((float)Math.sqrt(f8), t3.distance(atom), t3.distance(p3), ((T3)object).distance(p3)) / 1000.0f;
                    } else {
                        n8 = 2048;
                    }
                    bS4.set(this.addHBond(atom, (Atom)object, n8, f12));
                    ++n3;
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        atomIndexIterator.release();
        this.sm.setShapeSizeBs(1, Integer.MIN_VALUE, null, bS4);
        if (this.showRebondTimes) {
            Logger.checkTimer("hbond", false);
        }
        return bl2 ? n3 : -n3;
    }

    private static P3 checkMinAttachedAngle(Atom atom, float f, V3 v3, V3 v32, boolean bl) {
        Bond[] bondArray = atom.bonds;
        if (bondArray == null || bondArray.length == 0) {
            return P3.new3(Float.NaN, 0.0f, 0.0f);
        }
        Atom atom2 = null;
        float f2 = Float.MAX_VALUE;
        int n = bondArray.length;
        while (--n >= 0) {
            if (!bondArray[n].isCovalent()) continue;
            Atom atom3 = bondArray[n].getOtherAtom(atom);
            if (!bl && atom3.getElementNumber() == 1) continue;
            v32.sub2(atom, atom3);
            float f3 = v32.angle(v3);
            if (f3 < f) {
                return null;
            }
            if (!(f3 < f2)) continue;
            atom2 = atom3;
            f2 = f3;
        }
        return atom2;
    }

    void setStructureIndexes() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.ac; ++i) {
            int n5;
            int n6 = this.at[i].mi;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.at[i].getStrucNo()) == n2 || n5 == 0) continue;
            this.at[i].getGroup().setStrucNo(++n);
            n2 = n;
        }
    }

    public String getProteinStructureState(BS bS, boolean bl, boolean bl2, int n) {
        if (!this.isPDB) {
            return "";
        }
        for (int i = 0; i < this.mc; ++i) {
            if (!this.am[i].isBioModel) continue;
            return this.am[i].getProteinStructureState(bS, bl, bl2, n);
        }
        return "";
    }

    public String getModelInfoAsString() {
        SB sB = new SB().append("<models count=\"");
        sB.appendI(this.mc).append("\" modelSetHasVibrationVectors=\"").append(this.modelSetHasVibrationVectors() + "\">\n<properties>");
        if (this.modelSetProperties != null) {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                sB.append("\n <property name=\"").append(string).append("\" value=").append(PT.esc(this.modelSetProperties.getProperty(string))).append(" />");
            }
            sB.append("\n</properties>");
        }
        for (int i = 0; i < this.mc; ++i) {
            sB.append("\n<model index=\"").appendI(i).append("\" n=\"").append(this.getModelNumberDotted(i)).append("\" id=").append(PT.esc("" + this.getModelAuxiliaryInfoValue(i, "modelID")));
            int n = this.vwr.getJDXBaseModelIndex(i);
            if (n != i) {
                sB.append(" baseModelId=").append(PT.esc((String)this.getModelAuxiliaryInfoValue(n, "jdxModelID")));
            }
            sB.append(" name=").append(PT.esc(this.getModelName(i))).append(" title=").append(PT.esc(this.getModelTitle(i))).append(" hasVibrationVectors=\"").appendB(this.vwr.modelHasVibrationVectors(i)).append("\" />");
        }
        sB.append("\n</models>");
        return sB.toString();
    }

    public String getSymmetryInfoAsString() {
        SB sB = new SB().append("Symmetry Information:");
        for (int i = 0; i < this.mc; ++i) {
            sB.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsStringForModel(i));
        }
        return sB.toString();
    }

    public BS getAtomsConnected(float f, float f2, int n, BS bS) {
        int n2;
        int n3;
        boolean bl = bS instanceof BondSet;
        BS bS2 = bl ? new BondSet() : new BS();
        int[] nArray = new int[this.ac];
        boolean bl2 = n == 30720;
        boolean bl3 = n == 65535;
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bo[n3];
            if (!bl3 && !bond.is(n) && (!bl2 || !bond.isHydrogen())) continue;
            if (bl) {
                bS2.set(n3);
                continue;
            }
            if (bS.get(bond.atom1.i)) {
                n2 = bond.atom2.i;
                nArray[n2] = nArray[n2] + 1;
                bS2.set(n2);
            }
            if (!bS.get(bond.atom2.i)) continue;
            n2 = bond.atom1.i;
            nArray[n2] = nArray[n2] + 1;
            bS2.set(n2);
        }
        if (bl) {
            return bS2;
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.ac;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bS2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bS2.set(n2);
        }
        return bS2;
    }

    public SymmetryInterface getSymTemp(boolean bl) {
        return this.symTemp == null || bl ? (this.symTemp = Interface.getSymmetry()) : this.symTemp;
    }

    public void createModels(int n) {
        int n2 = this.mc + n;
        Model[] modelArray = (Model[])AU.arrayCopyObject(this.am, n2);
        this.validateBspf(false);
        this.modelNumbers = AU.arrayCopyI(this.modelNumbers, n2);
        this.modelFileNumbers = AU.arrayCopyI(this.modelFileNumbers, n2);
        this.modelNumbersForAtomLabel = AU.arrayCopyS(this.modelNumbersForAtomLabel, n2);
        this.modelNames = AU.arrayCopyS(this.modelNames, n2);
        this.frameTitles = AU.arrayCopyS(this.frameTitles, n2);
        int n3 = this.getModelFileNumber(this.mc - 1) / 1000000 + 1;
        int n4 = 0;
        for (int i = this.mc; i < n2; ++i) {
            this.modelNumbers[i] = i + this.mc;
            this.modelFileNumbers[i] = n3 * 1000000 + ++n4;
            this.modelNumbersForAtomLabel[i] = this.modelNames[i] = n3 + "." + n4;
        }
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfoValue("group3Lists");
        if (stringArray != null) {
            int[][] nArray = (int[][])this.getModelSetAuxiliaryInfoValue("group3Counts");
            stringArray = AU.arrayCopyS(stringArray, n2);
            nArray = AU.arrayCopyII(nArray, n2);
            this.modelSetAuxiliaryInfo.put("group3Lists", stringArray);
            this.modelSetAuxiliaryInfo.put("group3Counts", nArray);
        }
        this.unitCells = (SymmetryInterface[])AU.arrayCopyObject(this.unitCells, n2);
        for (n4 = this.mc; n4 < n2; ++n4) {
            modelArray[n4] = new Model((ModelSet)this, n4, -1, null, null, null);
            modelArray[n4].loadState = " model create #" + n4 + ";";
        }
        this.am = modelArray;
        this.mc = n2;
    }

    protected void deleteModel(int n, int n2, int n3, BS bS, BS bS2) {
        int n4;
        if (n < 0) {
            this.validateBspf(false);
            this.bsAll = null;
            this.resetMolecules();
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null, 1.0f);
            return;
        }
        this.modelNumbers = (int[])AU.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])AU.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])AU.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])AU.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])AU.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfoValue("group3Lists");
        int[][] nArray = (int[][])this.getModelSetAuxiliaryInfoValue("group3Counts");
        int n5 = n + 1;
        if (stringArray != null && stringArray[n5] != null) {
            n4 = stringArray[n5].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n5][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n6 = n4;
                nArray2[n6] = nArray2[n6] - nArray[n5][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", AU.deleteElements(stringArray, n, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", AU.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            this.unitCells = (SymmetryInterface[])AU.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (((StateScript)this.stateScripts.get(n4)).deleteAtoms(n, bS2, bS)) continue;
            this.stateScripts.remove(n4);
        }
        this.deleteModelAtoms(n2, n3, bS);
        this.vwr.deleteModelAtoms(n, n2, n3, bS);
    }

    public String getMoInfo(int n) {
        SB sB = new SB();
        for (int i = 0; i < this.mc; ++i) {
            int n2;
            Map map;
            if (n >= 0 && i != n || (map = (Map)this.vwr.getModelAuxiliaryInfoValue(i, "moData")) == null) continue;
            List list = (List)map.get("mos");
            int n3 = n2 = list == null ? 0 : list.size();
            if (n2 == 0) continue;
            int n4 = n2;
            while (--n4 >= 0) {
                String string;
                String string2;
                Float f;
                String string3;
                Map map2 = (Map)list.get(n4);
                String string4 = (String)map2.get("type");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = (String)map2.get("energyUnits")) == null) {
                    string3 = "";
                }
                if ((f = (Float)map2.get("occupancy")) != null) {
                    string4 = "occupancy " + f.floatValue() + " " + string4;
                }
                if ((string2 = (String)map2.get("symmetry")) != null) {
                    string4 = string4 + string2;
                }
                if (Float.isNaN(PT.parseFloat(string = "" + map2.get("energy")))) {
                    sB.append(Txt.sprintf("model %-2s;  mo %-2i # %s\n", "sis", new Object[]{this.getModelNumberDotted(i), n4 + 1, string4}));
                    continue;
                }
                sB.append(Txt.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", "sifss", new Object[]{this.getModelNumberDotted(i), n4 + 1, map2.get("energy"), string3, string4}));
            }
        }
        return sB.toString();
    }

    public void assignAtom(int n, String string, boolean bl) {
        JSONEncodable jSONEncodable;
        if (string == null) {
            string = "C";
        }
        Atom atom = this.at[n];
        BS bS = new BS();
        boolean bl2 = atom.getElementNumber() == 1;
        int n2 = Elements.elementNumberFromSymbol(string, true);
        boolean bl3 = false;
        if (n2 > 0) {
            this.setElement(atom, n2);
            this.vwr.setShapeSizeRD(0, this.vwr.getDefaultRadiusData(), BSUtil.newAndSetBit(n));
            this.setAtomName(n, string + atom.getAtomNumber());
            if (!this.am[atom.mi].isModelKit) {
                this.taintAtom(n, (byte)0);
            }
        } else if (string.equals("Pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (string.equals("Mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (string.equals("X")) {
            bl3 = true;
        } else if (!string.equals(".")) {
            return;
        }
        this.removeUnnecessaryBonds(atom, bl3);
        float f = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            if (bl2) {
                f = 1.5f;
            } else if (!bl2 && n2 == 1) {
                f = 1.0f;
            }
        }
        if (f != 0.0f) {
            jSONEncodable = V3.newVsub(atom, this.at[atom.getBondedAtomIndex(0)]);
            float f2 = ((T3)jSONEncodable).length();
            ((T3)jSONEncodable).normalize();
            ((T3)jSONEncodable).scale(f - f2);
            this.setAtomCoordRelative(n, ((V3)jSONEncodable).x, ((V3)jSONEncodable).y, ((V3)jSONEncodable).z);
        }
        jSONEncodable = BSUtil.newAndSetBit(n);
        if (n2 != 1 && bl) {
            this.validateBspf(false);
            bS = this.getAtomsWithinRD(1.0f, (BS)jSONEncodable, false, null);
            bS.andNot((BS)jSONEncodable);
            if (bS.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bS, false);
            }
            bS = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bS.andNot(this.getAtomBitsMDa(1613758476, null));
            this.makeConnections2(0.1f, 1.8f, 1, 0x40000050, (BS)jSONEncodable, bS, null, false, false, 0.0f);
        }
        this.vwr.addHydrogens((BS)jSONEncodable, false, true);
    }

    public void deleteAtoms(BS bS) {
        this.averageAtomPoint = null;
        if (bS == null) {
            return;
        }
        BS bS2 = new BS();
        int n = bS.nextSetBit(0);
        while (n >= 0 && n < this.ac) {
            this.at[n].deleteBonds(bS2);
            n = bS.nextSetBit(n + 1);
        }
        for (n = 0; n < this.mc; ++n) {
            this.am[n].bsAtomsDeleted.or(bS);
            this.am[n].bsAtomsDeleted.and(this.am[n].bsAtoms);
        }
        this.deleteBonds(bS2, false);
    }

    public String getModelCml(BS bS, int n, boolean bl) {
        Object object;
        Object object2;
        SB sB = new SB();
        int n2 = BSUtil.cardinalityOf(bS);
        if (n2 == 0) {
            return "";
        }
        Interface.getInterface("javajs.util.XmlUtil");
        XmlUtil.openTag(sB, "molecule");
        XmlUtil.openTag(sB, "atomArray");
        BS bS2 = new BS();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            object2 = this.at[n3];
            object = ((Atom)object2).getAtomName();
            PT.rep((String)object, "\"", "''");
            bS2.set(((Atom)object2).i);
            XmlUtil.appendTag(sB, "atom/", new String[]{"id", "a" + (((Atom)object2).i + 1), "title", ((Atom)object2).getAtomName(), "elementType", ((Atom)object2).getElementSymbol(), "x3", "" + ((Atom)object2).x, "y3", "" + ((Atom)object2).y, "z3", "" + ((Atom)object2).z});
            n3 = bS.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(sB, "atomArray");
        if (bl) {
            XmlUtil.openTag(sB, "bondArray");
            for (n3 = 0; n3 < this.bondCount; ++n3) {
                String string;
                object2 = this.bo[n3];
                object = ((Bond)object2).atom1;
                Atom atom = ((Bond)object2).atom2;
                if (!bS2.get(((Atom)object).i) || !bS2.get(atom.i) || (string = Edge.getCmlBondOrder(((Bond)object2).order)) == null) continue;
                XmlUtil.appendTag(sB, "bond/", new String[]{"atomRefs2", "a" + (((Bond)object2).atom1.i + 1) + " a" + (((Bond)object2).atom2.i + 1), "order", string});
            }
            XmlUtil.closeTag(sB, "bondArray");
        }
        XmlUtil.closeTag(sB, "molecule");
        return sB.toString();
    }

    void adjustAtomArrays(int[] nArray, int n, int n2) {
        Object[] objectArray;
        int n3;
        this.ac = n2;
        for (n3 = n; n3 < n2; ++n3) {
            this.at[n3] = this.at[nArray[n3]];
            this.at[n3].i = n3;
            objectArray = this.am[this.at[n3].mi];
            if (objectArray.firstAtomIndex == nArray[n3]) {
                objectArray.firstAtomIndex = n3;
            }
            objectArray.bsAtoms.set(n3);
        }
        if (this.vibrations != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.vibrations[n3] = this.vibrations[nArray[n3]];
            }
        }
        if (this.occupancies != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.occupancies[n3] = this.occupancies[nArray[n3]];
            }
        }
        if (this.bfactor100s != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.bfactor100s[n3] = this.bfactor100s[nArray[n3]];
            }
        }
        if (this.partialCharges != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.partialCharges[n3] = this.partialCharges[nArray[n3]];
            }
        }
        if (this.atomTensorList != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTensorList[n3] = this.atomTensorList[nArray[n3]];
                objectArray = this.atomTensorList[n3];
                int n4 = objectArray.length;
                while (--n4 >= 0) {
                    Tensor tensor = (Tensor)objectArray[n4];
                    if (tensor == null) continue;
                    tensor.atomIndex1 = nArray[tensor.atomIndex1];
                }
            }
        }
        if (this.atomNames != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomNames[n3] = this.atomNames[nArray[n3]];
            }
        }
        if (this.atomTypes != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomTypes[n3] = this.atomTypes[nArray[n3]];
            }
        }
        if (this.atomSerials != null) {
            for (n3 = n; n3 < n2; ++n3) {
                this.atomSerials[n3] = this.atomSerials[nArray[n3]];
            }
        }
    }

    protected void growAtomArrays(int n) {
        this.at = (Atom[])AU.arrayCopyObject(this.at, n);
        if (this.vibrations != null) {
            this.vibrations = (Vibration[])AU.arrayCopyObject(this.vibrations, n);
        }
        if (this.occupancies != null) {
            this.occupancies = AU.arrayCopyByte(this.occupancies, n);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = AU.arrayCopyShort(this.bfactor100s, n);
        }
        if (this.partialCharges != null) {
            this.partialCharges = AU.arrayCopyF(this.partialCharges, n);
        }
        if (this.atomTensorList != null) {
            this.atomTensorList = (Object[][])AU.arrayCopyObject(this.atomTensorList, n);
        }
        if (this.atomNames != null) {
            this.atomNames = AU.arrayCopyS(this.atomNames, n);
        }
        if (this.atomTypes != null) {
            this.atomTypes = AU.arrayCopyS(this.atomTypes, n);
        }
        if (this.atomSerials != null) {
            this.atomSerials = AU.arrayCopyI(this.atomSerials, n);
        }
    }

    public Atom addAtom(int n, Group group, int n2, String string, int n3, int n4, P3 p3, float f, V3 v3, int n5, float f2, int n6, float f3, List<Object> list, boolean bl, byte by, BS bS) {
        Atom atom = new Atom().setAtom(n, this.ac, p3, f, bS, n4, (short)n2, n5, bl);
        ++this.am[n].ac;
        this.am[n].bsAtoms.set(this.ac);
        if (Elements.isElement(n2, 1)) {
            ++this.am[n].hydrogenCount;
        }
        if (this.ac >= this.at.length) {
            this.growAtomArrays(this.ac + 100);
        }
        this.at[this.ac] = atom;
        this.setBFactor(this.ac, f3);
        this.setOccupancy(this.ac, n6);
        this.setPartialCharge(this.ac, f2);
        if (list != null) {
            this.setAtomTensors(this.ac, list);
        }
        atom.group = group;
        atom.colixAtom = this.vwr.getColixAtomPalette(atom, PAL.CPK.id);
        if (string != null) {
            int n7 = string.indexOf(0);
            if (n7 >= 0) {
                if (this.atomTypes == null) {
                    this.atomTypes = new String[this.at.length];
                }
                this.atomTypes[this.ac] = string.substring(n7 + 1);
                string = string.substring(0, n7);
            }
            atom.atomID = by;
            if (by == 0) {
                if (this.atomNames == null) {
                    this.atomNames = new String[this.at.length];
                }
                this.atomNames[this.ac] = string.intern();
            }
        }
        if (n3 != Integer.MIN_VALUE) {
            if (this.atomSerials == null) {
                this.atomSerials = new int[this.at.length];
            }
            this.atomSerials[this.ac] = n3;
        }
        if (v3 != null) {
            this.setVibrationVector(this.ac, v3);
        }
        ++this.ac;
        return atom;
    }

    public String getInlineData(int n) {
        SB sB = null;
        if (n >= 0) {
            sB = this.am[n].loadScript;
        } else {
            n = this.mc;
            while (--n >= 0 && (sB = this.am[n].loadScript).length() <= 0) {
            }
        }
        int n2 = sB.lastIndexOf("data \"");
        if (n2 < 0) {
            return null;
        }
        n2 = sB.indexOf2("\"", n2 + 7);
        int n3 = sB.lastIndexOf("end \"");
        if (n3 < n2 || n2 < 0) {
            return null;
        }
        return sB.substring2(n2 + 2, n3);
    }

    public boolean isAtomPDB(int n) {
        return n >= 0 && this.am[this.at[n].mi].isBioModel;
    }

    public boolean isAtomAssignable(int n) {
        return n >= 0 && this.at[n].mi == this.mc - 1;
    }

    public boolean haveModelKit() {
        for (int i = 0; i < this.mc; ++i) {
            if (!this.am[i].isModelKit) continue;
            return true;
        }
        return false;
    }

    public BS getModelKitStateBitset(BS bS, BS bS2) {
        BS bS3 = BSUtil.copy(bS2);
        for (int i = 0; i < this.mc; ++i) {
            if (this.am[i].isModelKit) continue;
            bS3.andNot(this.am[i].bsAtoms);
        }
        return BSUtil.deleteBits(bS, bS3);
    }

    public void setAtomNamesAndNumbers(int n, int n2, AtomCollection atomCollection) {
        if (n2 < 0) {
            n = this.am[this.at[n].mi].firstAtomIndex;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.ac];
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.ac];
        }
        boolean bl = this.isXYZ && this.vwr.getBoolean(603979978);
        int s = Integer.MAX_VALUE;
        int n3 = 1;
        for (int i = n; i < this.ac; ++i) {
            short s2;
            Atom atom = this.at[i];
            if (atom.mi != s2) {
                s2 = atom.mi;
                int n4 = n3 = bl ? 0 : 1;
            }
            if (i >= -n2) {
                if (this.atomSerials[i] == 0 || n2 < 0) {
                    int n5 = this.atomSerials[i] = i < n2 ? atomCollection.atomSerials[i] : n3;
                }
                if (this.atomNames[i] == null || n2 < 0) {
                    this.atomNames[i] = (atom.getElementSymbol() + this.atomSerials[i]).intern();
                }
            }
            if (this.am[s2].isModelKit && (atom.getElementNumber() <= 0 || atom.isDeleted())) continue;
            ++n3;
        }
    }

    public void setUnitCellOffset(SymmetryInterface symmetryInterface, P3 p3, int n) {
        if (symmetryInterface == null) {
            return;
        }
        if (p3 == null) {
            symmetryInterface.setOffset(n);
        } else {
            symmetryInterface.setOffsetPt(p3);
        }
    }

    public void connect(float[][] fArray) {
        this.resetMolecules();
        BS bS = new BS();
        for (int i = 0; i < fArray.length; ++i) {
            short s;
            int n;
            int n2;
            boolean bl;
            float[] fArray2 = fArray[i];
            if (fArray2 == null || fArray2.length < 2) continue;
            int n3 = (int)fArray2[0];
            boolean bl2 = bl = n3 < 0;
            if (bl) {
                n3 = -1 - n3;
            }
            if ((n2 = (int)fArray2[1]) < 0 || n3 >= this.ac || n2 >= this.ac) continue;
            int n4 = n = fArray2.length > 2 ? (int)fArray2[2] : 1;
            if (n < 0) {
                n &= 0xFFFF;
            }
            short s2 = s = fArray2.length > 3 ? (short)(1000.0f * fArray[i][3]) : this.getDefaultMadFromOrder(n);
            if (n == 0 || s == 0 && n != 32768 && !Bond.isOrderH(n)) {
                Bond bond = this.at[n3].getBond(this.at[n2]);
                if (bond == null) continue;
                bS.set(bond.index);
                continue;
            }
            float f = fArray2.length > 4 ? fArray2[4] : 0.0f;
            this.bondAtoms(this.at[n3], this.at[n2], n, s, null, f, bl, true);
        }
        if (bS.nextSetBit(0) >= 0) {
            this.deleteBonds(bS, false);
        }
    }

    public boolean allowSpecAtom() {
        return this.mc != 1 || this.am[0].isBioModel;
    }

    public void setFrameDelayMs(long l, BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.am[this.am[n].trajectoryBaseIndex].frameDelay = l;
            n = bS.nextSetBit(n + 1);
        }
    }

    public long getFrameDelayMs(int n) {
        return n < this.am.length && n >= 0 ? this.am[this.am[n].trajectoryBaseIndex].frameDelay : 0L;
    }

    public int getModelIndexFromId(String string) {
        boolean bl = string.indexOf("#") >= 0;
        boolean bl2 = string.toLowerCase().endsWith(".basemodel");
        if (bl2) {
            string = string.substring(0, string.length() - 10);
        }
        int n = -1;
        String string2 = null;
        for (int i = 0; i < this.mc; ++i) {
            String string3;
            String string4 = (String)this.getModelAuxiliaryInfoValue(i, "modelID");
            String string5 = string3 = string.startsWith("~") ? "~" + this.getModelNumberDotted(i) : null;
            if (string3 == null && string4 == null && (string4 = this.getModelTitle(i)) == null) continue;
            if (bl) {
                string2 = this.getModelFileName(i);
                if (string2.endsWith("#molfile")) {
                    string4 = string2;
                } else {
                    string2 = string2 + "#";
                    string4 = string2 + string4;
                }
            }
            if (string.equalsIgnoreCase(string4) || string.equalsIgnoreCase(string3)) {
                return bl2 ? this.vwr.getJDXBaseModelIndex(i) : i;
            }
            if (string2 == null || !string.startsWith(string2)) continue;
            n = -2;
        }
        return string2 == null && !bl ? -2 : n;
    }

    public Map<String, Object> getAuxiliaryInfo(BS bS) {
        Map<String, Object> map = this.modelSetAuxiliaryInfo;
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        for (int i = 0; i < this.mc; ++i) {
            if (bS != null && !bS.get(i)) continue;
            Map<String, Object> map2 = this.getModelAuxiliaryInfo(i);
            list.addLast(map2);
        }
        map.put("models", list);
        return map;
    }

    public int[][] getDihedralMap(int[] nArray) {
        int n;
        List<int[]> list = new List<int[]>();
        int n2 = nArray.length;
        Atom atom = null;
        Atom atom2 = null;
        Atom atom3 = null;
        Atom atom4 = null;
        int n3 = n2 - 1;
        while (--n3 >= 0) {
            n = n2;
            while (--n > n3) {
                atom = this.at[nArray[n3]];
                atom2 = this.at[nArray[n]];
                if (!atom.isBonded(atom2)) continue;
                int n4 = n2;
                while (--n4 >= 0) {
                    if (n4 == n3 || n4 == n || !(atom3 = this.at[nArray[n4]]).isBonded(atom)) continue;
                    int n5 = n2;
                    while (--n5 >= 0) {
                        if (n5 == n3 || n5 == n || n5 == n4 || !(atom4 = this.at[nArray[n5]]).isBonded(atom2)) continue;
                        int[] nArray2 = new int[]{atom3.i, atom.i, atom2.i, atom4.i};
                        list.addLast(nArray2);
                    }
                }
            }
        }
        n2 = list.size();
        int[][] nArray3 = AU.newInt2(n2);
        n = n2;
        while (--n >= 0) {
            nArray3[n2 - n - 1] = (int[])list.get(n);
        }
        return nArray3;
    }

    public void setModulation(BS bS, boolean bl, P3 p3, boolean bl2) {
        if (this.bsModulated == null) {
            if (bl) {
                this.bsModulated = new BS();
            } else if (bS == null) {
                return;
            }
        }
        if (bS == null) {
            bS = this.getModelAtomBitSetIncludingDeleted(-1, false);
        }
        float f = this.vwr.getFloat(1276121113);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Vibration vibration = this.getVibration(n, false);
            if (vibration instanceof JmolModulationSet) {
                ((JmolModulationSet)((Object)vibration)).setModTQ(this.at[n], bl, p3, bl2, f);
                if (this.bsModulated != null) {
                    this.bsModulated.setBitTo(n, bl);
                }
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    public Point3fi getDynamicAtom(int n, Point3fi point3fi) {
        Vibration vibration = this.getVibration(n, false);
        if (vibration == null) {
            return this.at[n];
        }
        if (point3fi == null) {
            point3fi = new Point3fi();
        }
        point3fi.setT(this.at[n]);
        point3fi = this.vwr.getVibrationPoint(vibration, point3fi);
        point3fi.sD = (short)-1;
        return point3fi;
    }

    public String getBoundBoxOrientation(int n, BS bS) {
        float f;
        Object object;
        int n2;
        int n3 = bS.nextSetBit(0);
        if (n3 < 0) {
            return "{0 0 0 1}";
        }
        int n4 = n2 = this.vOrientations == null ? 0 : this.vOrientations.length;
        if (n2 == 0) {
            int n5;
            object = new V3[3375];
            n2 = 0;
            P4 p4 = new P4();
            for (n5 = -7; n5 <= 7; ++n5) {
                for (int i = -7; i <= 7; ++i) {
                    int n6 = 0;
                    while (n6 <= 14) {
                        V3 v3;
                        object[n2] = V3.new3((float)n5 / 7.0f, (float)i / 7.0f, (float)n6 / 14.0f);
                        if (v3.length() > 1.0f) {
                            --n2;
                        }
                        ++n6;
                        ++n2;
                    }
                }
            }
            this.vOrientations = new Quat[n2];
            n5 = n2;
            while (--n5 >= 0) {
                float f2 = (float)Math.sqrt(1.0f - object[n5].lengthSquared());
                if (Float.isNaN(f2)) {
                    f2 = 0.0f;
                }
                p4.set(object[n5].x, object[n5].y, object[n5].z, f2);
                this.vOrientations[n5] = Quat.newP4(p4);
            }
        }
        object = new P3();
        float f3 = Float.MAX_VALUE;
        Quat quat = null;
        BoxInfo boxInfo = null;
        for (int i = 0; i < n2; ++i) {
            float f4;
            Quat quat2 = this.vOrientations[i];
            BoxInfo boxInfo2 = new BoxInfo();
            boxInfo2.setMargin(0.0f);
            int n7 = n3;
            while (n7 >= 0) {
                boxInfo2.addBoundBoxPoint((P3)quat2.transformP2(this.at[n7], (T3)object));
                n7 = bS.nextSetBit(n7 + 1);
            }
            switch (n) {
                default: {
                    f4 = (boxInfo2.bbCorner1.x - boxInfo2.bbCorner0.x) * (boxInfo2.bbCorner1.y - boxInfo2.bbCorner0.y) * (boxInfo2.bbCorner1.z - boxInfo2.bbCorner0.z);
                    break;
                }
                case 1112541205: {
                    f4 = boxInfo2.bbCorner1.x - boxInfo2.bbCorner0.x;
                    break;
                }
                case 1112541206: {
                    f4 = boxInfo2.bbCorner1.y - boxInfo2.bbCorner0.y;
                    break;
                }
                case 1112541207: {
                    f4 = boxInfo2.bbCorner1.z - boxInfo2.bbCorner0.z;
                }
            }
            if (!(f4 < f3)) continue;
            quat = quat2;
            boxInfo = boxInfo2;
            f3 = f4;
        }
        if (n != 1313866249 && n != 1073741863) {
            return quat.toString();
        }
        Quat quat3 = Quat.newQ(quat);
        float f5 = boxInfo.bbCorner1.x - boxInfo.bbCorner0.x;
        float f6 = boxInfo.bbCorner1.y - boxInfo.bbCorner0.y;
        float f7 = boxInfo.bbCorner1.z - boxInfo.bbCorner0.z;
        if (f5 < f6) {
            ((T3)object).set(0.0f, 0.0f, 1.0f);
            quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
            f = f5;
            f5 = f6;
            f6 = f;
        }
        if (f6 < f7) {
            if (f7 > f5) {
                ((T3)object).set(0.0f, 1.0f, 0.0f);
                quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
                f = f5;
                f5 = f7;
                f7 = f;
            }
            ((T3)object).set(1.0f, 0.0f, 0.0f);
            quat3 = Quat.newVA((T3)object, 90.0f).mulQ(quat3);
            f = f6;
            f6 = f7;
            f7 = f;
        }
        return n == 1313866249 ? f3 + "\t{" + f5 + " " + f6 + " " + f7 + "}" : (quat3.getTheta() == 0.0f ? "{0 0 0 1}" : quat3.toString());
    }

    public List<Object> intersectPlane(P4 p4, List<Object> list, int n) {
        return (this.triangulator == null ? (this.triangulator = (Triangulator)Interface.getUtil("TriangleData")) : this.triangulator).intersectPlane(p4, list, n);
    }

    public SymmetryInterface getUnitCellForAtom(int n) {
        Vibration vibration;
        if (n < 0 || n > this.ac) {
            return null;
        }
        if (this.bsModulated != null && (vibration = this.getVibration(n, false)) != null) {
            return vibration.getUnitCell();
        }
        return this.getUnitCell(this.at[n].mi);
    }
}

