/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Arrays;
import java.util.Comparator;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.MeshSurface;

public class MeshData
extends MeshSurface {
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    public String polygonColorData;

    public int addVertexCopy(P3 p3, float f, int n) {
        if (n < 0) {
            this.vertexIncrement = -n;
        }
        return this.addVCVal(p3, f);
    }

    public BS[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSetForLevel(0) : this.surfaceSet;
    }

    private BS[] getSurfaceSetForLevel(int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.surfaceSet = new BS[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (n3 = 0; n3 < this.pc; ++n3) {
            if (this.pis[n3] == null || this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n3)) continue;
            int[] nArray = this.pis[n3];
            n2 = this.findSet(nArray[0]);
            int n4 = this.findSet(nArray[1]);
            int n5 = this.findSet(nArray[2]);
            if (n2 < 0 && n4 < 0 && n5 < 0) {
                this.createSet(nArray[0], nArray[1], nArray[2]);
                continue;
            }
            if (n2 == n4 && n4 == n5) continue;
            if (n2 >= 0) {
                this.surfaceSet[n2].set(nArray[1]);
                this.surfaceSet[n2].set(nArray[2]);
                if (n4 >= 0 && n4 != n2) {
                    this.mergeSets(n2, n4);
                }
                if (n5 < 0 || n5 == n2 || n5 == n4) continue;
                this.mergeSets(n2, n5);
                continue;
            }
            if (n4 >= 0) {
                this.surfaceSet[n4].set(nArray[0]);
                this.surfaceSet[n4].set(nArray[2]);
                if (n5 < 0 || n5 == n4) continue;
                this.mergeSets(n4, n5);
                continue;
            }
            this.surfaceSet[n5].set(nArray[0]);
            this.surfaceSet[n5].set(nArray[1]);
        }
        n3 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n3;
        }
        BS[] bSArray = new BS[this.surfaceSet.length];
        n3 = 0;
        for (n2 = 0; n2 < this.nSets; ++n2) {
            if (this.surfaceSet[n2] == null) continue;
            bSArray[n3++] = this.surfaceSet[n2];
        }
        this.nSets = n3;
        this.surfaceSet = bSArray;
        if (!this.setsSuccessful && n < 2) {
            this.getSurfaceSetForLevel(n + 1);
        }
        if (n == 0) {
            this.sortSurfaceSets();
            this.setVertexSets(false);
        }
        return this.surfaceSet;
    }

    private void sortSurfaceSets() {
        int n;
        SSet[] sSetArray = new SSet[this.nSets];
        for (n = 0; n < this.nSets; ++n) {
            sSetArray[n] = new SSet(this.surfaceSet[n]);
        }
        Arrays.sort(sSetArray, new SortSet());
        for (n = 0; n < this.nSets; ++n) {
            this.surfaceSet[n] = sSetArray[n].bs;
        }
    }

    public void setVertexSets(boolean bl) {
        int n;
        if (this.surfaceSet == null) {
            return;
        }
        int n2 = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] != null && this.surfaceSet[i].cardinality() == 0) {
                this.surfaceSet[i] = null;
            }
            if (this.surfaceSet[i] != null) continue;
            ++n2;
        }
        if (n2 > 0) {
            BS[] bSArray = new BS[this.nSets - n2];
            int n3 = 0;
            for (n = 0; n < this.nSets; ++n) {
                if (this.surfaceSet[n] == null) continue;
                bSArray[n3++] = this.surfaceSet[n];
            }
            this.surfaceSet = bSArray;
            this.nSets -= n2;
        } else if (bl) {
            return;
        }
        this.vertexSets = new int[this.vc];
        for (int i = 0; i < this.nSets; ++i) {
            n = this.surfaceSet[i].nextSetBit(0);
            while (n >= 0) {
                this.vertexSets[n] = i;
                n = this.surfaceSet[i].nextSetBit(n + 1);
            }
        }
    }

    private int findSet(int n) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(n)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < this.nSets && this.surfaceSet[n4] != null; ++n4) {
        }
        if (n4 == this.surfaceSet.length) {
            this.surfaceSet = (BS[])AU.ensureLength(this.surfaceSet, this.surfaceSet.length + 100);
        }
        this.surfaceSet[n4] = new BS();
        this.surfaceSet[n4].set(n);
        this.surfaceSet[n4].set(n2);
        this.surfaceSet[n4].set(n3);
        if (n4 == this.nSets) {
            ++this.nSets;
        }
    }

    private void mergeSets(int n, int n2) {
        this.surfaceSet[n].or(this.surfaceSet[n2]);
        this.surfaceSet[n2] = null;
    }

    public void invalidateSurfaceSet(int n) {
        int n2 = this.surfaceSet[n].nextSetBit(0);
        while (n2 >= 0) {
            this.vvs[n2] = Float.NaN;
            n2 = this.surfaceSet[n].nextSetBit(n2 + 1);
        }
        this.surfaceSet[n] = null;
    }

    public static boolean checkCutoff(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f || f <= 0.0f && f2 <= 0.0f && f3 <= 0.0f;
    }

    public Object calculateVolumeOrArea(int n, boolean bl, boolean bl2) {
        if (bl2 || this.nSets == 0) {
            this.getSurfaceSet();
        }
        boolean bl3 = n >= -1;
        int n2 = bl3 || this.nSets == 0 ? 1 : this.nSets;
        double[] dArray = new double[n2];
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n3 = this.pc;
        while (--n3 >= 0) {
            int n4;
            if (!this.setABC(n3)) continue;
            int n5 = n4 = this.nSets == 0 ? 0 : this.vertexSets[this.iA];
            if (n >= 0 && n4 != n) continue;
            if (bl) {
                v3.sub2(this.vs[this.iB], this.vs[this.iA]);
                v32.sub2(this.vs[this.iC], this.vs[this.iA]);
                v33.cross(v3, v32);
                int n6 = bl3 ? 0 : n4;
                dArray[n6] = dArray[n6] + (double)v33.length();
                continue;
            }
            v3.setT(this.vs[this.iB]);
            v32.setT(this.vs[this.iC]);
            v33.cross(v3, v32);
            v32.setT(this.vs[this.iA]);
            int n7 = bl3 ? 0 : n4;
            dArray[n7] = dArray[n7] + (double)v32.dot(v33);
        }
        double d = bl ? 2 : 6;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = n8++;
            dArray[n9] = dArray[n9] / d;
        }
        if (bl3) {
            return Float.valueOf((float)dArray[0]);
        }
        return dArray;
    }

    public void updateInvalidatedVertices(BS bS) {
        bS.clearAll();
        for (int i = 0; i < this.vc; i += this.vertexIncrement) {
            if (!Float.isNaN(this.vvs[i])) continue;
            bS.set(i);
        }
    }

    public void invalidateVertices(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.vvs[n] = Float.NaN;
            n = bS.nextSetBit(n + 1);
        }
    }

    protected class SortSet
    implements Comparator<SSet> {
        protected SortSet() {
        }

        @Override
        public int compare(SSet sSet, SSet sSet2) {
            return sSet.n > sSet2.n ? -1 : (sSet.n < sSet2.n ? 1 : 0);
        }
    }

    private class SSet {
        BS bs;
        int n;

        protected SSet(BS bS) {
            this.bs = bS;
            this.n = bS.cardinality();
        }
    }
}

