/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jsv;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.JmolJDXMOLParser;
import org.jmol.adapter.smarter.JmolJDXMOLReader;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class JDXMOLParser
implements JmolJDXMOLParser {
    private String line;
    private String lastModel = "";
    private String thisModelID;
    private String baseModel;
    private float vibScale;
    private String piUnitsX;
    private String piUnitsY;
    private JmolJDXMOLReader loader;
    private String modelIdList = "";
    private int[] peakIndex;
    private String peakFilePath;

    @Override
    public JmolJDXMOLParser set(JmolJDXMOLReader jmolJDXMOLReader, String string, Map<String, Object> map) {
        this.loader = jmolJDXMOLReader;
        this.peakFilePath = string;
        this.peakIndex = new int[1];
        if (map != null) {
            map.remove("modelNumber");
            if (map.containsKey("zipSet")) {
                this.peakIndex = (int[])map.get("peakIndex");
                if (this.peakIndex == null) {
                    this.peakIndex = new int[1];
                    map.put("peakIndex", this.peakIndex);
                }
                if (!map.containsKey("subFileName")) {
                    this.peakFilePath = PT.split(string, "|")[0];
                }
            }
        }
        return this;
    }

    @Override
    public String getAttribute(String string, String string2) {
        String string3 = PT.getQuotedAttribute(string, string2);
        return string3 == null ? "" : string3;
    }

    @Override
    public String getRecord(String string) throws Exception {
        if (this.line == null || this.line.indexOf(string) < 0) {
            return null;
        }
        String string2 = this.line;
        while (string2.indexOf(">") < 0) {
            string2 = string2 + " " + this.readLine();
        }
        this.line = string2;
        return this.line;
    }

    @Override
    public boolean readModels() throws Exception {
        if (!this.findRecord("Models")) {
            return false;
        }
        this.line = "";
        this.thisModelID = "";
        boolean bl = true;
        while (true) {
            this.line = this.loader.discardLinesUntilNonBlank();
            if (this.getRecord("<ModelData") == null) break;
            this.getModelData(bl);
            bl = false;
        }
        return true;
    }

    @Override
    public String readACDMolFile() throws Exception {
        SB sB = new SB();
        sB.append(this.line.substring(this.line.indexOf("=") + 1)).appendC('\n');
        while (this.readLine() != null && !this.line.contains("$$$$")) {
            sB.append(this.line).appendC('\n');
        }
        return PT.rep(sB.toString(), "  $$ Empty String", "");
    }

    @Override
    public List<String[]> readACDAssignments(int n) throws Exception {
        List<String[]> list = new List<String[]>();
        this.readLine();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        for (int i = 0; i < n; ++i) {
            this.line = PT.replaceAllCharacters(this.readLine(), "()<>", " ").trim();
            if (this.line.length() == 0 || this.line.indexOf("#") >= 0 || this.line.indexOf("$") >= 0) break;
            int n2 = this.line.indexOf("'");
            if (n2 >= 0) {
                int n3 = this.line.indexOf("'", n2 + 1);
                this.line = this.line.substring(0, n2) + PT.rep(this.line.substring(n2 + 1, n3), ",", ";") + this.line.substring(n3 + 1);
            }
            Logger.info("Peak Assignment: " + this.line);
            String[] stringArray = PT.split(this.line, ",");
            list.addLast(stringArray);
        }
        return list;
    }

    @Override
    public int setACDAssignments(String string, String string2, int n, List<String[]> list, String string3) throws Exception {
        try {
            int n2;
            int n3;
            String[] stringArray;
            int n4;
            if (n >= 0) {
                this.peakIndex = new int[]{n};
            }
            boolean bl = string2.indexOf("MASS") == 0;
            String string4 = " file=" + PT.esc(this.peakFilePath.replace('\\', '/'));
            string = " model=" + PT.esc(string + " (assigned)");
            this.piUnitsX = "";
            this.piUnitsY = "";
            float f = this.getACDPeakWidth(string2) / 2.0f;
            Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
            List<Object[]> list2 = new List<Object[]>();
            Hashtable<String, String> hashtable2 = null;
            int n5 = 0;
            if (bl) {
                hashtable2 = new Hashtable<String, String>();
                String[] stringArray2 = PT.split(string3, "M  ZZC");
                n4 = stringArray2.length;
                while (--n4 >= 1) {
                    stringArray = PT.getTokens(stringArray2[n4]);
                    n5 = Math.max(n5, PT.parseInt(stringArray[0]));
                    hashtable2.put(stringArray[1], stringArray[0]);
                }
                n3 = 4;
                n2 = 0;
            } else if (string2.indexOf("NMR") >= 0) {
                n3 = 0;
                n2 = 3;
            } else {
                n3 = 0;
                n2 = 2;
            }
            int n6 = list.size();
            for (n4 = 0; n4 < n6; ++n4) {
                stringArray = (String[])list.get(n4);
                float f2 = PT.parseFloat(stringArray[n3]);
                String string5 = stringArray[n2];
                string5 = bl ? this.fixACDAtomList(string5, hashtable2, n5) : string5.replace(';', ',');
                String string6 = bl ? "m/z=" + Math.round(f2) + ": " + stringArray[2] + " (" + stringArray[1] + ")" : (n2 == 2 ? "" + (float)Math.round(f2 * 10.0f) / 10.0f : null);
                this.getStringInfo(string4, string6, string2, string, string5, hashtable, "" + f2, list2, " atoms=\"%ATOMS%\" xMin=\"" + (f2 - f) + "\" xMax=\"" + (f2 + f) + "\">");
            }
            return this.setPeakData(list2, 0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private String fixACDAtomList(String string, Map<String, String> map, int n) {
        string = string.trim();
        String[] stringArray = PT.getTokens(string.replace(';', ' '));
        BS bS = new BS();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string2 = stringArray[i];
            boolean bl2 = bl = string2.indexOf("M") >= 0;
            if (bl) {
                string2 = "1-" + n;
            }
            if ((n2 = string2.indexOf(45)) >= 0) {
                int n3 = PT.parseInt(string2.substring(0, n2));
                int n4 = PT.parseInt(string2.substring(n2 + 1)) + 1;
                for (int j = n3; j < n4; ++j) {
                    bS.set(bl ? j : PT.parseInt(map.get("" + j)));
                }
                continue;
            }
            bS.set(PT.parseInt(map.get(string2)));
        }
        String string3 = bS.toJSON();
        return string3.substring(1, string3.length() - 1);
    }

    private float getACDPeakWidth(String string) {
        return string.indexOf("HNMR") >= 0 ? 0.05f : (string.indexOf("CNMR") >= 0 ? 1.0f : (string.indexOf("MASS") >= 0 ? 1.0f : 10.0f));
    }

    @Override
    public int readPeaks(boolean bl, int n) throws Exception {
        try {
            String string;
            if (n >= 0) {
                this.peakIndex = new int[]{n};
            }
            int n2 = bl ? 1 : 0;
            String string2 = bl ? "Signals" : "Peaks";
            String string3 = string = bl ? "<Signal" : "<PeakData";
            if (!this.findRecord(string2)) {
                return 0;
            }
            String string4 = " file=" + PT.esc(this.peakFilePath.replace('\\', '/'));
            String string5 = PT.getQuotedAttribute(this.line, "model");
            string5 = " model=" + PT.esc(string5 == null ? this.thisModelID : string5);
            String string6 = PT.getQuotedAttribute(this.line, "type");
            this.piUnitsX = PT.getQuotedAttribute(this.line, "xLabel");
            this.piUnitsY = PT.getQuotedAttribute(this.line, "yLabel");
            Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
            List<Object[]> list = new List<Object[]>();
            while (this.readLine() != null && !(this.line = this.line.trim()).startsWith("</" + string2)) {
                if (!this.line.startsWith(string)) continue;
                this.getRecord(string);
                Logger.info(this.line);
                String string7 = PT.getQuotedAttribute(this.line, "title");
                if (string6 == null) {
                    string6 = PT.getQuotedAttribute(this.line, "type");
                }
                String string8 = PT.getQuotedAttribute(this.line, "atoms");
                String string9 = (int)(PT.parseFloat(PT.getQuotedAttribute(this.line, "xMin")) * 100.0f) + "_" + (int)(PT.parseFloat(PT.getQuotedAttribute(this.line, "xMax")) * 100.0f);
                this.getStringInfo(string4, string7, string6, PT.getQuotedAttribute(this.line, "model") == null ? string5 : "", string8, hashtable, string9, list, this.line.substring(string.length()).trim());
            }
            return this.setPeakData(list, n2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int setPeakData(List<Object[]> list, int n) {
        int n2 = 0;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            Object[] objectArray = (Object[])list.get(i);
            this.peakIndex[0] = this.peakIndex[0] + 1;
            String string = PT.rep((String)objectArray[0], "%INDEX%", "" + this.peakIndex[0]);
            BS bS = (BS)objectArray[1];
            if (bS != null) {
                String string2 = "";
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0) {
                    string2 = string2 + "," + (n4 + n);
                    n4 = bS.nextSetBit(n4 + 1);
                }
                n4 = bS.cardinality();
                n2 += n4;
                string = PT.rep(string, "%ATOMS%", string2.substring(1));
                string = PT.rep(string, "%S%", n4 == 1 ? "" : "s");
                string = PT.rep(string, "%NATOMS%", "" + n4);
            }
            Logger.info("adding PeakData " + string);
            this.loader.addPeakData(string);
        }
        this.loader.setSpectrumPeaks(n2, this.piUnitsX, this.piUnitsY);
        return n3;
    }

    private void getStringInfo(String string, String string2, String string3, String string4, String string5, Map<String, Object[]> map, String string6, List<Object[]> list, String string7) {
        Object[] objectArray;
        String string8;
        if ("HNMR".equals(string3)) {
            string3 = "1HNMR";
        } else if ("CNMR".equals(string3)) {
            string3 = "13CNMR";
        }
        String string9 = string8 = string3 == null ? "" : " type=" + PT.esc(string3);
        if (string2 == null) {
            string2 = "1HNMR".equals(string3) ? "atom%S%: %ATOMS%; integration: %NATOMS%" : "";
        }
        string2 = " title=" + PT.esc(string2);
        String string10 = "<PeakData " + string + " index=\"%INDEX%\"" + string2 + string8 + string4 + " " + string7;
        if (string5 != null) {
            string10 = PT.rep(string10, "atoms=\"" + string5 + "\"", "atoms=\"%ATOMS%\"");
        }
        if ((objectArray = map.get(string6)) == null) {
            objectArray = new Object[]{string10, string5 == null ? null : new BS()};
            map.put(string6, objectArray);
            list.addLast(objectArray);
        }
        if (string5 != null) {
            BS bS = (BS)objectArray[1];
            string5 = string5.replace(',', ' ');
            bS.or(BS.unescape("({" + string5 + "})"));
        }
    }

    private void getModelData(boolean bl) throws Exception {
        this.lastModel = this.thisModelID;
        this.thisModelID = this.getAttribute(this.line, "id");
        String string = ";" + this.thisModelID + ";";
        if (this.modelIdList.indexOf(string) >= 0) {
            this.line = this.loader.discardLinesUntilContains("</ModelData>");
            return;
        }
        this.modelIdList = this.modelIdList + string;
        this.baseModel = this.getAttribute(this.line, "baseModel");
        while (this.line.indexOf(">") < 0 && this.line.indexOf("type") < 0) {
            this.readLine();
        }
        String string2 = this.getAttribute(this.line, "type").toLowerCase();
        this.vibScale = PT.parseFloat(this.getAttribute(this.line, "vibrationScale"));
        if (string2.equals("xyzvib")) {
            string2 = "xyz";
        } else if (string2.length() == 0) {
            string2 = null;
        }
        SB sB = new SB();
        while (this.readLine() != null && !this.line.contains("</ModelData>")) {
            sB.append(this.line).appendC('\n');
        }
        this.loader.processModelData(sB.toString(), this.thisModelID, string2, this.baseModel, this.lastModel, Float.NaN, this.vibScale, bl);
    }

    private boolean findRecord(String string) throws Exception {
        if (this.line == null) {
            this.readLine();
        }
        if (this.line.indexOf("<" + string) < 0) {
            this.line = this.loader.discardLinesUntilContains2("<" + string, "##");
        }
        return this.line.indexOf("<" + string) >= 0;
    }

    private String readLine() throws Exception {
        this.line = this.loader.rd();
        return this.line;
    }

    @Override
    public void setLine(String string) {
        this.line = string;
    }
}

