/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.adapter.readers.pymol.JmolObject;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLGroup;
import org.jmol.api.JmolSceneGenerator;
import org.jmol.api.PymolAtomReader;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Text;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

class PyMOLScene
implements JmolSceneGenerator {
    private Viewer vwr;
    private int pymolVersion;
    BS bsHidden = new BS();
    BS bsNucleic = new BS();
    BS bsNonbonded = new BS();
    BS bsLabeled = new BS();
    BS bsHydrogen = new BS();
    BS bsNoSurface = new BS();
    private Map<Float, BS> htSpacefill = new Hashtable<Float, BS>();
    private Map<String, BS> ssMapAtom = new Hashtable<String, BS>();
    private List<Integer> atomColorList = new List();
    private Map<String, Boolean> occludedObjects = new Hashtable<String, Boolean>();
    private Map<Integer, Text> labels = new Hashtable<Integer, Text>();
    private short[] colixes;
    private JmolObject frameObj;
    private Map<String, PyMOLGroup> groups;
    private Map<Integer, List<Object>> objectSettings;
    private BS bsCartoon = new BS();
    private Map<String, BS> htCarveSets = new Hashtable<String, BS>();
    private Map<String, BS> htDefinedAtoms = new Hashtable<String, BS>();
    private Map<String, Boolean> htHiddenObjects = new Hashtable<String, Boolean>();
    private List<String> moleculeNames = new List();
    private List<JmolObject> jmolObjects = new List();
    private Map<String, int[]> htAtomMap = new Hashtable<String, int[]>();
    private Map<String, BS> htObjectAtoms = new Hashtable<String, BS>();
    private Map<String, String> htObjectGroups = new Hashtable<String, String>();
    private Map<String, MeasurementData[]> htMeasures = new Hashtable<String, MeasurementData[]>();
    private Map<String, Map<Integer, List<Object>>> htObjectSettings = new Hashtable<String, Map<Integer, List<Object>>>();
    private Map<String, Object[]> objectInfo = new Hashtable<String, Object[]>();
    private List<Object> settings;
    private Map<String, Map<Integer, List<Object>>> htStateSettings = new Hashtable<String, Map<Integer, List<Object>>>();
    private Map<Integer, List<Object>> stateSettings;
    private Map<Integer, List<Object>> uniqueSettings;
    private Map<Integer, Integer> uniqueList;
    private BS bsUniqueBonds;
    private int bgRgb;
    private int dotColor;
    private int surfaceMode;
    private int surfaceColor;
    private int cartoonColor;
    private int ribbonColor;
    private int sphereColor;
    private int labelFontId;
    private int labelColor;
    private float cartoonTranslucency;
    private float ribbonTranslucency;
    private float labelSize;
    private float meshWidth;
    private float nonbondedSize;
    private float nonbondedTranslucency;
    private float sphereScale;
    private float sphereTranslucency;
    private float stickTranslucency;
    private float transparency;
    private boolean cartoonLadderMode;
    private boolean cartoonRockets;
    private boolean haveNucleicLadder;
    private P3 labelPosition;
    private P3 labelPosition0 = new P3();
    private String objectName;
    private String objectNameID;
    private String objectJmolName;
    private int objectType;
    private BS bsAtoms;
    private boolean objectHidden;
    private PymolAtomReader reader;
    private int[] uniqueIDs;
    private int[] cartoonTypes;
    private int[] sequenceNumbers;
    private boolean[] newChain;
    private float[] radii;
    private int baseModelIndex;
    private int baseAtomIndex;
    private int stateCount;
    String mepList = "";
    boolean doCache;
    private boolean haveScenes;
    private BS bsCarve;
    private boolean solventAccessible;
    private BS bsLineBonds = new BS();
    private BS bsStickBonds = new BS();
    private int thisState;
    int currentAtomSetIndex;
    String surfaceInfoName;
    private static final P3 ptTemp = new P3();
    private static final int[] MEAS_DIGITS = new int[]{530, 531, 532};

    private void clearReaderData() {
        this.reader = null;
        this.colixes = null;
        this.atomColorList = null;
        this.objectSettings = null;
        this.stateSettings = null;
        if (this.haveScenes) {
            return;
        }
        this.settings = null;
        this.groups = null;
        this.labels = null;
        this.ssMapAtom = null;
        this.htSpacefill = null;
        this.htAtomMap = null;
        this.htMeasures = null;
        this.htObjectGroups = null;
        this.htObjectAtoms = null;
        this.htObjectSettings = null;
        this.htStateSettings = null;
        this.htHiddenObjects = null;
        this.objectInfo = null;
        this.occludedObjects = null;
        this.bsCartoon = null;
        this.bsNoSurface = null;
        this.bsHydrogen = null;
        this.bsLabeled = null;
        this.bsNonbonded = null;
        this.bsNucleic = null;
        this.bsHidden = null;
    }

    void setUniqueBond(int n, int n2) {
        if (n2 < 0) {
            return;
        }
        if (this.uniqueList == null) {
            this.uniqueList = new Hashtable<Integer, Integer>();
            this.bsUniqueBonds = new BS();
        }
        this.uniqueList.put(n, n2);
        this.bsUniqueBonds.set(n);
    }

    void setStateCount(int n) {
        this.stateCount = n;
    }

    PyMOLScene(PymolAtomReader pymolAtomReader, Viewer viewer, List<Object> list, Map<Integer, List<Object>> map, int n, boolean bl, int n2, int n3, boolean bl2, String string) {
        this.reader = pymolAtomReader;
        this.vwr = viewer;
        this.settings = list;
        this.uniqueSettings = map;
        this.pymolVersion = n;
        this.haveScenes = bl;
        this.baseAtomIndex = n2;
        this.baseModelIndex = n3;
        this.doCache = bl2;
        this.surfaceInfoName = string + "##JmolSurfaceInfo##";
        this.setVersionSettings();
        list.trimToSize();
        this.bgRgb = PyMOLScene.colorSetting(PyMOLScene.listAt(list, 6));
        PyMOLScene.pointAt((List)PyMOLScene.listAt(list, 471).get(2), 0, this.labelPosition0);
    }

    void setReaderObjectInfo(String string, int n, String string2, boolean bl, List<Object> list, List<Object> list2, String string3) {
        this.objectName = string;
        this.objectHidden = bl;
        this.objectNameID = this.objectName == null ? null : PyMOLScene.fixName(this.objectName + string3);
        this.objectSettings = new Hashtable<Integer, List<Object>>();
        this.stateSettings = new Hashtable<Integer, List<Object>>();
        if (this.objectName != null) {
            this.objectJmolName = PyMOLScene.getJmolName(string);
            if (string2 != null) {
                this.htObjectGroups.put(this.objectName, string2);
                this.htObjectGroups.put(this.objectNameID, string2);
            }
            this.objectInfo.put(this.objectName, new Object[]{this.objectNameID, n});
            if (this.htObjectSettings.get(this.objectName) == null) {
                PyMOLScene.listToSettings(list, this.objectSettings);
                this.htObjectSettings.put(this.objectName, this.objectSettings);
            }
            if (this.htStateSettings.get(this.objectNameID) == null) {
                PyMOLScene.listToSettings(list2, this.stateSettings);
                this.htStateSettings.put(this.objectNameID, this.stateSettings);
            }
        }
        this.getObjectSettings();
    }

    private static void listToSettings(List<Object> list, Map<Integer, List<Object>> map) {
        if (list != null && list.size() != 0) {
            int n = list.size();
            while (--n >= 0) {
                List list2 = (List)list.get(n);
                map.put((Integer)list2.get(0), list2);
            }
        }
    }

    private void getObjectSettings() {
        this.transparency = this.floatSetting(138);
        this.dotColor = (int)this.floatSetting(210);
        this.nonbondedSize = this.floatSetting(65);
        this.nonbondedTranslucency = this.floatSetting(524);
        this.sphereScale = this.floatSetting(155);
        this.cartoonColor = (int)this.floatSetting(236);
        this.ribbonColor = (int)this.floatSetting(235);
        this.sphereColor = (int)this.floatSetting(173);
        this.cartoonTranslucency = this.floatSetting(279);
        this.ribbonTranslucency = this.floatSetting(666);
        this.stickTranslucency = this.floatSetting(198);
        this.sphereTranslucency = this.floatSetting(172);
        this.cartoonLadderMode = this.booleanSetting(448);
        this.cartoonRockets = this.booleanSetting(180);
        this.surfaceMode = (int)this.floatSetting(143);
        this.surfaceColor = (int)this.floatSetting(144);
        this.solventAccessible = this.booleanSetting(338);
        this.meshWidth = this.floatSetting(90);
        String string = this.stringSetting(342).trim();
        if (string.length() == 0) {
            this.bsCarve = null;
        } else {
            this.bsCarve = this.htCarveSets.get(string);
            if (this.bsCarve == null) {
                this.bsCarve = new BS();
                this.htCarveSets.put(string, this.bsCarve);
            }
        }
        this.labelPosition = new P3();
        try {
            List<Object> list = this.getObjectSetting(471);
            PyMOLScene.pointAt(PyMOLScene.listAt(list, 2), 0, this.labelPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.labelPosition.add(this.labelPosition0);
        this.labelColor = (int)this.floatSetting(66);
        this.labelSize = this.floatSetting(453);
        this.labelFontId = (int)this.floatSetting(328);
    }

    void setAtomInfo(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, float[] fArray) {
        this.uniqueIDs = nArray;
        this.cartoonTypes = nArray2;
        this.sequenceNumbers = nArray3;
        this.newChain = blArray;
        this.radii = fArray;
    }

    private void setSceneObject(String string, int n) {
        this.objectName = string;
        this.objectType = this.getObjectType(string);
        this.objectJmolName = PyMOLScene.getJmolName(string);
        this.objectNameID = n == 0 && this.objectType != 0 ? this.getObjectID(string) : this.objectJmolName + "_" + n;
        this.bsAtoms = this.htObjectAtoms.get(string);
        this.objectSettings = this.htObjectSettings.get(string);
        this.stateSettings = this.htStateSettings.get(string + "_" + n);
        String string2 = this.htObjectGroups.get(string);
        this.objectHidden = this.htHiddenObjects.containsKey(string) || string2 != null && !this.groups.get((Object)string2).visible;
        this.getObjectSettings();
    }

    void buildScene(String string, List<Object> list, Map<String, List<Object>> map, Map<String, List<Object>> map2) {
        Object[] objectArray;
        Object e = list.get(2);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("pymolFrame", e);
        hashtable.put("generator", this);
        hashtable.put("name", string);
        List<Object> list2 = PyMOLScene.listAt(list, 0);
        if (list2 != null) {
            hashtable.put("pymolView", this.getPymolView(list2, false));
        }
        Map map3 = (Map)list.get(1);
        hashtable.put("visibilities", map3);
        String string2 = "_scene_" + string + "_";
        Object[] objectArray2 = new Object[PyMOL.REP_LIST.length];
        int n = PyMOL.REP_LIST.length;
        while (--n >= 0) {
            List<Object> list3 = map.get(string2 + PyMOL.REP_LIST[n]);
            objectArray = PyMOLScene.listAt(list3, 5);
            if (objectArray == null || objectArray.size() <= 0) continue;
            objectArray2[n] = PyMOLScene.listToMap(objectArray);
        }
        hashtable.put("moleculeReps", objectArray2);
        string2 = "_!c_" + string + "_";
        List<Object> list4 = PyMOLScene.listAt(list, 3);
        int n2 = list4.size();
        objectArray = new Object[n2 / 2];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            int n4 = PyMOLScene.intAt(list4, i);
            List<Object> list5 = map2.get(string2 + n4);
            if (list5 == null || list5.size() <= 1) continue;
            objectArray[n3++] = new Object[]{n4, list5.get(1)};
        }
        hashtable.put("colors", objectArray);
        this.addJmolObject((int)1073742139, null, hashtable).jmolName = string;
    }

    @Override
    public void generateScene(Map<String, Object> map) {
        block2: {
            Logger.info("PyMOLScene - generateScene " + map.get("name"));
            this.jmolObjects.clear();
            this.bsHidden.clearAll();
            this.occludedObjects.clear();
            this.htHiddenObjects.clear();
            Integer n = (Integer)map.get("pymolFrame");
            this.thisState = n;
            this.addJmolObject(4115, null, this.thisState - 1);
            try {
                this.generateVisibilities((Map)map.get("visibilities"));
                this.generateColors((Object[])map.get("colors"));
                this.generateShapes((Object[])map.get("moleculeReps"));
                this.finalizeVisibility();
                this.offsetObjects();
                this.finalizeObjects();
            }
            catch (Exception exception) {
                System.out.println("PyMOLScene exception " + exception);
                if (this.vwr.isJS) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void generateColors(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            Object[] objectArray2 = (Object[])objectArray[n];
            int n2 = (Integer)objectArray2[0];
            int n3 = PyMOL.getRGB(n2);
            List list = (List)objectArray2[1];
            BS bS = this.getSelectionAtoms(list, this.thisState, new BS());
            this.addJmolObject((int)0x44100001, (BS)bS, null).argb = n3;
        }
    }

    private BS getSelectionAtoms(List<Object> list, int n, BS bS) {
        if (list != null) {
            int n2 = list.size();
            while (--n2 >= 0) {
                this.selectAllAtoms(PyMOLScene.listAt(list, n2), n, bS);
            }
        }
        return bS;
    }

    private void selectAllAtoms(List<Object> list, int n, BS bS) {
        String string = (String)list.get(0);
        this.setSceneObject(string, n);
        List<Object> list2 = PyMOLScene.listAt(list, 1);
        int n2 = n == 0 ? 1 : n;
        int n3 = n == 0 ? this.stateCount : n;
        for (int i = n2; i <= n3; ++i) {
            int[] nArray = this.htAtomMap.get(PyMOLScene.fixName(string + "_" + i));
            if (nArray == null) continue;
            this.getBsAtoms(list2, nArray, bS);
        }
    }

    private void generateVisibilities(Map<String, Object> map) {
        Object object;
        int n;
        List list;
        String string;
        if (map == null) {
            return;
        }
        BS bS = new BS();
        this.addJmolObject(12294, null, null);
        for (Map.Entry<String, PyMOLGroup> entry : this.groups.entrySet()) {
            entry.getValue().visible = true;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            if (string.equals("all")) continue;
            list = (List)entry.getValue();
            int n2 = n = PyMOLScene.intAt(list, 0) == 1 ? 1610625028 : 12294;
            if (n == 12294) {
                this.htHiddenObjects.put(string, Boolean.TRUE);
            }
            switch (this.getObjectType(string)) {
                case 12: {
                    object = this.groups.get(string);
                    if (object == null) break;
                    ((PyMOLGroup)object).visible = n == 1610625028;
                }
            }
        }
        this.setGroupVisibilities();
        block10: for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            if (string.equals("all")) continue;
            this.setSceneObject(string, this.thisState);
            if (this.objectHidden) continue;
            list = (List)entry.getValue();
            n = this.objectHidden ? 12294 : 1610625028;
            bS = null;
            object = this.objectJmolName;
            switch (this.objectType) {
                case 0: 
                case 12: {
                    continue block10;
                }
                case 1: {
                    bS = this.vwr.getDefinedAtomSet((String)object);
                    if (bS.nextSetBit(0) >= 0) break;
                    continue block10;
                }
                case 4: {
                    MeasurementData[] measurementDataArray;
                    if (n == 1610625028 && (measurementDataArray = this.htMeasures.get(string)) != null) {
                        this.addMeasurements(measurementDataArray, measurementDataArray[0].points.size(), null, this.getBS(PyMOLScene.listAt(list, 2)), PyMOLScene.intAt(list, 3), null, true);
                    }
                    object = (String)object + "_*";
                    break;
                }
            }
            this.addJmolObject(n, bS, object);
        }
    }

    private void generateShapes(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        this.addJmolObject((int)12295, null, null).argb = this.thisState - 1;
        for (int i = 0; i < this.moleculeNames.size(); ++i) {
            int n;
            this.setSceneObject((String)this.moleculeNames.get(i), this.thisState);
            if (this.objectHidden) continue;
            BS[] bSArray = new BS[23];
            for (n = 0; n < 23; ++n) {
                bSArray[n] = new BS();
            }
            n = objectArray.length;
            while (--n >= 0) {
                Map map = (Map)objectArray[n];
                List list = map == null ? null : (List)map.get(this.objectName);
                if (list == null) continue;
                this.selectAllAtoms(list, this.thisState, bSArray[n]);
            }
            this.createShapeObjects(bSArray, true, -1, -1);
        }
    }

    private BS getBS(List<Object> list) {
        BS bS = new BS();
        int n = list.size();
        while (--n >= 0) {
            bS.set(PyMOLScene.intAt(list, n));
        }
        return bS;
    }

    private void getBsAtoms(List<Object> list, int[] nArray, BS bS) {
        int n = list.size();
        while (--n >= 0) {
            bS.set(nArray[PyMOLScene.intAt(list, n)]);
        }
    }

    static int getColorPt(Object object) {
        return object instanceof Integer ? (Integer)object : CU.colorPtToFFRGB(PyMOLScene.pointAt((List)object, 0, ptTemp));
    }

    static int intAt(List<Object> list, int n) {
        return ((Number)list.get(n)).intValue();
    }

    static int colorSetting(List<Object> list) {
        return PyMOLScene.getColorPt(list.get(2));
    }

    void setReaderObjects() {
        this.clearReaderData();
        this.finalizeObjects();
        if (!this.haveScenes) {
            this.uniqueSettings = null;
            this.bsLineBonds = null;
            this.bsStickBonds = null;
            this.bsUniqueBonds = null;
        }
    }

    private void finalizeObjects() {
        this.vwr.setStringProperty("defaults", "PyMOL");
        for (int i = 0; i < this.jmolObjects.size(); ++i) {
            try {
                JmolObject jmolObject = (JmolObject)this.jmolObjects.get(i);
                jmolObject.finalizeObject(this, this.vwr.ms, this.mepList, this.doCache);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (this.vwr.isJS) continue;
                exception.printStackTrace();
            }
        }
        this.finalizeUniqueBonds();
        this.jmolObjects.clear();
    }

    void offsetObjects() {
        for (int i = 0; i < this.jmolObjects.size(); ++i) {
            ((JmolObject)this.jmolObjects.get(i)).offset(this.baseModelIndex, this.baseAtomIndex);
        }
    }

    private JmolObject getJmolObject(int n, BS bS, Object object) {
        if (this.baseAtomIndex > 0) {
            bS = BSUtil.copy(bS);
        }
        return new JmolObject(n, this.objectNameID, bS, object);
    }

    private JmolObject addJmolObject(int n, BS bS, Object object) {
        return this.addObject(this.getJmolObject(n, bS, object));
    }

    private float[] getPymolView(List<Object> list, boolean bl) {
        int n;
        float[] fArray = new float[21];
        boolean bl2 = this.booleanSetting(84);
        boolean bl3 = this.booleanSetting(88);
        float f = this.floatSetting(192);
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 3; ++n) {
            fArray[n2++] = PyMOLScene.floatAt(list, n3++);
        }
        if (bl) {
            ++n3;
        }
        for (n = 0; n < 3; ++n) {
            fArray[n2++] = PyMOLScene.floatAt(list, n3++);
        }
        if (bl) {
            ++n3;
        }
        for (n = 0; n < 3; ++n) {
            fArray[n2++] = PyMOLScene.floatAt(list, n3++);
        }
        if (bl) {
            n3 += 5;
        }
        for (n = 0; n < 8; ++n) {
            fArray[n2++] = PyMOLScene.floatAt(list, n3++);
        }
        n = this.booleanSetting(23) ? 1 : 0;
        float f2 = this.floatSetting(152);
        fArray[n2++] = n != 0 ? f2 : -f2;
        fArray[n2++] = bl2 ? 1 : 0;
        fArray[n2++] = bl3 ? 1 : 0;
        fArray[n2++] = f;
        return fArray;
    }

    float globalSetting(int n) {
        try {
            List list = (List)this.settings.get(n);
            return ((Number)list.get(2)).floatValue();
        }
        catch (Exception exception) {
            return PyMOL.getDefaultSetting(n, this.pymolVersion);
        }
    }

    PyMOLGroup addGroup(List<Object> list, String string, int n) {
        if (this.groups == null) {
            this.groups = new Hashtable<String, PyMOLGroup>();
        }
        PyMOLGroup pyMOLGroup = this.getGroup(this.objectName);
        pyMOLGroup.object = list;
        pyMOLGroup.objectNameID = this.objectNameID;
        pyMOLGroup.visible = !this.objectHidden;
        pyMOLGroup.type = n;
        if (!pyMOLGroup.visible) {
            this.occludedObjects.put(this.objectNameID, Boolean.TRUE);
            this.htHiddenObjects.put(this.objectName, Boolean.TRUE);
        }
        if (string != null && string.length() != 0) {
            this.getGroup(string).addList(pyMOLGroup);
        }
        return pyMOLGroup;
    }

    private PyMOLGroup getGroup(String string) {
        PyMOLGroup pyMOLGroup = this.groups.get(string);
        if (pyMOLGroup == null) {
            pyMOLGroup = new PyMOLGroup(string);
            this.groups.put(string, pyMOLGroup);
            this.defineAtoms(string, pyMOLGroup.bsAtoms);
        }
        return pyMOLGroup;
    }

    void finalizeVisibility() {
        this.setGroupVisibilities();
        if (this.groups != null) {
            int n = this.jmolObjects.size();
            while (--n >= 0) {
                JmolObject jmolObject = (JmolObject)this.jmolObjects.get(n);
                if (jmolObject.jmolName == null || !this.occludedObjects.containsKey(jmolObject.jmolName)) continue;
                jmolObject.visible = false;
            }
        }
        if (!this.bsHidden.isEmpty()) {
            this.addJmolObject(3145770, this.bsHidden, null);
        }
    }

    void setCarveSets(Map<String, List<Object>> map) {
        if (this.htCarveSets.isEmpty()) {
            return;
        }
        for (Map.Entry<String, BS> entry : this.htCarveSets.entrySet()) {
            this.getSelectionAtoms(PyMOLScene.listAt(map.get(entry.getKey()), 5), 0, entry.getValue());
        }
    }

    private void setGroupVisibilities() {
        if (this.groups == null) {
            return;
        }
        Collection<PyMOLGroup> collection = this.groups.values();
        BS bS = new BS();
        for (PyMOLGroup pyMOLGroup : collection) {
            bS.or(pyMOLGroup.bsAtoms);
            if (pyMOLGroup.parent == null) {
                this.setGroupVisible(pyMOLGroup, true);
                continue;
            }
            if (!pyMOLGroup.list.isEmpty()) continue;
            pyMOLGroup.addGroupAtoms(new BS());
        }
        this.defineAtoms("all", bS);
    }

    private void defineAtoms(String string, BS bS) {
        this.htDefinedAtoms.put(PyMOLScene.getJmolName(string), bS);
    }

    private static String getJmolName(String string) {
        return "__" + PyMOLScene.fixName(string);
    }

    void createShapeObjects(BS[] bSArray, boolean bl, int n, int n2) {
        if (n2 >= 0) {
            this.bsAtoms = BSUtil.newBitSet2(n, n2);
            JmolObject jmolObject = this.addJmolObject(0x44100001, this.bsAtoms, null);
            this.colixes = AU.ensureLengthShort(this.colixes, n2);
            int n3 = n2;
            while (--n3 >= n) {
                this.colixes[n3] = (short)((Integer)this.atomColorList.get(n3)).intValue();
            }
            jmolObject.setColors(this.colixes, 0.0f);
            jmolObject.setSize(0.0f);
            jmolObject = this.addJmolObject(1, this.bsAtoms, null);
            jmolObject.setSize(0.0f);
        }
        this.createShapeObject(7, bSArray[7]);
        this.createShapeObject(0, bSArray[0]);
        this.fixReps(bSArray);
        this.createSpacefillObjects();
        block10: for (int i = 0; i < 23; ++i) {
            switch (i) {
                case 0: 
                case 7: {
                    continue block10;
                }
                case 2: 
                case 8: {
                    if (!bl) continue block10;
                    switch (this.surfaceMode) {
                        case 0: {
                            bSArray[i].andNot(this.bsNoSurface);
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: 
                        case 4: {
                            bSArray[i].andNot(this.bsHydrogen);
                        }
                    }
                }
                default: {
                    this.createShapeObject(i, bSArray[i]);
                }
            }
        }
        this.bsAtoms = null;
    }

    void addLabel(int n, int n2, int n3, List<Object> list, String string) {
        int n4 = (int)this.getUniqueFloatDef(n2, 66, this.labelColor);
        if (n4 != -7 && n4 != -6 && n4 < 0) {
            n4 = n3;
        }
        float[] fArray = new float[7];
        if (list == null) {
            P3 p3 = this.getUniquePoint(n2, 471, null);
            if (p3 == null) {
                p3 = this.labelPosition;
            } else {
                p3.add(this.labelPosition);
            }
            PyMOLScene.setLabelPosition(p3, fArray);
        } else {
            for (int i = 0; i < 7; ++i) {
                fArray[i] = PyMOLScene.floatAt(list, i);
            }
        }
        this.labels.put(n, this.newTextLabel(string, fArray, n4, this.labelFontId, this.labelSize));
    }

    float getUniqueFloatDef(int n, int n2, float f) {
        List<Object> list;
        if (n <= 0 || (list = this.uniqueSettings.get((n << 10) + n2)) == null) {
            return f;
        }
        float f2 = ((Number)list.get(2)).floatValue();
        if (Logger.debugging) {
            Logger.debug("Pymol unique setting for " + n + ": [" + n2 + "] = " + f2);
        }
        return f2;
    }

    P3 getUniquePoint(int n, int n2, P3 p3) {
        List<Object> list;
        if (n <= 0 || (list = this.uniqueSettings.get((n << 10) + n2)) == null) {
            return p3;
        }
        p3 = new P3();
        PyMOLScene.pointAt((List)list.get(2), 0, p3);
        Logger.info("Pymol unique setting for " + n + ": " + n2 + " = " + p3);
        return p3;
    }

    List<Object> getObjectSetting(int n) {
        return this.objectSettings.get(n);
    }

    boolean booleanSetting(int n) {
        return this.floatSetting(n) != 0.0f;
    }

    float floatSetting(int n) {
        try {
            List<Object> list = this.getSetting(n);
            return ((Number)list.get(2)).floatValue();
        }
        catch (Exception exception) {
            return PyMOL.getDefaultSetting(n, this.pymolVersion);
        }
    }

    String stringSetting(int n) {
        try {
            List<Object> list = this.getSetting(n);
            return list.get(2).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<Object> getSetting(int n) {
        List<Object> list = null;
        if (this.stateSettings != null) {
            list = this.stateSettings.get(n);
        }
        if (list == null && this.objectSettings != null) {
            list = this.objectSettings.get(n);
        }
        if (list == null) {
            list = (List<Object>)this.settings.get(n);
        }
        return list;
    }

    static P3 pointAt(List<Object> list, int n, P3 p3) {
        p3.set(PyMOLScene.floatAt(list, n++), PyMOLScene.floatAt(list, n++), PyMOLScene.floatAt(list, n));
        return p3;
    }

    static float floatAt(List<Object> list, int n) {
        return list == null ? 0.0f : ((Number)list.get(n)).floatValue();
    }

    static float[] floatsAt(List<Object> list, int n, float[] fArray, int n2) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            fArray[i] = PyMOLScene.floatAt(list, n++);
        }
        return fArray;
    }

    static List<Object> listAt(List<Object> list, int n) {
        if (list == null || n >= list.size()) {
            return null;
        }
        Object e = list.get(n);
        return e instanceof List ? (List)e : null;
    }

    static float[] setLabelPosition(P3 p3, float[] fArray) {
        fArray[0] = 1.0f;
        fArray[1] = p3.x;
        fArray[2] = p3.y;
        fArray[3] = p3.z;
        return fArray;
    }

    String addCGO(List<Object> list, int n) {
        list.addLast(this.objectName);
        JmolObject jmolObject = this.addJmolObject(23, null, list);
        jmolObject.argb = n;
        jmolObject.translucency = this.floatSetting(441);
        return PyMOLScene.fixName(this.objectName);
    }

    boolean addMeasurements(MeasurementData[] measurementDataArray, int n, List<Object> list, BS bS, int n2, List<Object> list2, boolean bl) {
        int n3;
        int n4;
        boolean bl2 = measurementDataArray == null;
        int n5 = n4 = bl2 ? list.size() / 3 / n : measurementDataArray.length;
        if (n4 == 0) {
            return false;
        }
        boolean bl3 = bl && bS.get(3);
        boolean bl4 = bS.get(10);
        float f = this.floatSetting(107) / 20.0f;
        if (f == 0.0f) {
            f = 0.05f;
        }
        if (!bl4) {
            f = -5.0E-4f;
        }
        if (n2 < 0) {
            n2 = (int)this.floatSetting(574);
        }
        int n6 = PyMOL.getRGB(n2);
        short s = C.getColix(n6);
        int n7 = n3 = this.labelColor < 0 ? n2 : this.labelColor;
        if (bl2) {
            measurementDataArray = new MeasurementData[n4];
            this.htMeasures.put(this.objectName, measurementDataArray);
        }
        BS bS2 = BSUtil.newAndSetBit(0);
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            MeasurementData measurementData;
            float[] fArray;
            if (bl2) {
                List<Object> list3 = new List<Object>();
                int n9 = 0;
                while (n9 < n) {
                    list3.addLast(PyMOLScene.pointAt(list, n8, new Point3fi()));
                    ++n9;
                    n8 += 3;
                }
                fArray = PyMOLScene.floatsAt(PyMOLScene.listAt(list2, i), 0, new float[7], 7);
                if (fArray == null) {
                    fArray = PyMOLScene.setLabelPosition(this.labelPosition, new float[7]);
                }
                measurementData = measurementDataArray[i] = this.vwr.newMeasurementData(this.objectNameID + "_" + (i + 1), list3);
                measurementData.note = this.objectName;
            } else {
                measurementData = measurementDataArray[i];
                fArray = measurementData.text.pymolOffset;
            }
            int n10 = (int)this.floatSetting(MEAS_DIGITS[n - 2]);
            String string = n + ": " + (bl3 ? "%0." + (n10 < 0 ? 1 : n10) + "VALUE" : "");
            Text text = this.newTextLabel(string, fArray, n3, (int)this.floatSetting(328), this.floatSetting(453));
            measurementData.set(1060866, null, null, string, "angstroms", null, false, false, null, false, (int)(f * 2000.0f), s, text);
            this.addJmolObject(6, bS2, measurementData);
        }
        return true;
    }

    SB getViewScript(List<Object> list) {
        SB sB = new SB();
        float[] fArray = this.getPymolView(list, true);
        sB.append(";set translucent " + (this.globalSetting(213) != 2.0f) + ";set zshadePower 1;set traceAlpha " + (this.globalSetting(111) != 0.0f));
        boolean bl = this.cartoonRockets;
        sB.append(";set cartoonRockets " + bl);
        if (bl) {
            sB.append(";set rocketBarrels " + bl);
        }
        sB.append(";set cartoonLadders " + this.haveNucleicLadder);
        sB.append(";set ribbonBorder " + (this.globalSetting(118) != 0.0f));
        sB.append(";set cartoonFancy " + (this.globalSetting(118) == 0.0f));
        String string = "000000" + Integer.toHexString(this.bgRgb & 0xFFFFFF);
        string = "[x" + string.substring(string.length() - 6) + "]";
        sB.append(";background " + string);
        sB.append(";moveto 0 PyMOL " + Escape.eAF(fArray));
        sB.append(";save orientation 'default';");
        return sB;
    }

    short getColix(int n, float f) {
        short s = n == -7 ? (C.getBgContrast(this.bgRgb) == 8 ? (short)4 : 8) : (n == -6 ? (short)C.getBgContrast(this.bgRgb) : (short)C.getColixO(PyMOL.getRGB(n)));
        return C.getColixTranslucent3(s, f > 0.0f, f);
    }

    static int colorSettingClamped(List<Object> list) {
        return list.size() < 6 || PyMOLScene.intAt(list, 4) == 0 ? PyMOLScene.colorSetting(list) : PyMOLScene.getColorPt(list.get(5));
    }

    void setAtomColor(int n) {
        this.atomColorList.addLast(Integer.valueOf(this.getColix(n, 0.0f)));
    }

    void setFrameObject(int n, Object object) {
        if (object != null) {
            this.frameObj = this.getJmolObject(n, null, object);
            return;
        }
        if (this.frameObj == null) {
            return;
        }
        this.frameObj.finalizeObject(this, this.vwr.getModelSet(), null, false);
        this.frameObj = null;
    }

    private static String fixName(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        int n = cArray.length;
        while (--n >= 0) {
            if (Character.isLetterOrDigit(cArray[n])) continue;
            cArray[n] = 95;
        }
        return String.valueOf(cArray);
    }

    String getObjectID(String string) {
        return (String)this.objectInfo.get(string)[0];
    }

    private int getObjectType(String string) {
        Object[] objectArray = this.objectInfo.get(string);
        return objectArray == null ? 0 : (Integer)objectArray[1];
    }

    BS setAtomMap(int[] nArray, int n) {
        this.htAtomMap.put(this.objectNameID, nArray);
        BS bS = this.htDefinedAtoms.get(this.objectJmolName);
        if (bS == null) {
            bS = BS.newN(n + nArray.length);
            Logger.info("PyMOL molecule " + this.objectName);
            this.htDefinedAtoms.put(this.objectJmolName, bS);
            this.htObjectAtoms.put(this.objectName, bS);
            this.moleculeNames.addLast(this.objectName);
        }
        return bS;
    }

    private Text newTextLabel(String string, float[] fArray, int n, int n2, float f) {
        String string2;
        String string3;
        float f2 = 1.0f;
        switch (n2) {
            default: {
                string3 = "SansSerif";
                break;
            }
            case 0: 
            case 1: {
                string3 = "Monospaced";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string3 = "Serif";
            }
        }
        switch (n2) {
            default: {
                string2 = "Plain";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 17: {
                string2 = "Italic";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                string2 = "Bold";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                string2 = "BoldItalic";
            }
        }
        Font font = this.vwr.getFont3D(string3, string2, f == 0.0f ? 12.0f : f * f2);
        Text text = Text.newLabel(this.vwr.getGraphicsData(), font, string, this.getColix(n, 0.0f), (short)0, 0, 0.0f, fArray);
        return text;
    }

    private void setVersionSettings() {
        if (this.pymolVersion < 100) {
            this.addSetting(550, 2, 0);
            this.addSetting(529, 2, 2);
            this.addSetting(471, 4, new double[]{1.0, 1.0, 0.0});
            if (this.pymolVersion < 99) {
                this.addSetting(448, 2, 0);
                this.addSetting(431, 2, 0);
                this.addSetting(361, 2, 1);
            }
        }
    }

    private void addSetting(int n, int n2, Object list) {
        int n3 = this.settings.size();
        if (n3 <= n) {
            int n4 = n + 1;
            while (--n4 >= n3) {
                this.settings.addLast((Object)null);
            }
        }
        if (n2 == 4) {
            List<Double> list2;
            double[] dArray = (double[])list;
            list = list2 = new List<Double>();
            for (int i = 0; i < 3; ++i) {
                list2.addLast(dArray[i]);
            }
        }
        List<Serializable> list3 = new List<Serializable>();
        list3.addLast(Integer.valueOf(n));
        list3.addLast(Integer.valueOf(n2));
        list3.addLast(list);
        this.settings.set(n, list3);
    }

    private void fixReps(BS[] bSArray) {
        this.htSpacefill.clear();
        this.bsCartoon.clearAll();
        int n = this.bsAtoms.nextSetBit(0);
        while (n >= 0) {
            int n2;
            int n3;
            float f = 0.0f;
            int n4 = n3 = this.reader == null ? this.uniqueIDs[n] : this.reader.getUniqueID(n);
            if (bSArray[1].get(n)) {
                f = (this.reader == null ? this.radii[n] : this.reader.getVDW(n)) * this.getUniqueFloatDef(n3, 155, this.sphereScale);
            } else if (bSArray[4].get(n)) {
                f = this.nonbondedSize;
            }
            if (f != 0.0f) {
                Float f2 = Float.valueOf(f);
                BS bS = this.htSpacefill.get(f2);
                if (bS == null) {
                    bS = new BS();
                    this.htSpacefill.put(f2, bS);
                }
                bS.set(n);
            }
            int n5 = n2 = this.reader == null ? this.cartoonTypes[n] : this.reader.getCartoonType(n);
            if (bSArray[5].get(n)) {
                switch (n2) {
                    case 1: 
                    case 4: {
                        bSArray[21].set(n);
                    }
                    case -1: {
                        bSArray[5].clear(n);
                        this.bsCartoon.clear(n);
                        break;
                    }
                    case 7: {
                        bSArray[22].set(n);
                        bSArray[5].clear(n);
                        this.bsCartoon.clear(n);
                        break;
                    }
                    default: {
                        this.bsCartoon.set(n);
                    }
                }
            }
            n = this.bsAtoms.nextSetBit(n + 1);
        }
        bSArray[5].and(this.bsCartoon);
        this.cleanSingletons(bSArray[5]);
        this.cleanSingletons(bSArray[6]);
        this.cleanSingletons(bSArray[21]);
        this.cleanSingletons(bSArray[22]);
        this.bsCartoon.and(bSArray[5]);
    }

    private void cleanSingletons(BS bS) {
        if (bS.isEmpty()) {
            return;
        }
        bS.and(this.bsAtoms);
        BS bS2 = new BS();
        int n = bS.length();
        int n2 = 0;
        while (true) {
            int n3 = 0;
            int n4 = 0;
            int n5 = Integer.MIN_VALUE;
            int n6 = Integer.MIN_VALUE;
            int n7 = Integer.MIN_VALUE;
            while (n3 < n) {
                if (n5 < 0 || (this.reader == null ? this.newChain[n3] : this.reader.compareAtoms(n5, n3))) {
                    ++n4;
                }
                int n8 = n7 = this.reader == null ? this.sequenceNumbers[n3] : this.reader.getSequenceNumber(n3);
                if (n7 != n6) {
                    n6 = n7;
                    ++n4;
                }
                if (n2 == 0) {
                    if (bS.get(n3)) {
                        bS2.set(n4);
                    }
                } else if (!bS2.get(n4)) {
                    bS.clear(n3);
                }
                n5 = n3++;
            }
            if (++n2 == 2) break;
            BS bS3 = new BS();
            n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                if (!bS2.get(n4 - 1) && !bS2.get(n4 + 1)) {
                    bS3.set(n4);
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
            bS2.andNot(bS3);
        }
    }

    private void createShapeObject(int n, BS bS) {
        if (bS.isEmpty()) {
            return;
        }
        JmolObject jmolObject = null;
        switch (n) {
            case 11: {
                bS.and(this.bsNonbonded);
                if (bS.isEmpty()) {
                    return;
                }
                this.setUniqueObjects(7, bS, 0, 0, 524, this.nonbondedTranslucency, 0, this.nonbondedSize, 0.5f);
                break;
            }
            case 1: 
            case 4: {
                this.setUniqueObjects(0, bS, 173, this.sphereColor, 172, this.sphereTranslucency, 155, this.sphereScale, 1.0f);
                break;
            }
            case 19: {
                float f = this.floatSetting(571);
                int n2 = (int)this.floatSetting(570);
                float f2 = this.floatSetting(569);
                this.setUniqueObjects(20, bS, 570, n2, 571, f, 569, f2, 50.0f);
                break;
            }
            case 9: {
                this.setUniqueObjects(16, bS, 210, this.dotColor, 0, 0.0f, 155, this.sphereScale, 1.0f);
                break;
            }
            case 2: {
                float f = this.floatSetting(344);
                jmolObject = this.addJmolObject(135180, bS, new Object[]{this.booleanSetting(156) ? "FULLYLIT" : "FRONTLIT", this.surfaceMode == 3 || this.surfaceMode == 4 ? " only" : "", this.bsCarve, Float.valueOf(f)});
                jmolObject.setSize(this.floatSetting(4) * (float)(this.solventAccessible ? -1 : 1));
                jmolObject.translucency = this.transparency;
                if (this.surfaceColor >= 0) {
                    jmolObject.argb = PyMOL.getRGB(this.surfaceColor);
                }
                jmolObject.modelIndex = this.currentAtomSetIndex;
                jmolObject.cacheID = this.surfaceInfoName;
                this.setUniqueObjects(24, bS, 144, this.surfaceColor, 138, this.transparency, 0, 0.0f, 0.0f);
                break;
            }
            case 8: {
                jmolObject = this.addJmolObject(135180, bS, null);
                jmolObject.setSize(this.floatSetting(4));
                jmolObject.translucency = this.transparency;
                this.setUniqueObjects(24, bS, 144, this.surfaceColor, 138, this.transparency, 0, 0.0f, 0.0f);
                break;
            }
            case 3: {
                bS.and(this.bsLabeled);
                if (bS.isEmpty()) {
                    return;
                }
                jmolObject = this.addJmolObject(5, bS, this.labels);
                break;
            }
            case 7: {
                jmolObject = this.addJmolObject(659488, bS, null);
                jmolObject.setSize(this.floatSetting(44) / 15.0f);
                int n3 = (int)this.floatSetting(526);
                if (n3 < 0) break;
                jmolObject.argb = PyMOL.getRGB(n3);
                break;
            }
            case 0: {
                jmolObject = this.addJmolObject(1, bS, null);
                jmolObject.setSize(this.floatSetting(21) * 2.0f);
                jmolObject.translucency = this.stickTranslucency;
                int n4 = (int)this.floatSetting(376);
                if (n4 < 0) break;
                jmolObject.argb = PyMOL.getRGB(n4);
                break;
            }
            case 5: {
                this.createCartoonObject("H", this.cartoonRockets ? 181 : 100);
                this.createCartoonObject("S", 96);
                this.createCartoonObject("L", 92);
                this.createCartoonObject(" ", 92);
                break;
            }
            case 22: {
                this.createPuttyObject(bS);
                break;
            }
            case 21: {
                this.createTraceObject(bS);
                break;
            }
            case 6: {
                this.createRibbonObject(bS);
                break;
            }
            default: {
                Logger.error("Unprocessed representation type " + n);
            }
        }
    }

    private JmolObject setUniqueObjects(int n, BS bS, int n2, int n3, int n4, float f, int n5, float f2, float f3) {
        int n6 = bS.cardinality();
        short[] sArray = n2 == 0 ? null : new short[n6];
        float[] fArray = n4 == 0 ? null : new float[n6];
        float[] fArray2 = new float[n6];
        int n7 = 0;
        int n8 = bS.nextSetBit(0);
        while (n8 >= 0) {
            int n9;
            int n10;
            int n11 = n10 = this.reader == null ? this.uniqueIDs[n8] : this.reader.getUniqueID(n8);
            if (sArray != null && (n9 = (int)this.getUniqueFloatDef(n10, n2, n3)) > 0) {
                sArray[n7] = this.getColix(n9, 0.0f);
            }
            if (fArray != null) {
                fArray[n7] = this.getUniqueFloatDef(n10, n4, f);
            }
            fArray2[n7] = this.getUniqueFloatDef(n10, n5, f2) * f3;
            n8 = bS.nextSetBit(n8 + 1);
            ++n7;
        }
        return this.addJmolObject(n, bS, new Object[]{sArray, fArray, fArray2});
    }

    private void createSpacefillObjects() {
        for (Map.Entry<Float, BS> entry : this.htSpacefill.entrySet()) {
            float f = entry.getKey().floatValue();
            BS bS = entry.getValue();
            this.addJmolObject((int)0x44100001, (BS)bS, null).rd = new RadiusData(null, f, RadiusData.EnumType.ABSOLUTE, VDW.AUTO);
        }
        this.htSpacefill.clear();
    }

    private void createTraceObject(BS bS) {
        this.checkNucleicObject(bS, true);
        if (bS.isEmpty()) {
            return;
        }
        float f = this.floatSetting(103);
        JmolObject jmolObject = this.setUniqueObjects(10, bS, 236, this.cartoonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jmolObject.setSize(f * 2.0f);
        jmolObject.translucency = this.cartoonTranslucency;
    }

    private void checkNucleicObject(BS bS, boolean bl) {
        BS bS2 = BSUtil.copy(this.bsNucleic);
        bS2.and(bS);
        if (!bS2.isEmpty()) {
            if (bl && this.cartoonLadderMode) {
                this.haveNucleicLadder = true;
            }
            JmolObject jmolObject = this.addJmolObject(11, bS2, null);
            jmolObject.translucency = this.cartoonTranslucency;
            jmolObject.setSize(this.floatSetting(103) * 2.0f);
            bS.andNot(bS2);
        }
    }

    private void createPuttyObject(BS bS) {
        float[] fArray = new float[]{this.floatSetting(378), this.floatSetting(377), this.floatSetting(382), this.floatSetting(379), this.floatSetting(380), this.floatSetting(381), this.floatSetting(581)};
        this.addJmolObject((int)1113200654, (BS)bS, (Object)fArray).translucency = this.cartoonTranslucency;
    }

    private void createRibbonObject(BS bS) {
        boolean bl = this.floatSetting(19) > 1.0f;
        float f = this.floatSetting(20) * 2.0f;
        float f2 = this.floatSetting(327);
        if (f == 0.0f) {
            f = this.floatSetting(106) * (bl ? 1.0f : (f2 <= 1.0f ? 0.5f : f2)) * 0.1f;
        }
        JmolObject jmolObject = this.setUniqueObjects(bl ? 10 : 9, bS, 235, this.ribbonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jmolObject.setSize(f);
        jmolObject.translucency = this.ribbonTranslucency;
    }

    private void createCartoonObject(String string, int n) {
        BS bS = BSUtil.copy(this.ssMapAtom.get(string));
        if (bS == null) {
            return;
        }
        bS.and(this.bsCartoon);
        if (bS.isEmpty()) {
            return;
        }
        if (string.equals(" ")) {
            this.checkNucleicObject(bS, false);
            if (bS.isEmpty()) {
                return;
            }
        }
        JmolObject jmolObject = this.setUniqueObjects(11, bS, 236, this.cartoonColor, 0, 0.0f, 0, 0.0f, 0.0f);
        jmolObject.setSize(this.floatSetting(n) * 2.0f);
        jmolObject.translucency = this.cartoonTranslucency;
    }

    private JmolObject addObject(JmolObject jmolObject) {
        this.jmolObjects.addLast(jmolObject);
        return jmolObject;
    }

    private void setGroupVisible(PyMOLGroup pyMOLGroup, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl && pyMOLGroup.visible;
        if (bl2) {
            return;
        }
        pyMOLGroup.visible = false;
        this.occludedObjects.put(pyMOLGroup.objectNameID, Boolean.TRUE);
        this.htHiddenObjects.put(pyMOLGroup.name, Boolean.TRUE);
        switch (pyMOLGroup.type) {
            case 1: {
                this.bsHidden.or(pyMOLGroup.bsAtoms);
                break;
            }
            default: {
                pyMOLGroup.occluded = true;
            }
        }
        for (PyMOLGroup pyMOLGroup2 : pyMOLGroup.list.values()) {
            this.setGroupVisible(pyMOLGroup2, bl2);
        }
    }

    BS getSSMapAtom(String string) {
        BS bS = this.ssMapAtom.get(string);
        if (bS == null) {
            bS = new BS();
            this.ssMapAtom.put(string, bS);
        }
        return bS;
    }

    static Map<String, List<Object>> listToMap(List<Object> list) {
        Hashtable<String, List<Object>> hashtable = new Hashtable<String, List<Object>>();
        int n = list.size();
        while (--n >= 0) {
            List<Object> list2 = PyMOLScene.listAt(list, n);
            if (list2 == null || list2.size() <= 0) continue;
            hashtable.put((String)list2.get(0), list2);
        }
        return hashtable;
    }

    Map<String, Object> setAtomDefs() {
        this.setGroupVisibilities();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (Map.Entry<String, BS> entry : this.htDefinedAtoms.entrySet()) {
            BS bS = entry.getValue();
            if (bS.isEmpty()) continue;
            hashtable.put(entry.getKey(), bS);
        }
        this.addJmolObject(1060866, null, hashtable);
        return hashtable;
    }

    public boolean needSelections() {
        return this.haveScenes || !this.htCarveSets.isEmpty();
    }

    public void setUniqueBonds(BS bS, boolean bl) {
        if (bl) {
            this.bsStickBonds.or(bS);
            this.bsStickBonds.andNot(this.bsLineBonds);
        } else {
            this.bsLineBonds.or(bS);
            this.bsLineBonds.andNot(this.bsStickBonds);
        }
    }

    private void finalizeUniqueBonds() {
        if (this.uniqueList == null) {
            return;
        }
        int n = this.vwr.getBondCount();
        Bond[] bondArray = this.vwr.ms.bo;
        int n2 = this.bsUniqueBonds.nextSetBit(0);
        while (n2 >= 0) {
            float f = Float.NaN;
            int n3 = this.uniqueList.get(n2);
            if (this.bsLineBonds.get(n2)) {
                f = this.getUniqueFloatDef(n3, 44, Float.NaN) / 30.0f;
            } else if (this.bsStickBonds.get(n2)) {
                f = this.getUniqueFloatDef(n3, 21, Float.NaN);
            }
            int n4 = (int)this.getUniqueFloatDef(n3, 376, 2.1474836E9f);
            if (n4 != Integer.MAX_VALUE) {
                n4 = PyMOL.getRGB(n4);
            }
            float f2 = this.getUniqueFloatDef(n3, 64, Float.NaN);
            float f3 = this.getUniqueFloatDef(n3, 198, Float.NaN);
            if (n2 < 0 || n2 >= n) {
                return;
            }
            Bond bond = bondArray[n2];
            this.setBondParameters(bond, this.thisState - 1, f, f2, n4, f3);
            n2 = this.bsUniqueBonds.nextSetBit(n2 + 1);
        }
    }

    public void setBondParameters(Bond bond, int n, float f, float f2, int n2, float f3) {
        if (n >= 0 && bond.atom1.mi != n) {
            return;
        }
        if (!Float.isNaN(f)) {
            bond.mad = (short)(f * 2000.0f);
        }
        short s = bond.colix;
        if (n2 != Integer.MAX_VALUE) {
            s = C.getColix(n2);
        }
        if (!Float.isNaN(f3)) {
            bond.colix = C.getColixTranslucent3(s, f3 != 0.0f, f3);
        } else if (bond.colix != s) {
            bond.colix = C.copyColixTranslucency(bond.colix, s);
        }
        if (f2 == 1.0f) {
            bond.order |= 0x18000;
        } else if (f2 == 0.0f) {
            bond.order |= 0x10000;
        }
    }

    public void addMesh(int n, List<Object> list, String string, boolean bl) {
        JmolObject jmolObject = this.addJmolObject(n, null, list);
        this.setSceneObject(string, -1);
        int n2 = (int)this.floatSetting(146);
        if (n2 < 0) {
            n2 = PyMOLScene.intAt(PyMOLScene.listAt(list, 0), 2);
        }
        if (!bl) {
            jmolObject.setSize(this.meshWidth);
            jmolObject.argb = PyMOL.getRGB(n2);
        }
        jmolObject.translucency = this.transparency;
        jmolObject.cacheID = this.surfaceInfoName;
    }

    public JmolObject addIsosurface(String string) {
        JmolObject jmolObject = this.addJmolObject(135180, null, string);
        jmolObject.cacheID = this.surfaceInfoName;
        return jmolObject;
    }
}

