/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.List;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.JmolJDXMOLParser;
import org.jmol.adapter.smarter.JmolJDXMOLReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class JcampdxReader
extends MolReader
implements JmolJDXMOLReader {
    private int selectedModel;
    private JmolJDXMOLParser mpr;
    private String acdMolFile;
    private int nPeaks;
    private List<String[]> acdAssignments;
    private String title;
    private String nucleus = "";
    private String type;
    private List<String> peakData = new List();
    private String allTypes;

    @Override
    public void initializeReader() throws Exception {
        this.vwr.setBooleanProperty("_JSpecView".toLowerCase(), true);
        if (this.isTrajectory) {
            Logger.warn("TRAJECTORY keyword ignored");
            this.isTrajectory = false;
        }
        if (this.reverseModels) {
            Logger.warn("REVERSE keyword ignored");
            this.reverseModels = false;
        }
        this.selectedModel = this.desiredModelNumber;
        this.desiredModelNumber = Integer.MIN_VALUE;
        if (!this.checkFilterKey("NOSYNC")) {
            this.addJmolScript("sync on");
        }
    }

    @Override
    public boolean checkLine() throws Exception {
        int n;
        int n2 = this.line.indexOf("=");
        if (n2 < 0 || !this.line.startsWith("##")) {
            return true;
        }
        String string = PT.replaceAllCharacters(this.line.substring(0, n2).trim(), " ", "").toUpperCase();
        if (string.length() > 12) {
            string = string.substring(0, 12);
        }
        if ((n = "##$MODELS   ##$PEAKS    ##$SIGNALS  ##$MOLFILE  ##NPOINTS   ##TITLE     ##PEAKASSIGN##.OBSERVENU##DATATYPE  ".indexOf(string)) < 0) {
            return true;
        }
        if (this.mpr == null) {
            this.mpr = ((JmolJDXMOLParser)Interface.getOption("jsv.JDXMOLParser")).set(this, this.filePath, this.htParams);
        }
        String string2 = this.line.substring(n2 + 1).trim();
        this.mpr.setLine(string2);
        switch (n) {
            case 0: {
                this.mpr.readModels();
                break;
            }
            case 12: 
            case 24: {
                this.mpr.readPeaks(n == 24, -1);
                break;
            }
            case 36: {
                this.acdMolFile = this.mpr.readACDMolFile();
                this.processModelData(this.acdMolFile, this.title + " (assigned)", "MOL", "mol", "", 0.01f, Float.NaN, true);
                break;
            }
            case 48: {
                this.nPeaks = PT.parseInt(string2);
                break;
            }
            case 60: {
                this.title = PT.split(string2, "$$")[0].trim();
                break;
            }
            case 72: {
                this.acdAssignments = this.mpr.readACDAssignments(this.nPeaks);
                break;
            }
            case 84: {
                this.nucleus = string2.substring(1);
                break;
            }
            case 96: {
                this.type = string2;
                n = this.type.indexOf(" ");
                if (n < 0) break;
                this.type = this.type.substring(0, n);
            }
        }
        return true;
    }

    @Override
    public void finalizeReader() throws Exception {
        if (this.mpr != null) {
            this.processPeakData();
        }
        this.finalizeReaderMR();
    }

    @Override
    public void processModelData(String string, String string2, String string3, String string4, String string5, float f, float f2, boolean bl) throws Exception {
        int n = this.asc.currentAtomSetIndex;
        AtomSetCollection atomSetCollection = null;
        Object object = SmarterJmolAdapter.staticGetAtomSetCollectionReader(this.filePath, string3, Rdr.getBR(string), this.htParams);
        if (object instanceof String) {
            Logger.warn("" + object);
        } else if ((object = SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)object)) instanceof String) {
            Logger.warn("" + object);
        } else {
            int n2;
            int n3;
            atomSetCollection = (AtomSetCollection)object;
            String string6 = string4;
            if (string6.length() == 0) {
                string6 = string5;
            }
            if (string6.length() != 0 && (n3 = this.findModelById(string6)) >= 0) {
                this.asc.setAtomSetAuxiliaryInfoForSet("jdxModelID", string6, n3);
                n2 = atomSetCollection.atomSetCount;
                while (--n2 >= 0) {
                    atomSetCollection.setAtomSetAuxiliaryInfoForSet("jdxBaseModel", string6, n2);
                }
                if (atomSetCollection.bondCount == 0) {
                    this.setBonding(atomSetCollection, n3);
                }
            }
            if (!Float.isNaN(f2)) {
                Logger.info("JcampdxReader applying vibration scaling of " + f2 + " to " + atomSetCollection.ac + " atoms");
                Atom[] atomArray = atomSetCollection.atoms;
                n2 = atomSetCollection.ac;
                while (--n2 >= 0) {
                    atomArray[n2].scaleVector(f2);
                }
            }
            if (!Float.isNaN(f)) {
                Logger.info("JcampdxReader applying model scaling of " + f + " to " + atomSetCollection.ac + " atoms");
                Atom[] atomArray = atomSetCollection.atoms;
                n2 = atomSetCollection.ac;
                while (--n2 >= 0) {
                    atomArray[n2].scale(f);
                }
            }
            Logger.info("jdx model=" + string2 + " type=" + atomSetCollection.fileTypeName);
            this.asc.appendAtomSetCollection(-1, atomSetCollection);
        }
        this.updateModelIDs(string2, n, bl);
    }

    private void setBonding(AtomSetCollection atomSetCollection, int n) {
        int n2;
        int n3 = atomSetCollection.ac;
        int n4 = this.asc.getAtomSetAtomCount(n);
        if (n3 % n4 != 0) {
            Logger.warn("atom count in secondary model (" + n3 + ") is not a multiple of " + n4 + " -- bonding ignored");
            return;
        }
        Bond[] bondArray = this.asc.bonds;
        int n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n5 += this.asc.getAtomSetBondCount(n2);
        }
        n2 = n5 + this.asc.getAtomSetBondCount(n);
        int n6 = this.asc.getAtomSetAtomIndex(n);
        int n7 = atomSetCollection.atomSetCount;
        for (int i = 0; i < n7; ++i) {
            int n8 = atomSetCollection.getAtomSetAtomIndex(i) - n6;
            if (atomSetCollection.getAtomSetAtomCount(i) != n4) {
                Logger.warn("atom set atom count in secondary model (" + atomSetCollection.getAtomSetAtomCount(i) + ") is not equal to " + n4 + " -- bonding ignored");
                return;
            }
            for (int j = n5; j < n2; ++j) {
                atomSetCollection.addNewBondWithOrder(bondArray[j].atomIndex1 + n8, bondArray[j].atomIndex2 + n8, bondArray[j].order);
            }
        }
    }

    private void updateModelIDs(String string, int n, boolean bl) {
        int n2 = this.asc.atomSetCount;
        if (bl && n2 == n + 2) {
            this.asc.setAtomSetAuxiliaryInfo("modelID", string);
            return;
        }
        int n3 = 0;
        int n4 = n;
        while (++n4 < n2) {
            this.asc.setAtomSetAuxiliaryInfoForSet("modelID", string + "." + ++n3, n4);
        }
    }

    @Override
    public void addPeakData(String string) {
        this.peakData.addLast(string);
    }

    private void processPeakData() {
        String string;
        int n;
        int n2;
        if (this.acdAssignments != null) {
            try {
                this.mpr.setACDAssignments(this.title, this.nucleus + this.type, 0, this.acdAssignments, this.acdMolFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n2 = this.peakData.size()) == 0) {
            return;
        }
        BS bS = new BS();
        boolean bl = n2 > 0;
        for (n = 0; n < n2; ++n) {
            String string2;
            this.line = (String)this.peakData.get(n);
            string = this.mpr.getAttribute(this.line, "type");
            String string3 = this.mpr.getAttribute(this.line, "model");
            int n3 = this.findModelById(string3);
            if (n3 < 0) {
                Logger.warn("cannot find model " + string3 + " required for " + this.line);
                continue;
            }
            this.addType(n3, string);
            String string4 = string + ": " + this.mpr.getAttribute(this.line, "title");
            String string5 = "jdxAtomSelect_" + this.mpr.getAttribute(this.line, "type");
            bS.set(n3);
            if (this.mpr.getAttribute(this.line, "atoms").length() != 0) {
                this.processPeakSelectAtom(n3, string5, this.line);
                string2 = string + ": ";
            } else {
                string2 = this.processPeakSelectModel(n3, string4) ? "model: " : "ignored: ";
            }
            Logger.info(string2 + this.line);
        }
        n = n2 = this.asc.atomSetCount;
        while (--n >= 0) {
            string = (String)this.asc.getAtomSetAuxiliaryInfoValue(n, "modelID");
            if (!bl || bS.get(n) || string.indexOf(".") < 0) continue;
            this.asc.removeAtomSet(n);
            --n2;
        }
        if (this.selectedModel == Integer.MIN_VALUE) {
            if (this.allTypes != null) {
                this.appendLoadNote(this.allTypes);
            }
        } else {
            if (this.selectedModel == 0) {
                this.selectedModel = n2 - 1;
            }
            n = this.asc.atomSetCount;
            while (--n >= 0) {
                if (n + 1 == this.selectedModel) continue;
                this.asc.removeAtomSet(n);
            }
            if (n2 > 0) {
                this.appendLoadNote((String)this.asc.getAtomSetAuxiliaryInfoValue(0, "name"));
            }
        }
        n = this.asc.atomSetCount;
        while (--n >= 0) {
            this.asc.setAtomSetNumber(n, n + 1);
        }
        this.asc.centralize();
    }

    private int findModelById(String string) {
        int n = this.asc.atomSetCount;
        while (--n >= 0) {
            String string2 = (String)this.asc.getAtomSetAuxiliaryInfoValue(n, "modelID");
            if (!string.equals(string2)) continue;
            return n;
        }
        return -1;
    }

    private void addType(int n, String string) {
        String string2 = this.addTypeStr((String)this.asc.getAtomSetAuxiliaryInfoValue(n, "spectrumTypes"), string);
        if (string2 == null) {
            return;
        }
        this.asc.setAtomSetAuxiliaryInfoForSet("spectrumTypes", string2, n);
        String string3 = this.addTypeStr(this.allTypes, string);
        if (string3 != null) {
            this.allTypes = string3;
        }
    }

    private String addTypeStr(String string, String string2) {
        if (string != null && string.contains(string2)) {
            return null;
        }
        string = string == null ? "" : string + ",";
        return string + string2;
    }

    private void processPeakSelectAtom(int n, String string, String string2) {
        List<String> list = (List<String>)this.asc.getAtomSetAuxiliaryInfoValue(n, string);
        if (list == null) {
            list = new List<String>();
            this.asc.setAtomSetAuxiliaryInfoForSet(string, list, n);
        }
        list.addLast(string2);
    }

    private boolean processPeakSelectModel(int n, String string) {
        if (this.asc.getAtomSetAuxiliaryInfoValue(n, "jdxModelSelect") != null) {
            return false;
        }
        this.asc.setAtomSetAuxiliaryInfoForSet("name", string, n);
        this.asc.setAtomSetAuxiliaryInfoForSet("jdxModelSelect", this.line, n);
        return true;
    }

    @Override
    public void setSpectrumPeaks(int n, String string, String string2) {
    }
}

