/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import org.jmol.java.BS;

public final class BSUtil {
    public static final BS emptySet = new BS();

    public static BS newAndSetBit(int n) {
        BS bS = BSUtil.newBitSet(n + 1);
        bS.set(n);
        return bS;
    }

    public static boolean areEqual(BS bS, BS bS2) {
        return bS == null || bS2 == null ? bS == null && bS2 == null : bS.equals(bS2);
    }

    public static boolean haveCommon(BS bS, BS bS2) {
        return bS == null || bS2 == null ? false : bS.intersects(bS2);
    }

    public static int cardinalityOf(BS bS) {
        return bS == null ? 0 : bS.cardinality();
    }

    public static BS newBitSet2(int n, int n2) {
        BS bS = BSUtil.newBitSet(n2);
        bS.setBits(n, n2);
        return bS;
    }

    public static BS setAll(int n) {
        BS bS = BSUtil.newBitSet(n);
        bS.setBits(0, n);
        return bS;
    }

    public static BS andNot(BS bS, BS bS2) {
        if (bS2 != null && bS != null) {
            bS.andNot(bS2);
        }
        return bS;
    }

    public static BS copy(BS bS) {
        return bS == null ? null : (BS)bS.clone();
    }

    public static BS copy2(BS bS, BS bS2) {
        if (bS == null || bS2 == null) {
            return null;
        }
        bS2.clearAll();
        bS2.or(bS);
        return bS2;
    }

    public static BS copyInvert(BS bS, int n) {
        return bS == null ? null : BSUtil.andNot(BSUtil.setAll(n), bS);
    }

    public static BS invertInPlace(BS bS, int n) {
        return BSUtil.copy2(BSUtil.copyInvert(bS, n), bS);
    }

    public static BS toggleInPlace(BS bS, BS bS2) {
        if (bS.equals(bS2)) {
            bS.clearAll();
        } else if (BSUtil.andNot(BSUtil.copy(bS2), bS).length() == 0) {
            BSUtil.andNot(bS, bS2);
        } else {
            bS.or(bS2);
        }
        return bS;
    }

    public static BS deleteBits(BS bS, BS bS2) {
        if (bS == null || bS2 == null) {
            return bS;
        }
        int n = bS2.nextSetBit(0);
        if (n < 0) {
            return bS;
        }
        int n2 = bS.length();
        int n3 = Math.min(n2, bS2.length());
        int n4 = bS2.nextClearBit(n);
        while (n4 < n3 && n4 >= 0) {
            bS.setBitTo(n++, bS.get(n4));
            n4 = bS2.nextClearBit(n4 + 1);
        }
        for (n4 = n3; n4 < n2; ++n4) {
            bS.setBitTo(n++, bS.get(n4));
        }
        if (n < n2) {
            bS.clearBits(n, n2);
        }
        return bS;
    }

    public static BS newBitSet(int n) {
        return BS.newN(n);
    }

    public static void offset(BS bS, int n, int n2) {
        if (bS == null) {
            return;
        }
        BS bS2 = BS.newN(bS.length() + n2);
        int n3 = bS.nextSetBit(0);
        while (n3 >= n) {
            bS2.set(n3 + n2);
            n3 = bS.nextSetBit(n3 + 1);
        }
        BSUtil.copy2(bS2, bS);
    }

    public static void setMapBitSet(Map<String, BS> map, int n, int n2, String string) {
        BS bS;
        if (map.containsKey(string)) {
            bS = map.get(string);
        } else {
            bS = new BS();
            map.put(string, bS);
        }
        bS.setBits(n, n2 + 1);
    }
}

